var winurlobj = getNeProperty(self);

var btnRightArr = new Object();//           
var slmParamTable;//    (         )    
var DEFAULT_QUERY_SEGMENTID = 0; //                     id
var DEFAULT_SEGMENT_NUM = "--";
var SLM_LINEMGR_MAX_FIBERTYPE_LENGTH = 15;
var win = window.parent;
var neid = win.neid;//   ID

var crossSpanList = [];

var NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;

loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/slmlinemgr_u2kv1r3c00/slmlinemgr_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/linemonitor_u2kv1r3c00/slmparamtable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

var sync = true;

var isSame = "true";

var segmentNum = 0;

/**
 *         
 * @param   
 * @return   
 */
function initParam()
{
	if (!isIE)
	{
		sync = false;
	}
	
	initParamTable();
}

function tabSelectHandler()
{
	win.slmlineInfoTabs.removeTabNodeHref();
	queryLineDetails();
}

function doQuery(lineID)
{
	win.slmlineInfoTabs.removeTabNodeHref();
	queryLineDetails();
}

window.onresize = function()
{
	slmParamTable.setBodyHeight(getComponetHeight($("slmParamTable"), 50)+"px");
}

/**
 *               
 * @param   
 * @return   
 */
function initParamTable()
{
	slmParamTable = new SortTable();
	slmParamTable.setImage("../../../../images/");
  slmParamTable.setBodyHeight(getComponetHeight($("slmParamTable"), 50)+"px");
	createTableHead(slmParamTable, window.tableconf[1]);
	slmParamTable.setOnRowSelectHandler(rowSelectHandlerParamTable); 
	slmParamTable.setOnCellEditHandler(cellEditHandler);
	$("slmParamTable").oncontextmenu = popupMenuHandler;
	$("slmParamTable").appendChild(slmParamTable.getTable());
}

function rowSelectHandlerParamTable(rows)
{
  var selrows = slmParamTable.getSelectedRowCount();
  document.getElementById("theitem").innerHTML = selrows;
}
/**
 *                     
 * @return   
 */
function addCellEvent()
{
    var cell;
    var editelement;
    
    for(var i = 0, tbLen = slmParamTable.getDataRowLength(); i < tbLen; i++)//        
    {
        cell = slmParamTable.getCell(i,"fiberType");//   fiberType     
        if(null != cell)
        {
            editelement = cell.element.editElement.element;//   fiberType             
            editelement.maxLength = SLM_LINEMGR_MAX_FIBERTYPE_LENGTH;//        text            
            
            editelement.onkeyup = function()
            {
            	  return calStrSinoLen(this, SLM_LINEMGR_MAX_FIBERTYPE_LENGTH);
            }
        }
				cell = slmParamTable.getCell(i, "refractiveRate");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_REFRACTIVE_RATE, SLM_LINEMGR_MAX_REFRACTIVE_RATE, 3);
				
			  cell = slmParamTable.getCell(i, "fiberLength");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_FIBER_LENGTH, SLM_LINEMGR_MAX_FIBER_LENGTH, 1);
			 
				cell = slmParamTable.getCell(i, "attenuation");	
				textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_ATTENUATION, SLM_LINEMGR_MAX_ATTENUATION, 2);
				
        var isSameFlag = slmParamTable.getCellStoreValue(i, "isSameFlag", "isSameFlag");
        if ("false" == isSameFlag)
        {
        	setCellColor(slmParamTable, i, "spanNo");
        	setCellColor(slmParamTable, i, "fiberType");
        	setCellColor(slmParamTable, i, "refractiveRate");
        	setCellColor(slmParamTable, i, "attenuation");
        	setCellColor(slmParamTable, i, "fiberLength");
        }
    }
}

/**
 *           
 * @param   
 * @return   
 */
function doSetLineInfo ()
{
	removejsDOMmenu(); 
	if ("false" == isSame)
	{
		if (!confirm(RESOURCE["crossspanDifferences"]))
		{
			return;
		}
	}
	setTableStatus(true);
	win.disableAllBtn();
	
	var data = createApplyLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_SET_LINE_PARAM + "&nmUser=" + win.winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackApplyLineInfoData, null, "inputdata="+data);
	
}
/**
 *                XML   
 * @param   
 * @return   
 */
function createApplyLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colId = null;
	var cellModifyFlag = null;
	var isModified = false;
	
	var colValue = 0;
	
	for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (!slmParamTable.getModify(rowIndex))
		{
			continue;
		}
		
		isModified = true;
		rowData = slmParamTable.getRow(rowIndex);
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",win.neid);
		row.appendChild(param);
		
		var selectedRow = win.slmLineTable.getSelectedRows();
		var srcNEID = win.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
		var sinkNEID = win.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID");
		
	  if (null == srcNEID || UNKNOWN == srcNEID)
	  {
	  	srcNEID = 0;
	  }
	  param = new tagElement("param");
	  param.setAttribute("name", "srcneid");
	  param.setAttribute("value", srcNEID);
	  row.appendChild(param);
	    
	  if (null == sinkNEID || UNKNOWN == sinkNEID)
	  {
	    sinkNEID = 0;
	  }
	  param = new tagElement("param");
	  param.setAttribute("name", "sinkneid");
	  param.setAttribute("value", sinkNEID);
	  row.appendChild(param);
				
		var opNeID = sinkNEID;
		
		if (srcNEID != win.neid)
		{
			opNeID = srcNEID;
		}
		
    if (null == opNeID) 
    {
        opNeID = 0;
    }
		
		param = new tagElement("param");
		param.setAttribute("name", "opNeID");
		param.setAttribute("value", opNeID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","lineID");
		param.setAttribute("value",win.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","segmentNum");
		param.setAttribute("value",segmentNum);
		row.appendChild(param);
		
		for (var colIndex = 0, colLen = slmParamTable.getColumnCount(); colIndex < colLen; colIndex++)
		{
			colId = window.tableconf[1].getColId(colIndex);
			cellModifyFlag = slmParamTable.getCellModify(rowIndex, colId);
			colKeyArray = window.tableconf[1].getColKeyArray(colIndex);
			
			for (var keyindx = 0, keyLen = colKeyArray.length; keyindx < keyLen; keyindx++)
			{
				param = new tagElement("param");
				var keyName = colKeyArray[keyindx].name;
				colValue = slmParamTable.getCellStoreValue(rowIndex, colId, keyName);
				if (keyName == "attenuation")
				{
					colValue = parseFloat(colValue) * 100; 
				}
				else if (keyName == "refractiveRate")
				{
					colValue = parseFloat(colValue) * 1000; 
				}
				else if (keyName == "fiberLength")
				{
					colValue = parseFloat(colValue) * 10; 
				}
				param.setAttribute("name", keyName);
				param.setAttribute("value", colValue);
				param.setAttribute("modifyFalg", cellModifyFlag);
				row.appendChild(param);
			}
		}
		
		var vFiberLength = slmParamTable.getCellStoreValue(rowIndex, "fiberLength", "fiberLength")
		var isModifyFiberLengthFlag = "true";
		var spanNo = slmParamTable.getCellStoreValue(rowIndex, "spanNo", "spanNo");
			
		for (var i = 0, len = crossSpanList.length; i < len; i++)
		{
			var crossSpan = crossSpanList[i];
			if (spanNo == crossSpan.spanNo)
			{
				if (vFiberLength == crossSpan.fiberLength)
				{
					isModifyFiberLengthFlag = "false";
					param = new tagElement("param");
					param.setAttribute("name","originalFiberLength");
					param.setAttribute("value",crossSpan.fiberLength);
					row.appendChild(param);
					
					break;
				}
				else
				{
					isModifyFiberLengthFlag = "true";
					
					param = new tagElement("param");
					param.setAttribute("name","originalFiberLength");
					param.setAttribute("value",crossSpan.fiberLength);
					row.appendChild(param);
					
					break;
				}
			}
		}
		
		param = new tagElement("param");
		param.setAttribute("name", "isModifyFiberLength");
		param.setAttribute("value", isModifyFiberLengthFlag);
		row.appendChild(param);
		
		bussiness.appendChild(row);
	}
	
	if(!isModified)
	{
		return null;
	}
	
	root.getRoot().appendChild(bussiness);

	return root.toString();
}
/**
 *                
 * @param doc
 * @return   
 */
function callbackApplyLineInfoData(doc)
{
	var data = EncapsulateData(doc);
	
	refreshTableState(slmParamTable, window.tableconf[1], data);
	setTableStatus(false);
	win.refreshBtnStatus();
	
	if(0 != data.getSErrorCode())
	{
		win.cellEditHandler(null)
		showErrorDialog(data);
	}
}

/**
 *                      
 * @param param
 * @return   
 */
function cellEditHandler(param)
{
	win.cellEditHandler(param);
}

/**
 *                                 
 * @param   
 * @return   
 */
function queryLineDetails()
{
	var selectedRow = win.slmLineTable.getSelectedRows();
	if (0 == selectedRow.length)
	{
		return;
	}
	
	setLineTableStatusParam(true);
	var data = createQueryLineDetailsXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE_DETAILS + "&nmUser=" + win.winurlobj["nmUser"];
	loadXMLdoc(url, "POST", sync, constructtblXML, null, "inputdata="+data);
	setLineTableStatusParam(false);

}
/**
 *                            XML   
 * @param   
 * @return   
 */
function createQueryLineDetailsXML()
{
	var selectedRow = win.slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
  var pageparam = new tagElement("page-params");
  param = new tagElement("param");
  param.setAttribute("name","pageNum");
  if(document.getElementById("pagenum").value != "")
  {
      param.setAttribute("value",document.getElementById("pagenum").value);
  }
  else
  {
      param.setAttribute("value","1");
  }
  pageparam.appendChild(param);
    
    
  param = new tagElement("param");
  param.setAttribute("name","resultNumPerPage");
  param.setAttribute("value",document.getElementById("columnnum").value);
  pageparam.appendChild(param);
  root.getRoot().appendChild(pageparam);
    
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
  var srcneid = win.slmLineTable.getCellStoreValue(selectedRow[0], "srcNEID", "srcNEID");
  if (null == srcneid || UNKNOWN == srcneid)
  {
  	srcneid = 0;
  }
  param = new tagElement("param");
  param.setAttribute("name", "srcneid");
  param.setAttribute("value", srcneid);
  row.appendChild(param);
    
  var sinkneid = win.slmLineTable.getCellStoreValue(selectedRow[0], "sinkNEID", "sinkNEID")
  if (null == sinkneid || UNKNOWN == sinkneid)
  {
    sinkneid = 0;
  }
  param = new tagElement("param");
  param.setAttribute("name", "sinkneid");
  param.setAttribute("value", sinkneid);
  row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", win.slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "spanNo");
	param.setAttribute("value", DEFAULT_QUERY_SEGMENTID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                         
 * @param doc
 * @return   
 */
function callbackQueryLineDetailsData(data)
{
	
	var refractiveRate;//          0.001
	var fiberLength;   //           1
	var attenuation;   //       0.01
	
	crossSpanList = [];
	
	segmentNum = 0;
	
	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode() || NSERR_MARINE_LINE_NOT_CONSISTANT == data.getSErrorCode())
	{
		segmentNum = data.getDataRowLength();
		
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			refractiveRate = (parseFloat(data.getDataRowParam(i, "refractiveRate")) / 1000).toFixed(3);
			fiberLength = (parseFloat(data.getDataRowParam(i, "fiberLength")) / 10).toFixed(1);
			attenuation = (parseFloat(data.getDataRowParam(i, "attenuation")) / 100).toFixed(2);
			data.rows[i]["refractiveRate"].value = refractiveRate;
			data.rows[i]["fiberLength"].value = fiberLength;
			data.rows[i]["attenuation"].value = attenuation;
			
			isSame = data.getDataRowParam(i, "isSame");
			
			var crossSpan = new TESLMLineCrossSpan(data.rows[i]["spanNo"].value, data.rows[i]["fiberLength"].value);
			crossSpanList.push(crossSpan);
		}
		createTableBody(slmParamTable, window.tableconf[1], data, RESOURCE);
		if(!slmParamTable.element.colsArray.selectedId)
	  {
	  	 slmParamTable.element.colsArray.selectedId = "spanNo";
	  	 slmParamTable.element.colsArray.imgflag = 1;
	  }
	  var td=slmParamTable.element.headRow.element.cols[slmParamTable.element.colsArray.selectedId].element; 
	  slmParamTable.sortRows(td,slmParamTable.element.colsArray.imgflag);
		
		
	}
	else
	{
	}
	setLineTableStatusParam(false);
	
	win.slmlineInfoTabs.enableHref();
	
	win.refreshBtnStatus();
}

/**
 *        
 * @param neid
 * @return   
 */
function TESLMLineCrossSpan(spanNo, fiberLength)
{
	this.spanNo = spanNo;
	this.fiberLength = fiberLength;
}


/**
 *             
 *        
 *       AU9D17370
 *                        
 * @param flg:      true                             
 * @return   
 */
function setTableStatus(flg)
{
	if(flg)
	{
		/*
		for (var i = 0, len = win.slmLineTable.getDataRowLength(); i < len; i++)
		{
			win.slmLineTable.getRow(i).element.onclick = null;
		}*/
		$("slmParamTable").oncontextmenu = null;
		for (var j = 0, len = slmParamTable.getDataRowLength(); j < len; j++)
		{
			slmParamTable.getCellElement(j, "fiberType").ondblclick = null;
			slmParamTable.getCellElement(j, "refractiveRate").ondblclick = null;
			slmParamTable.getCellElement(j, "attenuation").ondblclick = null;
			slmParamTable.getCellElement(j, "fiberLength").ondblclick = null;
		}
	}
	else
	{
		/*
		for (var i = 0, len = win.slmLineTable.getDataRowLength(); i < len; i++)
		{
			win.slmLineTable.getRow(i).element.onclick = rowclick;
		}*/
		
		$("slmParamTable").oncontextmenu = popupMenuHandler;
		for (var j = 0, len = slmParamTable.getDataRowLength(); j < len; j++)
		{
			slmParamTable.getCellElement(j, "fiberType").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "refractiveRate").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "attenuation").ondblclick = cellondbclick;
			slmParamTable.getCellElement(j, "fiberLength").ondblclick = cellondbclick;
		}
	}
}
/**
 *              
 * @param flg:      true                             
 * @return   
 */
function setLineTableStatusParam(flg)
{
	/**
	if(flg)
	{
		for (var i = 0, len = win.slmLineTable.getDataRowLength(); i < len; i++)
		{
			win.slmLineTable.getRow(i).element.onclick = null;
		}
	}
	else
	{
		for (var i = 0, len = win.slmLineTable.getDataRowLength(); i < len; i++)
		{
			win.slmLineTable.getRow(i).element.onclick = win.slmLineTable.rowclick;
		}
	}*/
}


function firstpage()
{
    document.getElementById("pagenum").value = 1;
    queryLineDetails();
}

function pageup()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value)-1;
    queryLineDetails();
}

function pagedown()
{
    document.getElementById("pagenum").value = parseInt(document.getElementById("pagenum").value) + 1;
    queryLineDetails();
}

function lastpage()
{
	var str = document.getElementById("pagestatus").innerHTML;
    document.getElementById("pagenum").value = str.split("/")[1];
    queryLineDetails();
}


function constructtblXML(doc)
{
    for(var i=0; i< slmParamTable.getDataRowLength(); i++)
    {
        slmParamTable.deleteRow(i);
    }
    slmParamTable.adjustDataRows();
    
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
	  
    if("pageNum" in dinterface.page)
    {
        var total = document.getElementById("totalitem");
        total.removeChild(total.childNodes[0]);
        total.appendChild(document.createTextNode(dinterface.getPageParam("totalResultNum").value));

        document.getElementById("theitem").innerHTML = 0;
        
        document.getElementById("pagestatus").innerHTML = dinterface.getPageParam("pageNum").value+"/"+dinterface.getPageParam("totalPageNum").value;
        
        optionlen = document.getElementById("pagenum").options.length;
        for(i = 0; i < optionlen; i++)
        {
            document.getElementById("pagenum").options[0] = null;
        }
        for(i = 0; i < dinterface.getPageParam("totalPageNum").value; i++)
        {
            document.getElementById("pagenum").options[i] = new Option(i+1,i+1);
        }
        document.getElementById("pagenum").value = dinterface.getPageParam("pageNum").value;
        if(dinterface.getPageParam("pageNum").value > 1)
        {
        	  $("previouspage").innerHTML = "<a href='javascript:pageup();'><u>" + RESOURCE["previouspage"] + "</u></a>";
            $("firstpage").innerHTML = "<a href='javascript:firstpage();'><u>" + RESOURCE["firstpage"] + "</u></a>";
            document.getElementById("previouspage").disabled = false;
            document.getElementById("firstpage").disabled = false;
        }
        else
        {
        	  $("previouspage").innerHTML = RESOURCE["previouspage"];
            $("firstpage").innerHTML = RESOURCE["firstpage"];
            document.getElementById("previouspage").disabled = true;
            document.getElementById("firstpage").disabled = true;
        }
        if(dinterface.getPageParam("pageNum").value != dinterface.getPageParam("totalPageNum").value)
        {
        	  $("nextpage").innerHTML = "<a href='javascript:pagedown();'><u>" + RESOURCE["nextpage"] + "</u></a>";
            $("lastpage").innerHTML = "<a href='javascript:lastpage();'><u>" + RESOURCE["lastpage"] + "</u></a>";
            document.getElementById("nextpage").disabled = false;
            document.getElementById("lastpage").disabled = false;
        }
        else
        {
        	  $("nextpage").innerHTML = RESOURCE["nextpage"];
            $("lastpage").innerHTML = RESOURCE["lastpage"];
            document.getElementById("nextpage").disabled = true;
            document.getElementById("lastpage").disabled = true;
        }
        var countsPerPage = dinterface.getPageParam("resultNumPerPage").value;
        if (countsPerPage != 20 && countsPerPage != 40 && countsPerPage != 60 &&
        		countsPerPage != 80 && countsPerPage != 100)
        {
        	document.getElementById("columnnum").value = 0;
        }
        else
        {
        	document.getElementById("columnnum").value = countsPerPage;
        }
        
    }
    else
    {
    	document.getElementById("theitem").innerHTML = 0;
    	document.getElementById("totalitem").innerHTML = 0;
    	
    	document.getElementById("pagestatus").innerHTML = "1/1"
    	optionlen = document.getElementById("pagenum").options.length;
      for(i = 0; i < optionlen; i++)
      {
          document.getElementById("pagenum").options[0] = null;
      }
      document.getElementById("pagenum").options[0] = new Option(1,1);
      
      document.getElementById("previouspage").disabled = true;
      document.getElementById("firstpage").disabled = true;
      document.getElementById("nextpage").disabled = true;
      document.getElementById("lastpage").disabled = true;
      document.getElementById("previouspage").innerHTML = RESOURCE["previouspage"];
			document.getElementById("firstpage").innerHTML = RESOURCE["firstpage"];
			document.getElementById("nextpage").innerHTML = RESOURCE["nextpage"];
			document.getElementById("lastpage").innerHTML = RESOURCE["lastpage"];
   }

   callbackQueryLineDetailsData(dinterface);
}



