/**
 *                 js                     
 *     :        00104334
 *    : 2008-01-23
 */

var winurlobj = getNeProperty(self);

var nmUser = parseURLStr(self)["nmUserName"];
if(nmUser == undefined)
{
    nmUser = parseURLStr(self)["nmUser"];
}

var lineInfoTable = null;

var lineStatus = null;

var FILE_TRANS_FLAG = false;

var btnRight = null;

var menuRight = null;

var timer = null;
var pageIsVisble = true;
var isShowInfoOOS = false;

var ISBtnStatus = false;
var OOSBtnStatus = false;

var waveLengthList = null;

var bandTypeList = [];
bandTypeList[0] = "C+L";
bandTypeList[1] = "C";
bandTypeList[2] = "L";
bandTypeList[3] = "C320G";
bandTypeList[4] = "LMC";
bandTypeList[5] = "LML";
bandTypeList[6] = "CWDM";
    
var sync = true;

/**
 *         
 */
function initPage()
{
	  if (!isIE)
	  {
		  sync = false;
	  }
	
    initTable();
    
    initButton();
    
    
	  getWaveLength();
    
    getLineStatus();
    
    timer = setInterval("refreshLineStatus()", 5000);
}

/**
 *                  ?
 */
function initTable()
{
	initLineInfoTable();
	
    initLineStatusTable();       
}

/**
 *               ?
 */
function initLineInfoTable()
{
    lineInfoTable = new SortTable();
    
    lineInfoTable.setImage("../../../../images/");
    
    lineInfoTable.setBodyHeight(getComponetHeight($("lineInfoTableDiv"), 400)+"px");
    
    createTableHead(lineInfoTable, window.tableconf[0]);
    
    lineInfoTable.setOnRowSelectHandler(lineInfoRowSltHandler);
    
    lineInfoTable.setOnCellEditHandler(cellEditHandler);
    
    lineInfoTable.setSingleChoiceFlg(true);
    
    $("lineInfoTableDiv").oncontextmenu = rightClickHandler;          
    
    $("lineInfoTableDiv").appendChild(lineInfoTable.getTable());
}

/**
 *              ?
 */
function initLineStatusTable()
{
    lineStatus = new SortTable();
    
    lineStatus.setImage("../../../../images/");
    
    lineStatus.setBodyHeight(getComponetHeight($("lineStatusTableDiv"), 120)+"px");
    
    createTableHead(lineStatus, window.tableconf[1]);
    
    lineStatus.setOnRowSelectHandler(lineStatusRowSltHandler);
    
    lineStatus.setOnCellEditHandler(cellEditHandler);
    
    lineStatus.setSingleChoiceFlg(true);
    
    
    $("lineStatusTableDiv").appendChild(lineStatus.getTable());  
}

function refreshLineInfoTableStaData()
{
	var selectedRows = lineInfoTable.getSelectedRows();
    $("upSelRows").innerHTML = selectedRows.length;
	$("uptotalrows").innerHTML = lineInfoTable.getDataRowLength();
}

function refreshLineStatusStaData()
{
	var selectedRows = lineStatus.getSelectedRows();
    $("downSelRows").innerHTML = selectedRows.length;
	$("downTotalRows").innerHTML = lineStatus.getDataRowLength();
}

function lineInfoRowSltHandler()
{
	refreshLineInfoTableStaData();
	
	lineStatus.clearTableData();
	
	var selectedRows = lineInfoTable.getSelectedRows();
	
    if (0 == selectedRows.length || selectedRows.length >= 2)
    {
    	lineStatusRowSltHandler();
        return;
    }
	
	var data = createLineStatusData(selectedRows);
	
	
	createTableBody(lineStatus, window.tableconf[1], data, RESOURCE, null, null, null, $('lineStatusTableDiv').clientWidth);
	
	refreshLineStatusStaData();
	
	if (0 < lineStatus.getDataRowLength() && 0 == lineStatus.getSelectedRowCount())
	{
		lineStatus.setRowSelect(0);
	}
	else
	{
			
	}
}

/**
 *                       XML   ?
 * @param   
 * @return   
 */
function createLineStatusData(selectedRows)
{
	var lineID = -1;
	var srcProbeWaveBand = null;
	var srcProbeWaveIndex = null;
	var srcLoadingWaveBand = null;
	var srcLoadingWaveIndex = null;
	var srcTestStatus = null;
	var srcTestMode = -1;
	var srcTestType = -1;
	var srcStartTime = null;
	var srcRemainingTime = null;
	var srcTestProgress = null;
	var srcLmuNeId = null;
	var srcLmuNeName = null;
	var srcLmuSlotId = null;
	var srcLmuPortId = null;
	var srcLmiNEId = null;
	var srcLmiSlotId = null;
	var srcLmiPortId = null;
	var srcFilterStatus = null;
	var srcCommunicateCheck = null;
	
	var sinkProbeWaveBand = null;
	var sinkProbeWaveIndex = null;
	var sinkLoadingWaveBand = null;
	var sinkLoadingWaveIndex = null;
	var sinkTestStatus = null;
	var sinkTestMode = -1;
	var sinkTestType = -1;
	var sinkStartTime = null;
	var sinkRemainingTime = null;
	var sinkTestProgress = null;
	var sinkLmuNeId = null;
	var sinkLmuNeName = null;
	var sinkLmuSlotId = null;
	var sinkLmuPortId = null;
	var sinkLmiNEId = null;
	var sinkLmiSlotId = null;
	var sinkLmiPortId = null;
	var sinkFilterStatus = null;
	var sinkCommunicateCheck = null;
	
	var lineDirection = null;
	
	var dataInterface = new DataInterface();
	var row = null;
	var ptag = null;

	var rowId = -1;
	for (var i = 0, len = selectedRows.length; i < len; i ++)
	{
		rowId = selectedRows[i];
		lineID = getLineInfoCellValue(rowId, "lineID", "lineID");
		lineDirection = getLineInfoCellValue(rowId, "lineDirection", "lineDirection");
		
		srcProbeWaveBand = getLineInfoCellValue(rowId, "srcProbeWaveBand", "srcProbeWaveBand");
		srcProbeWaveIndex = getLineInfoCellValue(rowId, "srcProbeWaveIndex", "srcProbeWaveIndex");
		srcLoadingWaveBand = getLineInfoCellValue(rowId, "srcLoadingWaveBand", "srcLoadingWaveBand");
		srcLoadingWaveIndex = getLineInfoCellValue(rowId, "srcLoadingWaveIndex", "srcLoadingWaveIndex");
		srcFilterStatus = getLineInfoCellValue(rowId, "srcFilterStatus", "srcFilterStatus");
		srcCommunicateCheck = getLineInfoCellValue(rowId, "srcCommunicateCheck", "srcCommunicateCheck");
		srcTestStatus = getLineInfoCellValue(rowId, "srcTestStatus", "srcTestStatus");
		srcTestMode = getLineInfoCellValue(rowId, "srcTestMode", "srcTestMode");
		srcTestType = getLineInfoCellValue(rowId, "srcTestType", "srcTestType");
		srcStartTime = getLineInfoCellValue(rowId, "srcStartTime", "srcStartTime");
		srcRemainingTime = getLineInfoCellValue(rowId, "srcRemainingTime", "srcRemainingTime");
		srcTestProgress = getLineInfoCellValue(rowId, "srcTestProgress", "srcTestProgress");
		if ("-" != srcTestProgress)
    {
        srcTestProgress = getTestProgress(srcTestProgress);
    }
		srcLmuNeId = getLineInfoCellValue(rowId, "srcLmuNeId", "srcLmuNeId");
		srcLmuNeName = getLineInfoCellValue(rowId, "srcLmuNeName", "srcLmuNeName");
    srcLmuSlotId = getLineInfoCellValue(rowId, "srcLmuSlotId", "srcLmuSlotId");
	  srcLmuPortId = getLineInfoCellValue(rowId, "srcLmuPortId", "srcLmuPortId");
		srcLmiNEId = getLineInfoCellValue(rowId, "srcLmiNeId", "srcLmiNeId");
	  srcLmiSlotId = getLineInfoCellValue(rowId, "srcLmiSlotId", "srcLmiSlotId");
	  srcLmiPortId = getLineInfoCellValue(rowId, "srcLmiPortId", "srcLmiPortId");
		
		sinkProbeWaveBand = getLineInfoCellValue(rowId, "sinkProbeWaveBand", "sinkProbeWaveBand");
		sinkProbeWaveIndex = getLineInfoCellValue(rowId, "sinkProbeWaveIndex", "sinkProbeWaveIndex");
		sinkLoadingWaveBand = getLineInfoCellValue(rowId, "sinkLoadingWaveBand", "sinkLoadingWaveBand");
		sinkLoadingWaveIndex = getLineInfoCellValue(rowId, "sinkLoadingWaveIndex", "sinkLoadingWaveIndex");
		sinkFilterStatus = getLineInfoCellValue(rowId, "sinkFilterStatus", "sinkFilterStatus");
		sinkCommunicateCheck = getLineInfoCellValue(rowId, "sinkCommunicateCheck", "sinkCommunicateCheck");
		sinkTestStatus = getLineInfoCellValue(rowId, "sinkTestStatus", "sinkTestStatus");
		sinkTestMode = getLineInfoCellValue(rowId, "sinkTestMode", "sinkTestMode");
		sinkTestType = getLineInfoCellValue(rowId, "sinkTestType", "sinkTestType");
		sinkStartTime = getLineInfoCellValue(rowId, "sinkStartTime", "sinkStartTime");
		sinkRemainingTime = getLineInfoCellValue(rowId, "sinkRemainingTime", "sinkRemainingTime");
		sinkTestProgress = getLineInfoCellValue(rowId, "sinkTestProgress", "sinkTestProgress");
		if ("-" != sinkTestProgress)
    {
       sinkTestProgress = getTestProgress(sinkTestProgress);
    }
		sinkLmuNeId = getLineInfoCellValue(rowId, "sinkLmuNeId", "sinkLmuNeId");
		sinkLmuNeName = getLineInfoCellValue(rowId, "sinkLmuNeName", "sinkLmuNeName");
		sinkLmuSlotId = getLineInfoCellValue(rowId, "sinkLmuSlotId", "sinkLmuSlotId");
	  sinkLmuPortId = getLineInfoCellValue(rowId, "sinkLmuPortId", "sinkLmuPortId");
		sinkLmiNEId = getLineInfoCellValue(rowId, "sinkLmiNeId", "sinkLmiNeId");
	  sinkLmiSlotId = getLineInfoCellValue(rowId, "sinkLmiSlotId", "sinkLmiSlotId");
	  sinkLmiPortId = getLineInfoCellValue(rowId, "sinkLmiPortId", "sinkLmiPortId");
		
		if (srcLmuNeId != null && srcLmuNeId != "0")
		{
			row = new Object();lineDirection
			appendRowParam(row, "lineDirection", "1");
			appendRowParam(row, "lineID", lineID);
		  appendRowParam(row, "probeWaveBand", bandTypeList[srcProbeWaveBand]);
		  if (srcProbeWaveIndex != 0 && srcProbeWaveIndex != null)
		  {
		  	appendRowParam(row, "probeWaveIndex", waveLengthList.bandType[srcProbeWaveBand].options[srcProbeWaveIndex - 1].text);
		  }
		  else
		  {
		  	appendRowParam(row, "probeWaveIndex", "--");
		  }
			appendRowParam(row, "loadingWaveBand", bandTypeList[srcLoadingWaveBand]);
			if (srcLoadingWaveIndex != 0 && srcLoadingWaveIndex != null)
		  {
		  	appendRowParam(row, "loadingWaveIndex", waveLengthList.bandType[srcLoadingWaveBand].options[srcLoadingWaveIndex - 1].text);
		  }
		  else
		  {
		  	appendRowParam(row, "loadingWaveIndex", "--");
		  }
		  appendRowParam(row, "filterStatus", srcFilterStatus);
		  appendRowParam(row, "communicateCheck", srcCommunicateCheck);
			appendRowParam(row, "testMode", srcTestMode);
			appendRowParam(row, "testType", srcTestType);
			appendRowParam(row, "startTime", srcStartTime);
			appendRowParam(row, "remainingTime", srcRemainingTime);
			appendRowParam(row, "testProgress", srcTestProgress);
			appendRowParam(row, "neid", srcLmuNeId);
			appendRowParam(row, "currentWorkStatus", srcTestStatus);
			appendRowParam(row, "direction", LINE_DIR_CUR);
			appendRowParam(row, "lmuNEId", srcLmuNeId);
			appendRowParam(row, "lmuSlotId", srcLmuSlotId);
			appendRowParam(row, "lmuPortId", srcLmuPortId);
			appendRowParam(row, "lmiNEId", srcLmiNEId);
			appendRowParam(row, "lmiSlotId", srcLmiSlotId);
			appendRowParam(row, "lmiPortId", srcLmiPortId);
			appendRowParam(row, "nename", srcLmuNeName);
					
			dataInterface.rows.append(row);
		}
		
		if (sinkLmuNeId != null && sinkLmuNeId != "0")
		{
			row = new Object();
			appendRowParam(row, "lineDirection", "0");
			appendRowParam(row, "lineID", lineID);
			appendRowParam(row, "probeWaveBand", bandTypeList[sinkProbeWaveBand]);
			if (sinkProbeWaveIndex != 0 && sinkProbeWaveIndex != null)
		  {
		  	appendRowParam(row, "probeWaveIndex", waveLengthList.bandType[sinkProbeWaveBand].options[sinkProbeWaveIndex - 1].text);
		  }
		  else
		  {
		  	appendRowParam(row, "probeWaveIndex", "--");
		  }
			appendRowParam(row, "loadingWaveBand", bandTypeList[sinkLoadingWaveBand]);
			if (sinkLoadingWaveIndex != 0 && sinkLoadingWaveIndex != null)
		  {
		  	appendRowParam(row, "loadingWaveIndex", waveLengthList.bandType[sinkLoadingWaveBand].options[sinkLoadingWaveIndex - 1].text);
		  }
		  else
		  {
		  	appendRowParam(row, "loadingWaveIndex", "--");
		  }
		  appendRowParam(row, "filterStatus", sinkFilterStatus);
		  appendRowParam(row, "communicateCheck", sinkCommunicateCheck);
			appendRowParam(row, "testMode", sinkTestMode);
			appendRowParam(row, "testType", sinkTestType);
			appendRowParam(row, "startTime", sinkStartTime);
			appendRowParam(row, "remainingTime", sinkRemainingTime);
			appendRowParam(row, "testProgress", sinkTestProgress);
			appendRowParam(row, "neid", sinkLmuNeId);
			appendRowParam(row, "currentWorkStatus", sinkTestStatus);
			appendRowParam(row, "direction", LINE_DIR_REVERSE);
			appendRowParam(row, "lmuNEId", sinkLmuNeId);
			appendRowParam(row, "lmuSlotId", sinkLmuSlotId);
			appendRowParam(row, "lmuPortId", sinkLmuPortId);
			appendRowParam(row, "lmiNEId", sinkLmiNEId);
			appendRowParam(row, "lmiSlotId", sinkLmiSlotId);
			appendRowParam(row, "lmiPortId", sinkLmiPortId);
			appendRowParam(row, "nename", sinkLmuNeName);
			
			dataInterface.rows.append(row);
		}
	}

	return dataInterface;
}

function getLineInfoCellValue(rowId, cellName, cellObjName)
{
	return lineInfoTable.getCellStoreValue(rowId, cellName, cellObjName);
}

function appendRowParam(row, paramName, paramValue)
{
	var ptag = new ParamTag();
	ptag.value = paramValue;
	row[paramName] = ptag;
}

/**
 *                       added by l00104422
 * @param param
 * @return   
 */
function cellEditHandler(param)
{
	$("applyBtn").disabled = (!btnRight.applyBtn.right);
}

/**
 *          added by l00104422
 */
function refreshApplyBtn()
{
	$("applyBtn").disabled = true;
}

/**
 *         
 */
function initButton()
{
    $("applyBtn").value = RESOURCE["applyBtn"];
    $("getLineStatus").value = RESOURCE["getLineStatus"];
    $("syncTestData").value = RESOURCE["syncTestData"];
    $("getTestResult").value = RESOURCE["getTestResult"];
    $("getCurrResult").value = RESOURCE["getCurrResult"];
    $("buttonIS").value = RESOURCE["buttonIS"];
    $("buttonOOS").value = RESOURCE["buttonOOS"];
    
    if ("en" == SYSTEMCONF.getLanguage())
    {
        $("getLineStatus").style.width = "125px";
        $("syncTestData").style.width = "150px";
        $("getCurrResult").style.width = "160px";
        $("getTestResult").style.width = "125px";
    }
    else
    {
        $("getLineStatus").style.width = "100px";
        $("syncTestData").style.width = "100px";
        $("getCurrResult").style.width = "120px";
        $("getTestResult").style.width = "100px";
        $("buttonOOS").className = "buttonstyle7";
    }
    
    getAllBtnRight();
    getMenuBtnRight();
    
    $("buttonIS").onclick = initISBtn;  
    
    $("buttonOOS").onclick = initOOSBtn;
    
    queryInServiceTestSupport();
    
    $("syncTestData").disabled = true;
    $("getTestResult").disabled = true; 
    $("getCurrResult").disabled = true;
}
/**
 *             
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_SLM_REFRESH_TYPE_SET);   
    
    btnRight.getLineStatus = new BtnRightObj("getLineStatus", TECMDCODE_SLM_GET_LINE_STATUS);    
    
    btnRight.syncTestData = new BtnRightObj("syncTestData", TECMDCODE_SLM_SYNC_TEST_DATA);
    
    
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
    
}
/**
 *                    
 *        FOG           
 *     SLM1630  5.61.01.30               
 * @param   
 * @return   
 */
function queryInServiceTestSupport()
{
	var data = createQueryInServiceTestSupportXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_QUERY_ISFUN_SUPPORT + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", sync, callbackQueryInServiceTestSupport, null, "inputdata="+data);
}
/**
 *                       XML   ?
 * @param   
 * @return   
 */
function createQueryInServiceTestSupportXML()
{
  var obj = getNeProperty(self);    
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "funID");
	param.setAttribute("value", FUN_SPT_ALL); //        0x0000
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}

/**
 *                                 ?
 * @param doc
 * @return   
 */
function callbackQueryInServiceTestSupport(doc)
{
	var data = EncapsulateData(doc);
	var isSupportInServiceTest;
	var funID;
	var flag = false;
	var isSupport;
	if (0 == data.getSErrorCode())
	{
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			funID = data.getDataRowParam(i,"funID");
			isSupport = data.getDataRowParam(i,"isSupport");
			
			refreshBtnShow(funID, isSupport);
			
		}
	}
}

/**
 *             ?
 *            ID 0                                 isSupport 1
 *       ID 
 */
function refreshBtnShow(funID, isSupport)
{
	var tmpFlag = (FUN_NOT_SUPPORT == isSupport);
	if (FUN_SPT_ALL == funID)
	{
		isShowInfoOOS = tmpFlag;
		ISBtnStatus = tmpFlag;
		OOSBtnStatus = tmpFlag;
		$("buttonIS").disabled = ISBtnStatus;
		$("buttonOOS").disabled = OOSBtnStatus;
		return;
	}
	
	if (FUN_SPT_ALL_IS == funID)
	{
		isShowInfoOOS = tmpFlag;
		ISBtnStatus = tmpFlag;
		$("buttonIS").disabled = ISBtnStatus;
		return;
	}
	
	if (FUN_SPT_ALL_OOS == funID)
	{
		isShowInfoOOS = tmpFlag;
		OOSBtnStatus = tmpFlag;
		$("buttonOOS").disabled = OOSBtnStatus;
		return;
	}
	
	refreshMenuStatus(funID, isSupport);
	
}
/**
 *              
 */
function refreshMenuStatus(funID, isSupport)
{
	var sptFlag = (FUN_IS_SUPPORT == isSupport);
	if (funID == FUN_SPT_IS_BASELINE)
	{
		menuRight.startBaselineTestIS.right = menuRight.startBaselineTestIS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_IS_SINGLE)
	{
		menuRight.startSingleTestIS.right = menuRight.startSingleTestIS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_IS_MANUAL)
	{
		menuRight.startManualTestIS.right = menuRight.startManualTestIS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_IS_PERIOD)
	{
		menuRight.startCycleTestIS.right = menuRight.startCycleTestIS.right && sptFlag;	
		return;
	}

	if (funID == FUN_SPT_ALL_OOS_BASELINE)
	{
		menuRight.startBaselineTestOOS.right = menuRight.startBaselineTestOOS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_ALL_OOS_SINGLE)
	{
		menuRight.startSingleTestOOS.right = menuRight.startSingleTestOOS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_ALL_OOS_MANUAL)
	{
		menuRight.startManualTestOOS.right = menuRight.startManualTestOOS.right && sptFlag;	
		return;
	}
	else if (funID == FUN_SPT_ALL_OOS_QUICK)
	{
		menuRight.startQuickTestOOS.right = menuRight.startQuickTestOOS.right && sptFlag;	
		return;
	}
}


/**
 *                ?
 */
function getMenuBtnRight()
{
    menuRight = new Object();
    
                                                        
    menuRight.startSingleTestIS = new BtnRightObj("startSingleTestIS", TECMDCODE_SLM_START_TEST);                                                 
                                                        
    menuRight.startManualTestIS = new BtnRightObj("startManualTestIS", TECMDCODE_SLM_START_TEST);                                                 
                                                        
    menuRight.startBaselineTestIS = new BtnRightObj("startBaselineTestIS", TECMDCODE_SLM_START_TEST);
    
                                                        
    menuRight.startCycleTestIS = new BtnRightObj("startCycleTestIS", TECMDCODE_SLM_START_CYCLE_TEST);                                                    
                                                        
    menuRight.stopTestIS = new BtnRightObj("stopTestIS", TECMDCODE_SLM_STOP_TEST);                                                    
                                                        
    menuRight.manageBaselineIS = new BtnRightObj("manageBaselineIS", MANAGE_BASELINE_IS);                                                    
                                                        
    menuRight.manageTestParamIS = new BtnRightObj("manageTestParamIS", TECMDCODE_SLM_GET_TEST_PARAM);                                                 
                                                        
    menuRight.repeaterTDAnalysisIS = new BtnRightObj("repeaterTDAnalysisIS", REPEATER_TD_ANALYSIS_IS);                                        
                                                        
    menuRight.lineTDAnalysisIS = new BtnRightObj("lineTDAnalysisIS", LINE_TD_ANALYSIS_IS);                                                    
       
    
    menuRight.startSingleTestOOS = new BtnRightObj("startSingleTestOOS", TECMDCODE_SLM_START_OUTSERVICE_TEST);
    
    menuRight.startManualTestOOS = new BtnRightObj("startManualTestOOS", TECMDCODE_SLM_START_OUTSERVICE_TEST);
    
    menuRight.startBaselineTestOOS = new BtnRightObj("startBaselineTestOOS", TECMDCODE_SLM_START_OUTSERVICE_TEST);
    
		menuRight.startQuickTestOOS= new BtnRightObj("startQuickTestOOS", TECMDCODE_SLM_START_OUTSERVICE_TEST);
    
    menuRight.stopTestOOS = new BtnRightObj("stopTestOOS", TECMDCODE_SLM_STOP_OUTSERVICE_TEST);
    
    menuRight.manageBaselineOOS = new BtnRightObj("manageBaselineOOS", MANAGE_BASELINE_OOS);
    
    menuRight.manageTestParamOOS = new BtnRightObj("manageTestParamOOS", TECMDCODE_SLM_GET_TEST_PARAM);
    
    menuRight.testDataAnalysisOOS = new BtnRightObj("testDataAnalysisOOS", TEST_DATA_ANALYSIS_OOS);     
    
    menuRight.getLineMoreInfo = new BtnRightObj("getLineMoreInfo", TECMDCODE_SLM_LINEMGR_QUERY_LINE);
    
    
    getRightInfo(winurlobj, menuRight);
}

/**
 *                      
 */
function initISBtn(evt)
{
    removejsDOMmenu();
    
    if (!evt)
    {
        evt = window.event;
    }
    evt.cancelBubble = true;
    
    var cursorMenu = null;
    if ("en" == SYSTEMCONF.getLanguage())
    {
        cursorMenu = new jsDOMenu(283); //    ?180px
    }
    else
    {
        cursorMenu = new jsDOMenu(173); //    ?150px
    }
    
    
    var isOneLineSlct = isOneLineSelected();
    
    var isIdle = isIdleStatus();
    
    var isIS = isTestMode(IS_MODE);    
    
    
    var item = null;
    
    item = new menuItem(RESOURCE["StartSingleTest"], "",startSingleTestIS, "", (isIdle && menuRight.startSingleTestIS.right));
    
    item.id = "startSingleTestIS";
    
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartManualTest"], "",startManualTestIS, "", (isIdle && menuRight.startManualTestIS.right));
    item.id = "startManualTestIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartBaselineTest"], "",startBaselineTestIS, "", (isIdle && menuRight.startBaselineTestIS.right));
    item.id = "startBaselineTestIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartCycleTest"], "",startCycleTestIS, "", menuRight.startCycleTestIS.right);
    item.id = "startCycleTestIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
        
    item = new menuItem(RESOURCE["StopTest"], "",stopTestIS, "", (isIS && menuRight.stopTestIS.right));
    item.id = "stopTestIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["ManageBaseline"], "",manageBaselineIS, "", isOneLineSlct);
    item.id = "manageBaselineIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["ManageTestParam"], "",manageTestParamIS, "", (isOneLineSlct && menuRight.manageTestParamIS.right));
    item.id = "manageTestParamIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["LineTestDataAnalysis"], "",lineTestDataAnalysisIS, "", isOneLineSlct);
    item.id = "lineTDAnalysisIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["RepeaterTestDataAnalysis"], "",repeaterTestDataAnalysisIS, "", isOneLineSlct);
    item.id = "repeaterTDAnalysisIS";
    cursorMenu.addMenuItem(item);
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["rptReport"], "",inSerRepeaterReportIS, "", true);
    item.id = "repeaterReportIS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["eventReport"], "",eventReportIS, "", true);
    item.id = "eventReportIS";
    cursorMenu.addMenuItem(item);
    
    
    setPopUpMenu(cursorMenu);
    
    showMenu(evt);
}
/**
 *               
 *
 */
function eventReportIS()
{
    removejsDOMmenu();
		
        var selectedRows = lineStatus.getSelectedRows();
    var rowId = selectedRows[0];
		var neID = lineStatus.getCellStoreValue(rowId, "neid", "neid");
		var neName = lineStatus.getCellStoreValue(rowId, "nename", "nename");
		var lineID = lineStatus.getCellStoreValue(rowId, "lineID", "lineID");
		var lineDirection = lineStatus.getCellStoreValue(rowId, "lineDirection", "lineDirection");
		var functitle = RESOURCE["LineIDcolon"] + lineID + " - " + RESOURCE[LINE_DIRECTION[lineDirection]] + " - " + RESOURCE["InServiceMode"] + " - " + RESOURCE["eventReport"];
    var url = "eventReport.html?&neID=" + neID + "&testMode=" + IS_MODE  + "&nmUser=" + nmUser + "&functitle=" + encodeURI(functitle);   
		
		if (isIE)
		{
		    xshowModalDialog(url, "eventReportIS", 900, 560, "../../../../images/");
		}
		else
		{
		    xshowModalDialog(url, functitle, 860, 560, "../../../../images/");
		}
		
	/*var report = window.open(url,"rptReport","height = 560,width = 860,resizable = yes, location=no, titlebar=no,toolbar=no,menubar=no,status=no");
	  var startx = (screen.availWidth - 860)/2;
   	var starty = (screen.availHeight - 560)/2;
	
	  report.moveTo(startx, starty);
	  report.focus();*/
}
/**
 *               
 *
 */
function inSerRepeaterReportIS()
{
    removejsDOMmenu();
		
    var selectedRows = lineStatus.getSelectedRows();
    var rowId = selectedRows[0];
		var neID = lineStatus.getCellStoreValue(rowId, "neid", "neid");
		var neName = lineStatus.getCellStoreValue(rowId, "nename", "nename");
		var lineID = lineStatus.getCellStoreValue(rowId, "lineID", "lineID");
		var lineDirection = lineStatus.getCellStoreValue(rowId, "lineDirection", "lineDirection");
		var functitle = RESOURCE["LineIDcolon"] + lineID + " - " + RESOURCE[LINE_DIRECTION[lineDirection]] + " - " + RESOURCE["InServiceMode"] + " - " + RESOURCE["rptReport"];
    var url = "rptReport.html?&neID=" + neID + "&testMode=" + IS_MODE + "&nmUser=" + nmUser + "&functitle=" + encodeURI(functitle);    
		
		if (isIE)
		{
		    xshowModalDialog(url, "inSerRepeaterReportIS", 900, 560, "../../../../images/");
		}
		else
		{
		    xshowModalDialog(url, functitle, 860, 560, "../../../../images/");
		}
		
	/*var report = window.open(url,"rptReport","height = 560,width = 860,resizable = yes, location=no, titlebar=no,toolbar=no,menubar=no,status=no");
	  var startx = (screen.availWidth - 860)/2;
   	var starty = (screen.availHeight - 560)/2;
	
	  report.moveTo(startx, starty);
	  report.focus();*/
}
/**
 *                      
 */
function initOOSBtn(evt)
{
    removejsDOMmenu();
    
    if (!evt)
    {
        evt = window.event;
    }
    evt.cancelBubble = true;
    
    var cursorMenu = null;
    if ("en" == SYSTEMCONF.getLanguage())
    {
        cursorMenu = new jsDOMenu(283); //    ?180px
    }
    else
    {
        cursorMenu = new jsDOMenu(185); //    ?150px
    }
   
    
    var isOneLineSlct = isOneLineSelected();
    
    var isIdle = isIdleStatus();
    
    var isIS = isTestMode(OOS_MODE);      
    
    
    var item = null;
    
    item = new menuItem(RESOURCE["StartSingleTest"], "",startSingleTestOOS, "", (isIdle && menuRight.startSingleTestOOS.right));
    item.id = "startSingleTestOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartManualTest"], "",startManualTestOOS, "", (isIdle && menuRight.startManualTestOOS.right));
    item.id = "startManualTestOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartBaselineTest"], "",startBaselineTestOOS, "", (isIdle && menuRight.startBaselineTestOOS.right));
    item.id = "startBaselineTestOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StartQuickTest"], "",startQuickTestOOS, "", (isIdle && menuRight.startQuickTestOOS.right));
    item.id = "startQuickTestOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["StopTest"], "",stopTestOOS, "", (isTestMode(OOS_MODE) && menuRight.stopTestOOS.right));
    item.id = "stopTestOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["ManageBaseline"], "",manageBaselineOOS, "", isOneLineSlct);
    item.id = "manageBaselineOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["ManageTestParam"], "",manageTestParamOOS, "", (isOneLineSlct && menuRight.manageTestParamOOS.right));
    item.id = "manageTestParamOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["TestDataAnalysis"], "",testDataAnalysisOOS, "", isOneLineSlct);
    item.id = "testDataAnalysisOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem("-", "","", "", true);
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["rptReport"], "",outSerRepeaterReportOOS, "", true);
    item.id = "repeaterReportOOS";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["eventReport"], "",eventReportOOS, "", true);
    item.id = "eventReportOOS";
    cursorMenu.addMenuItem(item);
    
    setPopUpMenu(cursorMenu);
   
    showMenu(evt);
}
/**
 *                
 *
 */
function eventReportOOS()
{
    removejsDOMmenu();
		
    var selectedRows = lineStatus.getSelectedRows();
    var rowId = selectedRows[0];
		var neID = lineStatus.getCellStoreValue(rowId, "neid", "neid");
		var neName = lineStatus.getCellStoreValue(rowId, "nename", "nename");
		var lineID = lineStatus.getCellStoreValue(rowId, "lineID", "lineID");
		var lineDirection = lineStatus.getCellStoreValue(rowId, "lineDirection", "lineDirection");
		var functitle = RESOURCE["LineIDcolon"] + lineID + " - " + RESOURCE[LINE_DIRECTION[lineDirection]] + " - " + RESOURCE["OutOfServiceMode"] + " - " + RESOURCE["eventReport"];
    var url = "eventReport.html?&neID=" + neID + "&testMode=" + OOS_MODE  + "&nmUser=" + nmUser + "&functitle=" + encodeURI(functitle);  
	
	if (isIE)
	{
		xshowModalDialog(url, "eventReportOOS", 900, 560, "../../../../images/");
	}
	else
	{
		xshowModalDialog(url, functitle, 860, 560, "../../../../images/");
	}
		/*var report = window.open(url,"eventReport","height = 560,width = 860,resizable = yes, location=no, titlebar=no,toolbar=no,menubar=no,status=no");
	  var startx = (screen.availWidth - 860)/2;
   	var starty = (screen.availHeight - 560)/2;
	
	  report.moveTo(startx, starty);
	  report.focus();*/
}
/**
 *               
 *
 */
function outSerRepeaterReportOOS()
{
    removejsDOMmenu();
    var selectedRows = lineStatus.getSelectedRows();
    var rowId = selectedRows[0];
		var neID = lineStatus.getCellStoreValue(rowId, "neid", "neid");
		var neName = lineStatus.getCellStoreValue(rowId, "nename", "nename");
		var lineID = lineStatus.getCellStoreValue(rowId, "lineID", "lineID");
		var lineDirection = lineStatus.getCellStoreValue(rowId, "lineDirection", "lineDirection");
		var functitle = RESOURCE["LineIDcolon"] + lineID + " - " + RESOURCE[LINE_DIRECTION[lineDirection]] + " - " + RESOURCE["OutOfServiceMode"] + " - " + RESOURCE["rptReport"];
		
    var url = "rptReport.html?&neID=" + neID + "&testMode=" + OOS_MODE + "&nmUser=" + nmUser + "&functitle=" + encodeURI(functitle);
    
	if (isIE)
	{
		xshowModalDialog(url, "outSerRepeaterReportOOS", 900, 560, "../../../../images/");
	}
	else
	{
		xshowModalDialog(url, functitle, 860, 560, "../../../../images/");
	}
		/*var report = window.open(url,"rptReport","height = 560,width = 860,resizable = yes, location=no, titlebar=no,toolbar=no,menubar=no,status=no");
	  var startx = (screen.availWidth - 860)/2;
   	var starty = (screen.availHeight - 560)/2;
	
	  report.moveTo(startx, starty);
	  report.focus();*/
	
}
/**
 *             ID
 */
function getSelectedLineId()
{
    var selectedRows = lineStatus.getSelectedRows();
    
    if (0 == selectedRows.length)
    {
        alert("UnSelectLine");
        return;
    }
    
    var rowId = selectedRows[0];    
    
    var lineID = lineStatus.getCellStoreValue(rowId, "lineID", "lineID");
    
    return lineID;
}

/**
 *             ID
 */
function getSelectedNEID()
{
    var selectedRows = lineStatus.getSelectedRows();
    
    if (0 == selectedRows.length)
    {
        alert("UnSelectLine");
        return;
    }
    
    var rowId = selectedRows[0];    
    
    var neid = lineStatus.getCellStoreValue(rowId, "neid", "neid");
    
    return neid;
}

/**
 *             ID
 */
function getSelectedLineIsSame()
{
    var selectedRows = lineInfoTable.getSelectedRows();
    
    if (0 == selectedRows.length)
    {
        alert("UnSelectLine");
        return;
    }
    
    var rowId = selectedRows[0];    
    
    var isSame = lineInfoTable.getCellStoreValue(rowId, "isSame", "isSame");
    
    return isSame;
}

/**
 *             ID
 */
function getLineDirection()
{
    var selectedRows = lineStatus.getSelectedRows();
    
    if (0 == selectedRows.length)
    {
        alert("UnSelectLine");
        return;
    }
    
    var rowId = selectedRows[0];    
    
    var lineDirection = lineStatus.getCellStoreValue(rowId, "lineDirection", "lineDirection");
    
    return lineDirection;
}

/**
 *                  ?
 */
function getSelectedTestMode()
{   
    var selectedRows = lineStatus.getSelectedRows();
    
    var rowId = selectedRows[0];
    
    var testMode = lineStatus.getCellStoreValue(rowId, "testMode", "testMode");
    
    return testMode;
}

/**
 *                   ?
 */
function getSelectedTestType()
{   
    var selectedRows = lineStatus.getSelectedRows();
    
    var rowId = selectedRows[0];
    
    var testType = lineStatus.getCellStoreValue(rowId, "testType", "testType");
    
    return testType;
}

/**
 *                    ?
 */
function getWorkStatus()
{   
    var selectedRows = lineStatus.getSelectedRows();
    
    var rowId = selectedRows[0];
    
    var status = lineStatus.getCellStoreValue(rowId, "currentWorkStatus", "currentWorkStatus");
    
    return status;
}

/**
 *               
 */
function lineStatusRowSltHandler()
{
	refreshLineStatusStaData();
	
    var selectedRows = lineStatus.getSelectedRows();
	
    var testMode = null;
    
    if (null == selectedRows || 1 != selectedRows.length)
    {
        $("syncTestData").disabled = true;
        $("getTestResult").disabled = true;
    }
    else
    {
        if (FILE_TRANS_FLAG)
        {
            $("syncTestData").disabled = true;
            $("getTestResult").disabled = true;
        }
        else
        {
        	if (!$("getLineStatus").disabled)
        	{
        		$("syncTestData").disabled = !btnRight.syncTestData.right;
            $("getTestResult").disabled = false;
        	}
            
        }
        
        
        /*testMode = getSelectedTestMode();
        if (testMode == IS_MODE || testMode == OOS_MODE)
        {
            $("getCurrResult").disabled = false;
        }
        else
        {
            $("getCurrResult").disabled = true;
        } */       
    }
    refreshGetCurrResultBtn();
}
/**
 *                   ?
 * added by l00104422
 */
function refreshGetCurrResultBtn()
{
    var selectedRows = lineStatus.getSelectedRows();
    var flag = false;
    var status;
    var count = 0;
    if (null == selectedRows || 0 == selectedRows.length)
    {
    		$("getCurrResult").disabled = true;
    }
    else
    {
    		for(var i = 0; i < selectedRows.length; i++)
   		 	{
    				status = getWorkStatusByRow(selectedRows[i]);
    				if (TESTING_STATUS != status)
    				{
    						count++;
    				}
    		}
    		if (selectedRows.length == count)
    		{
    				$("getCurrResult").disabled = true;
    		}
    		else
    		{
    			if (!$("getLineStatus").disabled)
        	{
        		$("getCurrResult").disabled = false;
        	}
    		}
  	}
}

/**
 *                ?
 * added by l00104422
 */
function getWorkStatusByRow(rowId)
{
	if (0 > rowId)
	{
		return null;
	}
  var status = lineStatus.getCellStoreValue(rowId, "currentWorkStatus", "currentWorkStatus");
    
  return status;
}

/**
 *                 
 */
function rightClickHandler(evt)
{   
    removejsDOMmenu();
    
    if(!evt){
      evt= window.event;    
    }
     
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
        elem.blur();        
    }
   
   while(elem!=null)
     {
        if(elem.tagName == 'TD')
        {
            break;  
        }
        else
        {
            elem =elem.parentNode;      
        }   
    } 
    
    if(elem == null || elem.tagName != 'TD' || null == elem.parent)
    {
          return;
    }
    
    var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    
    if(!rows.contains(rowid))
    {
        return;
    }
		if(null != elem.editElement && elem.isEdit == 1)
		{
			createTablePopupMenu(elem,evt);
			return;
		}
    var selectedRows = lineStatus.getSelectedRows();
    if ( 1 != selectedRows.length)
    {
        return;
    }
		
    var cursorMenu = null;
    if ("en" == SYSTEMCONF.getLanguage())
    {
        cursorMenu = new jsDOMenu(180); //    ?180px
    }
    else
    {
        cursorMenu = new jsDOMenu(150); //    ?150px
    }
    
   
    var item = new menuItem(RESOURCE["GetLineMoreInfo"], "",getLineMoreInfo, "", menuRight.getLineMoreInfo.right);
    item.id = "getLineMoreInfo";
    cursorMenu.addMenuItem(item);
    
    if (CYCLE_TEST == getSelectedTestType())
    {
        item = new menuItem(RESOURCE["ViewTestPeriodInfo"], "", viewTestPeriodInfo, "", true);
        item.id = "viewTestPeriodInfo";
        cursorMenu.addMenuItem(item);
    }    
    
    setPopUpMenu(cursorMenu);
    
    showMenu();
}

/**
 *                                           ?
 */
function isOneLineSelected()
{
    var selectedRows = lineStatus.getSelectedRows();
    
    if (1 != selectedRows.length)
    {
        return false;
    }
    
    return true;
}

/**
 *                                          ?
 */
function isIdleStatus()
{
    if (!isOneLineSelected())
    {
        return false;
    }
    
    var testStatus = getWorkStatus();
    
    if (RESOURCE[CURRENT_WORK_STATUS[IDLE_STATUS]] == testStatus || IDLE_STATUS == testStatus)
    {
        return true;
    }
    
    return false;
}

/**
 *                          ?
 */
function isTestMode(mode)
{
    if (!isOneLineSelected())
    {
        return false;
    }
    
    var currentTestMode = getSelectedTestMode();
    
    if (currentTestMode != mode)
    {
        return false;
    }
    
    return true;
}

/*
 *         ?
 */
function adjustHeight()
{
    lineInfoTable.setBodyHeight(getComponetHeight($("lineInfoTableDiv"),1)+"px");
    
    lineStatus.setBodyHeight(getComponetHeight($("lineStatusTableDiv"),1)+"px");
}


/**
 *             
 *             ?
 */
window.onunload=function()
{    
    if(typeof(lineStatus)!='undefined' && lineStatus instanceof SortTable)
    {
		clearSortTable(lineStatus);
	}         
    		
    doBeforeCloseImmediately();
}

/**
 *                onunload   
 *                                  ?
 * V2R7C01B2 magang 2008-11-12
 */
function doBeforeCloseImmediately()
{
    pageIsVisble = false;
	if (null != timer)
	{	    
	    window.clearInterval(timer);	      
    }
}

function waveLength()
{
	this.bandType = new Array();
}

function bandType()
{
	this.id = null;
	this.value = null;
	this.options = new Array();
	this.waveNoMap = new Array();
}

function getWaveLength()
{
	var xmlstr = createWaveLengthXML();
	urlreq = "../../../../neExlorerServlet?sfid=" + CFG_GET_WAVE_LENGTH_INFO;
	loadXMLdoc(urlreq, "POST", false, EncapsulateWave, null, "inputdata="+xmlstr);
}

function createWaveLengthXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params"); //bean               ?	
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",winurlobj.neid);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();	
}

function EncapsulateWave(doc)
{
	var waveLengthData = EncapsulateData(doc);
	waveLengthList = new waveLength();
  var bandtype = null;
  var waveNumMap = null;
  var options = null;
  var option = null;
  var optionName = null;
  var optionValue = null;
  var waveNO = null;
  var custWaveNO = null;
  for(var i = 0,size = waveLengthData.getDataRowLength(); i < size; i++)
  {
  	bandtype = new bandType();
  	var bandTypeParam = waveLengthData.getDataRowParam(i,"bandType");
  	bandtype.id = bandTypeList[bandTypeParam];
  	bandtype.value = bandTypeParam;
  	var waveLengthCount = Number(waveLengthData.getDataRowParam(i,"waveLengthCount"));
    for(var j = 0; j < waveLengthCount; j++)
    {
    		waveNO = waveLengthData.getDataRowParam(i,"waveNO" + j);
    		custWaveNO = waveLengthData.getDataRowParam(i,"custWaveNO" + j);
        optionName = waveLengthData.getDataRowParam(i,"waveLengthInfo" + j);
        optionValue = waveNO;
        option = new Option(optionName,optionValue);
        bandtype.options[bandtype.options.length] = option;      
        bandtype.waveNoMap[waveNO] = custWaveNO;
    }
    
    waveLengthList.bandType[i] = bandtype;
  }
}

function getTestProgress(testProgress)
{
	if (null == testProgress)
	{
		return "-";
	}
	
	if ("-" == testProgress)
	{
		return testProgress;
	}
	
	if(testProgress.indexOf("%") >= 0)
	{
		return testProgress;
	}
	
	testProgress = testProgress + "%";
	
	return testProgress;
}


function createTableBody(st, tc, di, res, refreshFlag,serverOrClient,format,fixWidth)
{
	createFilterTableBody(st, tc, di, res, refreshFlag,serverOrClient,format,fixWidth)

	if (st.element.colsArray.selectedId)
	{
		var colEle = st.getHeadCell(st.element.colsArray.selectedId).element;
		st.sortRows(colEle, st.element.colsArray.imgflag);
	}
}

function createFilterTableBody(st, tc, di, res, refreshFlag,serverOrClient,format,fixWidth)
{
	if (st.element.isAppendEmptyTr)
	{
		var tBody = st.bodyPack.firstChild.lastChild;
		tBody.removeChild(tBody.firstChild);
		st.element.isAppendEmptyTr = false;
	}
	if (!st.isListenerRegister && !st.isUsedForSelectList)
	{
		EventUtil.addEventHandler(window, "resize", windowOnResizeTableHandle);
		EventUtil.addEventHandler(window, "unload", windowUnloadTableHandle);
		st.isListenerRegister = true;
	}

	var basicCalWidth = document.body.clientWidth - 20;
	if(fixWidth)
	{
	    basicCalWidth = fixWidth - 20;
	}
	
	if (st.isUsedForSelectList)
	{
		basicCalWidth = st.bodyPack.offsetWidth;
	}
	var num = di.getDataRowLength();

	var didatalength = di.getDataRowLength();
	var colslength = tc.getColsLength();

	if (st.editdom == null)
	{
		st.editdom = new Array();
		for ( var i = 0; i < colslength; i++)
		{
			if (tc.hasEditElement(i))
			{
				var atom = st.createAtom(tc.getColEditType(i));
				var options = tc.getColEditOptions(i);
				var editobj = tc.getColEdit(i);
				if (options.length > 0)
				{
					for ( var k = 0; k < options.length; k++)
					{
						atom.addOption(options[k].getName(), options[k]
								.getValue());
					}
				}

				atom.element.onclick = stopEventPropagation;
				atom.element.onmousedown = atomOnMouseDownHandle;
				atom.element.ondblclick = stopEventPropagation;
				atom.element.onblur = cellonblur;

				if (editobj.verify)
				{
					var verifyobj = editobj.verify;
					if (verifyobj.type == "num")
					{
						textCheck(atom.element, verifyobj.min, verifyobj.max,null,verifyobj.other);
					}
					else if (verifyobj.type == "string")
					{
						atom.element.maxLength = verifyobj.length;
					}
	      	else if(verifyobj.type == "func")
	      	{	   
	      		var tmpelement = atom.element;
	      		var maxLength = verifyobj.length;
	      		atom.element.title = maxLength;
	      		atom.element.onkeyup =  function()
	      		{
	      			  checkLength(this);
	      		}  
	      	}
	      }

				var dom = st.editdom;
				dom[tc.getColId(i)] = atom;
			}
		}
	}
	var appendWidth = getAppendWidth(st, tc, fixWidth);
	var tempWidth = 0;
	var colWidth = 0;
	for ( var i = 0; i < di.getDataRowLength(); i++)
	{
		var row = st.createRow();
		for ( var j = 0; j < colslength; j++)
		{
      		if(st.element.cellsWidth[tc.getColId(j)]!=null)
      		{
        		tempWidth = st.element.cellsWidth[tc.getColId(j)];
      		}
      		else
		  	{
			  	colWidth = tc.getColWidth(j) + "";
			  	if (colWidth.indexOf("%") != -1)
			  	{
				  	tempWidth = basicCalWidth * parseInt(tc.getColWidth(j)) / 100;
				  	if (tempWidth != 0)
				  	{
					  	tempWidth = tempWidth + appendWidth;
				  	}
			  	}
			  	else
			  	{
				  	tempWidth = tc.getColWidth(j);
			  	}
			}

			var cell = st.createCell(tempWidth);
			cell.colid = tc.getColId(j);
			st.setCellIsEdit(cell, tc.getIsEdit(j));
			var atom = st.createAtom(tc.getColShowType(j))
			var options = tc.getColShowOptions(j);
			if (null != options && "" != options)
			{
				for ( var k = 0; k < options.length; k++)
				{
					atom.addOption(options[k].getName(), options[k].getValue());
				}
				atom.element.disabled = true;
			}
			var showvalue = new Array();
			var tccolkeylen = tc.getColKeyArray(j).length;

			for ( var k = 0; k < tccolkeylen; k++)
			{
				var tccolkeyname = tc.getColKeyArray(j)[k].getName();
				var tcconvert = tc.getColKeyArray(j)[k].getConvert();
				if (di.getDataRowParam(i, tccolkeyname))
				{
          			if (tcconvert != null && tcconvert == "hidden")
          			{
            			st.setHiddenCellValue(cell, tccolkeyname, di.getDataRowParam(i, tccolkeyname));
            			continue;
          			}
          			else
          			{
					  	st.setCellValue(cell, tccolkeyname, di.getDataRowParam(i,
							  tccolkeyname));
					}
					var paramData = di.getDataRowParam(i, tccolkeyname);
					if(tc.getColKeyArray(j)[k].getName().toLowerCase() == "slotid"&&tcconvert==null)
					{
						tcconvert = "getSlotIDFromSlot";
					}
					/**
				     *                       tcconvert != "nojoin"                  ?:
				     * atom.setValue(showvalue.join('-'));
					 */
					if (tcconvert && "" != paramData)
					{				
						if(tcconvert != "nojoin")
						{
							var convert = eval(tcconvert);
							if (typeof (convert) == "function")
							{
								if(tcconvert == "getNMTime")
								{
									showvalue.push(convert(paramData,serverOrClient,format));
								}
								else
	              				{
								  	showvalue.push(convert(paramData));
								}
							}
							else
							{
								showvalue.push(convertMsg(res, convert, paramData));
							}
						}						
					}
					else
					{
						if ("" != paramData)
						{
							showvalue.push(paramData);
						}
					}
				}
			}

			if (showvalue.length > 0)
			{
				atom.setValue(showvalue.join('-'));
			}
			else
			{
				atom.setValue("");
			}
			st.addCellShow(cell, atom);

			if (tc.hasEditElement(j))
			{
				st.addCellEdit(cell, st.editdom[cell.colid]);
			}

			st.addCell(row, tc.getColId(j), cell);
			var cellwidth = tc.getColWidth(j);
			if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
			{
				cell.element.style.display = "none";
			}
		}
		st.addRow(row)
	}

	st.body.style.padding = "1px";
	adjustTableLayout(st, tc, num, fixWidth);
	st.body.style.padding = "0px";

	if (st.element.datarows.length == 0)
	{
		var tr = document.createElement("tr");
		var td = document.createElement("td");
		td.innerHTML = "";
		tr.appendChild(td);
		st.bodyPack.firstChild.lastChild.appendChild(tr);
		if (st.element.cellsWidth["tableWidth"] != null)
		{
			st.bodyPack.firstChild.style.width = st.element.cellsWidth["tableWidth"];
		}
		else
		{
			st.bodyPack.firstChild.style.width = st.headPack.firstChild.offsetWidth;
		}
		st.element.isAppendEmptyTr = true;
	}
}

/*
 * adjust table layout          AU9D21620           isLayout     true                           ?
 */
function adjustTableLayout(st, tc, num)
{
	if (st.bodyPack.offsetWidth == "0")
	{
		return;
	}
	
	if (st.headPack.isLayout == true)
	{
		for ( var i = 0; i < st.getDataRowLength(); i++)
		{
			for ( var j = 0; j < tc.getColsLength(); j++)
			{
				var colWidth = st.getHeadCell(tc.getColId(j)).element.width
						+ "";
				if (colWidth != "")
				{
					st.getCellElement(i, tc.getColId(j)).width = colWidth;
				}
			}
		}

		st.bodyPack.scrollTop = st.bodyPack.lastScrollTop;
		st.bodyPack.scrollLeft = st.bodyPack.lastScrollLeft;

		var scrollWidth = parseInt(st.bodyPack.offsetWidth)
				- parseInt(st.bodyPack.clientWidth);
		var bodyWidth = 0;
		if (st.element.parentElement != null)
		{
			bodyWidth = st.element.parentElement.offsetWidth - 2;
			st.element.parentElement.style.width = "100%";
			st.element.parentElement.style.overflowX = "hidden";
		}
		else
		{
			bodyWidth = adjustWidth;
		}
		if (scrollWidth > 0)
		{
			st.headPack.style.width = bodyWidth - scrollWidth;
			if (st.headPack.firstChild.offsetWidth > bodyWidth - scrollWidth)
			{
				st.headPack.firstChild.style.width = bodyWidth - scrollWidth;
			}
			st.bodyPack.style.width = bodyWidth;
			if (st.bodyPack.firstChild.offsetWidth > bodyWidth - scrollWidth)
			{
				st.bodyPack.firstChild.style.width = bodyWidth - scrollWidth;
			}
			st.bodyPack.style.overflow = "scroll";
		}
		else
		{
			st.headPack.style.width = bodyWidth;
			st.bodyPack.style.width = bodyWidth;
			if (st.headPack.firstChild.offsetWidth > bodyWidth)
			{
				st.headPack.firstChild.style.width = bodyWidth;
			}
			if (st.bodyPack.firstChild.offsetWidth > bodyWidth)
			{
				st.bodyPack.firstChild.style.width = bodyWidth;
			}
		}
		var headtr = st.element.firstChild.firstChild;
		if (headtr.childNodes[1])
		{
			headtr.removeChild(headtr.childNodes[1]);
		}
		return;
	}
	
	var appendWidth = getAppendWidth(st, tc);
	var adjustWidth = document.body.clientWidth - 20;
	if (st.isUsedForSelectList)
	{
		adjustWidth = st.headPack.offsetWidth;
	}

	for (i = 0; i < tc.getColsLength(); i++)
	{

		var cellwidth = 0;
		var colWidth = tc.getColWidth(i) + "";
		
		if (colWidth.indexOf("%") != -1)
		{
			cellwidth = adjustWidth * parseInt(tc.getColWidth(i)) / 100;
			if ((cellwidth + "") == "0")
			{
				st.getHeadCell(tc.getColId(i)).element.style.display = "none";
			}
			else
			{
				var newWidth = cellwidth + appendWidth;
				
				if (newWidth >= 0)
				{
					st.getHeadCell(tc.getColId(i)).element.width = newWidth
							+ "px";
				}
			}
		}
		else
		{
			var headWidth = parseInt(st.getHeadCell(tc.getColId(i)).element.width
					.replace("px", ""));	
			if (headWidth != "0%" && headWidth != "0px" && headWidth != "")
			{
				if ((headWidth + appendWidth) >= 0)
				{
				  
				    st.getHeadCell(tc.getColId(i)).element.width = headWidth
							+ appendWidth;
				}
			}
		}
	}
	
	st.headPack.isLayout = true;

	var bodyWidth = 0;
	if (st.element.parentElement != null && !st.isUsedForSelectList)
	{
		st.element.parentElement.style.width = "100%";
		st.element.parentElement.style.overflowX = "hidden";
		bodyWidth = st.element.parentElement.offsetWidth - 2;
	}
	else
	{
		bodyWidth = adjustWidth;
	}
	st.body.style.padding = "0px";
	st.headPack.style.width = bodyWidth;
	st.headPack.firstChild.style.width = bodyWidth;
	st.bodyPack.style.width = bodyWidth;
	st.bodyPack.firstChild.style.width = bodyWidth;
	var headtr = st.element.firstChild.firstChild;
	if (headtr.childNodes[1])
	{
		headtr.removeChild(headtr.childNodes[1]);
	}
	var scrollWidth = parseInt(st.bodyPack.offsetWidth)
			- parseInt(st.bodyPack.clientWidth);
	if (scrollWidth > 0)
	{
		st.headPack.style.width = (bodyWidth - scrollWidth) + "px";
		st.headPack.firstChild.style.width = (bodyWidth - scrollWidth) + "px";
		st.bodyPack.style.width = bodyWidth + "px";
		st.bodyPack.firstChild.style.width = (bodyWidth - scrollWidth) + "px";
		st.bodyPack.style.overflow = "scroll";
	}
}
