 /**
 *          js              
 *   :     00104334
 *   : 2008-01-23
 */

var parentWin = getParentWindow();
var winurlobj = parentWin.winurlobj;


var testParam = null;

var btnRight = null;

var TESTMODE_IN_SVR = "1";
var TESTMODE_OUT_SVR = "2";
var DEFAULT_BIT_LENGTH_OF_GRAY_CODE = 128;


var	POWER_MIN_VALUE = null;
var	POWER_MAX_VALUE = null;
var	POWER_DEFAULT_VALUE = null;

var VELOCITY_OF_LIGTH = 299792458;
var PROCESSING_TIME = 180;//s
var AVERAGE_REFRECTIVE_INDEX = 1.468;//     
var AADDLINE = 100160;//19     A  
var BADDLINE_INDEX = 0.7;//19     B    
var AJUSTTIME = 600;//        10  
var SINGLE_PULSE = 1;//   
var opticalfiberParam = new OpticalFiberParam();

var NOT_POWER = 214748364.7;

var DUMMYPOWER_MAX = "1.5";
var DUMMYPOWER_MIN = "-2.0";

var POWER_DEFAUL = "2147483647";

var sync = true;

/**
 *     Id  url   
 */
function getLineId()
{
    var obj = getNeProperty(self);
    
    return obj["lineID"];
}

/**
 *     Id  url   
 */
function getLineDirection()
{
    var obj = getNeProperty(self);
    
    return obj["lineDirection"];
}

/**
 *     Id  url   
 */
function getNeID()
{
    var obj = getNeProperty(self);
    
    return obj["neID"];
}

/**
 *     Id  url   
 */
function getTitle()
{
    var obj = getNeProperty(self);
    
    return obj["functitle"];
}

document.title = getTitle();

/**
 *      
 */
function initPage()
{
		if (!isIE)
	  {
		  sync = false;
	  }
	  
    
    
    
    initTable();

    initButton();
        
    
    getTestParam();

}
function initParamByTestMode()
{
    var obj = getNeProperty(self);
    var testMode = obj["testMode"];    
    if (TESTMODE_IN_SVR == testMode)
    {
        PULSE_WIDTH_MIN_STR = "1";
        PULSE_WIDTH_MAX_STR = "10";
        PULSE_WIDTH_MIN = 1;
        PULSE_WIDTH_MAX = 10;
    }
    else if (TESTMODE_OUT_SVR == testMode)
    {
        PULSE_WIDTH_MIN_STR = "1";
        PULSE_WIDTH_MAX_STR = "200";
        PULSE_WIDTH_MIN = 1;
        PULSE_WIDTH_MAX = 200;        
    }    
}

/**
 *      
 */
function initTable()
{
    testParam = new CTable();
    testParam.addHead(RESOURCE["Attribute"],RESOURCE["Value"]);
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, PULSE_WIDTH_MIN_STR, PULSE_WIDTH_MAX_STR);
    testParam.addAttrRow("pulseWidth", RESOURCE["PulseWidth"], cTableAtom); 

    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    checkSamplingTimes(cTableAtomEle, SAMPLING_TIMES_MIN_STR, SAMPLING_TIMES_MAX_STR);
    testParam.addAttrRow("samplingTimes", RESOURCE["SamplingTimes"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    testParam.addAttrRow("samplingFreq", RESOURCE["SamplingFreq"], cTableAtom);
    
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    testParam.addAttrRow("lmiPower", RESOURCE["lmiPower"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());


    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = false;
    testParam.addAttrRow("power", RESOURCE["Power"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    addSelectOption(cTableAtomEle, RESOURCE["SingleCode"], SINGLE_CODE_VALUE);
    cTableAtomEle.onchange = codePatternHandler;
    testParam.addAttrRow("codePattern", RESOURCE["CodePattern"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    
    
    
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    validateTime(cTableAtomEle);
    cTableAtomEle.disabled = true;
    testParam.addAttrRow("testTime", RESOURCE["TestTime"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());    
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    addSelectOption(cTableAtomEle, RESOURCE["DUMMYSTATUS_OPEN"], DUMMYSTATUS_OPEN);
    addSelectOption(cTableAtomEle, RESOURCE["DUMMYSTATUS_CLOSE"], DUMMYSTATUS_CLOSE);
    testParam.addAttrRow("dummyStatus", RESOURCE["dummyStatus"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    addSelectOption(cTableAtomEle, bandTypeList[1], "1");
    testParam.addAttrRow("dummyWaveBand", RESOURCE["dummyWaveBand"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    createWaveLengthOption(cTableAtomEle, "1");
    testParam.addAttrRow("dummyWaveIndex", RESOURCE["dummyWaveIndex"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element;
    addSelectOption(cTableAtomEle, RESOURCE["YES"], "1");
    addSelectOption(cTableAtomEle, RESOURCE["NO"], "0");
    cTableAtomEle.onchange = dummyPowerAdjustHandler;
    testParam.addAttrRow("dummyPowerAdjust", RESOURCE["dummyPowerAdjust"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.disabled = true;
    testParam.addAttrRow("dummyPower", RESOURCE["dummyPower"], cTableAtom);
    $("testParamTbl").appendChild(testParam.getTable());
}

/**
 *      
 */
function initButton()
{
    $("query").value = RESOURCE["Query"];
    $("set").value = RESOURCE["applyBtn"];
    $("cancel").value = RESOURCE["Cancel"];         
    
    btnRight = new Object();
    btnRight.set = new BtnRightObj("set", "" + TECMDCODE_SLM_SET_TEST_PARAM);
        
    getRightInfo(winurlobj, btnRight);
    initrightbtn(btnRight);
}

/**
 *       
 */
function getTestParam()
{
	  $("query").disabled = true;
    $("set").disabled = true;
    
    var lineID = getLineId();
    
    var obj = getNeProperty(self);
    
    var testMode = obj["testMode"];
    var lmiSlotID = obj["lmiSlotID"]
    
    var xml = getTestParamXML(lineID, testMode, lmiSlotID);
        
    var sfid = TECMDCODE_SLM_GET_TEST_PARAM_OOS;
    
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", sync, getTestParamBack, null, "inputdata=" + xml);
    
    
}

/**
 *              XML  
 */
function getTestParamXML(lineID, testMode, lmiSlotID)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "testMode");
    param.setAttribute("value", testMode);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "testType");
    param.setAttribute("value", MANUAL_TEST);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "spanNo");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiSlotID");
    param.setAttribute("value", lmiSlotID);
    row.appendChild(param);
    
	param = new tagElement("param");
    param.setAttribute("name", "lmiPortID");
    param.setAttribute("value", 1);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lmiChannelID");
    param.setAttribute("value", 1);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

var partOfFormula = 0; //sum(refractiveRate * fiberLength)
var opticalSpeed = 300000;//   


/**
 *       
 *                                 
 *              50-20000           
 *              50-1000,                     128
 */
function decideCurrentCodePattern()
{
   /* var obj = getNeProperty(self);
    var testMode = obj["testMode"];    
    if (TESTMODE_IN_SVR == testMode)
    {
        return GRAY_CODE;
    }
    else if (TESTMODE_OUT_SVR == testMode)
    {
        return SINGLE_PULSE;
    }
    else
    {
        return -1;
    }*/
    return testParam.getAttrValue("codePattern");//  
}

function caculateBitLength(code)
{
    if (GRAY_CODE == code)
    {
        return DEFAULT_BIT_LENGTH_OF_GRAY_CODE;
    }
    else
    {
        return 0;
    }
}

/**
 *                
 */
function calcEstimateTime()
{
    var samplingTimes = testParam.getAttrValue("samplingTimes");//    
    var pulseWidth = Number(testParam.getAttrValue("pulseWidth")) * 0.000001;//    
    
    var codePattern = decideCurrentCodePattern();
    
    var testTime = 0;//    
    
    if (null == samplingTimes || null == codePattern  || 0 == partOfFormula)
    {
        return;
    }
    
    var g;
    if(SINGLE_PULSE == codePattern)
    {
        g = 1;
    }
    else
    {
        g = 4;	
    }

    opticalfiberParam.codetime = codePattern * pulseWidth;
    opticalfiberParam.btime = BADDLINE_INDEX * pulseWidth;
    testTime = (opticalfiberParam.codetime + opticalfiberParam.linetime + opticalfiberParam.atime + opticalfiberParam.btime)
                * g * samplingTimes + PROCESSING_TIME;
    
    if (testTime % 1 > 0)
    {
        testTime = Math.floor(testTime) + 1;
    }
    else
    {
        testTime = Math.floor(testTime);
    }
    
    var hour = Math.floor(testTime / 3600);
    
    var minute = Math.floor((testTime % 3600) / 60);
    
    var second = testTime % 60;
    
    testTime = hour + ":" + minute + ":" + second;
    testParam.setAttrValue("testTime", testTime);
}

/**
 *                
 */
function calcSamplingTimes()
{  
    var codePattern = decideCurrentCodePattern();
    var pulseWidth = Number(testParam.getAttrValue("pulseWidth")) * 0.000001;//    
    var estimateTime = testParam.getAttrValue("testTime");//    
    var timeStr = estimateTime.split(":");
    var testTime = timeStr[0] * 3600 + timeStr[1] * 60 + parseInt(timeStr[2]);
    
    var maxTestTime = 0;
    if (SINGLE_CODE_VALUE == codePattern)
    {
        maxTestTime = 2 * partOfFormula / opticalSpeed * SAMPLING_TIMES_MAX ;
    }
    else
    {
        maxTestTime = 8 * partOfFormula / opticalSpeed  * SAMPLING_TIMES_MAX;
    }
    
    if (maxTestTime - Math.floor(maxTestTime) > 0)
    {
        maxTestTime = Math.floor(maxTestTime) + 1;
    }
    else
    {
        maxTestTime = Math.floor(maxTestTime);
    }        
    
    if (testTime > maxTestTime)
    {
        var hour = Math.floor(maxTestTime / 3600);
        var minute = Math.floor((maxTestTime % 3600) / 60);
        var second = maxTestTime - hour * 3600 - minute * 60;

        if (hour < 10)
        {
            hour = "0" + hour;
        }
        if (minute < 10)
        {
            minute = "0" + minute;
        }
        if (second < 10)
        {
            second = "0" + second;
        }
        var maxTestTimeStr = hour + ":" + minute + ":" + second;

        alert(RESOURCE["MaxTestTime"] + maxTestTimeStr);
        
        testParam.setAttrValue("testTime", maxTestTimeStr);
    }
    
    var samplingTimes = 0;//    
    
    if (null == testTime || null == codePattern  || 0 == partOfFormula)
    {
        return;
    }
    
    var g;
    if(SINGLE_PULSE == codePattern)
    {
        g = 1;
    }
    else
    {
        g = 4;	
    }

    opticalfiberParam.codetime = codePattern * pulseWidth;
    opticalfiberParam.btime = BADDLINE_INDEX * pulseWidth;
                
    samplingTimes = (testTime - PROCESSING_TIME) / g / (opticalfiberParam.codetime + opticalfiberParam.linetime + Math.max(opticalfiberParam.atime, opticalfiberParam.btime));
    
    samplingTimes = Math.floor(samplingTimes);
    
    if (samplingTimes > SAMPLING_TIMES_MAX)
    {
        samplingTimes = SAMPLING_TIMES_MAX;
    }
    
    if(samplingTimes < SAMPLING_TIMES_MIN)
    {
        samplingTimes = SAMPLING_TIMES_MIN;
    }
    
    estimateTime = testParam.getAttrValue("testTime");//    
    if (estimateTime == "0:0:1")
    {
        if (samplingTimes > SAMPLING_TIMES_MIN)
        {
            samplingTimes = SAMPLING_TIMES_MIN;
        }
    }
    
    testParam.setAttrValue("samplingTimes", samplingTimes);
}

/**
 *              
 */
function getTestParamBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
        showErrorDialog(data);
        if(1 != smallErrorCode)
        {
            return;
        }
    }
    partOfFormula = 0;       
    var pulseWidth = data.getDataRowParam(0, "pulseWidth");
    
    var samplingTimes = data.getDataRowParam(0, "samplingTimes");
    
    var samplingFreq = data.getDataRowParam(0, "samplingFreq");
    
    var codePattern = data.getDataRowParam(0, "codePattern");
    
    
    var power = data.getDataRowParam(0, "power") / 10;
    
    var lmiPower = data.getDataRowParam(0, "lmiPower") / 10;
    testParam.setAttrValue("lmiPower", lmiPower);
    
    
    testParam.setAttrValue("pulseWidth", pulseWidth);
    
    testParam.setAttrValue("samplingTimes", samplingTimes);
    
    testParam.setAttrValue("samplingFreq", samplingFreq);
    
    testParam.setAttrValue("codePattern", codePattern);
    
    /*
    for (var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
       refractiveRate = data.getDataRowParam(i, "refractiveRate");
       refractiveRate /= 1000;
       
       fiberLength = data.getDataRowParam(i, "fiberLength");        
       fiberLength /= 10;
       
        partOfFormula += refractiveRate * fiberLength * 1000;
    }*/
    partOfFormula = data.getDataRowParam(0, "partOfFormula");
    
    opticalfiberParam.linetime = 2 * partOfFormula / VELOCITY_OF_LIGTH;
    opticalfiberParam.atime = 2 * AVERAGE_REFRECTIVE_INDEX * AADDLINE / VELOCITY_OF_LIGTH;
    
 	 	var obj = getNeProperty(self);
 		var testMode = obj["testMode"];    
 		if (TESTMODE_IN_SVR == testMode)
 		{
  		POWER_MIN_VALUE = "-10.0";
  		POWER_MAX_VALUE = "2.0";
  		POWER_DEFAULT_VALUE = "-10.0";
  		var inSerThrMax =  data.getDataRowParam(0, "inSerThrMax");
  		var inSerThrMin =  data.getDataRowParam(0, "inSerThrMin");
  		if (null != inSerThrMax && null != inSerThrMin)
  		{
  				POWER_MAX_VALUE = parseFloat(inSerThrMax) / 10;
  				POWER_MIN_VALUE = parseFloat(inSerThrMin) / 10;
  		}
  	}
  	else if (TESTMODE_OUT_SVR == testMode)
  	{
	  	POWER_MIN_VALUE = "-10.0"; 
  		POWER_MAX_VALUE = "18.5"; 
  		POWER_DEFAULT_VALUE = "18.5";
  	}
    powerCheckHandler();
    codePatternHandler();
    
    
    {
    }
    
    testParam.setAttrValue("power", power);
    
    calcEstimateTime();
    
    testParam.setAttrValue("dummyStatus", data.getDataRowParam(0, "dummyStatus"));
    testParam.setAttrValue("dummyWaveBand", data.getDataRowParam(0, "dummyWaveBand"));
    testParam.setAttrValue("dummyWaveIndex", data.getDataRowParam(0, "dummyWaveIndex"));
       
    var dummyPower = data.getDataRowParam(0, "dummyPower") / 10;
    
    if (NOT_POWER == dummyPower)
    {
    	testParam.setAttrValue("dummyPowerAdjust", "1");
    	testParam.setAttrValue("dummyPower", "-");
    	testParam.getAtom("dummyPower").element.disabled = true;
    }
    else
    {
    	testParam.setAttrValue("dummyPowerAdjust", "0");
    	testParam.setAttrValue("dummyPower", dummyPower);
    	testParam.getAtom("dummyPower").element.disabled = false;
    	checkText(testParam.getAtom("dummyPower").element, DUMMYPOWER_MIN, DUMMYPOWER_MAX, 1);
    }
    
    $("query").disabled = false;
    $("set").disabled = false;
}


function setTestParam()
{    
    var lineID = getLineId();
    
    if (!checkData())
    {
        return;
    }

    var pulseWidth = testParam.getAttrValue("pulseWidth");
    
    var times = testParam.getAttrValue("samplingTimes");
    
    var freq = testParam.getAttrValue("samplingFreq");
    if ("" == freq)
    {
    	freq = DEFAULT_SAMPLINE_FREQ;
    }
    
    var code = decideCurrentCodePattern();
    
    
    if (pulseWidth < PULSE_WIDTH_MIN || pulseWidth > PULSE_WIDTH_MAX)
    {
    	alert(RESOURCE["PulseWidthUnvalid"]);
    	return;
    } 
    
    if (times < SAMPLING_TIMES_MIN || times > SAMPLING_TIMES_MAX)
    {
    	alert(RESOURCE["SamplingTimesUnvalid"]);
    	return;
    } 
    
    $("query").disabled = true;
    $("set").disabled = true;
    
    var power = getPowerValue() * 10;
    
    var xml = setTestParamXML(lineID, pulseWidth, times, freq, code, power);
    
    var sfid = TECMDCODE_SLM_SET_TEST_PARAM_OOS;
        
    var url = "../../../../neExlorerServlet?sfid=";
    url += sfid+"&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", false, setTestParamBack, null, "inputdata=" + xml);
    
}

/**
 *           XML  
 */
function setTestParamXML(lineID, pulseWidth, times, freq, code, power)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = new tagElement("param");
   
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeID());
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "lineID");
    param.setAttribute("value", lineID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "lineDirection");
    param.setAttribute("value", getLineDirection());
    row.appendChild(param);
    
    var obj = getNeProperty(self);    
    var testMode = obj["testMode"];
    param = new tagElement("param");
    param.setAttribute("name", "testMode");
    param.setAttribute("value", testMode);
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name", "pulseWidth");
    param.setAttribute("value", pulseWidth);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "samplingTimes");
    param.setAttribute("value", times);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "power");
    param.setAttribute("value", power);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "samplingFreq");
    param.setAttribute("value", freq);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "codePattern");
    param.setAttribute("value", code);
    row.appendChild(param);
    
    
    param = new tagElement("param");
    param.setAttribute("name", "dummyStatus");
    param.setAttribute("value", testParam.getAttrValue("dummyStatus"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "dummyWaveBand");
    param.setAttribute("value", testParam.getAttrValue("dummyWaveBand"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "dummyWaveIndex");
    param.setAttribute("value", testParam.getAttrValue("dummyWaveIndex"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "dummyPowerAdjust");
    param.setAttribute("value", testParam.getAttrValue("dummyPowerAdjust"));
    row.appendChild(param);
    
    var dummyPowerAdjust = testParam.getAttrValue("dummyPowerAdjust");
    if ("1" == dummyPowerAdjust)
    {
    	param = new tagElement("param");
      param.setAttribute("name", "dummyPower");
      param.setAttribute("value", POWER_DEFAUL);
      row.appendChild(param);
    }
    else
    {
    	param = new tagElement("param");
      param.setAttribute("name", "dummyPower");
      param.setAttribute("value", testParam.getAtom("dummyPower").element.value * 10);
      row.appendChild(param);
    }
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString();
}

/**
 *            
 */
function setTestParamBack(doc)
{  
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (0 != smallErrorCode)
    {
    	  $("query").disabled = false;
        $("set").disabled = false;
        
        showErrorDialog(data);
        return;
    }
    
    xcloseDialog();
}

/**
 *       
 * added by l00104422
 */
function getPowerValue()
{
    var power = testParam.getAtom("power").element.value;
    if ("" == power || "-" == power)
    {
    	power = NOTUSELAS_POWER;
    }
    return power;
}

/**
 *  select    option          
 */
function addSelectOption(oListbox,sName,sValue)
{
    var oOption = document.createElement("option");
    
    oOption.appendChild(document.createTextNode(sName));
    
    oOption.setAttribute("value",sValue);

    
    oListbox.appendChild(oOption);
}

/**
 *    CTable       
 */
function createOption(atomElmt, bitLength)
{
    for(var i = 0, len = bitLength.length; i < len; i++)
    {
        atomElmt.options[atomElmt.options.length] = new Option(bitLength[i], bitLength[i]);
    }
}

/**
 *            
 */ 
function codePatternHandler()
{
    
    var patternSelect = testParam.getAtom("codePattern").element;
    var pattern = patternSelect.value;
    
    
    if (SINGLE_CODE_VALUE == pattern)
    {       
        
        PULSE_WIDTH_MIN_STR = "1";
        PULSE_WIDTH_MAX_STR = "200";
        PULSE_WIDTH_MIN = 1;
        PULSE_WIDTH_MAX = 200;
        
    }   
    else// if (GRAY_CODE == pattern)
    {
        
        PULSE_WIDTH_MIN_STR = "1";
        PULSE_WIDTH_MAX_STR = "10";
        PULSE_WIDTH_MIN = 1;
        PULSE_WIDTH_MAX = 10;
    }
    var widthValue = testParam.getAtom("pulseWidth").element.value;
    if ("" == widthValue || widthValue < PULSE_WIDTH_MIN)
	  {
    	  testParam.setAttrValue("pulseWidth", PULSE_WIDTH_MIN);
    }
    else if (widthValue > PULSE_WIDTH_MAX)
    {
    	  testParam.setAttrValue("pulseWidth", PULSE_WIDTH_MAX);
    }
    checkText(testParam.getAtom("pulseWidth").element, PULSE_WIDTH_MIN_STR, PULSE_WIDTH_MAX_STR);
    calcEstimateTime();
}

/**
 *       
 */
function checkData()
{
    var param = testParam.getAttrValue("pulseWidth");
    
    if ("" == param)
    {
        alert(RESOURCE["PulseWidth"] + RESOURCE["CantBeNull"]);
        return false;
    }
    
    param = testParam.getAttrValue("samplingTimes");
    if ("" == param)
    {
        alert(RESOURCE["SamplingTimes"] + RESOURCE["CantBeNull"]);
        return false;
    }   
    return true;
}
/**
 *        
 */
function showErrorDialog(data)
{
    var errArr = new Array();
    errArr.push("nename");
    
    openErrPage("../../../../page/", data.getError(), errArr); 
}

function buildTestData()
{
    var bitSelect = testParam.getAtom("bitLength").element;
    var codeSelect = testParam.getAtom("codePattern").element;
    codeSelect.value = 1;
    bitSelect.disabled = false;
    bitSelect.options.length = 0;
    createOption(bitSelect, BIT_LENGTH);
    bitSelect.value = 128;
}

function samplingTimesHandler()
{
    checkText(this, SAMPLING_TIMES_MIN_STR, SAMPLING_TIMES_MAX_STR);
    calcEstimateTime();
}

/**
 *        
 * added by l00104422
 */
function powerCheckHandler()
{
  /*var obj = getNeProperty(self);
  var testMode = obj["testMode"];    
  if (TESTMODE_IN_SVR == testMode)
  {
  	POWER_MIN_VALUE = "-10.0";
  	POWER_MAX_VALUE = "2.0";
  	POWER_DEFAULT_VALUE = "-10.0";
  }
  else if (TESTMODE_OUT_SVR == testMode)
  {
  	POWER_MIN_VALUE = "-10.0"; 
  	POWER_MAX_VALUE = "18.5"; 
  	POWER_DEFAULT_VALUE = "18.5";
  }*/

  var power = testParam.getAtom("power").element.value;
  if ("" == power || power < POWER_MIN_VALUE)
	{
  	  testParam.setAttrValue("power", POWER_MIN_VALUE);
  }
  else if (power > POWER_MAX_VALUE)
  {
  	  testParam.setAttrValue("power", POWER_MAX_VALUE);
  }
	checkText(testParam.getAtom("power").element, POWER_MIN_VALUE, POWER_MAX_VALUE, 1);
}

function dummyPowerAdjustHandler()
{
	var dummyPowerAdjust = testParam.getAtom("dummyPowerAdjust").element.value;
	var dummyPowerEle = testParam.getAtom("dummyPower").element;
	
	if ("1" == dummyPowerAdjust)
	{
		dummyPowerEle.disabled = true;
		testParam.setAttrValue("dummyPower", "-");
	}
	else
	{
		dummyPowerEle.disabled = false;
		testParam.setAttrValue("dummyPower", DUMMYPOWER_MIN);
		checkText(testParam.getAtom("dummyPower").element, DUMMYPOWER_MIN, DUMMYPOWER_MAX);
	}
}


function doCancel()
{
    xcloseDialog();
}

/*
 *           
 */
function checkTestTime()
{
    var time = testParam.getAttrValue("testTime");
    if (time.value == "")
    {
        alert("TestTime cant be null");
        return false;
    }
    
    timeSplit = time.split(":");
    
    if (timeSplit.length != 3)
    {
        alert("Time format invalid");
        return false;
    }
    
    var hour = timeSplit[0];
    var minute = timeSplit[1];
    var second = timeSplit[2];
    
    if (isNaN(hour))
    {
        alert("Hour invalid");
        return false;
    }
    
    if (isNaN(minute))
    {
        alert("Minute invalid");
        return false;
    }
    
    if (isNaN(second))
    {
        alert("Second invalid");
        return false;
    }
    
    var expression = /[0-9]{1,3}/;
    var hourExp = new RegExp(expression);
    if (false == hourExp.test(hour))
    {
        alert("Hour error");
        return false;
    }
    
    if(hour > 100)
    {
        alert("Hour must below 100");
        return false;
    }
    
    var minuteExp = /[0-5]?[0-9]/;
    if (!minuteExp.test(minute))
    {
        alert("Minute error");
        return false;
    }
    
    var secondExp = /[0-5]?[0-9]/;
    if (!secondExp.test(second))
    {
        alert("Second error");
        return false;
    }
    return true;
}

function OpticalFiberParam()
{
    this.linetime;//      
    this.codetime;//      
    this.atime;//    A  
    this.btime;//    B  
}

function createWaveLengthOption(cTableAtomEle, bandTypeValue)
{
	cTableAtomEle.options.length = 0;
	
	if (null == parentWin.waveLengthList)
	{
		return;
	}
	
	var lengths = 0;
	
  for (var i = 0, len = parentWin.waveLengthList.bandType.length; i < len; i++)
	{
	    if (bandTypeValue == parentWin.waveLengthList.bandType[i].value)
	    {
	    	lengths = parentWin.waveLengthList.bandType[i].options.length;
	    	
	    	if ("1" == bandTypeValue)
	    	{
	    		lengths = 88;
	    	}
	    	
	    	for (var j = 0, k = lengths; j < k; j++)
	    	{
			     cTableAtomEle.options.add(new Option(parentWin.waveLengthList.bandType[i].options[j].text, parentWin.waveLengthList.bandType[i].options[j].value));
	    	}
	    }
	}
}
