var SINGLE_TEST = 1;                //      
var MANUAL_TEST = 2;                //    
var CYCLE_TEST = 3;                 //      
var BASELINE_TEST = 4;              //      
var QUICK_TEST = 5;           //           
var UNKNOWN_TESTTYPE = 6;           //     

var IDLE_STATUS = 1;                //   
var TESTING_STATUS = 2;             //   
var WAITING_STATUS = 3;             //   
var UNKNOWN_STATUS = 4;             //   

var IS_MODE = 1;                    //    
var OOS_MODE = 2;                   //    
var UNKNOWN_MODE = 3;               //    

var NOREP = 1;                      //       
var REP = 0;                        //      

var VALID = 1;                      //  
var NOT_VALID = 0;                  //   

var USE_LAS = 0;
var NOT_USE_LAS = 1;

var SHORT_TAG = "-";

/*
 *              ,
 *       1     "    "
 */ 
var CURRENT_WORK_STATUS = [];
CURRENT_WORK_STATUS[1] = "IdleStatus";    //   
CURRENT_WORK_STATUS[2] = "TestStatus";    //   
CURRENT_WORK_STATUS[3] = "WaitingStatus"; //   
CURRENT_WORK_STATUS[4] = "PrepareStatus"; //   
CURRENT_WORK_STATUS[5] = "BUSwitchingStatus"; //BU   
CURRENT_WORK_STATUS[6] = "UnknownStatus"; //  

var TEST_MODE = [];
TEST_MODE[0] = "Idle";               //  
TEST_MODE[1] = "InServiceMode";      //    
TEST_MODE[2] = "OutOfServiceMode";   //    
TEST_MODE[3] = "UnknownMode";        //  

var TEST_TYPE = [];
TEST_TYPE[0] = "Idle";               //  
TEST_TYPE[1] = "SingleTest";         //      
TEST_TYPE[2] = "ManualTest";         //    
TEST_TYPE[3] = "CycleTest";          //      
TEST_TYPE[4] = "BaselineTest";       //      
TEST_TYPE[5] = "QuickTest";          //         
TEST_TYPE[6] = "UnknownTest";        //  
TEST_TYPE[7] = "QuickTest";          //         

var LINE_DIRECTION = [];
LINE_DIRECTION[0] = "Reverse";      //0   
LINE_DIRECTION[1] = "Positive";     //1   

var bandTypeList = [];
bandTypeList[0] = "C+L";
bandTypeList[1] = "C";
bandTypeList[2] = "L";
bandTypeList[3] = "C320G";
bandTypeList[4] = "LMC";
bandTypeList[5] = "LML";
bandTypeList[6] = "CWDM";

var DUMMYSTATUS_OPEN = 1;
var DUMMYSTATUS_CLOSE = 0;


var GET_LINE_STATUS = 2556967;        //      
var SYNC_TEST_DATA = 2556967;         //      
var GET_TEST_RESULT = 2556967;        //      
var GET_MID_RESULT = 2556967;		  //        



var START_SINGLE_TEST_IS = 2556967;   //             
var START_MANUAL_TEST_IS = 2556967;   //           
var START_BASELINE_TEST_IS = 2556967; //             
var START_CYCLE_TEST_IS = 2556967;    //             
var STOP_TEST_IS = 2556967;           //         
var MANAGE_BASELINE_IS = 2556967;     //         
var MANAGE_TEST_PARAM_IS = 2556967;   //           
var REPEATER_TD_ANALYSIS_IS = 2556967;//Repeater           
var LINE_TD_ANALYSIS_IS = 2556967;    //             
var START_SINGLE_TEST_OOS = 2556967;  //             
var START_MANUAL_TEST_OOS = 2556967;  //           
var START_BASELINE_TEST_OOS = 2556967;//             
var STOP_TEST_OOS = 2556967;          //         
var MANAGE_BASELINE_OOS = 2556967;    //         
var MANAGE_TEST_PARAM_OOS = 2556967;  //           
var TEST_DATA_ANALYSIS_OOS = 2556967; //           
var GET_LINE_MORE_INFO = 2556967;     //        


var BIT_LENGTH = [64, 128, 256];

var PULSE_WIDTH_MIN = 1;            //   
var PULSE_WIDTH_MAX = 200;        //   

var PULSE_WIDTH_MIN_STR = "1";      //   
var PULSE_WIDTH_MAX_STR = "200";  //   

var SAMPLING_TIMES_MIN = 1;          //   
var SAMPLING_TIMES_MAX = 1048575;    //      2 20  

var SAMPLING_TIMES_MIN_STR = "1";    //   
var SAMPLING_TIMES_MAX_STR = "1048575";//      2 20  

var DEFAULT_SAMPLINE_FREQ = 5;



var Period_12h = 720;
var Period_24h = 1440;
var Period_3d = 4320;
var Period_7d = 10080;
var Period_14d = 20160;
var Period_28d = 40320;
var Period_poll = 0;

var periodToMin = [720, 1440, 4320, 10080, 20160, 40320, 0];
var periodToStr = [];
periodToStr[0] = "TwelveHours";
periodToStr[1] = "Everyday";
periodToStr[2] = "ThreeDays";
periodToStr[3] = "Week";
periodToStr[4] = "HalfMonth";
periodToStr[5] = "Month";
periodToStr[6] = "Poll";

var SLM_LINEMGR_MIN_REFRACTIVE_RATE = "1.300";  //      
var SLM_LINEMGR_MAX_REFRACTIVE_RATE = "1.600";  //      
var SLM_LINEMGR_MIN_FIBER_LENGTH = "45.0";      //         
var SLM_LINEMGR_MAX_FIBER_LENGTH= "120.0";      //        
var SLM_LINEMGR_MIN_ATTENUATION = "0.15";       //       
var SLM_LINEMGR_MAX_ATTENUATION = "0.30";       //       

var SLM_LMU_BOARDTYPE = 1229;                   //LMU    
var SLM_LOA_BOARDTYPE = 1228;                   //LOA    
var SLM_LSU_BOARDTYPE = 1227;                   //LSU    
var SLM_LMI_BOARDTYPE = 1226;                   //LMI    

var DEFAULT_LINE_NUM = "--";

var refreshType = new Object();
refreshType["1"] = "refreshStart";
refreshType["0"] = "refreshStop";

var SINGLE_CODE_VALUE = 1;
var SHORT_CODE_VALUE = 64;
var MEDIUM_CODE_VALUE = 128;
var LONG_CODE_VALUE = 256;
var JRE_VERSION = "1.6.0_43";


var FUN_SPT_ALL = 0X0000;
var FUN_SPT_ALL_IS = 0X0100;
var FUN_SPT_IS_BASELINE = 0x0101;
var FUN_SPT_IS_SINGLE = 0x0102;
var FUN_SPT_IS_MANUAL = 0x0103;
var FUN_SPT_IS_PERIOD = 0x0104;

var FUN_SPT_ALL_OOS = 0X0200;
var FUN_SPT_ALL_OOS_BASELINE = 0X0201;
var FUN_SPT_ALL_OOS_SINGLE = 0X0202;
var FUN_SPT_ALL_OOS_MANUAL = 0X0203;
var FUN_SPT_ALL_OOS_QUICK = 0X0204;

var FUN_IS_SUPPORT = 1;
var FUN_NOT_SUPPORT = 0;

var LINE_DIR_CUR = 1;
var LINE_DIR_REVERSE = 0;

REFRESH_TYPE_START = 1;
REFRESH_TYPE_STOP = 0;

/**
 *       
 */
function TELinePartTestState(lineID, lineDirection)
{
	this.element.lineID = lineID
	this.element.testStatus = IDLE_STATUS;
	this.element.testMode = UNKNOWN_MODE;
	this.element.testType = UNKNOWN_TESTTYPE;
	this.element.startTime = "-";
	this.element.remainingTime = "-";
	this.element.testProgress = "-";
	this.element.direction = lineDirection;
}

TELinePartTestState.prototype.getLineID = function()
{
	return this.element.lineID;
}

TELinePartTestState.prototype.setLineID = function(lineID)
{
	this.element.lineID = lineID;
}

TELinePartTestState.prototype.getTestStatus = function()
{
	return this.element.testStatus;
}

TELinePartTestState.prototype.setTestStatus = function(testStatus)
{
	this.element.testStatus = testStatus;
}

TELinePartTestState.prototype.getTestMode = function()
{
	return this.element.testMode;
}

TELinePartTestState.prototype.setTestMode = function(testMode)
{
	this.element.testMode = testMode;
}

TELinePartTestState.prototype.getTestType = function()
{
	return this.element.testType;
}

TELinePartTestState.prototype.setTestType = function(testType)
{
	this.element.testType = testType;
}

TELinePartTestState.prototype.getStartTime = function()
{
	return this.element.startTime;
}

TELinePartTestState.prototype.setStartTime = function(startTime)
{
	this.element.startTime = startTime;
}

TELinePartTestState.prototype.getRemainingTime = function()
{
	return this.element.remainingTime;
}

TELinePartTestState.prototype.setRemainingTime = function(remainingTime)
{
	this.element.remainingTime = remainingTime;
}

TELinePartTestState.prototype.getTestProgress = function()
{
	return this.element.testProgress;
}

TELinePartTestState.prototype.setTestProgress = function(testProgress)
{
	this.element.testProgress = testProgress;
}

TELinePartTestState.prototype.getDir = function()
{
	return this.element.direction;
}
	
TELinePartTestState.prototype.setDir = function(direction)
{
	this.element.direction = direction;
}
	
/**
 *       
 */
function TELineTestState(lineid)
{
	this.element.lineID = lineid;
	this.element.curDirState = new TELinePartTestState(lineid, LINE_DIR_CUR);
	this.element.reverseDirState = new TELinePartTestState(lineid, LINE_DIR_REVERSE);
}

TELineTestState.prototype.getLineID = function()
{
	return this.element.lineID;
}

TELineTestState.prototype.setLineID = function(lineID)
{
	this.element.lineID = lineID;
}


TELineTestState.prototype.getCurTestStatus = function()
{
	return this.element.curDirState.getTestStatus();
}

TELineTestState.prototype.setCurTestStatus = function(testStatus)
{
	this.element.curDirState.setTestStatus(testStatus);
}

TELineTestState.prototype.getCurTestMode = function()
{
	return this.element.curDirState.getTestMode();
}

TELineTestState.prototype.setCurTestMode = function(testMode)
{
	this.element.curDirState.setTestMode(testMode);
}

TELineTestState.prototype.getCurTestType = function()
{
	return this.element.curDirState.getTestType();
}

TELineTestState.prototype.setCurTestType = function(testType)
{
	this.element.curDirState.setTestType(testType);
}

TELineTestState.prototype.getCurStartTime = function()
{
	return this.element.curDirState.getStartTime();
}

TELineTestState.prototype.setCurStartTime = function(startTime)
{
	this.element.curDirState.setStartTime(startTime);
}

TELineTestState.prototype.getCurRemainingTime = function()
{
	return this.element.curDirState.getRemainingTime();
}

TELineTestState.prototype.setCurRemainingTime = function(remainingTime)
{
	this.element.curDirState.setRemainingTime(remainingTime);
}

TELineTestState.prototype.getCurTestProgress = function()
{
	return this.element.curDirState.getTestProgress();
}

TELineTestState.prototype.setCurTestProgress = function(testProgress)
{
	this.element.curDirState.setTestProgress(testProgress);
}

TELineTestState.prototype.getRevTestStatus = function()
{
	return this.element.reverseDirState.getTestStatus();
}

TELineTestState.prototype.setRevTestStatus = function(testStatus)
{
	this.element.reverseDirState.setTestStatus(testStatus);
}

TELineTestState.prototype.getRevTestMode = function()
{
	return this.element.reverseDirState.getTestMode();
}

TELineTestState.prototype.setRevTestMode = function(testMode)
{
	this.element.reverseDirState.setTestMode(testMode);
}

TELineTestState.prototype.getRevTestType = function()
{
	return this.element.reverseDirState.getTestType();
}

TELineTestState.prototype.setRevTestType = function(testType)
{
	this.element.reverseDirState.setTestType(testType);
}

TELineTestState.prototype.getRevStartTime = function()
{
	return this.element.reverseDirState.getStartTime();
}

TELineTestState.prototype.setRevStartTime = function(startTime)
{
	this.element.reverseDirState.setStartTime(startTime);
}

TELineTestState.prototype.getRevRemainingTime = function()
{
	return this.element.reverseDirState.getRemainingTime();
}

TELineTestState.prototype.setRevRemainingTime = function(remainingTime)
{
	this.element.reverseDirState.setRemainingTime(remainingTime);
}

TELineTestState.prototype.getRevTestProgress = function()
{
	return this.element.reverseDirState.getTestProgress();
}

TELineTestState.prototype.setRevTestProgress = function(testProgress)
{
	this.element.reverseDirState.setTestProgress(testProgress);
}
