 var parentWin = getParentWindow(); //     
var winurlobj = parentWin.winurlobj;


var btnRightArr = new Object();//        
var slmLineTable;//   (      )   
var slmParamTable;//   (      )  
var TABLE_TOTLE_HEIGHT = 265;
var DEFAULT_QUERY_LINEID = 0;//              id
var DEFAULT_QUERY_SEGMENTID = 0; //              id
var availableLine =null; //      
var availablePort = null;//      
var DEFAULT_SEGMENT_NUM = "--";

document.title = RESOURCE["GetLineMoreInfo"];

/**
 *      
 * @param  
 * @return  
 */
function init()
{
	initBtn();
	initTable();
	doQueryLineInfo();
}
/**
 *           
 * @param  
 * @return  
 */
function initBtn()
{
    $("cancel").value = RESOURCE["cancelBtn"];
}
/**
 *          
 * @param  
 * @return  
 */
function initTable()
{
	slmLineTable = new SortTable();
	slmLineTable.setImage("../../../../images/");
	slmLineTable.setBodyHeight(TABLE_TOTLE_HEIGHT);
	createTableHead(slmLineTable, window.tableconf[0]); 
	slmLineTable.setOnRowSelectHandler(rowSelectHandler);
	$("slmLineTable").appendChild(slmLineTable.getTable());
	
	slmParamTable = new SortTable();
	slmParamTable.setImage("../../../../images/");
	slmParamTable.setBodyHeight(TABLE_TOTLE_HEIGHT);
	createTableHead(slmParamTable, window.tableconf[1]); 
	slmParamTable.setOnCellEditHandler(cellEditHandler);
	$("slmParamTable").oncontextmenu = popupMenuHandler;
	$("slmParamTable").appendChild(slmParamTable.getTable());
}
/**
 *             
 * @param rows
 * @return  
 */
function rowSelectHandler(rows)
{
	if (rows.length == 1)
	{
		queryLineDetails();
	}
	else
	{
		slmParamTable.clearTableData();
	$("segmentNum").innerHTML = DEFAULT_SEGMENT_NUM;
	}
}
/**
 *                
 * @param param
 * @return  
 */
function cellEditHandler(param)
{
	var cell;//   
	if (param.colid == "refractiveRate")
	{
		cell = slmParamTable.getCell(param.rowindex, "refractiveRate");	
		textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_REFRACTIVE_RATE, SLM_LINEMGR_MAX_REFRACTIVE_RATE);
	}
	if (param.colid == "fiberLength")
	{
		cell = slmParamTable.getCell(param.rowindex, "fiberLength");	
		textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_FIBER_LENGTH, SLM_LINEMGR_MAX_FIBER_LENGTH);
	}
	if (param.colid == "attenuation")
	{
		cell = slmParamTable.getCell(param.rowindex, "attenuation");	
		textCheck(cell.element.editElement.element, SLM_LINEMGR_MIN_ATTENUATION, SLM_LINEMGR_MAX_ATTENUATION, 2);
	}
}


/**
 *              
 * @param evt
 * @return  
 */
function remarkMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}
	 var elem = (evt.target) ? evt.target : evt.srcElement;   
	if (elem != null && elem.blur)
    {
    	elem.blur();	  	
    }
    while (elem != null)
	{
		if (elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
    } 
    if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	} 
	var rowid= elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
	if (rows.length == 0)
	{
		return;
	}
    if (rows.contains(rowid))
	{
		createRemarkMenu(rows, evt); 
	}
}
/**
 *         
 * @param  
 * @return  
 */
function createRemarkMenu(rows, evt)
{
	removejsDOMmenu();
	var menuSize = 150;
	var cursorMenu = new jsDOMenu(menuSize);
	cursorMenu.addMenuItem(new menuItem(RESOURCE["remarkTitle"], "", openRemrkDlg, true));
	setPopUpMenu(cursorMenu);
	showMenu(evt);
}
/**
 *           
 * @param  
 * @return  
 */
function openRemrkDlg()
{
	removejsDOMmenu();
	var dialogHeight = 175;//"175px";
	var dialogWidth = 275;//"275px";
	xshowModalDialog("slmlineremarkmodify.html", RESOURCE["remarkTitle"], dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *          
 * @param  
 * @return  
 */
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackRightInfoData, null, "inputdata=" + createRightInfoXML());

}
/**
 *               XML  
 * @param  
 * @return      
 */
function createRightInfoXML()
{
	var root = new inputxml("datainterface")
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for (var btnrightobj in btnRightArr)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "btnId");
		param.setAttribute("value", btnRightArr[btnrightobj].btnId);
		row.appendChild(param)
		
		param = new tagElement("param");
		param.setAttribute("name", "sfid");
		param.setAttribute("value", btnRightArr[btnrightobj].sfid);
		row.appendChild(param)
		bussiness.appendChild(row);
	}
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
/**
 *             
 * @param doc 
 * @return  
 */
function callbackRightInfoData(doc)
{
	var data = EncapsulateData(doc);
	for (var i = 0, len = data.getDataRowLength(); i<len; i++)
	{
		var right = data.getDataRowParam(i,"right");
		
		
		var btnDisabled = parseInt(right)?false:true;
		btnRightArr[data.getDataRowParam(i,"btnId")].right = !btnDisabled;
	}
}

/**
 *       
 * @param   
 * @return  
 */
function doQueryLineInfo()
{
	var data = createQueryLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_MARINE_LINEMGR_QUERY_LINE_MORE_INFO + "&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackQueryLineInfoData,null,"inputdata="+data);

}
/**
 *           XML  
 * @param  
 * @return  
 */
function createQueryLineInfoXML()
{
  var obj = getNeProperty(self);    
	var lineID = obj["lineID"];
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", lineID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *           
 * @param doc 
 * @return  
 */
function callbackQueryLineInfoData(doc)
{
	availableLine = null;
	var data = EncapsulateData(doc);
	var errObj = null;
  slmParamTable.clearTableData();
		
	var errorCode = data.getSErrorCode();
	availableLine = data;
	if (0 == errorCode || 1 == errorCode)
	{
		slmLineTable.clearTableData();
		
		var newData = getPortMap(data); 
		createTableBody(slmLineTable, window.tableconf[0], newData, RESOURCE);
		if (0 < slmLineTable.getDataRowLength() && 0 == slmLineTable.getSelectedRowCount())
		{
			slmLineTable.setRowSelect(0);
			rowSelectHandler(slmLineTable.getSelectedRows());
		}
		showOperResult(data);
	}
	else
	{
		showOperResult(data, errObj);
	}
	
}
/**
 *     data      
 * @param data
 * @return newData
 */
function getPortMap(data)
{
	var newData = new DataInterface();
	var slotId;
	var boardName;
	var portId;
	var portName;
	for (var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		obj = new Object();
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "lineID");
		obj["lineID"] = ptag;
		
		slotId = data.getDataRowParam(i,"lmuSlotId");
		boardName = data.getDataRowParam(i, "lmuBoardName");
		portId = data.getDataRowParam(i, "lmuPortId");
		portName = data.getDataRowParam(i, "lmuPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineMonitorUnit"] = ptag;
		
		slotId = data.getDataRowParam(i,"loaSlotId");
		boardName = data.getDataRowParam(i, "loaBoardName");
		portId = data.getDataRowParam(i, "loaPortId");
		portName = data.getDataRowParam(i, "loaPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineAmplifierUnit"] = ptag;
		
		slotId = data.getDataRowParam(i,"lsuSlotId");
		boardName = data.getDataRowParam(i, "lsuBoardName");
		portId = data.getDataRowParam(i, "lsuPortId");
		portName = data.getDataRowParam(i, "lsuPortName");

		ptag = new ParamTag();
		ptag.value = slotId + "-" + boardName + "-" + portName;
		obj["lineSelectUnit"] = ptag;
		
		neName = data.getDataRowParam(i, "lmiNeName");
		slotId = data.getDataRowParam(i,"lmiSlotId");
		boardName = data.getDataRowParam(i, "lmiBoardName");
		portId = data.getDataRowParam(i, "lmiPortId");
		portName = data.getDataRowParam(i, "lmiPortName");

		ptag = new ParamTag();
		ptag.value = neName + "-" + slotId + "-" + boardName + "-" + portName;
		obj["lineMonitorInterface"] = ptag;
		
		ptag = new ParamTag();
		ptag.value = data.getDataRowParam(i, "remark");
		obj["remark"] = ptag;
		
		newData.rows.append(obj)
	}
	return newData;
}
/**
 *                      
 * @param  
 * @return  
 */
function queryLineDetails()
{
	var data = createQueryLineDetailsXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_LINE_DETAILS + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackQueryLineDetailsData, null, "inputdata="+data);

}
/**
 *                   XML  
 * @param  
 * @return  
 */
function createQueryLineDetailsXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "segmentID");
	param.setAttribute("value", DEFAULT_QUERY_SEGMENTID);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                 
 * @param doc
 * @return  
 */
function callbackQueryLineDetailsData(doc)
{
	slmParamTable.clearTableData();
	var data = EncapsulateData(doc);
	var segmentNum;
	
	var refractiveRate;//      0.001
	var fiberLength;   //       1
	var attenuation;   //       0.01
	
	if (0 == data.getSErrorCode())
	{
		for (var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			refractiveRate = parseFloat(data.getDataRowParam(i, "refractiveRate")) / 1000;
			fiberLength = parseFloat(data.getDataRowParam(i, "fiberLength")) / 10;
			attenuation = parseFloat(data.getDataRowParam(i, "attenuation")) / 100;
			data.rows[i]["refractiveRate"].value = refractiveRate;
			data.rows[i]["fiberLength"].value = fiberLength;
			data.rows[i]["attenuation"].value = attenuation;
		}
		createTableBody(slmParamTable, window.tableconf[1], data, RESOURCE);
		
		$("segmentNum").innerHTML = data.getDataRowLength();
	}
	else
	{
		var errObj = new Array();
		errObj.push("nename");
		showOperResult(data, errObj);
	}
}
/**
 *       
 * @param  
 * @return  
 */
function doActivateLine() 
{
	var data = createActivateLineXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_ACTIVATE_BASELINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackActivateLineData, null, "inputdata="+data);

}

/**
 *               XML
 * @param  
 * @return  
 */
function createActivateLineXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	var selectedRow = slmLineTable.getSelectedRows();
	var lmiMap = slmLineTable.getCellStoreValue(selectedRow[0], "lineMonitorInterface", "lineMonitorInterface");
	var lmiSoltId = lmiMap.split("-")[0];
	var lmiPortId = lmiMap.split("-")[2].split("(")[0];
	var lmineid = getLMIneid(lmiSoltId, lmiPortId);
	param = new tagElement("param");
	param.setAttribute("name", "lmineid");
	param.setAttribute("value", lmineid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiSoltId");
	param.setAttribute("value", lmiSoltId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "lmiPortId");
	param.setAttribute("value", lmiPortId);
	row.appendChild(param);
	
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	
	return root.toString();
}
function callbackActivateLineData(doc)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["activeSuccess"]);
	}
	else
	{
		errObj = [];
		errObj.push("nename");
		showOperResult(data, errObj);
	}
}
/**
 *       
 * @param slotId, portId
 * @return lmiNeid
 */
function getLMIneid(slotId, portId)
{
	var selectedRow = slmLineTable.getSelectedRows();
	for (var index = 0, indexLen = availableLine.getDataRowLength(); index < indexLen; index++)
	{
		if(availableLine.getDataRowParam(index, "lineID") == slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"))
		{
			return availableLine.getDataRowParam(index, "lmineid");
		}
	}
}
/**
 *       
 * @param  
 * @return  
 */
function doSetLineInfo ()
{
	
	var data = createApplyLineInfoXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_SET_LINE_PARAM + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackApplyLineInfoData, null, "inputdata="+data);
	
}
/**
 *           XML  
 * @param  
 * @return  
 */
function createApplyLineInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colId = null;
	var cellModifyFlag = null;
	var isModified = false;
	
	var colValue = 0;
	
	for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (!slmParamTable.getModify(rowIndex))
		{
			continue;
		}
		isModified = true;
		rowData = slmParamTable.getRow(rowIndex);
		row = new tagElement("row-params");
		
		param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",winurlobj["neid"]);
		row.appendChild(param);
		
		var selectedRow = slmLineTable.getSelectedRows();
		param = new tagElement("param");
		param.setAttribute("name","lineID");
		param.setAttribute("value",slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
		row.appendChild(param);
		
		for (var colIndex = 0, colLen = slmParamTable.getColumnCount(); colIndex < colLen; colIndex++)
		{
			colId = window.tableconf[1].getColId(colIndex);
			cellModifyFlag = slmParamTable.getCellModify(rowIndex, colId);
			colKeyArray = window.tableconf[1].getColKeyArray(colIndex);
			
			for (var keyindx = 0, keyLen = colKeyArray.length; keyindx < keyLen; keyindx++)
			{
				param = new tagElement("param");
				var keyName = colKeyArray[keyindx].name;
				colValue = slmParamTable.getCellStoreValue(rowIndex, colId, keyName);
				if (keyName == "attenuation")
				{
					colValue = parseFloat(colValue) * 100; 
				}
				else if (keyName == "refractiveRate")
				{
					colValue = parseFloat(colValue) * 1000; 
				}
				else if (keyName == "fiberLength")
				{
					colValue = parseFloat(colValue) * 10; 
				}
				param.setAttribute("name", keyName);
				param.setAttribute("value", colValue);
				param.setAttribute("modifyFalg", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	
	if(!isModified)
	{
		return null;
	}
	
	root.getRoot().appendChild(bussiness);

	return root.toString();
}
/**
 *            
 * @param doc
 * @return  
 */
function callbackApplyLineInfoData(doc)
{
	var data = EncapsulateData(doc);
	refreshTableState(slmParamTable, window.tableconf[1], data);
	
	if(0 != data.getSErrorCode())
	{
		errObj = [];
		errObj.push("nename");
		showOperResult(data, errObj);
	}
}
/**
 *                
 * @param  
 * @return  
 */
function doDeleteLine()
{
	if (!confirm(RESOURCE["confirmDelete"]))
	{
		return;
	}
	
	
	var data = createDeleteLineXML();
	var url = "../../../../neExlorerServlet?sfid=" +TECMDCODE_SLM_LINEMGR_DELETE_LINE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackDeleteLineData, null, "inputdata="+data);

} 
/**
 *             XML  
 * @param  
 * @return  
 */
function createDeleteLineXML()
{
	var selectedRow = slmLineTable.getSelectedRows();
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "lineID");
	param.setAttribute("value", slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID"));
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
} 
/**
 *              
 * @param doc
 * @return  
 */
function callbackDeleteLineData(doc)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		slmParamTable.clearTableData();
		$("segmentNum").innerHTML = DEFAULT_SEGMENT_NUM;
		
		var selectedRow = slmLineTable.getSelectedRows();
		var lineID = slmLineTable.getCellStoreValue(selectedRow[0], "lineID", "lineID");
		slmLineTable.deleteRow(selectedRow[0]);
		slmLineTable.adjustDataRows();
		
		for(var index = 0, len = availableLine.getDataRowLength(); index < len; index++)
		{
			if(availableLine.getDataRowParam(index, "lineID") == lineID)
			{
				availableLine.rows.removeAt(index);
				break;
			}
		}
		alert(RESOURCE["deleteSuccess"]);
	}
	else
	{
		errObj = [];
		errObj.push("nename");
		showOperResult(data, errObj);
	}
} 

/**
 *       
 * @param  
 * @return  
 */
function refreshBtnStatus()
{
	if(slmLineTable.getSelectedRowCount() == 1)
	{
	}
	else
	{
		$("delBtn").disabled = true;
	}
	$("queryBtn").disabled = !btnRightArr["queryBtn"].right;
	$("createBtn").disabled = !btnRightArr["createBtn"].right;
	
	$("applyBtn").disabled = true;
	for (var rowIndex = 0, rowLen = slmParamTable.getDataRowLength(); rowIndex < rowLen; rowIndex++)
	{
		if (slmParamTable.getModify(rowIndex))
		{
			$("applyBtn").disabled = false;
			break;
		}
	}
}
/**
 *       
 * @param  
 * @return  
 */
function queryAvailablePort()
{
	var data = createQueryAvailablePortXML()
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SLM_LINEMGR_QUERY_AVAILABLE_PORT + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQueryAvailablePortData, null, "inputdata="+data);

}
/**
 *           XML  
 * @param  
 * @return  
 */
function createQueryAvailablePortXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",winurlobj["neid"]);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}
/**
 *                
 * @param doc
 * @return  
 */
function callbackQueryAvailablePortData(doc)
{	
	availablePort = null;
	var data = EncapsulateData(doc);
	availablePort = data;
}
/**
 *              
 * @param  
 * @return  
 */
function openCreateLineDlg()
{
	queryAvailablePort();
	if(0 == availableLine.getDataRowLength() && 0 == availablePort.getDataRowLength())
	{
		alert(RESOURCE["noAvailableResource"]);
		return;
	}
	var dialogHeight = 300;//"300px";
	var dialogWidth = 550;//"550px";
	xshowModalDialog("slmlinecreate.html", RESOURCE["createLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}
/**
 *             
 * @param  
 * @return  
 */
function openModifyDlg()
{
	queryAvailablePort();
	var dialogHeight = 280;//"280px";
	var dialogWidth = 550;//"550px";
	xshowModalDialog("slmlinemodify.html", RESOURCE["createLineTitle"], dialogWidth, dialogHeight, "../../../../images/");
}


/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//           
		errArr[0] = "nename";//           
	
		/*for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			data.getError().rowErrors[i].errorObj["lineID"] = RESOURCE["slmLineError"]+ data.getError().rowErrors[i].errorObj["lineID"];
		}	*/	
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}
/**
 *       
 * @return  
 */
function disableAllBtn()
{
	$("queryBtn").disabled = true;
	$("createBtn").disabled = true;
	$("activeBtn").disabled = true;
	$("applyBtn").disabled = true;
	$("modifyBtn").disabled = true;
	$("delBtn").disabled = true;
}
/**
 *          
 * @param  
 * @return  
 */
function doCancel()
{
	xcloseDialog();
}
