 /*******************
 *       
 *******************/
var MIN_VOLTAGE = 0;
var MAX_VOLTAGE = 12000;
var MAX_INPUT_LENGTH = 5;

/*************
 *       
**************/
var win = getParentWindow();
if(!isIE)
{
    win = win.getDialogParentWindow();
}
var neid = win.neid;//  ID
var nmUser = win.nmUser;//    
var mainPageUrl = getNeProperty(self);//            
var isModify = false;
var bondPfeList = new Object();
var buObj;
var buName;
var parentDocument = window.frameElement.parentElement.document;
var buttonFrm;
if(isIE)
{
	  buttonFrm = parentDocument.frames.buttonFrm;
}
else
{
    var frameArr = window.frameElement.parentElement.getElementsByTagName("frame");
    buttonFrm = frameArr.buttonFrm.contentWindow;
}

window.onload = initPage;

/*****************
 *      
******************/
function initPage()
{
    initPageStringRes();

    initListener();

    initPageContent();
}

/********************
 *        
*********************/
function initPageStringRes()
{
    $("controlEndLbl").innerHTML = RESOURCE["controlunit"];
    $("controlLineIDLbl").innerHTML = RESOURCE["controllineid"];
    $("controlEndNeIDLbl").innerHTML = RESOURCE["controlend"];
    
    $("switchConditionLbl").innerHTML = RESOURCE["switchconditions"];
    $("forceLbl").innerHTML = RESOURCE["forceswitch"];
    
    $("switchModeLbl").innerHTML = RESOURCE["switchmode"];
    $("inServiceLbl").innerHTML = RESOURCE["inservice"];
    $("outOffServiceLbl").innerHTML = RESOURCE["outoffservice"];
    
    
}

/********************
 *      
*********************/
function initListener()
{
	  $("controlEndNeIDSlt").onchange = afterModify;
	  $("forceChx").onclick = afterModify;
	  $("inService").onclick = afterModify;
	  $("outOffService").onclick = afterModify;
	  
}

/***********************
 *           
************************/
function afterModify()
{
    isModify = true;
    buttonFrm.setModify();
}

/***********************
 *          
************************/
function initPageContent()
{
	  getBUFromParentPage();
    
    initControlUnitCbx();
    
}

/*****************************************
 *               BU  
******************************************/
function getBUFromParentPage()
{
    var parentTable = win.buTable;
    if(1 != parentTable.getSelectedRowCount())
    {
    	  alert("Not selected one BU!");
        return;
    }
    
    var selectedRow = parentTable.getSelectedRows()[0];
    
    buObj = new BUObject();
    buObj.name = parentTable.getCellStoreValue(selectedRow, "buName", "buname");
    buName = buObj.name;
    buObj.macAddr = parentTable.getCellStoreValue(selectedRow, "buMac", "macaddr");
    buObj.pressure = parentTable.getCellStoreValue(selectedRow, "pressure", "pressure");
    buObj.portList = getSelectedPortList(parentTable, selectedRow);
    buObj.bondLineList = getBondLines();
}

/*********************************
 *         BU     
***********************************/
function getSelectedPortList(parentTable, selectedRow)
{
    var portList = new Object();
    var portA = new BUPortObject();
    portA.portName = BU_APORT_NAME;
    portA.bondSLM = parentTable.getCellStoreValue(selectedRow, "abondslm", "abondslm");
    portA.bondPFE = parentTable.getCellStoreValue(selectedRow, "abondpfe", "abondpfe");
    portA.bondPFEName = parentTable.getCellStoreValue(selectedRow, "abondpfename", "abondpfename");
    portList[BU_APORT_NAME] = portA;
    
    var portB = new BUPortObject();
    portB.portName = BU_BPORT_NAME;
    portB.bondSLM = parentTable.getCellStoreValue(selectedRow, "bbondslm", "bbondslm");
    portB.bondPFE = parentTable.getCellStoreValue(selectedRow, "bbondpfe", "bbondpfe");
    portB.bondPFEName = parentTable.getCellStoreValue(selectedRow, "bbondpfename", "bbondpfename");
    portList[BU_BPORT_NAME] = portB;
    
    var portC = new BUPortObject();
    portC.portName = BU_CPORT_NAME;
    portC.bondSLM = parentTable.getCellStoreValue(selectedRow, "cbondslm", "cbondslm");
    portC.bondPFE = parentTable.getCellStoreValue(selectedRow, "cbondpfe", "cbondpfe");
    portC.bondPFEName = parentTable.getCellStoreValue(selectedRow, "cbondpfename", "cbondpfename");
    portList[BU_CPORT_NAME] = portC;
    
    return portList;
}

/************************************
 *         BU       
*************************************/
function getBondLines()
{
    var bondLineList = new Array();
    var bondLineTable = win.bondLineTable;
    
    var bondLine;
    for(var i = 0, len = bondLineTable.getDataRowLength(); i < len; i++)
    {
        bondLine = new BUBindLine();
        bondLine.lineID = bondLineTable.getCellStoreValue(i, "lineID", "lineID");	
	      bondLine.srcNEID = bondLineTable.getCellStoreValue(i, "srcLmuneid", "srcLmuneid");
	      bondLine.srcNEName = bondLineTable.getCellStoreValue(i, "srcLmuNeName", "srcLmuNeName");
	      bondLine.srcLmuSlotID = bondLineTable.getCellStoreValue(i, "srcLmuSlotId", "srcLmuSlotId");
	      bondLine.srcLmuPortID = bondLineTable.getCellStoreValue(i, "srcLmuPortId", "srcLmuPortId");
	      bondLine.srcLmiSlotID = bondLineTable.getCellStoreValue(i, "srcLmiSlotId", "srcLmiSlotId");
	      bondLine.srcLmiPortID = bondLineTable.getCellStoreValue(i, "srcLmiPortId", "srcLmiPortId");
	      bondLine.snkNEID = bondLineTable.getCellStoreValue(i, "sinkLmuneid", "sinkLmuneid");
	      bondLine.snkNEName = bondLineTable.getCellStoreValue(i, "sinkLmuNeName", "sinkLmuNeName");
	      bondLine.snkLmuSlotID = bondLineTable.getCellStoreValue(i, "sinkLmuSlotId", "sinkLmuSlotId");
	      bondLine.snkLmuPortID = bondLineTable.getCellStoreValue(i, "sinkLmuPortId", "sinkLmuPortId");
	      bondLine.snkLmiSlotID = bondLineTable.getCellStoreValue(i, "sinkLmiSlotId", "sinkLmiSlotId");
	      bondLine.snkLmiPortID = bondLineTable.getCellStoreValue(i, "sinkLmiPortId", "sinkLmiPortId");
	      bondLine.direction = bondLineTable.getCellStoreValue(i, "lineDirection", "lineDirection");
	      bondLine.bucontrolpoint = bondLineTable.getCellStoreValue(i, "bucontrolpoint", "bucontrolpoint");
	      
	      bondLineList[bondLineList.length] = bondLine;
    }
    
    return bondLineList;
}

/********************************
 *             
*********************************/
function initControlUnitCbx()
{
	  var bondLine;
	  
    for(var i = 0, len = buObj.bondLineList.length; i < len; i++)
    {
    	  bondLine = buObj.bondLineList[i];
        $("controlLineIDSlt").options[$("controlLineIDSlt").options.length] = new Option(bondLine.getLineIDString(), bondLine.lineID);
    }
    
    $("controlLineIDSlt").onchange = changeLineID;
    
    var selects = new Array();
    selects[0] = $("controlLineIDSlt");
    replaceSelects(selects);
    
    if(1 == win.bondLineTable.getSelectedRowCount())
    {
    	  var bondLineTable = win.bondLineTable;
        var selectedBondLineID = bondLineTable.getCellCurrentValue(bondLineTable.getSelectedRows()[0], "lineID", "lineID");
        $("controlLineIDSlt").selectedIndex = bondLineTable.getSelectedRows[0];
    }
    else
    {
        $("controlLineIDSlt").selectedIndex = 0;
    }
    
    changeLineID(true);
}

/********************************************
 *          ID          
*********************************************/
function changeLineID(flg)
{
	  if(0 == $("controlLineIDSlt").options.length)
	  {
	      return;
	  }
	  
	  var selectedLineID = $("controlLineIDSlt").options[$("controlLineIDSlt").options.selectedIndex].innerHTML;
	  var bondLineList = buObj.bondLineList;
	  var bondLine;

    $("controlEndNeIDSlt").options.length = 0;

	  for(var i = 0, len = bondLineList.length; i < len; i++)
	  {
	      bondLine = bondLineList[i];
	      if(bondLine.getLineIDString() == selectedLineID)
	      {
	      	  if(undefined != bondLine.srcNEID && 0 != bondLine.srcNEID && 
	      	         (bondLine.bucontrolpoint == BU_CONTROLEND_SRC || bondLine.bucontrolpoint == BU_CONTROLEND_BOTH))
	      	  {
	      	      $("controlEndNeIDSlt").options[$("controlEndNeIDSlt").options.length] = new Option(bondLine.srcNEName, bondLine.srcNEID);
	      	  }
	      	  
	      	  if(undefined != bondLine.snkNEID && 0 != bondLine.snkNEID && 
	      	         (bondLine.bucontrolpoint == BU_CONTROLEND_SNK || bondLine.bucontrolpoint == BU_CONTROLEND_BOTH))
	      	  {
	      	      $("controlEndNeIDSlt").options[$("controlEndNeIDSlt").options.length] = new Option(bondLine.snkNEName, bondLine.snkNEID);
	      	  }
	          
	          break;
	      }
	  }
    
    if(!flg)
    {
        afterModify();
    }
}

/*************************************
 *                  
**************************************/
function enableAllElement()
{
	  enableBtn();
}

/****************************
 *           
 ****************************/
function checkSubmitData()
{	  
	  if(-1 == $("controlLineIDSlt").selectedIndex || -1 == $("controlEndNeIDSlt").selectedIndex)
	  {
	      alert(RESOURCE["controlunitwrong"]);
	      return false;
	  }
	  
	  if(!($("inService").checked) && !($("outOffService").checked))
	  {
	      alert(RESOURCE["chooseswitchmode"]);
	      return false;
	  }
	  
	  
	  if($("forceChx").checked && !confirm(RESOURCE["dangoursOperation"]))
	  {
	      return false;
	  }
	  
	  return true;
	  
}

/**
 *       
 */
function isForceSwitch()
{
		if ($("forceChx").checked)
		{
			return true;
		}
		
		return false;
}

/****************************
 *           xml
 ****************************/
function createSwitchXML()
{
	  var paramList = new Array();
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buName);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "controlne");
    thirdlevel.setAttribute("value", $("controlEndNeIDSlt").options[$("controlEndNeIDSlt").selectedIndex].value);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "lineID");
    thirdlevel.setAttribute("value", $("controlLineIDSlt").options[$("controlLineIDSlt").selectedIndex].value);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "switchMode");
    thirdlevel.setAttribute("value", $("inService").checked ? BU_SWITCHMODE_INSERVICE : BU_SWITCHMODE_OUTOFSERVICE);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "conflictCheck");
    thirdlevel.setAttribute("value", BU_SWITCH_NOTCHECK);//$("collisionDetectChx").checked ? BU_SWITCH_CHECK : 
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "macAddr");
    thirdlevel.setAttribute("value", buObj.macAddr);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "voltageCheck");
    thirdlevel.setAttribute("value", $("forceChx").checked ? BU_SWITCH_VOTAGE_NOTCHECK : BU_SWITCH_VOTAGE_CHECK);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "malfunctionend");
    thirdlevel.setAttribute("value", "0");
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "malfunctionpoint");                
    thirdlevel.setAttribute("value", 0);//                                  
    paramList[paramList.length] = thirdlevel;
                                           
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "malfunctiontype");
    thirdlevel.setAttribute("value", MALFUNCTYPE_NONE);
    paramList[paramList.length] = thirdlevel;
    
    return paramList;
}

/**************************
 *           
***************************/

/**************************
 *        
***************************/

/******************************
 *           PFE  
*******************************/
function hasEnouphPFE()
{
		if ($("forceChx").checked)
		{
			  return true;
		}

    var buPortList = buObj.portList;
    var count = 0;
    if(null != buPortList && 0 != buPortList.length)
    {
    	if (buPortList[BU_APORT_NAME].bondPFE == "2027" 
    		&& buPortList[BU_BPORT_NAME].bondPFE == "2027"
    		&& buPortList[BU_CPORT_NAME].bondPFE == "2027") {
    		return true
    	}
    }
    
    if(confirm(RESOURCE["notenoughpfe"]))
    {
        return true;
    }
    
    return false;
}

function checkPrimaryLine() {
	if ($("forceChx").checked) {
		  return true;
	}
	var buPortList = buObj.portList;
	if (buObj.primaryLine == PRIMARY_LINE_AB) {
		if (buPortList[BU_APORT_NAME].bondPFE == "2027" || buPortList[BU_BPORT_NAME].bondPFE == "2027") {
			return true;
		}
	}
	else if (buObj.primaryLine == PRIMARY_LINE_AC) {
		if (buPortList[BU_APORT_NAME].bondPFE == "2027" || buPortList[BU_CPORT_NAME].bondPFE == "2027") {
			return true;
		}
	}
	else if (buObj.primaryLine == PRIMARY_LINE_BC) {
		if (buPortList[BU_BPORT_NAME].bondPFE == "2027" || buPortList[BU_CPORT_NAME].bondPFE == "2027") {
			return true;
		}
	}
	if (confirm(RESOURCE["confirmPrimaryLine"])) {
		return true;
	}
	return false;
}

