 /*************
 *       
**************/
var win = getParentWindow();
var topWin = isIE ? top : win;
var buObj;//BU    
var neid = win.neid;
var nmUser = win.nmUser;
var mainPageUrl = getNeProperty(self);//            
var statusFlg = (mainPageUrl && mainPageUrl["statusFlg"]) ? mainPageUrl["statusFlg"] : "";
var buName = (mainPageUrl && mainPageUrl["buName"]) ? mainPageUrl["buName"] : "";
var isModifyPageFlag = false;

window.onload = initPage;

if(statusFlg != "")
{
	  if(statusFlg == BU_CURRENT_STATUS)
	  {
	      document.title = RESOURCE["curbustatusmgr"];
	  }
	  else
	  {
	      document.title = RESOURCE["intbustatusmgr"];
	  }
    
}


/*******************
 *        
********************/
function initPage()
{
    initPageStringRes();

    initPageElement();
    
    if(statusFlg == "")
    {
        buObj = topWin.buObject;
        topWin.sunWin = this;
        
        refreshBUStatus();
    }
}

/**********************
 *          
***********************/
function initPageStringRes()
{
    $("buStatusLbl").innerHTML = RESOURCE["bustatuspicture"];
    $("buControlLbl").innerHTML = RESOURCE["bustatuscontrol"];
    
    $("prevStepBtn").value = RESOURCE["prevstep"];
    $("confirmBtn").value = RESOURCE["okbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    $("cancelBtn").value = RESOURCE["cancelbutton"];
    $("resetBtn").value = RESOURCE["reset"];
    $("queryBtn").value = RESOURCE["query"];
}

/**********************
 *         
***********************/
function openPrevStepPage()
{
	  getBuStatus(buObj);
	  if(isIE)
	  {
        top.switchPage("setbuattribute.html");
        top.dialogHeight = "630px";
    }
    else
    {
        win.switchPage("setbuattribute.html");
    }
}

/***************************
 *    BU        
****************************/
function initPageElement()
{
	  $("buStatusDiv").innerHTML = drawBuStatusView(0,0);
    $("buControlDiv").innerHTML = initBUControlBtn();
    
    if("" == statusFlg)
    {
    	  var pfeList = new Object();
    	  pfeList[BU_APORT_NAME] = mainPageUrl["aBondPfeList"];
    	  pfeList[BU_BPORT_NAME] = mainPageUrl["bBondPfeList"];
    	  pfeList[BU_CPORT_NAME] = mainPageUrl["cBondPfeList"];
    	  drawBondPFEStr(pfeList);
    	  getBondPFEPolarity(pfeList);
    	  $("resetBtn").style.display = "none";
        $("queryBtn").style.display = "none";
        
        $("applyBtn").disabled = true;

    }
    else
    {
    	  $("prevStepBtn").style.display = "none";
        
        queryBUStatus();
    }
}

/*********
 *   
*************/
function doApply(closeFlg)
{	
    if(!checkBUStatusInfe(true))
    {
        return;
    }
    
    if(null == closeFlg)
    {
        closeFlg = false;
    }
    
    if("" == statusFlg)
    {
    	  if(!isModifyPageFlag)
    	  {
    	      xcloseDialog();
    	      return;
    	  }
    	  getBuStatus(buObj);
        topWin.doCreateBU(closeFlg);
    }
    else if(isModifyPageFlag)
    {
        applySetBUStatus(closeFlg);
    }
    
    $("applyBtn").disabled = true;
}

/*********
 *   
*************/
function commit()
{
    doApply(true);
}

/*******************
 *         
********************/
function enableAllElement(enableFlg)
{
	  $("buControlDiv").disabled = !enableFlg;
	  $("resetBtn").disabled = !enableFlg;
    $("prevStepBtn").disabled = !enableFlg;
    $("confirmBtn").disabled = !enableFlg;
    $("applyBtn").disabled = !enableFlg;
    
    if(enableFlg)
    {
        isModifyPageFlag = true;
    }
}

/*************
 *     
**************/
function closeWin()
{
    closePage();
}

/*************
 *   BU  
***************/
function refreshBUStatus()
{
	handleRedioPanel();
	var isbondPFEModified = mainPageUrl["isbondPFEModified"]
	
    if (isbondPFEModified == "true")
	{
      if ($("aElec0") && !$("aElec0").checked) {
  		  $("aElec0").click()
  	  }
  	  if ($("bElec0") && !$("bElec0").checked) {
  		  $("bElec0").click()
  	  }
  	  if ($("cElec0") && !$("cElec0").checked) {
  		  $("cElec0").click()
  	  }
	}
    else
    {
        drawMainBridge(buObj.primaryLine);
        
        redrawCurDirection();
    }
}

/*************
 *   BU  
***************/
function queryBUStatus()
{
    var xmldata = createQueryBUStatusXML();
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUSTATUS + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleQueryBUStatus, null, "inputdata=" + xmldata);//      
}

/********************
 *     BU  xml
**********************/
function createQueryBUStatusXML()
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buName);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "statusFlg");
    thirdlevel.setAttribute("value", statusFlg);
    secondlevel.appendChild(thirdlevel);//        

    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/**********************
 *     BU    
************************/
function handleQueryBUStatus(doc)
{
    var data = EncapsulateData(doc); //          

    if (0 == data.getSErrorCode() && data.getDataRowLength() > 0) 
    {
    	  setBUObj(data);

    	  handleRedioPanel();
    	  
    	  drawMainBridge(data.getDataRowParam(0, "mainbridge"));
    	  
    	  drawEarth(data);
    	  
    	  drawCurDirection(data);
    	  
    	  isModifyPageFlag = false;
    	  $("resetBtn").disabled = true;
    	  $("applyBtn").disabled = true;
    }
    
    var errArr = [];//              
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//         
}

/****************
 *       
******************/
function setBUObj(data)
{
    if(statusFlg == "")
    {
        return;
    }
    
    buObj = new BUObject();
    buObj.name = buName;
    if(statusFlg == BU_CURRENT_STATUS)
    {
        buObj.curPrimaryLine = data.getDataRowParam(0, "mainbridge");
    }
    else
    {
        buObj.primaryLine = data.getDataRowParam(0, "mainbridge");
    }

    buObj.portList[BU_APORT_NAME] = newBUPortObj(BU_APORT_NAME, data);
    buObj.portList[BU_BPORT_NAME] = newBUPortObj(BU_BPORT_NAME, data);
    buObj.portList[BU_CPORT_NAME] = newBUPortObj(BU_CPORT_NAME, data);
}

/******************************
 *        BU    
*******************************/
function newBUPortObj(buPortName, data)
{
    var portObj = new BUPortObject();
    portObj.portName = buPortName;
    portObj.bondPFE = data.getDataRowParam(0, buPortName.toLowerCase() + "bondpfe");
    if(statusFlg == BU_CURRENT_STATUS)
    {
        portObj.curIsEarth = data.getDataRowParam(0, buPortName.toLowerCase() + "isearth");
        portObj.curElecDirection = data.getDataRowParam(0, buPortName.toLowerCase() + "elecdir");
    }
    else
    {
        portObj.isEarth = data.getDataRowParam(0, buPortName.toLowerCase() + "isearth");
        portObj.elecDirection = data.getDataRowParam(0, buPortName.toLowerCase() + "elecdir");
    }
    
    return portObj;
}

/**********************
 *         
************************/
function drawEarth(data)
{
	  var isEarth = data.getDataRowParam(0, "aisearth");

    chooseEarthPort(BU_APORT_NAME);
    
    isEarth = data.getDataRowParam(0, "bisearth");
    chooseEarthPort(BU_BPORT_NAME);
    
    isEarth = data.getDataRowParam(0, "cisearth");
    chooseEarthPort(BU_CPORT_NAME);
}

/**********************
 *         
************************/
function drawCurDirection(data)
{
	  drawPortCurDir(BU_APORT_NAME, data.getDataRowParam(0, "aelecdir"));
	  drawPortCurDir(BU_BPORT_NAME, data.getDataRowParam(0, "belecdir"));
	  drawPortCurDir(BU_CPORT_NAME, data.getDataRowParam(0, "celecdir"));
}

/**********************
 *        
************************/
function drawPortCurDir(portName, direction)
{
	  var realDir = convertPortCurDir(portName, direction);
    chooseElecDir(portName, realDir);
}

/******************************************
 *                    
*******************************************/
function convertPortCurDir(portName, direction)
{
    if(portName == BU_APORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_RIGHT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_LEFT;//     
        }
    }
    
    if(portName == BU_BPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_LEFT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_RIGHT;//     
        }
    }
    
    if(portName == BU_CPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_UP;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_DOWN;//     
        }
    }
    
    return ELECDIRECTION_NONE;
}

/*************************
 *           
***************************/
function handleRedioPanel()
{
	  if(null == buObj)
	  {
	      return;
	  }
	  
	  var dirObj = new Object();
	  var earthObj = new Object();
	  var mainBridge;

	  dirObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].elecDirection;
	  dirObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].elecDirection;
	  dirObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].elecDirection;
	  
	  earthObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].isEarth;
	  earthObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].isEarth;
	  earthObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].isEarth;
	  
	  mainBridge = buObj.primaryLine;
	  
	  setRedioCheckStatus(dirObj, earthObj, mainBridge);
}

/*************************
 *     BU    
***************************/
function applySetBUStatus(closeFlg)
{
	  if(statusFlg == BU_CURRENT_STATUS)
	  {
	  	  if(!confirm(RESOURCE["setstatusalert"]))
	  	  {
	          return;
	      }
	  }
	  else if(!confirm(RESOURCE["setinitstatusalert"]))
	  {
	      return;
	  }
	  	
    var xmldata = createSetBUStatusXML();
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_BUSTATUS + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleSetBUStatus, closeFlg, "inputdata=" + xmldata);//      
}

/*****************************
 *     BU   xml   
******************************/
function createSetBUStatusXML()
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buName);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "statusFlg");
    thirdlevel.setAttribute("value", statusFlg);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aelecdir");
    thirdlevel.setAttribute("value", getDirection(BU_APORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "belecdir");
    thirdlevel.setAttribute("value", getDirection(BU_BPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "celecdir");
    thirdlevel.setAttribute("value", getDirection(BU_CPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "mainbridge");
    thirdlevel.setAttribute("value", getPrimaryLine());
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aisearth");
    thirdlevel.setAttribute("value", getEarth(BU_APORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "bisearth");
    thirdlevel.setAttribute("value", getEarth(BU_BPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "cisearth");
    thirdlevel.setAttribute("value", getEarth(BU_CPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        

    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/*************************
 *     BU      
***************************/
function handleSetBUStatus(doc, closeFlg)
{
	  var data = EncapsulateData(doc);
	  
	  if (0 == data.getSErrorCode())
	  {
	      getBuStatus(buObj);
	      $("resetBtn").disabled = true;
        $("applyBtn").disabled = true;
        isModifyPageFlag = false;
	  }
	  
	  var errArr = [];//              
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//         
    
    if(closeFlg)
    {
        xcloseDialog();
    }

}

/****************
 *       
******************/
function reset()
{
	  handleRedioPanel();
	  
    drawMainBridge((statusFlg == BU_CURRENT_STATUS) ? buObj.curPrimaryLine : buObj.primaryLine);
    
    redrawCurDirection();
    
    isModifyPageFlag = false;
    $("resetBtn").disabled = true;
    $("applyBtn").disabled = true;
}

/**********************
 *         
************************/
function redrawCurDirection()
{
    var portDir = buObj.portList[BU_APORT_NAME].elecDirection;
    drawPortCurDir(BU_APORT_NAME, portDir);
    
    portDir = buObj.portList[BU_BPORT_NAME].elecDirection;
    drawPortCurDir(BU_BPORT_NAME, portDir);
    
    portDir = buObj.portList[BU_CPORT_NAME].elecDirection;
    drawPortCurDir(BU_CPORT_NAME, portDir);
}

/*********************
 *         
***********************/
function setPageStatus()
{
    $("applyBtn").disabled = true;
    isModifyPageFlag = false;
}

/***************************
 *       PFE    
*****************************/
function handleQueryPFEPolarity(doc)
{
    var data = EncapsulateData(doc);//           
    var polarytyObj = new Object();
    if ((0 == data.getSErrorCode() || 1 == data.getSErrorCode()) && data.getDataRowLength() > 0)
    {
        polarytyObj[BU_APORT_NAME] = data.getDataRowParam(0, "apfevoltage");
        polarytyObj[BU_BPORT_NAME] = data.getDataRowParam(0, "bpfevoltage");
        polarytyObj[BU_CPORT_NAME] = data.getDataRowParam(0, "cpfevoltage");
        
        drawPFEPolarityStr(polarytyObj);
    }
}
    
function closePage()
{
	  if(isIE)
	  {
	      xcloseDialog();
	  }
	  else
	  {
	      win.xcloseDialog();
	  }
}
