 /*******************************************************************************
 *       
 ******************************************************************************/
var MIN_VOLTAGE = 25;
var MAX_VOLTAGE = 30;
var DEFAULT_VOLTAGE = 28;
var INVALID_NEID = "-1";
var INVALID_NENAME = "--";
var BIND_STATUS = "1";
var UNBIND_STATUS = "0";
var LIST_SEPARATER = ",";

/*******************************************************************************
 *       
 ******************************************************************************/
var win = getParentWindow();
var topWin = isIE ? top : win;
var neid = win.neid;//   ID
var nmUser = win.nmUser;//     
var mainPageUrl = getNeProperty(self);//             
if(null == mainPageUrl || null == mainPageUrl["pageAttr"])
{
    if(isIE)
    {
        mainPageUrl = getNeProperty(top);
    }
    else
    {
        mainPageUrl = getNeProperty(win);
    }
}
var pageAttribute = mainPageUrl["pageAttr"];
var buName = mainPageUrl["buName"];
var isE2EFunction = mainPageUrl["isE2EFunction"];
var isFromMainTOPO = mainPageUrl["isFromMainTOPO"];
var bondLineTable;//       
var bondLineTblConf;//           
var slmList = new Array();
var pfeList = new Array();
var selectedSlmObj = new Array();
var selectedPfeObj = new Array();
var buObject = new BUObject();

var isModify = false;
var isbondPFEModified = false;
var buExist = false;//BU      
var buOldType = "";

if(pageAttribute == PAGE_ATTR_CREATE)
{
    top.document.title = RESOURCE["createbu"];
}
else
{
    document.title = RESOURCE["modifybuinfo"];
}

document.oncontextmenu = returnFalse;
window.onload = initPage;

/*******************************************************************************
 *        
 ******************************************************************************/
function initPage()
{
	isbondPFEModified = false;
	
    initPageStringRes();

    initButton();
    
    initBondLineTable();
    
    initPageContent();
    
    topWin.sunWin = this;
}

/*******************************************************************************
 *          
 ******************************************************************************/
function initPageStringRes()
{
    $("buAttrLbl").innerHTML = RESOURCE["buattribute"];
    $("buNameLbl").innerHTML = RESOURCE["buname"];
    $("buTypeLbl").innerHTML = RESOURCE["butype"];
    $("findExitBUBtn").value = RESOURCE["query"];
    $("buMacLbl").innerHTML = RESOURCE["bumac"];
    $("pressureLbl").innerHTML = RESOURCE["pressure"];
    $("bondSLMLbl").innerHTML = RESOURCE["bondslmunit"];
    $("aBondSlmLbl").innerHTML = RESOURCE["porta"];
    $("bBondSlmLbl").innerHTML = RESOURCE["portb"];
    $("cBondSlmLbl").innerHTML = RESOURCE["portc"];
    $("bondPFELbl").innerHTML = RESOURCE["bondpfeunit"];
    $("aBondPFELbl").innerHTML = RESOURCE["porta"];
    $("bBondPFELbl").innerHTML = RESOURCE["portb"];
    $("cBondPFELbl").innerHTML = RESOURCE["portc"];
    $("bondLineTblLbl").innerHTML = RESOURCE["bondLine"];
    
    $("findLineBtn").value = RESOURCE["findLine"];
    $("nextStepBtn").value = RESOURCE["nextstep"];
    $("confirmBtn").value = RESOURCE["okbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    $("cancelBtn").value = RESOURCE["cancelbutton"];
    
    $("aBondSlmTxt").title = $("aBondSlmTxt").value;
    $("bBondSlmTxt").title = $("bBondSlmTxt").value;
    $("cBondSlmTxt").title = $("cBondSlmTxt").value;
    
    $("buTypeSlt").options[0] = new Option("FP BU", BU_TYPE_FP);
    $("buTypeSlt").options[1] = new Option("OADM BU", BU_TYPE_OADM);
    
    if(pageAttribute == PAGE_ATTR_MODIFY)
    {
    	  $("buNamtTxt").disabled = true;
        $("buNamtTxt").size = 18;
        $("buNamtTxt").style.width = "90%";
    }
}

/*******************************************************************************
 *          
 ******************************************************************************/
function initBondLineTable()
{
    bondLineTable = new SortTable();
    bondLineTable.setImage("../../../../images/");
    bondLineTblConf = window.tableconf[0];    
    createTableHead(bondLineTable, bondLineTblConf);
    
    $("bondLineTblDiv").appendChild(bondLineTable.getTable());
    
    bondLineTable.setBodyHeight(getComponetHeight($("bondLineTblDiv"), 60)+"px");
    
    var newData = new DataInterface();
    createTableBody(bondLineTable, window.tableconf[0], newData, RESOURCE);

    $("bondLineTblDiv").oncontextmenu = popupMenuHandler;      
    bondLineTable.setOnCellEditHandler(cellEditHandler);
}

/**
 *       
 * @param param    
 * param 
 * 	param.stage = stage;
	param.rowindex = obj.parentNode.rowIndex;
	param.cellindex = obj.cellIndex;
	param.colid = obj.colid;
	param.value = obj.showElement.getValue();
	param.st = obj.parent;
 * 
 * @returns
 */
function cellEditHandler(param)
{		
	  var row = param.rowindex;
	  var colid = param.colid;	
	  var st = param.st;
	  
	  if ("bindstatus" == colid)
	  {
	  	  var buccell = st.getCell(row, "bucontrolpoint");		
	  	  var value = st.getCellCurrentValue(row, colid, "bindstatus");	
	  	  var isBinded = BIND_STATUS == value;
	  	  st.setCellIsEdit(buccell, isBinded);		
	  	  if (!isBinded)
	  	  {
	  	  	  buccell.element.showElement.setValue("");			
	  	  }
	  	  else
	  	  {	
	  	  	  buccell.element.showElement.setValue(RESOURCE[refreshbucontrolpointType["0"]]);
	  	  	  st.setCellValue(buccell, "bucontrolpoint", "0");
	  	  }
	  }
	  
	  if(pageAttribute == PAGE_ATTR_MODIFY)
	  {
	  	  $("applyBtn").disabled = false;
	  	  isModify = true;
	  }	
}

/*******************************************************************************
 *              
 ******************************************************************************/
function initButton()
{
    if(pageAttribute == PAGE_ATTR_CREATE)
    {
        $("confirmBtn").style.display = "none";
        $("applyBtn").style.display = "none";
    }
    else
    {
    	  $("findExitBUBtn").style.display = "none";
        $("nextStepBtn").style.display = "none";
    }
}

/*******************************************************************************
 *        
 ******************************************************************************/
function initPageContent()
{
	  $("buNamtTxt").onkeypress = enableBtn;
	  
	  $("aBondPFESlt").onchange = changeSelectObj;
	  $("bBondPFESlt").onchange = changeSelectObj;
	  $("cBondPFESlt").onchange = changeSelectObj;
	  
	  $("buNamtTxt").maxLength = 8;
	  $("buNamtTxt").style.imeMode = "disabled";
	  
	  $("buMacTxt").maxLength = 2;
	  $("buMacTxt").style.imeMode = "disabled";
	  checkMacInput($("buMacTxt"));
	  
	  $("buMacTxt").onkeyup = function()
	  {
	  	  isModify = true;
	      $("applyBtn").disabled = false;
	  }
	  
	  validateNum($("pressureTxt"), MIN_VOLTAGE, MAX_VOLTAGE, 2, DEFAULT_VOLTAGE);
	  
	  $("pressureTxt").onkeyup = function()
	  {
	  	  isModify = true;
	      $("applyBtn").disabled = false;
	  }
    
    for(var i = 0; i < 3; i++)
    {
        selectedPfeObj[i] = new NeObj();
    }
    
    buObject = topWin.buObject;
	  
	  if(null == buObject || "undefined" == buObject)
	  {
	      buObject = new BUObject();
	  }
    
    if(pageAttribute == PAGE_ATTR_CREATE && null != topWin.slmList && 0 != topWin.slmList.length)
    {
        slmList = topWin.slmList;
        pfeList = topWin.pfeList;
        initComboboxes(PFE_NETYPE);
        buObject = topWin.buObject;
        refreshPageContent();
    }
    else
    {
        queryBondNeRes();
    }
    
    if(pageAttribute == PAGE_ATTR_MODIFY)
    {
    	  var selectedRows = win.buTable.getSelectedRows();
    	  if(selectedRows && 0 != selectedRows.length)
    	  {
    	      buName = win.buTable.getCellCurrentValue(selectedRows[0], "buName", "buname");
    	      queryBU(buName, neid);
    	  }
    	  findLineResImpl(false);
    }
}

/*******************************************************************************
 *       
 ******************************************************************************/
function refreshPageContent()
{
    if(null == buObject)
    {
        return;
    }
    $("buNamtTxt").value = buObject.name;
    refreshSelect($("buTypeSlt"), buObject.type);
    $("buMacTxt").value = buObject.macAddr;
    $("pressureTxt").value = buObject.pressure;
    
    if(null != buObject.portList && 0 != buObject.portList.length)
    {
        refreshNeSelection(buObject.portList);
    }
    
    if(buObject.name != "")
    {
    	  $("findExitBUBtn").disabled = false;
        $("nextStepBtn").disabled = false;
    }
    
    enableFindLineBtn();
    
}

/***********************
 *          
 ***********************/
function refreshNeSelection(portList)
{
	  var selectPFENode;
    
    for(var buPort in portList)
    {
        selectPFENode = $(portList[buPort].portName.toLowerCase() + "BondPFESlt");
        setSLMValue(portList[buPort].portName, portList[buPort].bondSLM);
        refreshSelect(selectPFENode, portList[buPort].bondPFE, portList[buPort].bondBondPFEName);
    }
}

/********************************************************
 *        SLM             slm  
 ********************************************************/
function setSLMValue(selectSLMNode, bondSLMStr)
{
	  var slmTxt = getSlmTxtByPortName(selectSLMNode);
	  var hiddenTxt = getSlmHiddenByPortName(selectSLMNode);
    
    hiddenTxt.value = bondSLMStr;
    slmTxt.value = getBondSlmViewValue(bondSLMStr);
    slmTxt.title = slmTxt.value;
}

/********************************************************
 *   Value          
 ********************************************************/
function getBondSlmViewValue(bondSLMStr)
{
    if(0 == bondSLMStr.length || "-1" == bondSLMStr)
    {
        return INVALID_NENAME;
    }
    
    var bondSLMStrArr = bondSLMStr.split(",");
    var bondSLMNameStr = "";
    var tmpNe;
    
    for(var i = 0, arrLen = bondSLMStrArr.length; i < arrLen; i++)
    {
    	  var slmid = bondSLMStrArr[i];
        for(var j = 0, listLen = slmList.length; j < listLen; j++)
        {
            tmpNe = slmList[j];
            if(tmpNe.neid == slmid)
            {
                bondSLMNameStr += ("" == bondSLMNameStr)? tmpNe.nename : "," + tmpNe.nename;
                break;
            }
        }
    }
    
    return bondSLMNameStr;
}

/*****************
 *      
 *****************/
function refreshSelect(selectNode, value, text)
{
    for(var i = 0, optLen = selectNode.options.length; i < optLen; i++)
    {
    	/*   pfe           */
    	if (value == "-2027" && text == selectNode.options[i].text)
    	{
    		selectNode.selectedIndex = i;
    	}
    	else if(selectNode.options[i].value == value && value != "-2027")
        {
            selectNode.selectedIndex = i;
            break;
        }
    }
    
    changeSelectObj(selectNode, true);
}

/*******************************************************************************
 *         
 ******************************************************************************/
function enableBtn()
{
	  $("findExitBUBtn").disabled = false;
    $("nextStepBtn").disabled = false;
    $("applyBtn").disabled = false;
    enableFindLineBtn();
    isModify = true;
}

/*******************************************************************************
 *         
 ******************************************************************************/
function changeSelectObj(obj, flag)
{  
	  var bu_index;
	  var buSlt = (null == obj) ? $(this.id) : obj;
	  var netype;
	  
	  switch(buSlt.id)
	  {
	      case "aBondPFESlt": bu_index = 0;
	                          netype = PFE_NETYPE;
	                          break;
	      case "bBondPFESlt": bu_index = 1;
	                          netype = PFE_NETYPE;
	                          break;
	      case "cBondPFESlt": bu_index = 2;
	                          netype = PFE_NETYPE;
	                          break;
	      default:return;
	  }
	  
	  var tmpObj = new Object();            
	  tmpObj.neid = buSlt.options[buSlt.selectedIndex].value;          
	  tmpObj.nename = buSlt.options[buSlt.selectedIndex].text;
	  
	  if(netype == SLM_NETYPE)
	  {
	      selectedSlmObj[bu_index].neid = tmpObj.neid;
	      selectedSlmObj[bu_index].nename = tmpObj.nename;
	  }
	  else
	  {
	      selectedPfeObj[bu_index].neid = tmpObj.neid;
	      selectedPfeObj[bu_index].nename = tmpObj.nename;
	  }
	  
	  initComboboxes(netype);
	  isModify = true;
	  isbondPFEModified = !flag;
	  $("applyBtn").disabled = false;
}

/*******************************************************************************
 *         
 ******************************************************************************/
function enableFindLineBtn()
{   
	  if($("buNamtTxt").value == "")
	  {
	      $("findLineBtn").disabled = true;
	      return;
	  }
	  var aBondSlmId = getSlmHiddenByPortName(BU_APORT_NAME).value;
	  var bBondSlmId = getSlmHiddenByPortName(BU_BPORT_NAME).value;
	  var cBondSlmId = getSlmHiddenByPortName(BU_CPORT_NAME).value;

    if(("-1" == aBondSlmId && "-1" == bBondSlmId && "-1" == cBondSlmId) || !buExist)
    {
        $("findLineBtn").disabled = true;
    }
    else
    {
        $("findLineBtn").disabled = false;
    }

}

/*******************************************************************************
 *      BU   SLM    
 ******************************************************************************/
function queryBondNeRes()
{
     var xmldata = createQueryBondNeResXML();     
     var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUBONDNERES + "&nmUser=" + nmUser;//             Servlet   
     loadXMLdoc(url, "POST", false, handleQueryBondNeRes, null, "inputdata=" + xmldata);//       
}

/*******************************************************************************
 *        BU        xml   
 ******************************************************************************/
function createQueryBondNeResXML()
{
    var root = new inputxml("datainterface"); //     datainterface    
    var firstlevel = new tagElement("bussiness-params"); //          
    var secondlevel = new tagElement("row-params"); //          
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//         
    firstlevel.appendChild(secondlevel); //                
    root.getRoot().appendChild(firstlevel); //                
    return root.toString(); //     
}

/*******************************************************************************
 *        BU         
 ******************************************************************************/
function handleQueryBondNeRes(doc)
{
    var data = EncapsulateData(doc);//           
    var tempObj;
    var tmpNetype;
    for (var i = 0, datalen = data.getDataRowLength(); i < datalen; i++)
    {
        tempObj = new NeObj();
        tempObj.neid = data.getDataRowParam(i, "neid");
        tempObj.nename = data.getDataRowParam(i, "nename");
        tmpNetype = data.getDataRowParam(i, "netype");
        
        if(pageAttribute == PAGE_ATTR_CREATE && "" == topWin.buObject.name && tempObj.neid == neid)
        {
        	  $("aBondSlmTxt").value = tempObj.nename;
        	  $("aBondSlmHide").value = tempObj.neid;
        	  $("aBondSlmTxt").title = $("aBondSlmTxt").value;
        }

        switch(tmpNetype)
        {
            case SLM_NETYPE: slmList.push(tempObj);
                             break;
            case PFE_NETYPE: pfeList.push(tempObj);
                             break;
            case "-2027":pfeList.push(tempObj);
            				break;
            default: continue;
        }
    }
    
    initComboboxes(PFE_NETYPE);
    
    enableFindLineBtn();
}

/*******************************************************************************
 *            
 ******************************************************************************/
function initComboboxes(netype)
{
     var aSelectNode;
     var bSelectNode;
     var cSelectNode;
     
     var nelist;
     var selectedObj;
     
     aSelectNode = $("aBondPFESlt");
     bSelectNode = $("bBondPFESlt");
     cSelectNode = $("cBondPFESlt");
     
     pfeList.sort(comparison_nemame);
     nelist = pfeList;
     selectedObj = selectedPfeObj;

     aSelectNode.options.length = 0;
     bSelectNode.options.length = 0;
     cSelectNode.options.length = 0;
     var tempObj;
     
     for(var i = 0, len = nelist.length; i < len; i++)
     {
         tempObj = nelist[i];
         
         if(!containsNeObj(selectedObj, tempObj))
         {
             aSelectNode.options[aSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             bSelectNode.options[bSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             cSelectNode.options[cSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             continue;
         }
         
         if(selectedObj[0] && selectedObj[0].equals(tempObj) && selectedObj[0].neid != "-1" && selectedObj[0].neid != "0")
         {
             aSelectNode.options[aSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             aSelectNode.selectedIndex = aSelectNode.options.length - 1;
             continue;
         }
         
         if(null != selectedObj[1] && selectedObj[1].equals(tempObj) && selectedObj[1].neid != "-1" && selectedObj[1].neid != "0")
         {
             bSelectNode.options[bSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             bSelectNode.selectedIndex = bSelectNode.options.length - 1;
             continue;
         }
         
         if(null != selectedObj[2] && selectedObj[2].equals(tempObj) && selectedObj[2].neid != "-1" && selectedObj[2].neid != "0")
         {
             cSelectNode.options[cSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             cSelectNode.selectedIndex = cSelectNode.options.length - 1;
             continue;
         }
     }

     if(netype == PFE_NETYPE)
     {
         aSelectNode.options[aSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[0] && selectedObj[0].neid == "0")
         {
             aSelectNode.selectedIndex = aSelectNode.options.length - 1;
         }
         bSelectNode.options[bSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[1] && selectedObj[1].neid == "0")
         {
             bSelectNode.selectedIndex = bSelectNode.options.length - 1;
         }
         cSelectNode.options[cSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[2] && selectedObj[2].neid == "0")
         {
             cSelectNode.selectedIndex = cSelectNode.options.length - 1;
         }
     }
     
     aSelectNode.options[aSelectNode.options.length] = new Option(INVALID_NENAME, -1);
     bSelectNode.options[bSelectNode.options.length] = new Option(INVALID_NENAME, -1);
     cSelectNode.options[cSelectNode.options.length] = new Option(INVALID_NENAME, -1);
     
     if(selectedObj[0] == null || selectedObj[0].neid == -1 || (!containsNeObj(nelist, selectedObj[0]) && selectedObj[0].neid != "0"))
     {
         aSelectNode.selectedIndex = aSelectNode.options.length - 1;
     }
     
     if(selectedObj[1] == null || selectedObj[1].neid == -1 || (!containsNeObj(nelist, selectedObj[1]) && selectedObj[1].neid != "0"))
     {
         bSelectNode.selectedIndex = bSelectNode.options.length -1;
     }
     
     if(selectedObj[2] == null || selectedObj[2].neid == -1 || (!containsNeObj(nelist, selectedObj[2]) && selectedObj[2].neid != "0"))
     {
         cSelectNode.selectedIndex = cSelectNode.options.length - 1;
     }
}

/*******************************************************************************
 *     BU      
 ******************************************************************************/
function openSetStatusPage()
{
	  var canGotoNextFlg = checkInputInfo();
	  if(!canGotoNextFlg)
	  {
	      return;
	  }
	  
	  getBUObjvalue();
	  
	  topWin.slmList = slmList;
	  topWin.pfeList = pfeList;
	  
	  var pfeStrList = new Object();
	  pfeStrList[BU_APORT_NAME] = $("aBondPFESlt").options[$("aBondPFESlt").selectedIndex].innerHTML;
	  pfeStrList[BU_BPORT_NAME] = $("bBondPFESlt").options[$("bBondPFESlt").selectedIndex].innerHTML;
	  pfeStrList[BU_CPORT_NAME] = $("cBondPFESlt").options[$("cBondPFESlt").selectedIndex].innerHTML;
	  
	  topWin.switchPage("setbustatus.html?aBondPfeList=" + pfeStrList[BU_APORT_NAME] 
	  + "&bBondPfeList=" + pfeStrList[BU_BPORT_NAME] 
	  + "&cBondPfeList=" + pfeStrList[BU_CPORT_NAME]
	  + "&isbondPFEModified=" + isbondPFEModified, isModify);
	  if(isIE)
	  {
	      topWin.dialogHeight = "320px";
	  }
}

/*******************************************************************************
 *              BU  
 ******************************************************************************/
function getBUObjvalue()
{
	  buObject.name = $("buNamtTxt").value;
	  buObject.type = $("buTypeSlt").options[$("buTypeSlt").selectedIndex].value;
	  buObject.macAddr = getBuMacValue($("buMacTxt").value);
	  buObject.pressure = $("pressureTxt").value;
	  
	  var tmpPortName;
	  var tmpBondSLM, tmpBondPFE, tmpBondPFEName;
	  for(var i = 0; i < 3; i++)
	  {
	      switch(i)
	      {
	          case 0: tmpPortName = BU_APORT_NAME;
	                  tmpBondSLM = getSlmHiddenByPortName(tmpPortName).value;
	                  tmpBondPFE = $("aBondPFESlt").options[$("aBondPFESlt").selectedIndex].value;
	                  tmpBondPFEName =  $("aBondPFESlt").options[$("aBondPFESlt").selectedIndex].text;
	                  break;
	          case 1: tmpPortName = BU_BPORT_NAME;
	                  tmpBondSLM = getSlmHiddenByPortName(tmpPortName).value;
	                  tmpBondPFE = $("bBondPFESlt").options[$("bBondPFESlt").selectedIndex].value;
	                  tmpBondPFEName =  $("bBondPFESlt").options[$("bBondPFESlt").selectedIndex].text;
	                  break;
	          case 2: tmpPortName = BU_CPORT_NAME;
	                  tmpBondSLM = getSlmHiddenByPortName(tmpPortName).value;
	                  tmpBondPFE = $("cBondPFESlt").options[$("cBondPFESlt").selectedIndex].value;
	                  tmpBondPFEName =  $("cBondPFESlt").options[$("cBondPFESlt").selectedIndex].text;
	                  break;
	          default: continue;
	      }
	      
	      if((null == buObject.portList[tmpPortName]))
	      {
	          buObject.portList[tmpPortName] = new BUPortObject();
	      }
	      
	      buObject.portList[tmpPortName].portName = tmpPortName;
	      buObject.portList[tmpPortName].bondSLM = tmpBondSLM;
	      buObject.portList[tmpPortName].bondPFE = tmpBondPFE;
	      buObject.portList[tmpPortName].bondBondPFEName = tmpBondPFEName;
	  }
	  
	  var  bindLineList = new Array();
	  var rowCount = bondLineTable.getDataRowLength();//  	  
	    for (var row=0; row<rowCount; row ++)
	    {
	    	var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
	    	if (BIND_STATUS == bindStatus)
	    	{
	    		var line = new BUBindLine();
	    		
	    		line.lineID = bondLineTable.getCellStoreValue(row, "lineID", "lineID");
	    		line.srcNEID = bondLineTable.getCellStoreValue(row, "srcLmuneid", "srcLmuneid");
	    		line.srcNEID = (undefined == line.srcNEID) ? 0 : line.srcNEID;
	    		line.srcLmuSlotID = bondLineTable.getCellStoreValue(row, "srcLmuSlotId", "srcLmuSlotId");
	    		line.srcLmuSlotID = (undefined == line.srcLmuSlotID) ? 0 : line.srcLmuSlotID;
	    		line.srcLmuPortID = bondLineTable.getCellStoreValue(row, "srcLmuPortId", "srcLmuPortId");
	    		line.srcLmuPortID = (undefined == line.srcLmuPortID) ? 0 : line.srcLmuPortID;
	    		line.srcLmiSlotID = bondLineTable.getCellStoreValue(row, "srcLmiSlotId", "srcLmiSlotId");
	    		line.srcLmiSlotID = (undefined == line.srcLmiSlotID) ? 0 : line.srcLmiSlotID;
	    		line.srcLmiPortID = bondLineTable.getCellStoreValue(row, "srcLmiPortId", "srcLmiPortId");
	    		line.srcLmiPortID = (undefined == line.srcLmiPortID) ? 0 : line.srcLmiPortID;
	    		
	    		line.snkNEID = bondLineTable.getCellStoreValue(row, "sinkLmuneid", "sinkLmuneid");
	    		line.snkNEID = (undefined == line.snkNEID) ? 0 : line.snkNEID;
	    		line.snkLmuSlotID = bondLineTable.getCellStoreValue(row, "sinkLmuSlotId", "sinkLmuSlotId");
	    		line.snkLmuSlotID = (undefined == line.snkLmuSlotID) ? 0 : line.snkLmuSlotID;
	    		line.snkLmuPortID = bondLineTable.getCellStoreValue(row, "sinkLmuPortId", "sinkLmuPortId");
	    		line.snkLmuPortID = (undefined == line.snkLmuPortID) ? 0 : line.snkLmuPortID;
	    		line.snkLmiSlotID = bondLineTable.getCellStoreValue(row, "sinkLmiSlotId", "sinkLmiSlotId");
	    		line.snkLmiSlotID = (undefined == line.snkLmiSlotID) ? 0 : line.snkLmiSlotID;
	    		line.snkLmiPortID = bondLineTable.getCellStoreValue(row, "sinkLmiPortId", "sinkLmiPortId");
	    		line.snkLmiPortID = (undefined == line.snkLmiPortID) ? 0 : line.snkLmiPortID;
	    		line.bucontrolpoint = bondLineTable.getCellStoreValue(row, "bucontrolpoint", "bucontrolpoint");
	    		line.direction = bondLineTable.getCellStoreValue(row, "lineDirection", "lineDirection");
	    		
	    		bindLineList.push(line);
	    	}
	    }
	    
	    buObject.bondLineList = bindLineList;
}

/*******************************************************************************
 *           
 ******************************************************************************/
function checkInputInfo()
{
    if(!$("buNamtTxt").value || $("buNamtTxt").value == "" || !$("buMacTxt").value || $("buMacTxt").value == "")
    {
        alert(RESOURCE["infonotenough"]);
        return false;
    }
    
    if(!checkBuNameInput($("buNamtTxt")))
    {
        return false;
    }
    
    if(!onblurCheckMac($("buMacTxt")))
    {
        return false;
    }
    
    var aSelecteNe = getSlmHiddenByPortName(BU_APORT_NAME).value;
    var bSelecteNe = getSlmHiddenByPortName(BU_BPORT_NAME).value;
    var cSelecteNe = getSlmHiddenByPortName(BU_CPORT_NAME).value;
    if(aSelecteNe == "-1" && bSelecteNe == "-1" && cSelecteNe == "-1")
    {
        alert(RESOURCE["infonotenough"]);
        return false;
    }
    
    if(!getUsedSlmByPort(BU_APORT_NAME).contains(neid) && !getUsedSlmByPort(BU_BPORT_NAME).contains(neid) && !getUsedSlmByPort(BU_CPORT_NAME).contains(neid))
    {
        alert(RESOURCE["alertneetcurrentne"]);
        return false;
    }
    
    var rowCount = bondLineTable.getDataRowLength();//  
    var totalLineCount = 0;
    var neLineCount = {};
    var ONENEMAXLINE = 2;
    var TOTALMAXLINE = 6;
    var buPortACount = 0;
    var buPortBCount = 0;
    var buPortCCount = 0;
    
    for (var row=0; row<rowCount; row ++)
    {
    	  var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
    	  if (BIND_STATUS == bindStatus)
    	  {
    	  	  var srcLMUNEID = bondLineTable.getCellStoreValue(row, "srcLmuneid", "srcLmuneid");
    	  	  if(null == srcLMUNEID || 0 == srcLMUNEID)
    	  	  {
    	  	      continue;
    	  	  }
    	  	  var c = neLineCount[srcLMUNEID];
    	  	  if (c == null || c == "undefined")
    	  	  {
    	  	  	  c = 0;
    	  	  }
    	  	  c ++;
    	  	  neLineCount[srcLMUNEID] = c;
    	  	  
		    		var buporta = aSelecteNe;
		    		var buportb = bSelecteNe;
		    		var buportc = cSelecteNe;
		    		if (buporta.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortACount++;
		    		}
		    		else if (buportb.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortBCount++;
		    		}
		    		else if (buportc.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortCCount++;
		    		}
		    		
		    		if ((buPortACount > ONENEMAXLINE) || (buPortBCount > ONENEMAXLINE) || (buPortCCount > ONENEMAXLINE))
		    		{
		    			alert(RESOURCE["overonenemaxlinecount"]);
		    		  return false;
		    		}
		    		
    	  	  if (c > ONENEMAXLINE)
    	  	  {
    	  	      alert(RESOURCE["overonenemaxlinecount"]);
    	  	      return false;
    	  	  }
    	  	  totalLineCount ++;
    	  	  if (totalLineCount > TOTALMAXLINE)
    	  	  {
   		  	     alert(RESOURCE["overonenemaxlinecount"]);
		           return false;
    	  	  }
    	  	  
    	  }
    }
    
    aSelecteNe = $("aBondPFESlt").options[$("aBondPFESlt").selectedIndex].value;
    bSelecteNe = $("bBondPFESlt").options[$("bBondPFESlt").selectedIndex].value;
    cSelecteNe = $("cBondPFESlt").options[$("cBondPFESlt").selectedIndex].value;
    
    if(PAGE_ATTR_CREATE == pageAttribute && (aSelecteNe == "0" && bSelecteNe == "0" || aSelecteNe == "0" && cSelecteNe == "0" || bSelecteNe == "0" && cSelecteNe == "0"))
    {
        return alert(RESOURCE["createbuwrongse"]);
    }
    
    if(PAGE_ATTR_MODIFY == pageAttribute && aSelecteNe == "0" && bSelecteNe == "0" && cSelecteNe == "0")
    {
        return alert(RESOURCE["modifybuwrongse"]);
    }
    
    if(aSelecteNe == "-1" && bSelecteNe == "-1" && cSelecteNe == "-1")
    {
        return confirm(RESOURCE["notenoughpfe"]);
    }
    
    return true;
}

/*******************************************************************************
 *           
 ******************************************************************************/
function comparison_nemame(neObj1, neObj2)
{
    var value1 = neObj1.nename;
    var value2 = neObj2.nename;
    if(value1 < value2)
    {
        return -1;
    }
    else if(value1 > value2)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/*******************************************************************************
 *       
 ******************************************************************************/
function containsNeObj(selectedObj, tempObj)
{
    if(!tempObj || !tempObj.neid || tempObj.neid == "-1")
    {
        return false;
    }
    
    for(var i = 0; i < selectedObj.length; i++)
    {
        if(selectedObj[i].neid == tempObj.neid && selectedObj[i].nename == tempObj.nename)
        {
            return true;
        }
    }
    
    return false;
}

/*******************************************************************************
 *         BU
 ******************************************************************************/
function findExitBU()
{
	  disabledAllBtn(true);
    queryBU($("buNamtTxt").value, neid);
}

/*******************************************************************************
 *         BU
 ******************************************************************************/
function handleQueryBU(doc)
{
    var data = EncapsulateData(doc); //           

    if (0 == data.getSErrorCode() && data.getDataRowLength() > 0) //                   0 1
    {   
    	  buObject.name = data.getDataRowParam(0, "buname");
    	  buObject.type = data.getDataRowParam(0, "type");
    	  buObject.macAddr = data.getDataRowParam(0, "macaddr");
    	  buObject.pressure = data.getDataRowParam(0, "pressure");
    	  buObject.primaryLine = data.getDataRowParam(0, "mainbridge");
    	  buObject.curPrimaryLine = data.getDataRowParam(0, "curmainbridge");
    	  buObject.posX = data.getDataRowParam(0, "posx");
    	  buObject.posY = data.getDataRowParam(0, "posy");
    	  
        for(var i = 0; i < 3; i++)
        {
            selectedPfeObj[i] = new NeObj();
        }
    	  
    	  setBuPortInfo(BU_APORT_NAME, data);
        selectedPfeObj[0].neid = buObject.portList[BU_APORT_NAME].bondPFE;
        selectedPfeObj[0].nename = data.getDataRowParam(0, "abondpfename"); 

    	  setBuPortInfo(BU_BPORT_NAME, data);
        selectedPfeObj[1].neid = buObject.portList[BU_BPORT_NAME].bondPFE;
        selectedPfeObj[1].nename = data.getDataRowParam(0, "bbondpfename"); 

    	  setBuPortInfo(BU_CPORT_NAME, data);
        selectedPfeObj[2].neid = buObject.portList[BU_CPORT_NAME].bondPFE;
        selectedPfeObj[2].nename = data.getDataRowParam(0, "cbondpfename"); 
        
        refreshSelect($("buTypeSlt"), buObject.type);
        
        $("buMacTxt").value = buObject.macAddr.substring(2);
        $("pressureTxt").value = buObject.pressure;

        if(pageAttribute == PAGE_ATTR_MODIFY)
        {
            $("buNamtTxt").value = buObject.name;
        }
        
        refreshNeSelection(buObject.portList); 
        initComboboxes(PFE_NETYPE);
        
        if(pageAttribute == PAGE_ATTR_MODIFY)
        {
            buOldType = buObject.type;
        }
        buExist = true;
    }
    else
    {
        $("buMacTxt").value = "";
        $("bBondSlmTxt").value = "--";
        $("bBondSlmHide").value = "-1";
        $("bBondSlmTxt").title = $("bBondSlmTxt").value;
        $("cBondSlmTxt").value = "--";
        $("cBondSlmHide").value = "-1"
        $("cBondSlmTxt").title = $("cBondSlmTxt").value;
        $("buTypeSlt").selectedIndex = 0;
        $("pressureTxt").value = DEFAULT_VOLTAGE;
        
	      bondLineTable.clearTableData();
	      
	      $("aBondSlmTxt").value = getCurNeName();
	      $("aBondSlmHide").value = neid;
	      $("aBondSlmTxt").title = $("aBondSlmTxt").value;
	      
	      selectedPfeObj = [];
	      initComboboxes(PFE_NETYPE);
	      
	      buExist = false;
    }
    
    var errArr = [];//               
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//          

    disabledAllBtn(false);//      (        )         
}

/************************
 *         
 ************************/
function getCurNeName()
{
    if(null == slmList)
    {
        return "--";
    }
    
    for(var i = 0, len = slmList.length; i < len; i++)
    {
        var tmpNe = slmList[i];
        if(tmpNe.neid == neid)
        {
            return tmpNe.nename;
        }
    }
    
    return "--";
}

/*******************************************************************************
 *         BU    
 ******************************************************************************/
function setBuPortInfo(buName, data)
{
    buObject.portList[buName] = new BUPortObject();
    buObject.portList[buName].portName = buName;
    buObject.portList[buName].bondSLM = data.getDataRowParam(0, buName.toLowerCase() + "bondslm");
    buObject.portList[buName].bondPFE = data.getDataRowParam(0, buName.toLowerCase() + "bondpfe");
    buObject.portList[buName].isEarth = data.getDataRowParam(0, buName.toLowerCase() + "isearth");
    buObject.portList[buName].elecDirection = data.getDataRowParam(0, buName.toLowerCase() + "elecdir");
    buObject.portList[buName].bondBondPFEName = data.getDataRowParam(0, buName.toLowerCase() + "bondpfename");
}   
    
/*******************************************************************************
 *       
 ******************************************************************************/
function disabledAllBtn(flg)
{   
    $("findExitBUBtn").diabled = flg
    $("nextStepBtn").diabled = flg
    $("confirmBtn").diabled = flg
    $("cancelBtn").diabled = flg
    $("applyBtn").diabled = flg

    $("aBondPFESlt").diabled = flg
    $("bBondPFESlt").diabled = flg
    $("cBondPFESlt").diabled = flg
    
    if(flg)
    {
    	  $("findLineBtn").diabled = flg;
    }
    else
    {
        enableFindLineBtn();
    }
}

/*******************************************************************************
 *   BU MAC       3    3     
 ******************************************************************************/
function getBuMacValue(valueStr)
{
    if(valueStr.length == BU_MAC_MAXLENGTH)
    {
        return valueStr;
    }
    
    var num0 = BU_MAC_MAXLENGTH - valueStr.length;
    for(var i = 0; i < num0; i++)
    {
        valueStr = "0" + valueStr;
    }
    
    return valueStr;
}

/*******************************************************************************
 *       
 ******************************************************************************/
function confirmModifyInfo(applyFlg)
{
	  if(!isModify)
	  {
	  	  closePage();
	      
	      return;
	  }
	  
	  if((pageAttribute == PAGE_ATTR_MODIFY || buExist) && !canModifyBUType())
	  {
	  	  return;
	  }
	  
	  if(checkInputInfo())
	  {
	  	  getBUObjvalue();
        setBUInfo(applyFlg, true, TECMDCODE_SET_BUINFO);
    }
}

/****************************************
 *    BU           
 *                  
 *******************************************/
function canModifyBUType()
{
	  var buNewType = $("buTypeSlt").options[$("buTypeSlt").selectedIndex].value;
    var buTypeChange = (buOldType != buNewType);
    var canModify = true;
    
    if(buTypeChange)
    {
        canModify = confirm(RESOURCE["butypechangealert"]);
    }
    
    return canModify;
    
}

/*******************************************************************************
 *         
 ******************************************************************************/
function setPageStatus()
{
    $("applyBtn").disabled = true;    
    isModify = false;
}

/*******************************************************************************
 *            
 ******************************************************************************/
window.onunload = function()
{  
	  if (typeof (bondLineTable) != 'undefined' && bondLineTable instanceof SortTable)
	  {
		    clearSortTable(bondLineTable);
	  }
}

/**
 *         
 * @param needNEID          
 */
function findLineResImpl(needNEID)
{
	  var neids = [];
	  if (needNEID)
	  {	
	      var aSelecteNe = getSlmHiddenByPortName(BU_APORT_NAME).value;
	      var bSelecteNe = getSlmHiddenByPortName(BU_BPORT_NAME).value;
	      var cSelecteNe = getSlmHiddenByPortName(BU_CPORT_NAME).value;
	      if(aSelecteNe == INVALID_NEID && bSelecteNe == INVALID_NEID && cSelecteNe == INVALID_NEID)
	      {
	          alert(RESOURCE["infonotenough"]);
	          return false;
	      }
	      
	      if(!getUsedSlmByPort(BU_APORT_NAME).contains(neid) && !getUsedSlmByPort(BU_BPORT_NAME).contains(neid) && !getUsedSlmByPort(BU_CPORT_NAME).contains(neid))
        {
            alert(RESOURCE["alertneetcurrentne"]);
            return false;
        }
	      
	      neids = [aSelecteNe, bSelecteNe, cSelecteNe];
	  }
    var input = createQueryLineInfoXML(neids);
    if (null == input)
    {
    	alert("inner error");
    }    

    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUBONDLINES_RES + "&nmUser=" + nmUser;//             Servlet   
    loadXMLdoc(url, "POST", false, handleQueryBondLineRes, null, "inputdata=" + input);//       
}

/**
 *            
 */
function findLineRes()
{			
	  findLineResImpl(true);
}

/**
 *          
 */
function refreshTableEditStatus()
{	
	  var rowCount = bondLineTable.getDataRowLength();//  
	  if (0 >= rowCount)
	  {
	  	 return;
	  }
	  
	  for (var row=0; row<rowCount; row ++)
	  {
	    	var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
	  	  var buccell = bondLineTable.getCell(row, "bucontrolpoint");					
	  	  var isBinded = BIND_STATUS == bindStatus;
	  	  bondLineTable.setCellIsEdit(buccell, isBinded);		
	  	  if (!isBinded)
	  	  {
	  	  	buccell.element.showElement.setValue("");			
	  	  }	   	
	  }
}

/**
 *              
 * @param doc     
 */
function handleQueryBondLineRes(doc)
{
	  var data = EncapsulateData(doc);
	  bondLineTable.clearTableData();
	  
	  var errorCode = data.getSErrorCode();
	  var ndata = new DataInterface();
	  ndata.errObj = data.errObj;	
	  	
	  if (1 == errorCode)
    {
	  	  var rowlen = data.getDataRowLength();
	  	  for (var rl=rowlen-1; rl>=0; rl--)
	  	  {
	  	  	var dr = data.getDataRow(rl);
	  	  	var ep = data.getDataRowParam(rl, "iserror");
	  	  	if (null != ep)
	  	  	{
	  	  		data.removeDataRowAt(rl);
	  	  	}
	  	  }
    }
	  
	  if (0 == errorCode || 1 == errorCode)
	  {		
	  	  convertLineData(data);
	  	  if (data.rows.length != 0)
	  	  {
	  	  	createTableBody(bondLineTable, window.tableconf[0], data, RESOURCE);
	  	  	serControlEndCellStatus();
	  	  }		
	  	  if (1 == errorCode)
	  	  {			
	  	      var errArr = [];//              
	  	      errArr.push("buname");
	  	      openErrPage("../../../../page/", ndata.getError(), errArr);//         
	  	  }
	  	  
	  	  enableFindLineBtn();
	  }
	  else
	  {
	  	  var errArr = [];//              
	      errArr.push("buname");
	      openErrPage("../../../../page/", data.getError(), errArr);//         
	  }	
}

/**
 *       
 * @param neids   id  
 */
function createQueryLineInfoXML(neids)
{
	  if (null == neids || neids == "undefined")
	  {
	  	neids = [];
	  }
	  var root = new inputxml("datainterface");
	  var bussiness = new tagElement("bussiness-params");
	  var row = new tagElement("row-params");
	  var param = null;
	  
	  param = new tagElement("param");
	  param.setAttribute("name", "neid");
	  param.setAttribute("value", neid);
	  row.appendChild(param);	
	  	
	  param = new tagElement("param");
	  param.setAttribute("name", "neids");
	  var ids = "";
	  for (var index=0; index<neids.length; index++)
	  {
	  	  var id = neids[index]; 
	  	  if (INVALID_NEID != id)
	  	  {
	  	  	ids += id; 
	  	  	if (index != neids.length -1)
	  	  	{
	  	  		ids += ",";
	  	  	}
	  	  }		
	  }
	  param.setAttribute("value", ids); //    
	  row.appendChild(param);	
	
	  if (PAGE_ATTR_MODIFY == pageAttribute)
	  {
	  	  param = new tagElement("param");
	      param.setAttribute("name", "buname");
	      param.setAttribute("value", buName); //    
	      row.appendChild(param);
	  
	  	  param = new tagElement("param");
	  	  param.setAttribute("name", "queryaction");	
	  	  param.setAttribute("value", "2"); //           
	  	  row.appendChild(param);
	  }
	  else
	  {
	  	  param = new tagElement("param");
	      param.setAttribute("name", "buname");
	      param.setAttribute("value", $("buNamtTxt").value); //    
	      row.appendChild(param);
	  
	      if (buExist)
	      {
	      	param = new tagElement("param");
		  	  param.setAttribute("name", "queryaction");	
		  	  param.setAttribute("value", "2"); //           
		  	  row.appendChild(param);
	      }
	      else
	      {
		      param = new tagElement("param");
		  	  param.setAttribute("name", "queryaction");	
		  	  param.setAttribute("value", "0"); //    
		  	  row.appendChild(param);
	      }
	  }
	
	  bussiness.appendChild(row);
	  root.getRoot().appendChild(bussiness);
	  
	  return root.toString();
}

/**
 * @param data  Datainterface
 */
function refreshBindLineTableStatus(data)
{	
	  refreshTableState(bondLineTable, window.tableconf[0], data);
}

/********************************
 *              
 ********************************/
function chooseSlmNe(portName)
{  
	  xshowModalDialog('chooseslmnepage.html?buPortName=' + portName, RESOURCE["chooseslmnepage"], "300", "300", '../../../../images/');

}

/********************************
 *     slm      
 ********************************/
function getAvailSlmList(portName)
{
	  var availNeList = new Array();
    if(null != slmList && 0 != slmList.length)
    {
        for(var i = 0; i < slmList.length; i++)
        {
            if(!isUsedSlm(slmList[i], portName))
            {
                availNeList[availNeList.length] = slmList[i];
            }
            
        }
    }
    
    return availNeList;
        
}

/***********************************
 *   slm            
 ***********************************/
function isUsedSlm(slmObj, portName)
{
    if(null == slmObj)
    {
        return false;
    }

    var tmpUsedSlmNeids = new Array(); 
    switch(portName)
    {
        case BU_APORT_NAME:
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_BPORT_NAME));
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_CPORT_NAME));
            break;
        case BU_BPORT_NAME:
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_APORT_NAME));
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_CPORT_NAME));
            break;
        case BU_CPORT_NAME:
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_APORT_NAME));
            tmpUsedSlmNeids = tmpUsedSlmNeids.concat(getUsedSlmByPort(BU_BPORT_NAME));
            break;
        default: break;
    }
    
    return tmpUsedSlmNeids.contains(slmObj.neid);
   
}

/***********************************
 *              
 ***********************************/
function getUsedSlmByPort(portName)
{
    var usedSlmNeids = new Array();
    
    var hiderValue = getSlmHiddenByPortName(portName).value;
    
    if(null != hiderValue && "" != hiderValue)
    {
    	  if(-1 == hiderValue.indexOf(","))
    	  {
    	      usedSlmNeids.push(hiderValue);
    	  }
    	  else
    	  {
    	  	  usedSlmNeids.push(hiderValue.split(",")[0]);
    	  	  usedSlmNeids.push(hiderValue.split(",")[1]);
    	  }
        
    }
    
    return usedSlmNeids;
}

/***********************************
 *       slm    
 ***********************************/
function refreshBondNe(portName, selectedNes)
{
    var bondSlmTxt = getSlmTxtByPortName(portName); 
    var bondSlmHidden = getSlmHiddenByPortName(portName);
    
    if(null == selectedNes || 0 == selectedNes.length)
    {
        bondSlmTxt.value = INVALID_NENAME;
        bondSlmHidden.value = INVALID_NEID;
    }
    else
    {
        var viewStr = "";
        var hideStr = "";
        var tmpObj;
        for(var i = 0, len = selectedNes.length; i < len; i++)
        {
        	  tmpObj = selectedNes[i];
        	  if(0 != viewStr.length)
        	  {
        	      viewStr += LIST_SEPARATER;
        	      hideStr += LIST_SEPARATER;
        	  }
            viewStr += tmpObj.nename;
            hideStr += tmpObj.neid;
        }
        
        bondSlmTxt.value = viewStr;
        bondSlmHidden.value = hideStr;
    }
    
    bondSlmTxt.title = bondSlmTxt.value;
    
}

/***********************************
 *   bu      slm   
 ***********************************/
function getSlmTxtByPortName(portName)
{
	  return $(portName.toLowerCase() + "BondSlmTxt");
}

/***********************************
 *   bu      slm    
 ***********************************/
function getSlmHiddenByPortName(portName)
{
	  return $(portName.toLowerCase() + "BondSlmHide");
}

/*******************************************************************
 *                                
 *******************************************************************/
function serControlEndCellStatus()
{
    for(var i = 0, rowLen = bondLineTable.getDataRowLength(); i < rowLen; i++)
    {
        var bindstatus = bondLineTable.getCellCurrentValue(i, "bindstatus", "bindstatus");
        var buccell = bondLineTable.getCell(i, "bucontrolpoint");		
	  	  var isBinded = BIND_STATUS == bindstatus;
	  	  bondLineTable.setCellIsEdit(buccell, isBinded);	
        
    }
}
function closePage()
{
	  if(isIE || (pageAttribute != PAGE_ATTR_CREATE))
	  {
	      xcloseDialog();
	  }
	  else
	  {
	      win.xcloseDialog();
	  }
}

function closeWin()
{
    closePage();
}
