 /*************
 *       
**************/
var win = getParentWindow();
var topWin = isIE ? top : win;
var buObj;//BU    
var neid = win.neid;
var nmUser = win.nmUser;
var mainPageUrl = getNeProperty(self);//            
var buName = (mainPageUrl && mainPageUrl["buName"]) ? mainPageUrl["buName"] : "";
var isModifyPageFlag = false;

window.onload = initPage;

document.title = RESOURCE["querybustatus"] + "--" + buName;


/*******************
 *        
********************/
function initPage()
{
    initPageStringRes();

    initPageElement();
}

/**********************
 *          
***********************/
function initPageStringRes()
{
    $("buStatusLbl").innerHTML = RESOURCE["bustatuspicture"];
    $("closeBtn").value = RESOURCE["close"];
}

/***************************
 *    BU        
****************************/
function initPageElement()
{
	  $("buStatusDiv").innerHTML = drawBuStatusView(0,0);
    
    queryBUStatus();
}

/**********************
 *     BU    
************************/
function handleQueryBUStatus(doc)
{
    var data = EncapsulateData(doc); //          

    if (0 == data.getSErrorCode() && data.getDataRowLength() > 0)
    {
    	  setBUObj(data);

    	  drawMainBridge(data.getDataRowParam(0, "mainbridge"));

    	  drawCurDirection(data);
    	  
    	  drawPFEStr(data);
    	  
    	  isModifyPageFlag = false;
    	  $("resetBtn").disabled = true;
    	  $("applyBtn").disabled = true;
    }
    
    var errArr = [];//              
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//         
}

/****************
 *       
******************/
function setBUObj(data)
{   
    buObj = new BUObject();
    buObj.name = buName;
    buObj.primaryLine = data.getDataRowParam(0, "mainbridge");

    buObj.portList[BU_APORT_NAME] = newBUPortObj(BU_APORT_NAME, data);
    buObj.portList[BU_BPORT_NAME] = newBUPortObj(BU_BPORT_NAME, data);
    buObj.portList[BU_CPORT_NAME] = newBUPortObj(BU_CPORT_NAME, data);
}

/******************************
 *        BU    
*******************************/
function newBUPortObj(buPortName, data)
{
    var portObj = new BUPortObject();
    portObj.portName = buPortName;
    portObj.bondPFE = data.getDataRowParam(0, buPortName.toLowerCase() + "bondpfe");
    portObj.isEarth = data.getDataRowParam(0, buPortName.toLowerCase() + "isearth");
    portObj.elecDirection = data.getDataRowParam(0, buPortName.toLowerCase() + "elecdir");
    
    return portObj;
}

/**********************
 *         
************************/
function drawCurDirection(data)
{
	  drawPortCurDir(BU_APORT_NAME, data.getDataRowParam(0, "aelecdir"));
	  drawPortCurDir(BU_BPORT_NAME, data.getDataRowParam(0, "belecdir"));
	  drawPortCurDir(BU_CPORT_NAME, data.getDataRowParam(0, "celecdir"));
}

/**********************
 *        
************************/
function drawPortCurDir(portName, direction)
{
	  var realDir = convertPortCurDir(portName, direction);
    chooseElecDir(portName, realDir);
}

/******************************************
 *                    
*******************************************/
function convertPortCurDir(portName, direction)
{
    if(portName == BU_APORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_RIGHT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_LEFT;//     
        }
    }
    
    if(portName == BU_BPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_LEFT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_RIGHT;//     
        }
    }
    
    if(portName == BU_CPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_UP;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_DOWN;//     
        }
    }
    
    return ELECDIRECTION_NONE;
}

/*************************
 *            
***************************/
function drawPFEStr(data)
{
    var pfeList = new Object();
    pfeList[BU_APORT_NAME] = data.getDataRowParam(0, "abondpfe");
    pfeList[BU_BPORT_NAME] = data.getDataRowParam(0, "bbondpfe");
    pfeList[BU_CPORT_NAME] = data.getDataRowParam(0, "cbondpfe");
    
    drawBondPFEStr(pfeList);
    
    var polarytyObj = new Object();
    polarytyObj[BU_APORT_NAME] = data.getDataRowParam(0, "apfevoltage");
    polarytyObj[BU_BPORT_NAME] = data.getDataRowParam(0, "bpfevoltage");
    polarytyObj[BU_CPORT_NAME] = data.getDataRowParam(0, "cpfevoltage");
    
    drawPFEPolarityStr(polarytyObj);
}

/*************************
 *           
***************************/
function handleRedioPanel()
{
	  if(null == buObj)
	  {
	      return;
	  }
	  
	  var dirObj = new Object();
	  var earthObj = new Object();
	  var mainBridge;
	  if(statusFlg == BU_CURRENT_STATUS)
	  {
	      dirObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].curElecDirection;
	      dirObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].curElecDirection;
	      dirObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].curElecDirection;
	      
	      earthObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].curIsEarth;
	      earthObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].curIsEarth;
	      earthObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].curIsEarth;
	      
	      mainBridge = buObj.curPrimaryLine;
	  }
	  else
	  {
	      dirObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].elecDirection;
	      dirObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].elecDirection;
	      dirObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].elecDirection;
	      
	      earthObj[BU_APORT_NAME] = buObj.portList[BU_APORT_NAME].isEarth;
	      earthObj[BU_BPORT_NAME] = buObj.portList[BU_BPORT_NAME].isEarth;
	      earthObj[BU_CPORT_NAME] = buObj.portList[BU_CPORT_NAME].isEarth;
	      
	      mainBridge = buObj.primaryLine;
	  }
	  
	  setRedioCheckStatus(dirObj, earthObj, mainBridge);
}

/*************************
 *     BU    
***************************/
function applySetBUStatus(closeFlg)
{
	  if(statusFlg == BU_CURRENT_STATUS)
	  {
	  	  if(!confirm(RESOURCE["setstatusalert"]))
	  	  {
	          return;
	      }
	  }
	  else if(!confirm(RESOURCE["setinitstatusalert"]))
	  {
	      return;
	  }
	  	
    var xmldata = createSetBUStatusXML();
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_BUSTATUS + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleSetBUStatus, closeFlg, "inputdata=" + xmldata);//      
}

/*****************************
 *     BU   xml   
******************************/
function createSetBUStatusXML()
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buName);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "statusFlg");
    thirdlevel.setAttribute("value", statusFlg);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aelecdir");
    thirdlevel.setAttribute("value", getDirection(BU_APORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "belecdir");
    thirdlevel.setAttribute("value", getDirection(BU_BPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "celecdir");
    thirdlevel.setAttribute("value", getDirection(BU_CPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "mainbridge");
    thirdlevel.setAttribute("value", getPrimaryLine());
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aisearth");
    thirdlevel.setAttribute("value", getEarth(BU_APORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "bisearth");
    thirdlevel.setAttribute("value", getEarth(BU_BPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "cisearth");
    thirdlevel.setAttribute("value", getEarth(BU_CPORT_NAME));
    secondlevel.appendChild(thirdlevel);//        

    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/*************************
 *     BU      
***************************/
function handleSetBUStatus(doc, closeFlg)
{
	  var data = EncapsulateData(doc);
	  
	  if (0 == data.getSErrorCode())
	  {
	      getBuStatus(buObj);
	      $("resetBtn").disabled = true;
        $("applyBtn").disabled = true;
        isModifyPageFlag = false;
	  }
	  
	  var errArr = [];//              
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//         
    
    if(closeFlg)
    {
        xcloseDialog();
    }

}

/*************************************
 *                  
**************************************/
function enableAllElement()
{

}
