 /*******************************************************************************
 *       
 ******************************************************************************/
var MIN_VOLTAGE = 25;
var MAX_VOLTAGE = 30;
var DEFAULT_VOLTAGE = 28;
var INVALID_NEID = "-1";
var BIND_STATUS = "1";
var UNBIND_STATUS = "0";

/*******************************************************************************
 *       
 ******************************************************************************/
var win = getParentWindow();
var topWin = isIE ? top : win;
var neid = win.neid;//   ID
var nmUser = win.nmUser;//     
var mainPageUrl = getNeProperty(self);//             
if(null == mainPageUrl || null == mainPageUrl["pageAttr"])
{
    if(isIE)
    {
        mainPageUrl = getNeProperty(top);
    }
    else
    {
        mainPageUrl = getNeProperty(win);
    }
}
var pageAttribute = mainPageUrl["pageAttr"];
var buName = mainPageUrl["buName"];
var isE2EFunction = mainPageUrl["isE2EFunction"];
var isFromMainTOPO = mainPageUrl["isFromMainTOPO"];
var bondLineTable;//       
var bondLineTblConf;//           
var slmList = new Array();
var pfeList = new Array();
var selectedSlmObj = new Array();
var selectedPfeObj = new Array();
var buObject = new BUObject();
var neids = new Array();

var isModify = false;

if(pageAttribute == PAGE_ATTR_CREATE)
{
    top.document.title = RESOURCE["createbu"];
}
else
{
    document.title = RESOURCE["bondLine"];
}

document.oncontextmenu = returnFalse;
window.onload = initPage;

/*******************************************************************************
 *        
 ******************************************************************************/
function initPage()
{
    initButton();
    
    initBondLineTable();
    
    initPageContent();
    
    initPageStringRes();
    
    topWin.sunWin = this;
}

/*******************************************************************************
 *          
 ******************************************************************************/
function initPageStringRes()
{   
    $("confirmBtn").value = RESOURCE["okbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    $("cancelBtn").value = RESOURCE["cancelbutton"]; 
}


/*******************************************************************************
 *          
 ******************************************************************************/
function initBondLineTable()
{
    bondLineTable = new SortTable();
    bondLineTable.setImage("../../../../images/");
    bondLineTblConf = window.tableconf[0];    
    createTableHead(bondLineTable, bondLineTblConf);
    
    $("bondLineTblDiv").appendChild(bondLineTable.getTable());
    
    bondLineTable.setBodyHeight(getComponetHeight($("bondLineTblDiv"), 60)+"px");
    
    $("bondLineTblDiv").oncontextmenu = popupMenuHandler;      
    bondLineTable.setOnCellEditHandler(cellEditHandler);
}

/**
 *       
 * @param param    
 * param 
 * 	param.stage = stage;
	param.rowindex = obj.parentNode.rowIndex;
	param.cellindex = obj.cellIndex;
	param.colid = obj.colid;
	param.value = obj.showElement.getValue();
	param.st = obj.parent;
 * 
 * @returns
 */
function cellEditHandler(param)
{		
	var row = param.rowindex;
	var colid = param.colid;	
	var st = param.st;	
	if ("bindstatus" == colid)
	{
		var buccell = st.getCell(row, "bucontrolpoint");		
		var value = st.getCellCurrentValue(row, colid, "bindstatus");	
		var isBinded = BIND_STATUS == value;
		st.setCellIsEdit(buccell, isBinded);		
		if (!isBinded)
		{
			buccell.element.showElement.setValue("");			
		}
		else
		{	
			buccell.element.showElement.setValue(RESOURCE[refreshbucontrolpointType["0"]]);
			st.setCellValue(buccell, "bucontrolpoint", "0");
		}
	}			
	$("applyBtn").disabled = false;
	isModify = true;
}

/*******************************************************************************
 *              
 ******************************************************************************/
function initButton()
{
}

/*******************************************************************************
 *        
 ******************************************************************************/
function initPageContent()
{	    
	var selectedRows = win.buTable.getSelectedRows();
    if(selectedRows && 0 != selectedRows.length)
    {
        buName = win.buTable.getCellCurrentValue(selectedRows[0], "buName", "buname");
        neids.push(win.buTable.getCellCurrentValue(selectedRows[0], "abondslm", "abondslm"));
        neids.push(win.buTable.getCellCurrentValue(selectedRows[0], "bbondslm", "bbondslm"));
        neids.push(win.buTable.getCellCurrentValue(selectedRows[0], "cbondslm", "cbondslm"));
    }
    findLineResImpl(true);    
}

/*******************************************************************************
 *       
 ******************************************************************************/
function refreshPageContent()
{
    if(null == buObject)
    {
        return;
    }
    $("buNamtTxt").value = buObject.name;
    $("buMacTxt").value = buObject.macAddr;
    $("pressureTxt").value = buObject.pressure;
    
    if(null != buObject.portList && 0 != buObject.portList.length)
    {
        refreshNeSelection(buObject.portList);
    }
    
    if(null != buObject.bondLineList && 0 != buObject.bondLineList.length)
    {
    }
    
    if(buObject.name != "")
    {
    	  $("findExitBUBtn").disabled = false;
        $("nextStepBtn").disabled = false;
    }
    
    enableFindLineBtn();
    
}

/*******************************************************************************
 *          
 ******************************************************************************/
function refreshNeSelection(portList)
{
	  var selectSLMNode, selectPFENode;

    for(buPort in portList)
    {
    	  selectSLMNode = $(portList[buPort].portName.toLowerCase() + "BondSlmSlt");
        selectPFENode = $(portList[buPort].portName.toLowerCase() + "BondPFESlt");
        refreshSelect(selectSLMNode, portList[buPort].bondSLM);
        refreshSelect(selectPFENode, portList[buPort].bondPFE);
    }
}

/*******************************************************************************
 *      
 ******************************************************************************/
function refreshSelect(selectNode, value)
{
    for(var i = 0, optLen = selectNode.options.length; i < optLen; i++)
    {
        if(selectNode.options[i].value == value)
        {
            selectNode.selectedIndex = i;
            break;
        }
    }
    
    changeSelectObj(selectNode);
}

/*******************************************************************************
 *         
 ******************************************************************************/
function enableBtn()
{
	  $("findExitBUBtn").disabled = false;
    $("nextStepBtn").disabled = false;
    $("applyBtn").disabled = false;
    isModify = true;
}

/*******************************************************************************
 *         
 ******************************************************************************/
function changeSelectObj(obj)
{  
	  var bu_index;
	  var buSlt = (null == obj) ? $(this.id) : obj;
	  var netype;
	  
	  switch(buSlt.id)
	  {
	      case "aBondSlmSlt": bu_index = 0;
	                          netype = SLM_NETYPE;
	                          break;
	      case "aBondPFESlt": bu_index = 0;
	                          netype = PFE_NETYPE;
	                          break;
	      case "bBondSlmSlt": bu_index = 1;
	                          netype = SLM_NETYPE;
	                          break;
	      case "bBondPFESlt": bu_index = 1;
	                          netype = PFE_NETYPE;
	                          break;
	      case "cBondSlmSlt": bu_index = 2;
	                          netype = SLM_NETYPE;
	                          break;
	      case "cBondPFESlt": bu_index = 2;
	                          netype = PFE_NETYPE;
	                          break;
	      default:return;
	  }
	  
	  var tmpObj = new Object();            
	  tmpObj.neid = buSlt.options[buSlt.selectedIndex].value;          
	  tmpObj.nename = buSlt.options[buSlt.selectedIndex].text;
	  
	  if(netype == SLM_NETYPE)
	  {
	      selectedSlmObj[bu_index].neid = tmpObj.neid;
	      selectedSlmObj[bu_index].nename = tmpObj.nename;
	  }
	  else
	  {
	      selectedPfeObj[bu_index].neid = tmpObj.neid;
	      selectedPfeObj[bu_index].nename = tmpObj.nename;
	  }
	  
	  initComboboxes(netype);
	  isModify = true;
	  $("applyBtn").disabled = false;
}

/*******************************************************************************
 *         
 ******************************************************************************/
function enableFindLineBtn()
{
	  var aBondSelectedIndex = $("aBondSlmSlt").selectedIndex;
	  var bBondSelectedIndex = $("bBondSlmSlt").selectedIndex;
	  var cBondSelectedIndex = $("cBondSlmSlt").selectedIndex;
    if(-1 == aBondSelectedIndex && -1 == bBondSelectedIndex && -1 == cBondSelectedIndex)
    {
        return;
    }
    
    $("findLineBtn").disabled = false;
}

/*******************************************************************************
 *      BU   SLM    
 ******************************************************************************/
function queryBondNeRes()
{
     var xmldata = createQueryBondNeResXML();     
     var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUBONDNERES + "&nmUser=" + nmUser;//             Servlet   
     loadXMLdoc(url, "POST", false, handleQueryBondNeRes, null, "inputdata=" + xmldata);//       
}

/*******************************************************************************
 *        BU        xml   
 ******************************************************************************/
function createQueryBondNeResXML()
{
    var root = new inputxml("datainterface"); //     datainterface    
    var firstlevel = new tagElement("bussiness-params"); //          
    var secondlevel = new tagElement("row-params"); //          
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//         
    firstlevel.appendChild(secondlevel); //                
    root.getRoot().appendChild(firstlevel); //                
    return root.toString(); //     
}

/*******************************************************************************
 *        BU         
 ******************************************************************************/
function handleQueryBondNeRes(doc)
{
    var data = EncapsulateData(doc);//           
    var tempObj;
    var tmpNetype;
    for (var i = 0, datalen = data.getDataRowLength(); i < datalen; i++)
    {
        tempObj = new NeObj();
        tempObj.neid = data.getDataRowParam(i, "neid");
        tempObj.nename = data.getDataRowParam(i, "nename");
        tmpNetype = data.getDataRowParam(i, "netype");
        
        if(pageAttribute == PAGE_ATTR_CREATE && "" == topWin.buObject.name && tempObj.neid == neid)
        {
            selectedSlmObj[0].neid = tempObj.neid;
            selectedSlmObj[0].nename = tempObj.nename;
        }

        switch(tmpNetype)
        {
            case SLM_NETYPE: slmList.push(tempObj);
                             break;
            case PFE_NETYPE: pfeList.push(tempObj);
                             break;
            default: continue;
        }
    }
    
    initComboboxes(SLM_NETYPE);
    initComboboxes(PFE_NETYPE);
    
    enableFindLineBtn();
}

/*******************************************************************************
 *            
 ******************************************************************************/
function initComboboxes(netype)
{
     var aSelectNode;
     var bSelectNode;
     var cSelectNode;
     
     var nelist;
     var selectedObj;
     
	   if(netype == SLM_NETYPE)
	   {
	       aSelectNode = $("aBondSlmSlt");
         bSelectNode = $("bBondSlmSlt");
         cSelectNode = $("cBondSlmSlt");
         
         slmList.sort(comparison_nemame);
         nelist = slmList;
         selectedObj = selectedSlmObj;
	   }
	   else if(netype == PFE_NETYPE)
	   {
         aSelectNode = $("aBondPFESlt");
         bSelectNode = $("bBondPFESlt");
         cSelectNode = $("cBondPFESlt");
         
         pfeList.sort(comparison_nemame);
         nelist = pfeList;
         selectedObj = selectedPfeObj;
	   }
	   else
	   {
	   	   return;
	   }

     aSelectNode.options.length = 0;
     bSelectNode.options.length = 0;
     cSelectNode.options.length = 0;
     var tempObj;
     for(var i = 0, len = nelist.length; i < len; i++)
     {
         tempObj = nelist[i];
         
         if(!containsNeObj(selectedObj, tempObj))
         {
             aSelectNode.options[aSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             bSelectNode.options[bSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             cSelectNode.options[cSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             continue;
         }
         
         if(selectedObj[0] && selectedObj[0].equals(tempObj) && selectedObj[0].neid != "-1" && selectedObj[0].neid != "0")
         {
             aSelectNode.options[aSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             aSelectNode.selectedIndex = aSelectNode.options.length - 1;
             continue;
         }
         
         if(null != selectedObj[1] && selectedObj[1].equals(tempObj) && selectedObj[1].neid != "-1" && selectedObj[1].neid != "0")
         {
             bSelectNode.options[bSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             bSelectNode.selectedIndex = bSelectNode.options.length - 1;
             continue;
         }
         
         if(null != selectedObj[2] && selectedObj[2].equals(tempObj) && selectedObj[2].neid != "-1" && selectedObj[2].neid != "0")
         {
             cSelectNode.options[cSelectNode.options.length] = new Option(tempObj.nename, tempObj.neid);
             cSelectNode.selectedIndex = cSelectNode.options.length - 1;
             continue;
         }
     }

     if(netype == PFE_NETYPE)
     {
         aSelectNode.options[aSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[0] && selectedObj[0].neid == "0")
         {
             aSelectNode.selectedIndex = aSelectNode.options.length - 1;
         }
         bSelectNode.options[bSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[1] && selectedObj[1].neid == "0")
         {
             bSelectNode.selectedIndex = bSelectNode.options.length - 1;
         }
         cSelectNode.options[cSelectNode.options.length] = new Option("SE", 0);
         if(selectedObj[2] && selectedObj[2].neid == "0")
         {
             cSelectNode.selectedIndex = cSelectNode.options.length - 1;
         }
     }
     
     aSelectNode.options[aSelectNode.options.length] = new Option("--", -1);
     bSelectNode.options[bSelectNode.options.length] = new Option("--", -1);
     cSelectNode.options[cSelectNode.options.length] = new Option("--", -1);
     
     if(selectedObj[0] == null || selectedObj[0].neid == -1 || (!containsNeObj(nelist, selectedObj[0]) && selectedObj[0].neid != "0"))
     {
         aSelectNode.selectedIndex = aSelectNode.options.length - 1;
     }
     
     if(selectedObj[1] == null || selectedObj[1].neid == -1 || (!containsNeObj(nelist, selectedObj[1]) && selectedObj[1].neid != "0"))
     {
         bSelectNode.selectedIndex = bSelectNode.options.length -1;
     }
     
     if(selectedObj[2] == null || selectedObj[2].neid == -1 || (!containsNeObj(nelist, selectedObj[2]) && selectedObj[2].neid != "0"))
     {
         cSelectNode.selectedIndex = cSelectNode.options.length - 1;
     }
}

/*******************************************************************************
 *     BU      
 ******************************************************************************/
function openSetStatusPage()
{
	  var canGotoNextFlg = checkInputInfo();
	  if(!canGotoNextFlg)
	  {
	      return;
	  }	  
	  getBUObjvalue();
	  
	  topWin.buObject = buObject;
	  
	  topWin.slmList = slmList;
	  topWin.pfeList = pfeList;
	  
	  var pfeStrList = new Object();
	  pfeStrList[BU_APORT_NAME] = $("aBondPFESlt").options[$("aBondPFESlt").selectedIndex].innerHTML;
	  pfeStrList[BU_BPORT_NAME] = $("bBondPFESlt").options[$("bBondPFESlt").selectedIndex].innerHTML;
	  pfeStrList[BU_CPORT_NAME] = $("cBondPFESlt").options[$("cBondPFESlt").selectedIndex].innerHTML;
	  
	  topWin.switchPage("setbustatus.html?aBondPfeList=" + pfeStrList[BU_APORT_NAME] + "&bBondPfeList=" + pfeStrList[BU_BPORT_NAME] + "&cBondPfeList=" + pfeStrList[BU_CPORT_NAME], isModify);
	  if(isIE)
	  {
	      topWin.dialogHeight = "320px";
	  }
}

/*******************************************************************************
 *              BU  
 ******************************************************************************/
function getBUObjvalue()
{
	  buObject.name = buName;
	  
	  var  bindLineList = new Array();
	  var rowCount = bondLineTable.getDataRowLength();//  	  
	    for (var row=0; row<rowCount; row ++)
	    {
	    	var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
	    	if (BIND_STATUS == bindStatus)
	    	{
	    		var line = new BUBindLine();
	    		
	    		line.lineID = bondLineTable.getCellStoreValue(row, "lineID", "lineID");
	    		line.srcNEID = bondLineTable.getCellStoreValue(row, "srcLmuneid", "srcLmuneid");
	    		line.srcNEID = (undefined == line.srcNEID) ? 0 : line.srcNEID;
	    		line.srcLmuSlotID = bondLineTable.getCellStoreValue(row, "srcLmuSlotId", "srcLmuSlotId");
	    		line.srcLmuSlotID = (undefined == line.srcLmuSlotID) ? 0 : line.srcLmuSlotID;
	    		line.srcLmuPortID = bondLineTable.getCellStoreValue(row, "srcLmuPortId", "srcLmuPortId");
	    		line.srcLmuPortID = (undefined == line.srcLmuPortID) ? 0 : line.srcLmuPortID;
	    		line.srcLmiSlotID = bondLineTable.getCellStoreValue(row, "srcLmiSlotId", "srcLmiSlotId");
	    		line.srcLmiSlotID = (undefined == line.srcLmiSlotID) ? 0 : line.srcLmiSlotID;
	    		line.srcLmiPortID = bondLineTable.getCellStoreValue(row, "srcLmiPortId", "srcLmiPortId");
	    		line.srcLmiPortID = (undefined == line.srcLmiPortID) ? 0 : line.srcLmiPortID;
	    		
	    		line.snkNEID = bondLineTable.getCellStoreValue(row, "sinkLmuneid", "sinkLmuneid");
	    		line.snkNEID = (undefined == line.snkNEID) ? 0 : line.snkNEID;
	    		line.snkLmuSlotID = bondLineTable.getCellStoreValue(row, "sinkLmuSlotId", "sinkLmuSlotId");
	    		line.snkLmuSlotID = (undefined == line.snkLmuSlotID) ? 0 : line.snkLmuSlotID;
	    		line.snkLmuPortID = bondLineTable.getCellStoreValue(row, "sinkLmuPortId", "sinkLmuPortId");
	    		line.snkLmuPortID = (undefined == line.snkLmuPortID) ? 0 : line.snkLmuPortID;
	    		line.snkLmiSlotID = bondLineTable.getCellStoreValue(row, "sinkLmiSlotId", "sinkLmiSlotId");
	    		line.snkLmiSlotID = (undefined == line.snkLmiSlotID) ? 0 : line.snkLmiSlotID;
	    		line.snkLmiPortID = bondLineTable.getCellStoreValue(row, "sinkLmiPortId", "sinkLmiPortId");
	    		line.snkLmiPortID = (undefined == line.snkLmiPortID) ? 0 : line.snkLmiPortID;
	    		line.bucontrolpoint = bondLineTable.getCellStoreValue(row, "bucontrolpoint", "bucontrolpoint");
	    		line.direction = bondLineTable.getCellStoreValue(row, "lineDirection", "lineDirection");
	    		
	    		bindLineList.push(line);
	    	}
	    }
	    
	    buObject.bondLineList = bindLineList;
}

/*******************************************************************************
 *           
 ******************************************************************************/
function checkInputInfo()
{	
    var rowCount = bondLineTable.getDataRowLength();//  
    var totalLineCount = 0;
    var neLineCount = {};
    var ONENEMAXLINE = 2;
    var TOTALMAXLINE = 6;
    var buPortACount = 0;
    var buPortBCount = 0;
    var buPortCCount = 0;
    var buporta = "";
    var buportb = "";
    var buportc = "";
    
    for (var row=0; row<rowCount; row ++)
    {
    	var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
    	if (BIND_STATUS == bindStatus)
    	{
    		var srcLMUNEID = bondLineTable.getCellStoreValue(row, "srcLmuneid", "srcLmuneid");
    		if(null == srcLMUNEID || 0 == srcLMUNEID)
    	  {
    	  	  continue;
    	  }
    		var c = neLineCount[srcLMUNEID];
    		if (c == null || c == "undefined")
    		{
    			c = 0;
    		}
    		c ++;
    		neLineCount[srcLMUNEID] = c;
    		
    		    if (null != bondLineTable.getCellStoreValue(row, "buporta", "buporta"))
    		    {
    		    	buporta = bondLineTable.getCellStoreValue(row, "buporta", "buporta");
    		    }
    		    
    		    if (null != bondLineTable.getCellStoreValue(row, "buportb", "buportb"))
    		    {
    		    	buportb = bondLineTable.getCellStoreValue(row, "buportb", "buportb");
    		    }
    		    
    		    if (null != bondLineTable.getCellStoreValue(row, "buportc", "buportc"))
    		    {
    		    	buportc = bondLineTable.getCellStoreValue(row, "buportc", "buportc");
    		    }
		    		
		    		if (buporta.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortACount++;
		    		}
		    		else if (buportb.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortBCount++;
		    		}
		    		else if (buportc.indexOf(srcLMUNEID) != -1)
		    		{
		    			buPortCCount++;
		    		}
		    		
		    		if ((buPortACount > ONENEMAXLINE) || (buPortBCount > ONENEMAXLINE) || (buPortCCount > ONENEMAXLINE))
		    		{
		    			alert(RESOURCE["overonenemaxlinecount"]);
		    		  return false;
		    		}
    		
    		if (c > ONENEMAXLINE)
    		{
    			 alert(RESOURCE["overonenemaxlinecount"]);
    		     return false;
    		}
    		totalLineCount ++;
    		if (totalLineCount > TOTALMAXLINE)
    		{
   			 alert(RESOURCE["overonenemaxlinecount"]);
		     return false;
    		}
    		
    	}    
    }        
    return true;
}

/*******************************************************************************
 *           
 ******************************************************************************/
function comparison_nemame(neObj1, neObj2)
{
    var value1 = neObj1.nename;
    var value2 = neObj2.nename;
    if(value1 < value2)
    {
        return -1;
    }
    else if(value1 > value2)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/*******************************************************************************
 *       
 ******************************************************************************/
function NeObj()
{
    this.neid = "-1";
    this.nename = "--";
}

/*******************************************************************************
 *           
 ******************************************************************************/
NeObj.prototype.equals = function(obj)
{
    if(!obj)
    {
        return false;
    }
    
    if(obj.neid && obj.nename && this.neid == obj.neid && this.nename == obj.nename)
    {
        return true;
    }
    
    return false;
}

/*******************************************************************************
 *       
 ******************************************************************************/
function containsNeObj(selectedObj, tempObj)
{
    if(!tempObj || !tempObj.neid || tempObj.neid == "-1")
    {
        return false;
    }
    
    for(var i = 0; i < selectedObj.length; i++)
    {
        if(selectedObj[i].neid == tempObj.neid && selectedObj[i].nename == tempObj.nename)
        {
            return true;
        }
    }
    
    return false;
}

/*******************************************************************************
 *         BU
 ******************************************************************************/
function findExitBU()
{
	  disabledAllBtn(true);
    queryBU($("buNamtTxt").value, neid);
}

/*******************************************************************************
 *         BU
 ******************************************************************************/
function handleQueryBU(doc)
{
    var data = EncapsulateData(doc); //           

    if (0 == data.getSErrorCode() && data.getDataRowLength() > 0) //                   0 1
    {   
    	  buObject.name = data.getDataRowParam(0, "buname");
    	  buObject.macAddr = data.getDataRowParam(0, "macaddr");
    	  buObject.pressure = data.getDataRowParam(0, "pressure");
    	  buObject.primaryLine = data.getDataRowParam(0, "mainbridge");
    	  buObject.curPrimaryLine = data.getDataRowParam(0, "curmainbridge");
    	  buObject.posX = data.getDataRowParam(0, "posx");
    	  buObject.posY = data.getDataRowParam(0, "posy");
    	  
    	  setBuPortInfo(BU_APORT_NAME, data);
    	  selectedSlmObj[0].neid = buObject.portList[BU_APORT_NAME].bondSLM;
        selectedSlmObj[0].nename = data.getDataRowParam(0, "abondslmname");
        selectedPfeObj[0].neid = buObject.portList[BU_APORT_NAME].bondPFE;
        selectedPfeObj[0].nename = data.getDataRowParam(0, "abondpfename"); 
    	  
    	  setBuPortInfo(BU_BPORT_NAME, data);
    	  selectedSlmObj[1].neid = buObject.portList[BU_BPORT_NAME].bondSLM;
        selectedSlmObj[1].nename = data.getDataRowParam(0, "bbondslmname");
        selectedPfeObj[1].neid = buObject.portList[BU_BPORT_NAME].bondPFE;
        selectedPfeObj[1].nename = data.getDataRowParam(0, "bbondpfename"); 
    	  
    	  setBuPortInfo(BU_CPORT_NAME, data);
    	  selectedSlmObj[2].neid = buObject.portList[BU_CPORT_NAME].bondSLM;
        selectedSlmObj[2].nename = data.getDataRowParam(0, "cbondslmname");
        selectedPfeObj[2].neid = buObject.portList[BU_CPORT_NAME].bondPFE;
        selectedPfeObj[2].nename = data.getDataRowParam(0, "cbondpfename"); 
        
        
        $("buMacTxt").value = buObject.macAddr.substring(2);
        $("pressureTxt").value = buObject.pressure;

        if(pageAttribute == PAGE_ATTR_MODIFY)
        {
            $("buNamtTxt").value = buObject.name;
        }
        
        initComboboxes(SLM_NETYPE); 
        initComboboxes(PFE_NETYPE);
    }
    
    var errArr = [];//               
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//          
    
    disabledAllBtn(false);//      (        )         
}

/*******************************************************************************
 *         BU    
 ******************************************************************************/
function setBuPortInfo(buName, data)
{
    buObject.portList[buName] = new BUPortObject();
    buObject.portList[buName].portName = buName;
    buObject.portList[buName].bondSLM = data.getDataRowParam(0, buName.toLowerCase() + "bondslm");
    buObject.portList[buName].bondPFE = data.getDataRowParam(0, buName.toLowerCase() + "bondpfe");
}   
    
/*******************************************************************************
 *       
 ******************************************************************************/
function disabledAllBtn(flg)
{   
    $("findExitBUBtn").diabled = flg
    $("findLineBtn").diabled = flg
    $("nextStepBtn").diabled = flg
    $("confirmBtn").diabled = flg
    $("cancelBtn").diabled = flg
    $("applyBtn").diabled = flg
    
    $("aBondSlmSlt").diabled = flg
    $("bBondSlmSlt").diabled = flg
    $("cBondSlmSlt").diabled = flg
    $("aBondPFESlt").diabled = flg
    $("bBondPFESlt").diabled = flg
    $("cBondPFESlt").diabled = flg
}

/*******************************************************************************
 *   BU MAC       3    3     
 ******************************************************************************/
function getBuMacValue(valueStr)
{
    if(valueStr.length == BU_MAC_MAXLENGTH)
    {
        return valueStr;
    }
    
    var num0 = BU_MAC_MAXLENGTH - valueStr.length;
    for(var i = 0; i < num0; i++)
    {
        valueStr = "0" + valueStr;
    }
    
    return valueStr;
}

/*******************************************************************************
 *       
 ******************************************************************************/
function confirmModifyInfo(applyFlg)
{
	  if(!isModify)
	  {
	      xcloseDialog();
	      return;
	  }
	  if(checkInputInfo())
	  {
	  	  getBUObjvalue();
	  	  setBUInfo(applyFlg, true, TECMDCODE_SET_BUINFO);
    }
}

/*******************************************************************************
 *         
 ******************************************************************************/
function setPageStatus()
{
    $("applyBtn").disabled = true;    
    isModify = false;
}

/*******************************************************************************
 *            
 ******************************************************************************/
window.onunload = function()
{  
	  if (typeof (bondLineTable) != 'undefined' && bondLineTable instanceof SortTable)
	  {
		    clearSortTable(bondLineTable);
	  }
}

/**
 *         
 * @param needNEID          
 */
function findLineResImpl(needNEID)
{    
    var input = createQueryLineInfoXML(neids);
    if (null == input)
    {
    	alert("inner error");
    }    
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUBONDLINES_RES + "&nmUser=" + nmUser;//             Servlet   
    loadXMLdoc(url, "POST", false, handleQueryBondLineRes, null, "inputdata=" + input);//       
}

/**
 *            
 */
function findLineRes()
{			
	findLineResImpl(true);
}

/**
 *          
 */
function refreshTableEditStatus()
{	
	var rowCount = bondLineTable.getDataRowLength();//  
	if (0 >= rowCount)
	{
		 return;
	}
	
	for (var row=0; row<rowCount; row ++)
	{
	  	var bindStatus = bondLineTable.getCellStoreValue(row, "bindstatus", "bindstatus");
		var buccell = bondLineTable.getCell(row, "bucontrolpoint");					
		var isBinded = BIND_STATUS == bindStatus;
		bondLineTable.setCellIsEdit(buccell, isBinded);		
		if (!isBinded)
		{
			buccell.element.showElement.setValue("");			
		}	   	
	}
}

/**
 *              
 * 
 * @param doc
 *                
 */
function handleQueryBondLineRes(doc)
{		
	var data = EncapsulateData(doc);
	bondLineTable.clearTableData();
	
	var errorCode = data.getSErrorCode();
	var ndata = new DataInterface();
	ndata.errObj = data.errObj;	
		
	if (1 == errorCode)
    {
		var rowlen = data.getDataRowLength();
		for (var rl=rowlen-1; rl>=0; rl--)
		{
			var dr = data.getDataRow(rl);
			var ep = data.getDataRowParam(rl, "iserror");
			if (null != ep)
			{
				data.removeDataRowAt(rl);
			}
		}
    }
	
	if (0 == errorCode || 1 == errorCode)
	{		
		convertLineData(data);
		if (data.rows.length != 0)
		{
			createTableBody(bondLineTable, window.tableconf[0], data, RESOURCE);
			serControlEndCellStatus();
		}		
		if (1 == errorCode)
		{			
		    var errArr = [];//              
		    errArr.push("buname");
		    openErrPage("../../../../page/", ndata.getError(), errArr);//         
		}
	}
	else
	{
		showErrorDialog(data);
		var errArr = [];//              
	    errArr.push("buname");
	    openErrPage("../../../../page/", data.getError(), errArr);//         
	}	
}

/**
 *       
 * 
 * @param neids
 *              id  
 */
function createQueryLineInfoXML(neids)
{
	if (null == neids || neids == "undefined")
	{
		neids = [];
	}
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);	
		
	param = new tagElement("param");
	param.setAttribute("name", "neids");
	var ids = "";
	for (var index=0; index<neids.length; index++)
	{
		var id = neids[index]; 
		if (INVALID_NEID != id)
		{
			ids += id; 
			if (index != neids.length -1)
			{
				ids += ",";
			}
		}		
	}
	param.setAttribute("value", ids); //    
	row.appendChild(param);	

	
	param = new tagElement("param");
	param.setAttribute("name", "buname");
	param.setAttribute("value", buName); //    
	row.appendChild(param);
		
	param = new tagElement("param");
	param.setAttribute("name", "queryaction");	
	param.setAttribute("value", "2"); //           
	row.appendChild(param);
	
	
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}

/**
 * @param data  Datainterface
 */
function refreshBindLineTableStatus(data)
{		
	refreshTableState(bondLineTable, window.tableconf[0], data);
}

/*******************************************************************
 *                                
 *******************************************************************/
function serControlEndCellStatus()
{
    for(var i = 0, rowLen = bondLineTable.getDataRowLength(); i < rowLen; i++)
    {
        var bindstatus = bondLineTable.getCellCurrentValue(i, "bindstatus", "bindstatus");
        var buccell = bondLineTable.getCell(i, "bucontrolpoint");		
	  	  var isBinded = BIND_STATUS == bindstatus;
	  	  bondLineTable.setCellIsEdit(buccell, isBinded);	
        
    }
}

function closeWin()
{
	  xcloseDialog();
}
