 /*************
 *       
**************/

var parentDocument = window.frameElement.parentElement.parentElement.document;

var currentStatusWin;
var buttonFrm;
if(isIE)
{
    currentStatusWin = parentDocument.frames.currentViewFrm;
    buttonFrm = parentDocument.frames.buttonFrm;
}
else
{
    var frameArr = window.parent.window.document.getElementsByTagName("frame");
    currentStatusWin = frameArr.currentViewFrm.contentWindow;
    buttonFrm = frameArr.buttonFrm.contentWindow;
}
                    
window.onload = initPage;

/*******************
 *        
********************/
function initPage()
{
    initPageStringRes();

    initPageElement();
}

/**********************
 *          
***********************/
function initPageStringRes()
{
    $("buAimStatusLbl").innerHTML = RESOURCE["aimstatus"];
    $("buControlLbl").innerHTML = RESOURCE["bustatuscontrol"];
}

/***************************
 *    BU        
****************************/
function initPageElement()
{
	  $("buAimStatusDiv").innerHTML = drawBuStatusView(0, 0);
	  $("buControlDiv").innerHTML = initBUControlBtn();

}

/*********************
 *        
***********************/
function checkSubmitData()
{
	  var alertList = getStatusAlertList();
	  var checkInput = checkBUStatusInfe(alertList);
	  
	  return (checkInput && isNoModifyStatus());
}

/*********************
 *           
***********************/
function getStatusAlertList()
{
    alertList = new Array();
    alertList[0] = RESOURCE["curanoelectric"];
    alertList[1] = RESOURCE["curbnoelectric"];
    alertList[2] = RESOURCE["curcnoelectric"];
    alertList[3] = RESOURCE["curchoosemainbridge"];
    alertList[4] = RESOURCE["curwrongelectric"];
    
    return alertList;
}

/*******************************
 *              
********************************/
function isNoModifyStatus()
{
    var aimPrimaryLine = getPrimaryLine();
	  var curPrimaryLine = currentStatusWin.getBUPrimaryLine();
	  
	  if(aimPrimaryLine == curPrimaryLine)
	  {
	      alert(RESOURCE["samestatus"]);
	      return false;
	  }
	  
	  return true;
}

/*******************************
 *            xml
 *******************************/
function createSwitchXML()
{
    var paramList = new Array();
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "confStatusAfter");
    thirdlevel.setAttribute("value", getPrimaryLine());
    paramList[paramList.length] = thirdlevel;
    
    return paramList;
}

/*******************************
 *             xml
 *******************************/
function getAimStatusParams()
{
    var paramList = new Array();
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aelecdir");
    thirdlevel.setAttribute("value", getDirection(BU_APORT_NAME));
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "belecdir");
    thirdlevel.setAttribute("value", getDirection(BU_BPORT_NAME));
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "celecdir");
    thirdlevel.setAttribute("value", getDirection(BU_CPORT_NAME));
    paramList[paramList.length] = thirdlevel;
    
    var primaryLine = getPrimaryLine();
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "mainbridge");
    thirdlevel.setAttribute("value", primaryLine);
    paramList[paramList.length] = thirdlevel;
    
    var aEarth = 0;
    var bEarth = 0;
    var cEarth = 0;   
    switch(primaryLine)
    {
        case PRIMARY_LINE_AB:cEarth = 1;
                             break;
        case PRIMARY_LINE_AC:bEarth = 1;
                             break;
        case PRIMARY_LINE_BC:aEarth = 1;
                             break;
        default:break;
    }
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "aisearth");
    thirdlevel.setAttribute("value", aEarth);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "bisearth");
    thirdlevel.setAttribute("value", bEarth);
    paramList[paramList.length] = thirdlevel;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "cisearth");
    thirdlevel.setAttribute("value", cEarth);
    paramList[paramList.length] = thirdlevel;
    
    return paramList;
}

/***************************
 *       
****************************/
function enableAllElement(flg)
{
    buttonFrm.setModify();
}
