 /*************
 *       
**************/
var win = getDialogParentWindow();
var topWin = isIE ? top : win;
var buObj;//BU    
var neid = win.neid;
var nmUser = win.nmUser;
if(!isIE)
{
    neid = win.getParentWindow().neid;
    nmUser = win.getParentWindow().nmUser;
}
var buName;
var parentDocument = window.frameElement.parentElement.parentElement.document;
var controllFrm;
var aimStatusWin;

if(isIE)
{
    controllFrm = parentDocument.frames.controllerFrm;
    aimStatusWin = parentDocument.frames.aimViewFrm;
}
else
{
		var framArr = window.parent.window.document.getElementsByTagName("frame");
    controllFrm = framArr.controllerFrm.contentWindow;
    aimStatusWin = framArr.aimViewFrm.contentWindow;
}
var intervalID;
var buPreviousStatus;

window.onload = initPage;


/*******************
 *        
********************/
function initPage()
{
    initPageStringRes();

    initPageElement();
}

/**********************
 *          
***********************/
function initPageStringRes()
{
    $("buStatusLbl").innerHTML = RESOURCE["currentstatus"];
}

/***************************
 *    BU    
****************************/
function initPageElement()
{
	  $("buCurrentStatusDiv").innerHTML = drawBuStatusView(0,0);

    intervalID = window.setInterval(initBUStatusView, 2);
    
}

/**************
 *   BU  
*****************/
function initBUStatusView()
{
    if(!controllFrm.buObj)
    {
        return;
    }
    
    window.clearInterval(intervalID);
    buObj = controllFrm.buObj;
    buName = buObj.name;
    queryBUStatus();
    
}

/**********************
 *     BU    
************************/
function handleQueryBUStatus(doc)
{
    var data = EncapsulateData(doc); //          

    if (0 == data.getSErrorCode() && data.getDataRowLength() > 0)
    {
    	  setBUObj(data);

    	  drawMainBridge(data.getDataRowParam(0, "mainbridge"));
    	  buPreviousStatus = data.getDataRowParam(0, "mainbridge");

    	  drawCurDirection(data);
    	  
    	  drawPFEStr(data);
    	  
    	  $("buAimStatusDiv").innerHTML = drawBuStatusView(285,115);
    }
    
    var errArr = [];//              
    errArr.push("buname");
    openErrPage("../../../../page/", data.getError(), errArr);//         
}

/****************
 *       
******************/
function setBUObj(data)
{   
    buObj.primaryLine = data.getDataRowParam(0, "mainbridge");

    buObj.portList[BU_APORT_NAME] = newBUPortObj(BU_APORT_NAME, data);
    buObj.portList[BU_BPORT_NAME] = newBUPortObj(BU_BPORT_NAME, data);
    buObj.portList[BU_CPORT_NAME] = newBUPortObj(BU_CPORT_NAME, data);
}

/******************************
 *        BU    
*******************************/
function newBUPortObj(buPortName, data)
{
    var portObj = buObj.portList[buPortName];
    portObj.bondPFEName = data.getDataRowParam(0, buPortName.toLowerCase() + "bondpfe");
    portObj.isEarth = data.getDataRowParam(0, buPortName.toLowerCase() + "isearth");
    portObj.elecDirection = data.getDataRowParam(0, buPortName.toLowerCase() + "elecdir");
    
    return portObj;
}

/**********************
 *         
************************/
function drawCurDirection(data)
{
	  drawPortCurDir(BU_APORT_NAME, data.getDataRowParam(0, "aelecdir"));
	  drawPortCurDir(BU_BPORT_NAME, data.getDataRowParam(0, "belecdir"));
	  drawPortCurDir(BU_CPORT_NAME, data.getDataRowParam(0, "celecdir"));
}

/**********************
 *        
************************/
function drawPortCurDir(portName, direction)
{
	  var realDir = convertPortCurDir(portName, direction);

    chooseElecDir(portName, realDir);
}

/******************************************
 *                    
*******************************************/
function convertPortCurDir(portName, direction)
{
    if(portName == BU_APORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_RIGHT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_LEFT;//     
        }
    }
    
    if(portName == BU_BPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_LEFT;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_RIGHT;//     
        }
    }
    
    if(portName == BU_CPORT_NAME)
    {
        if(Number(direction) == 1)
        {
            return ELECDIRECTION_UP;//     
        }
        
        if(Number(direction) == 2)
        {
            return ELECDIRECTION_DOWN;//     
        }
    }
    
    return ELECDIRECTION_NONE;
}

/*************************
 *            
***************************/
function drawPFEStr(data)
{
    var pfeList = new Object();
    pfeList[BU_APORT_NAME] = data.getDataRowParam(0, "abondpfe");
    pfeList[BU_BPORT_NAME] = data.getDataRowParam(0, "bbondpfe");
    pfeList[BU_CPORT_NAME] = data.getDataRowParam(0, "cbondpfe");
    
    drawBondPFEStr(pfeList);
    aimStatusWin.drawBondPFEStr(pfeList);
    
    var polarytyObj = new Object();
    polarytyObj[BU_APORT_NAME] = data.getDataRowParam(0, "apfevoltage");
    polarytyObj[BU_BPORT_NAME] = data.getDataRowParam(0, "bpfevoltage");
    polarytyObj[BU_CPORT_NAME] = data.getDataRowParam(0, "cpfevoltage");
    
    drawPFEPolarityStr(polarytyObj);
    aimStatusWin.drawPFEPolarityStr(polarytyObj);
}

/*************************
 *       
***************************/
function enableAllElement(flg)
{
    
}

/*******************************
 *            xml
 *******************************/
function createSwitchXML()
{
    var paramList = new Array();
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "confStatusBefore");
    
    var curPrimaryLine = getBUPrimaryLine();
    if(curPrimaryLine != buPreviousStatus)
    {
        curPrimaryLine = buPreviousStatus;
    }
    
    thirdlevel.setAttribute("value", curPrimaryLine);
    paramList[paramList.length] = thirdlevel;
    
    return paramList;
}

/*******************************
 *   BU    
 *******************************/
function getBUPrimaryLine()
{
    return buObj.primaryLine;
}

/*******************************
 *       
 *******************************/
function setMidStatus()
{
    buObj.portList[BU_APORT_NAME].isEarth = "1";
    buObj.portList[BU_BPORT_NAME].isEarth = "1";
    buObj.portList[BU_CPORT_NAME].isEarth = "1";
    
    buObj.primaryLine = PRIMARY_LINE_NONE;
    
    drawMainBridge(PRIMARY_LINE_NONE);
    $("buStatusLbl").style.visibility = "visible";
}

/*******************************
 *       
 *******************************/
function setAimStatus()
{
	  aimStatusWin.getBuStatus(buObj);
    
    if(buObj.primaryLine != PRIMARY_LINE_NONE)
    {
        buPreviousStatus = buObj.primaryLine;
    }
    
    buObj.portList[BU_APORT_NAME].isEarth = "0";
    buObj.portList[BU_BPORT_NAME].isEarth = "0";
    buObj.portList[BU_CPORT_NAME].isEarth = "0";
    
    switch(buObj.primaryLine)
    {
        case PRIMARY_LINE_AB: buObj.portList[BU_CPORT_NAME].isEarth = "1";
                              break;
        case PRIMARY_LINE_AC: buObj.portList[BU_BPORT_NAME].isEarth = "1";
                              break;
        case PRIMARY_LINE_BC: buObj.portList[BU_APORT_NAME].isEarth = "1";
                              break;
        default: break;
    }
    
    drawMainBridge(buObj.primaryLine);
    
    for(var i = 0; i < 3; i++)
    {
    	  var buPort;
    	  var dir;
    	  switch(i)
    	  {
    	      case 0: buPort = buObj.portList[BU_APORT_NAME];
    	              dir = (ELECDIRECTION_IN == buPort.elecDirection) ? ELECDIRECTION_RIGHT : ELECDIRECTION_LEFT;
    	              break;
    	      case 1: buPort = buObj.portList[BU_BPORT_NAME];
    	              dir = (ELECDIRECTION_IN == buPort.elecDirection) ? ELECDIRECTION_LEFT : ELECDIRECTION_RIGHT;
    	              break;
            case 2: buPort = buObj.portList[BU_CPORT_NAME];
                    dir = (ELECDIRECTION_IN == buPort.elecDirection) ? ELECDIRECTION_UP : ELECDIRECTION_DOWN;
    	              break;
    	      default: break;    	                          
    	  }
        chooseElecDir(buPort.portName, dir);
    }
    $("buStatusLbl").style.visibility = "visible";
}
