 /***************************
 * BU           
****************************/
var BORDER_COLOR = "BLACK";
var ELECTRICITY_LINE_COLOR = "RED";
var EARTH_COLOR = "GREEN";

var BU_BORDER_LENGTH = 120;//BU   
var ELECTRICITY_LINE_LENGTH = 65;//BU    
var BLACK_WIDTH = 10;//              

var BORDERLINE_GAP_TOP = 50;//          
var BORDERLINE_GAP_LEFT = 80;//          

var RAW_LINE_LENGTH = 10;//      
var RAW_LINE_HALF_WIDTH = 5;//           

var BU_CURRENT_STATUS = 0;
var BU_INITIAL_STATUS = 1;

var BONDPFESTR_MAXLEN = 6;

/***************************
 * BU           
****************************/
var x0,y0;//  
var ax1, ay1;//A        
var bx0, by0;//B        
var cx0, cy0;//C        
var e0x, e0y;//      
var e1x, e1y;//      

var voltageMap = new Object();
var directionMap = new Object();
directionMap[BU_APORT_NAME] = 0;
directionMap[BU_BPORT_NAME] = 0;
directionMap[BU_CPORT_NAME] = 0;

/***************************** 
 *   (x0,y0) (x1,y1)   
******************************/
function drawLine(x0,y0,x1,y1,color) 
{ 
    var rs = ""; 
    if(y0 == y1)
    { 
        rs = "<table style='top:" + y0 + ";left:" + x0 + ";position:absolute'>" + 
             "<td bgcolor= " + color + " height=2 width=" + Math.abs(x1 - x0) + " ></td></table> "; 
    } 
    else if(x0 == x1)//x            table  
    { 
        rs = "<table style='top:" + y0 + ";left: " + x0 + ";position:absolute'>" + 
             "<td bgcolor= " + color + " width=1 height= " + Math.abs(y1 - y0) + "></td></table> "; 
    } 
    else //    
    { 
        var lx = x1 - x0;
        var ly = y1 - y0;
        var l = Math.sqrt(lx * lx + ly * ly);
        rs = new Array(); 
        for(var i = 0; i < l; i += 1) 
        { 
            var p = i / l; 
            var px = x0 + lx * p; 
            var py = y0 + ly * p; 
            rs[rs.length] = "<table style= 'top:" + py + ";left:" + px + ";position:absolute;'><td bgcolor= " + color + " height=1></td></table> "; 
        }
        rs = rs.join(" ");
    }           
    return rs; 
}

/*************** 
 *   BU             
*****************/
function drawBuBorder(x, y)
{
    x0 = x + BORDERLINE_GAP_LEFT;
    y0 = y + BORDERLINE_GAP_TOP;
    
    var x1 = x0 + BU_BORDER_LENGTH;
    var y1 = y0;
    
    var halfLength = BU_BORDER_LENGTH / 2;
    var x2 = x0 + halfLength;
    var y2 = y0 + Math.sqrt(BU_BORDER_LENGTH * BU_BORDER_LENGTH - halfLength * halfLength);
    
    var color = BORDER_COLOR;
    var rs = drawLine(x0, y0, x1, y1, color) + drawLine(x0, y0, x2, y2, color) + drawLine(x1, y1, x2, y2, color);
    return rs;
}

/******************  
 *   BU             
*******************/
function drawElecLine()
{
    var ax0 = x0 - 30;
    var ay0 = y0 + 25;
    ax1 = ax0 + ELECTRICITY_LINE_LENGTH;
    ay1 = ay0;
    var rs = drawLine(ax0, ay0, ax1, ay1, ELECTRICITY_LINE_COLOR);
    
    bx0 = ax1 + 50;
    by0 = ay1;
    var bx1 = bx0 + ELECTRICITY_LINE_LENGTH;
    var by1 = by0;
    rs += drawLine(bx0, by0, bx1, by1, ELECTRICITY_LINE_COLOR);
    
    cx0 = x0 + BU_BORDER_LENGTH / 2;
    cy0 = ay0 + 40;
    var cx1 = cx0;
    var cy1 = cy0 + ELECTRICITY_LINE_LENGTH;
    rs += drawLine(cx0, cy0, cx1, cy1, ELECTRICITY_LINE_COLOR);   
    return rs;
}

/******************  
 *        
*******************/
function drawPortStr()
{
    var asx = x0 - 40;
    var asy = y0;
    var rs = "<span style='top:" + asy + ";left:" + asx + ";position:absolute'>A</span>";
    
    var bsx = x0 + BU_BORDER_LENGTH + 40;
    var bsy = y0;
    rs += "<span style='top:" + bsy + ";left:" + bsx + ";position:absolute'>B</span>";
    
    var csx = asx + BU_BORDER_LENGTH / 2 + 20;
    var csy = y0 + BU_BORDER_LENGTH;
    rs += "<span style='top:" + csy + ";left:" + csx + ";position:absolute'>C</span>";
    return rs;
}

/*************************  
 *       PFE   
*************************/
function drawBondPFEStr(pfeList)
{
	  var rs = "";
	  var pfeStr, viewPfeStr;
	  if("--" != pfeList[BU_APORT_NAME] && "-" != pfeList[BU_APORT_NAME])
	  {   
        var asx = x0 - 65;
        var asy = y0 + 30;
        pfeStr = pfeList[BU_APORT_NAME];
        viewPfeStr = pfeStr;
        if(viewPfeStr.length > BONDPFESTR_MAXLEN)
        {
            viewPfeStr = viewPfeStr.substring(0, BONDPFESTR_MAXLEN - 1) + "...";
        }
        rs = "<span style='top:" + asy + ";left:" + asx + ";position:absolute' title='" + pfeStr +"'>" + viewPfeStr + "</span>";
    }
    
    if("--" != pfeList[BU_BPORT_NAME] && "-" != pfeList[BU_BPORT_NAME])
	  {
        var bsx = x0 + BU_BORDER_LENGTH;
        var bsy = y0 + 30;
        pfeStr = pfeList[BU_BPORT_NAME];
        viewPfeStr = pfeStr;
        if(viewPfeStr.length > BONDPFESTR_MAXLEN)
        {
            viewPfeStr = viewPfeStr.substring(0, BONDPFESTR_MAXLEN - 1) + "...";
        }
        rs += "<span style='top:" + bsy + ";left:" + bsx + ";position:absolute' title='" + pfeStr + "'>" + viewPfeStr + "</span>";
    }
    
    if("--" != pfeList[BU_CPORT_NAME] && "-" != pfeList[BU_CPORT_NAME])
	  {
        var csx = x0 + BU_BORDER_LENGTH / 2 + 10;
        var csy = y0 + BU_BORDER_LENGTH - 5;
        pfeStr = pfeList[BU_CPORT_NAME];
        viewPfeStr = pfeStr;
        if(viewPfeStr.length > BONDPFESTR_MAXLEN)
        {
            viewPfeStr = viewPfeStr.substring(0, BONDPFESTR_MAXLEN - 1) + "...";
        }
        rs += "<span style='top:" + csy + ";left:" + csx + ";position:absolute' title='" + pfeStr + "'>" + viewPfeStr + "</span>";
    }
    
    if(null == rs || rs == "")
    {
        return;
    }
    rs = $("viewDiv").innerHTML + rs;
	  $("viewDiv").innerHTML = rs;
}

/******************  
 *   PFE  
*******************/
function drawPFEPolarityStr(polarityObj)
{
	var pfePolarityDiv = $("pfePolarityDiv");
	clearDiv(pfePolarityDiv);
	
	var rs = "<div id='pfePolarityDiv'>";
	var pfePolariyStr;
	
	voltageMap[BU_APORT_NAME] = "-";
	if ("" != polarityObj[BU_APORT_NAME] && "-" != polarityObj[BU_APORT_NAME]) {
		var asx = x0 - 65;
		var asy = y0 + 45;
		pfePolariyStr = new Number(polarityObj[BU_APORT_NAME]);

		if (pfePolariyStr > 0) {
			pfePolariyStr = "+" + pfePolariyStr + "V";
		} else if (pfePolariyStr < 0) {
			pfePolariyStr = pfePolariyStr + "V";
		} else {
			pfePolariyStr = pfePolariyStr + "V";
		}
		rs = "<span style='top:" + asy + ";left:" + asx
				+ ";position:absolute'>" + pfePolariyStr + "</span>";
		voltageMap[BU_APORT_NAME] = new Number(polarityObj[BU_APORT_NAME]);
	}

	voltageMap[BU_BPORT_NAME] = "-";
	if ("" != polarityObj[BU_BPORT_NAME] && "-" != polarityObj[BU_BPORT_NAME]) {
		var bsx = bx0 + ELECTRICITY_LINE_LENGTH - 30;
		var bsy = y0 + 45;

		pfePolariyStr = new Number(polarityObj[BU_BPORT_NAME]);

		if (pfePolariyStr > 0) {
			pfePolariyStr = "+" + pfePolariyStr + "V";
		} else if (pfePolariyStr < 0) {
			pfePolariyStr = pfePolariyStr + "V";
		} else {
			pfePolariyStr = pfePolariyStr + "V";
		}
		rs += "<span style='top:" + bsy + ";left:" + bsx
				+ ";position:absolute'>" + pfePolariyStr + "</span>";
		voltageMap[BU_BPORT_NAME] = new Number(polarityObj[BU_BPORT_NAME]);
	}

	voltageMap[BU_CPORT_NAME] = "-";
	if ("" != polarityObj[BU_CPORT_NAME] && "-" != polarityObj[BU_CPORT_NAME]) {
		var csx = x0 + BU_BORDER_LENGTH / 2 + 10;
		var csy = y0 + BU_BORDER_LENGTH + 10;
		pfePolariyStr = new Number(polarityObj[BU_CPORT_NAME]);

		if (pfePolariyStr > 0) {
			pfePolariyStr = "+" + pfePolariyStr + "V";
		} else if (pfePolariyStr < 0) {
			pfePolariyStr = pfePolariyStr + "V";
		} else {
			pfePolariyStr = pfePolariyStr + "V";
		}
		rs += "<span style='top:" + csy + ";left:" + csx
				+ ";position:absolute'>" + pfePolariyStr + "</span>";
		voltageMap[BU_CPORT_NAME] = new Number(polarityObj[BU_CPORT_NAME]);
	}

	rs += "</div>";
	rs = $("viewDiv").innerHTML + rs;
	$("viewDiv").innerHTML = rs;
}

/******************  
 *        
*******************/
function drawLeftEarthPoint()
{
	clearDiv($("earthPointDiv"));
    
    e0x = cx0 - 60;
    e0y = cy0;
    var e0x0 = e0x;
    var e0y0 = e0y;
    var e0x1 = e0x;
    var e0y1 = e0y + 15;
    var rs = "<div id='earthPointDiv'>" + drawLine(e0x0, e0y0, e0x1, e0y1, EARTH_COLOR);
    
    e0x0 = e0x0 - 10;
    e0y0 = e0y1;
    e0x1 = e0x1 + 10;
    rs += drawLine(e0x0, e0y0, e0x1, e0y1, EARTH_COLOR);
    
    e0x0 = e0x0 + 3;
    e0y0 = e0y0 + 5;
    e0x1 = e0x1 - 3;
    e0y1 = e0y0;
    rs += drawLine(e0x0, e0y0, e0x1, e0y1, EARTH_COLOR);
    
    e0x0 = e0x0 + 3;
    e0y0 = e0y0 + 5;
    e0x1 = e0x1 - 3;
    e0y1 = e0y0;
    rs += drawLine(e0x0, e0y0, e0x1, e0y1, EARTH_COLOR) + "</div>";
        
    return rs;
}


/******************  
 *        
*******************/
function drawRightEarthPoint()
{
	clearDiv($("earthPointDiv"));
    
    e1x = cx0 + 60;
    e1y = cy0;
    var e1x0 = e1x;
    var e1y0 = e1y;
    var e1x1 = e1x;
    var e1y1 = e1y + 15;
    var rs = "<div id='earthPointDiv'>" + drawLine(e1x0, e1y0, e1x1, e1y1, EARTH_COLOR);
    
    e1x0 = e1x0 - 10;
    e1y0 = e1y1;
    e1x1 = e1x1 + 10;
    rs += drawLine(e1x0, e1y0, e1x1, e1y1, EARTH_COLOR);
    
    e1x0 = e1x0 + 3;
    e1y0 = e1y0 + 5;
    e1x1 = e1x1 - 3;
    e1y1 = e1y0;
    rs += drawLine(e1x0, e1y0, e1x1, e1y1, EARTH_COLOR);
    
    e1x0 = e1x0 + 3;
    e1y0 = e1y0 + 5;
    e1x1 = e1x1 - 3;
    e1y1 = e1y0;
    rs += drawLine(e1x0, e1y0, e1x1, e1y1, EARTH_COLOR) + "</div>";
    
    return rs;
}
/************************************************ 
 *   BU                              
**************************************************/
function drawBuStatusView(x, y)
{
	  var rs = "<div id='viewDiv'>";
    rs += drawBuBorder(x, y) + drawElecLine(x, y) + drawPortStr();// + drawEarthPoint();
    rs += "</div>"
    return rs;
}

/******************  
 *       
*******************/
function drawMainBridgeHandler(connectPorts)
{
	if (connectPorts != "" && !isStatusReasonable(connectPorts) &&
			reasonableStatus != connectPorts && !confirm(RESOURCE["unsupportedbustatus"]))
	{
		setStatusRadioButton();
		return;
	}
	reasonableStatus = connectPorts;
	drawMainBridge(connectPorts);
}

function isStatusReasonable(connectPorts) {
	var adirection = directionMap[BU_APORT_NAME];
	var bdirection = directionMap[BU_BPORT_NAME];
	var cdirection = directionMap[BU_CPORT_NAME];
	var aVoltage = voltageMap[BU_APORT_NAME];
	var bVoltage = voltageMap[BU_BPORT_NAME];
	var cVoltage = voltageMap[BU_CPORT_NAME];
	
	if (connectPorts == PRIMARY_LINE_AB)
	{
		if ((aVoltage != "-" && bVoltage == "-") || (aVoltage == "-" && bVoltage != "-"))
		{
			return false;
		}
		if(null == aVoltage || "undefined" == aVoltage || null == bVoltage || "undefined" == bVoltage)
		{
		    return ((ELECDIRECTION_IN == adirection && ELECDIRECTION_OUT == bdirection) 
		        || (ELECDIRECTION_OUT == adirection && ELECDIRECTION_IN == bdirection));
		}
		return (aVoltage >= bVoltage && ELECDIRECTION_IN == adirection && ELECDIRECTION_OUT == bdirection) 
		|| (aVoltage <= bVoltage && ELECDIRECTION_OUT == adirection && ELECDIRECTION_IN == bdirection);
	}
	if (connectPorts == PRIMARY_LINE_AC)
	{
		if ((aVoltage != "-" && cVoltage == "-") || (aVoltage == "-" && cVoltage != "-"))
		{
			return false;
		}
		if(null == aVoltage || "undefined" == aVoltage || null == cVoltage || "undefined" == cVoltage)
		{
		    return ((ELECDIRECTION_IN == adirection && ELECDIRECTION_OUT == cdirection) 
		        || (ELECDIRECTION_OUT == adirection && ELECDIRECTION_IN == cdirection));
		}
		return (aVoltage >= cVoltage && ELECDIRECTION_IN == adirection && ELECDIRECTION_OUT == cdirection) 
		|| (aVoltage <= cVoltage && ELECDIRECTION_OUT == adirection && ELECDIRECTION_IN == cdirection);
	}
	if (connectPorts == PRIMARY_LINE_BC)
	{
		if ((bVoltage != "-" && cVoltage == "-") || (bVoltage == "-" && cVoltage != "-"))
		{
			return false;
		}
		if(null == bVoltage || "undefined" == bVoltage || null == cVoltage || "undefined" == cVoltage)
		{
		    return ((ELECDIRECTION_IN == bdirection && ELECDIRECTION_OUT == cdirection)
		        || (ELECDIRECTION_OUT == bdirection && ELECDIRECTION_IN == cdirection));	
		}
		return (bVoltage >= cVoltage && ELECDIRECTION_IN == bdirection && ELECDIRECTION_OUT == cdirection) 
		|| (bVoltage <= cVoltage && ELECDIRECTION_OUT == bdirection && ELECDIRECTION_IN == cdirection);
	}
	
	return false;
}
function drawMainBridge(connectPorts)
{	
    var nx0, ny0, nx1, ny1;
    var rs = "<div id='connectDiv'>";
    var earthPort;
    
    clearDiv($("earthPointDiv"));
    clearDiv($("connectDiv"));
    clearDiv($("earthDiv"));

    switch(connectPorts)
    {
    	  case PRIMARY_LINE_AB: 
    	  case PRIMARY_LINE_NONE: nx0 = ax1;
    	                          ny0 = ay1;
    	                          nx1 = bx0;
    	                          ny1 = by0;
    	                          earthPort = BU_CPORT_NAME;
    	                          break;
    	  case PRIMARY_LINE_AC: nx0 = ax1;
    	                        ny0 = ay1;
    	                        nx1 = cx0;
    	                        ny1 = cy0;
    	                        earthPort = BU_BPORT_NAME;
    	                        break;
    	  case PRIMARY_LINE_BC: nx0 = bx0;
    	                        ny0 = by0;
    	                        nx1 = cx0;
    	                        ny1 = cy0;
    	                        earthPort = BU_APORT_NAME;
    	                        break;
    	  default:return;
    }
    rs += drawLine(nx0, ny0, nx1, ny1, ELECTRICITY_LINE_COLOR);
    
    if(PRIMARY_LINE_NONE == connectPorts)
    {
        rs += drawLine(cx0, ny0, cx0, cy0, ELECTRICITY_LINE_COLOR);
    }
    
    rs += "</div>";
    
    if(BU_APORT_NAME == earthPort)
    {
       rs += drawLeftEarthPoint();
    }
    else
    {
        rs += drawRightEarthPoint();
    }
    rs += chooseEarthPort(earthPort);
    
    rs = $("viewDiv").innerHTML + rs;
	  $("viewDiv").innerHTML = rs;

	  enableAllElement(true);
	  $("viewDiv").style.visibility = "visible";
}

/********************  
 *    BU    
*********************/
function initBUControlBtn()
{
   var rs = "<fieldset id='eleDirectionFld'><legend><span id='eleDirectionLbl'>" + RESOURCE["elecdirection"] + "</span></legend>";
   rs += "<table width='100%'><tr><td align='center' width='20%'><span id='aEleLbl'>A</span></td>";
   rs += "<td><input id='aElec1' name='aElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_APORT_NAME + "\", " + ELECDIRECTION_RIGHT + ")'/><span>" + RESOURCE["in"] + "</span></td>";
   rs += "<td><input id='aElec2' name='aElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_APORT_NAME + "\", " + ELECDIRECTION_LEFT + ")'/><span>" + RESOURCE["out"] + "</span></td>";
   rs += "<td><input id='aElec0' name='aElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_APORT_NAME + "\", " + ELECDIRECTION_NONE + ")' checked/><span>" + RESOURCE["nothing"] + "</span></td></tr>";
   
   rs += "<tr><td align='center' width='20%'><span id='bEleLbl'>B</span></td>";
   rs += "<td><input id='bElec1' name='bElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_BPORT_NAME + "\", " + ELECDIRECTION_LEFT + ")'/><span>" + RESOURCE["in"] + "</span></td>";
   rs += "<td><input id='bElec2' name='bElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_BPORT_NAME + "\", " + ELECDIRECTION_RIGHT + ")'/><span>" + RESOURCE["out"] + "</span></td>";
   rs += "<td><input id='bElec0' name='bElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_BPORT_NAME + "\", " + ELECDIRECTION_NONE + ")' checked/><span>" + RESOURCE["nothing"] + "</span></td></tr>";
   
   rs += "<tr><td align='center' width='20%'><span id='cEleLbl'>C</span></td>";
   rs += "<td><input id='cElec1' name='cElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_CPORT_NAME + "\", " + ELECDIRECTION_UP + ")'/><span>" + RESOURCE["in"] + "</span></td>";
   rs += "<td><input id='cElec2' name='cElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_CPORT_NAME + "\", " + ELECDIRECTION_DOWN + ")'/><span>" + RESOURCE["out"] + "</span></td>";
   rs += "<td><input id='cElec0' name='cElec' type='radio' onclick='chooseElecDirHandler(\"" + BU_CPORT_NAME + "\", " + ELECDIRECTION_NONE + ")' checked/><span>" + RESOURCE["nothing"] + "</span></td></tr>";
   rs += "</table></fieldset>";
   
   rs += "<br/><fieldset id='connectFld'><legend><span id='connectLbl'>" + RESOURCE["connectstatus"] + "</span></legend>";
   rs += "<table width='100%'><tr>" +
   		 "<td><input id='connect1' name='coonect' type='radio' onclick='drawMainBridgeHandler(\"" + PRIMARY_LINE_AB + "\")'/><span>" + RESOURCE["abstatus"] + "</span></td>";
   rs += "<td><input id='connect2' name='coonect' type='radio' onclick='drawMainBridgeHandler(\"" + PRIMARY_LINE_AC + "\")'/><span>" + RESOURCE["acstatus"] + "</span></td>";
   rs += "<td><input id='connect3' name='coonect' type='radio' onclick='drawMainBridgeHandler(\"" + PRIMARY_LINE_BC + "\")'/><span>" + RESOURCE["bcstatus"] + "</span></td></tr>";
   rs += "</table></fieldset>";

   return rs;
}

/*****************
 *       
******************/
function chooseElecDirHandler(portName, direction)
{
	chooseElecDir(portName, direction);
	autoMaticSetStatus();
}

function chooseElecDir(portName, direction)
{
	  var rs;
	  var rawDiv;
    
	  if(portName == BU_APORT_NAME)
	  {
	  	  rawDiv = $("rawADiv");
	  	  clearDiv(rawDiv);//           
	  	  rs = "<div id='rawADiv'>";
	      switch(direction)
	      {
	          case ELECDIRECTION_LEFT: rs += drawElecDirection(ax1 - ELECTRICITY_LINE_LENGTH, ay1, ELECDIRECTION_LEFT);
	          							directionMap[BU_APORT_NAME] = ELECDIRECTION_OUT;
	                                   break;
	          case ELECDIRECTION_RIGHT: rs += drawElecDirection(ax1 - ELECTRICITY_LINE_LENGTH, ay1, ELECDIRECTION_RIGHT);
	          							directionMap[BU_APORT_NAME] = ELECDIRECTION_IN;
	                                    break;
	          default:
	        	  directionMap[BU_APORT_NAME] = ELECDIRECTION_NONE;
	      }
	      rs += "</div>";
	  }
	  
	  if(portName == BU_BPORT_NAME)
	  {
	  	  rawDiv = $("rawBDiv");
	  	  clearDiv(rawDiv);
	  	  rs = "<div id='rawBDiv'>";
	      switch(direction)
	      {
	          case ELECDIRECTION_LEFT: rs += drawElecDirection(bx0, by0, ELECDIRECTION_LEFT);
	          							directionMap[BU_BPORT_NAME] = ELECDIRECTION_IN;
	                                   break;
	          case ELECDIRECTION_RIGHT: rs += drawElecDirection(bx0, by0, ELECDIRECTION_RIGHT);
	          							directionMap[BU_BPORT_NAME] = ELECDIRECTION_OUT;
	                                    break;
	          default:
	        	  directionMap[BU_BPORT_NAME] = ELECDIRECTION_NONE;
	      }
	      rs += "</div>";
	  }
	  
	  if(portName == BU_CPORT_NAME)
	  {
	  	  rawDiv = $("rawCDiv");
	  	  clearDiv(rawDiv);
	  	  rs = "<div id='rawCDiv'>";
	      switch(direction)
	      {
	          case ELECDIRECTION_UP: rs += drawElecDirection(cx0, cy0, ELECDIRECTION_UP);
										directionMap[BU_CPORT_NAME] = ELECDIRECTION_IN;
	                                   break;
	          case ELECDIRECTION_DOWN: rs += drawElecDirection(cx0, cy0, ELECDIRECTION_DOWN);
										directionMap[BU_CPORT_NAME] = ELECDIRECTION_OUT;
	                                    break;
	          default:
	        	  directionMap[BU_CPORT_NAME] = ELECDIRECTION_NONE;
	      }
	      rs += "</div>";
	  }
	  
	  if(rs != null || rs != "")
	  {
	      rs = $("viewDiv").innerHTML + rs;
	      $("viewDiv").innerHTML = rs;
	  }
	  enableAllElement(true);
}

var reasonableStatus = PRIMARY_LINE_NONE;

function autoMaticSetStatus()
{	
	reasonableStatus = PRIMARY_LINE_NONE;
	
	var adirection = directionMap[BU_APORT_NAME];
	var bdirection = directionMap[BU_BPORT_NAME];
	var cdirection = directionMap[BU_CPORT_NAME];
	
	var aVoltage = voltageMap[BU_APORT_NAME];
	var bVoltage = voltageMap[BU_BPORT_NAME];
	var cVoltage = voltageMap[BU_CPORT_NAME];
	
	if (autoMaticSetStatus2(adirection, bdirection, cdirection,  // A B 
            aVoltage, bVoltage, cVoltage)
            || autoMaticSetStatus2(bdirection, adirection, cdirection,  // B A 
                    bVoltage, aVoltage, cVoltage))
	{
		reasonableStatus = PRIMARY_LINE_AB;
	}
	if (autoMaticSetStatus2(adirection, cdirection, bdirection,  // A C 
                    aVoltage, cVoltage, bVoltage)
            || autoMaticSetStatus2(cdirection, adirection, bdirection,  // C A 
                    cVoltage, aVoltage, bVoltage))
	{
		reasonableStatus = PRIMARY_LINE_AC;
	}
	if (autoMaticSetStatus2(bdirection, cdirection, adirection,  // B C 
                    bVoltage, cVoltage, aVoltage)
            || autoMaticSetStatus2(cdirection, bdirection, adirection,  // C B 
                    cVoltage, bVoltage, aVoltage))
	{
		reasonableStatus = PRIMARY_LINE_BC;
	}
	setStatusRadioButton();
}

function setStatusRadioButton()
{
	switch (reasonableStatus)
    {
        case PRIMARY_LINE_AB:
        	$("connect1").click();
            break;
        case PRIMARY_LINE_AC:
        	$("connect2").click();
            break;
        case PRIMARY_LINE_BC:
        	$("connect3").click(); 
            break;
        case PRIMARY_LINE_NONE:
        default:
        	$("connect1").checked = false;
        	$("connect2").checked = false;
        	$("connect3").checked = false;
        	clearDiv($("earthPointDiv"));
        	clearDiv($("connectDiv"));
        	clearDiv($("earthDiv"));
    }
}

function autoMaticSetStatus2(directionIn, directionOut, directionOther,
		voltageIn, voltageOut, voltageOther)
{
	if (ELECDIRECTION_IN == directionIn && ELECDIRECTION_OUT == directionOut
			&& voltageIn != "-" && voltageOut != "-" && voltageIn >= voltageOut)
	{
		if (0 == directionOther || voltageOther == "-"
			|| (ELECDIRECTION_IN == directionOther && voltageOther < voltageOut)
			|| (ELECDIRECTION_OUT == directionOther && voltageOther > voltageIn))
		{
			return true;
		}
	}
	return false;
}

/*******************************************************************************
 *         
 ******************************************************************************/
function drawElecDirection(x, y, direction)
{
	  var x0, y0, x1, y1, x2, y2;
	  switch(direction)
	  {
	      case ELECDIRECTION_LEFT: x0 = x + ELECTRICITY_LINE_LENGTH / 2;
	                               y0 = y + 1;
	                               x1 = x0 + RAW_LINE_LENGTH;
	                               y1 = y0 - RAW_LINE_HALF_WIDTH;
	                               x2 = x1;
	                               y2 = y0 + RAW_LINE_HALF_WIDTH;
	                               break;
	      case ELECDIRECTION_RIGHT: x0 = x + ELECTRICITY_LINE_LENGTH / 2;
	                                y0 = y + 1;
	                                x1 = x0 - RAW_LINE_LENGTH;
	                                y1 = y0 - RAW_LINE_HALF_WIDTH;
	                                x2 = x1;
	                                y2 = y0 + RAW_LINE_HALF_WIDTH;
	                                break;
	      case ELECDIRECTION_UP: x0 = x + 1;
	                             y0 = y + ELECTRICITY_LINE_LENGTH / 2;
	                             x1 = x0 - RAW_LINE_HALF_WIDTH;
	                             y1 = y0 + RAW_LINE_LENGTH;
	                             x2 = x0 + RAW_LINE_HALF_WIDTH;
	                             y2 = y1;
	                             break;
	      case ELECDIRECTION_DOWN: x0 = x + 1;
	                               y0 = y + ELECTRICITY_LINE_LENGTH / 2;
	                               x1 = x0 - RAW_LINE_HALF_WIDTH;
	                               y1 = y0 - RAW_LINE_LENGTH;
	                               x2 = x0 + RAW_LINE_HALF_WIDTH;
	                               y2 = y1;
	                               break;
	      default:return;
	  }
	  
	  var rs = drawLine(x0, y0, x1, y1, ELECTRICITY_LINE_COLOR) + drawLine(x0, y0, x2, y2, ELECTRICITY_LINE_COLOR);
	  
	  return rs;
}

function clearDiv(rawDiv)
{
    if(!rawDiv)
    {
        return;
    }
    var rawParent = rawDiv.parentNode;
    rawParent.removeChild(rawDiv);
}

/*************** 
 *      
****************/
function chooseEarthPort(portName)
{    
	var rs = "<div id='earthDiv'>";
    
    var ex0, ey0, ex1, ey1;
    switch(portName)
    {
        case BU_APORT_NAME: ex0 = ax1;
                            ey0 = ay1;
                            ex1 = e0x;
                            ey1 = e0y;
                            break;
        case BU_BPORT_NAME: ex0 = bx0;
                            ey0 = by0;
                            ex1 = e1x;
                            ey1 = e1y;
                            break;
        case BU_CPORT_NAME: ex0 = cx0;
                            ey0 = cy0;
                            ex1 = e1x;
                            ey1 = e1y;
                            break;
        default:return;
    }
    
    rs += drawLine(ex0, ey0, ex1, ey1, EARTH_COLOR);
    
    rs += "</div>";

	  return rs;
}

/*********************** 
 *           
************************/
function checkBUStatusInfe(alertList)
{
	  var alertStr
    if($("aElec0").checked)
    {
    	  alertStr = (alertList && alertList[0]) ? alertList[0] : RESOURCE["anoelectric"];
        alert(alertStr);
        return false;
    }
    
    if($("bElec0").checked)
    {
    	  alertStr = (alertList && alertList[1]) ? alertList[1] : RESOURCE["bnoelectric"];
        alert(alertStr);
        return false;
    }
    
    if($("cElec0").checked)
    {
    	  alertStr = (alertList && alertList[2]) ? alertList[2] : RESOURCE["cnoelectric"];
        alert(alertStr);
        return false;
    }

    if(!$("connect3").checked && !$("connect2").checked && !$("connect1").checked)
    {
    	  alertStr = (alertList && alertList[3]) ? alertList[3] : RESOURCE["choosemainbridge"];
        alert(alertStr);
        return false;
    }
    
    var statusAlertStr;
    if(alertList && alertList.length > 4)
    {
    	  statusAlertStr = alertList[4];
    }
    if(!checkConnect(statusAlertStr))
    {
        return false;
    }
    
    return true;
}

/*********************** 
 *           
***********************/
function checkConnect(alertStr)
{
    /*                   */
	/* AB  */
	if ($("connect1").checked)
	{
		if (($("aElec1").checked && $("bElec1").checked)
				|| ($("aElec2").checked && $("bElec2").checked))
		{
			if(alertStr)
	    	{
	    	    alert(alertStr);
	    	}
	    	else
	    	{
	    	    alert(RESOURCE["wrongelectric"]);
	    	}
			return false;
		}
	}
	
	/* AC  */
	if ($("connect2").checked)
	{
		if (($("aElec1").checked && $("cElec1").checked)
				|| ($("aElec2").checked && $("cElec2").checked))
		{
			if(alertStr)
	    	{
	    	    alert(alertStr);
	    	}
	    	else
	    	{
	    	    alert(RESOURCE["wrongelectric"]);
	    	}
			return false;
		}
	}
    
	/* BC  */
	if ($("connect3").checked)
	{
		if (($("bElec1").checked && $("cElec1").checked)
				|| ($("bElec2").checked && $("cElec2").checked))
		{
			if(alertStr)
	    	{
	    	    alert(alertStr);
	    	}
	    	else
	    	{
	    	    alert(RESOURCE["wrongelectric"]);
	    	}
			return false;
		}
	}

    return true;
}

/*********************** 
 *   BU     
***********************/
function getBuStatus(buObject)
{
    if(null == buObject)
    {
        return;
    }
    
    var buPortList = buObject.portList;
    var portName;
    var buPort;
    for(var i = 0; i < 3; i++)
    {
        switch(i)
        {
            case 0: portName = BU_APORT_NAME;
                    break;
            case 1: portName = BU_BPORT_NAME;
                    break;
            case 2: portName = BU_CPORT_NAME;
                    break;
            default:break;
        }
        buPort = buPortList[portName];
        if(null == buPort)
        {
            buPort = new BUPortObject();
            buPort.portName = portName;
            buPortList[portName] = buPort;
        }
        buPort.isEarth = "0";
        buPort.elecDirection = getDirection(portName);
    }
    buObject.primaryLine = getPrimaryLine();
    switch(buObject.primaryLine)
    {
        case PRIMARY_LINE_AB: 
        case PRIMARY_LINE_NONE: buPortList[BU_CPORT_NAME].isEarth = "1";
                                break;
        case PRIMARY_LINE_AC: buPortList[BU_BPORT_NAME].isEarth = "1";
                              break;
        case PRIMARY_LINE_BC: buPortList[BU_APORT_NAME].isEarth = "1";
                              break;
        default:break;
    }
}

/*********************** 
 *       
***********************/
function getDirection(portName)
{
    if(null == portName || "" == portName)
    {
        return "0";
    }
    
    var tmpDirRadio;
    for(var i = 0; i < 3; i++)
    {
        tmpDirRadio = $(portName.toLowerCase() + "Elec" + i);
        if(tmpDirRadio.checked)
        {
            return i.toString();
        }
    }
    return "0";
}

/*********************** 
 *     
***********************/
function getPrimaryLine()
{
	  var tmpPrimaryLineRedio;
    for(var i = 1; i <= 3; i++)
    {
        tmpPrimaryLineRedio = $("connect" + i);
        if(tmpPrimaryLineRedio.checked)
        {
            return i.toString();
        }
    }
    
    return "-1";
}

/************************************* 
 *                  
****************************************/
function setRedioCheckStatus(dirObj, earthObj, mainBridge)
{
    if(dirObj)
    {
        setPortDirRedio(dirObj);
    }
    
    if(mainBridge)
    {
        setMainBridgeRedio(mainBridge);
    }
}

/************************************* 
 *                  
****************************************/
function setPortDirRedio(dirObj)
{
	  var portName;
	  for(var i = 0; i < 3; i++)
	  {
	      switch(i)
	      {
	          case 0: portName = BU_APORT_NAME;
	                  break;
	          case 1: portName = BU_BPORT_NAME;
	                  break;
	          case 2: portName = BU_CPORT_NAME;
	                  break;
	          default:break;
	      }
	      
	      $(portName.toLowerCase() + "Elec1").checked = false;
	      $(portName.toLowerCase() + "Elec2").checked = false;
	      $(portName.toLowerCase() + "Elec0").checked = false;
	      
	      $(portName.toLowerCase() + "Elec" + dirObj[portName]).checked = true;	      
	  }
    
}

/************************************* 
 *                
****************************************/
function setMainBridgeRedio(mainBridge)
{
	  $("connect3").checked = false;
	  $("connect2").checked = false;
	  $("connect1").checked = false;
	  
    switch(mainBridge)
    {
        case PRIMARY_LINE_AB: $("connect1").checked = true;
                              break;
        case PRIMARY_LINE_AC: $("connect2").checked = true;
                              break;
        case PRIMARY_LINE_BC: $("connect3").checked = true;
                              break;
        default:return;
    }
}
