 /**********************
 * BU        
***********************/
var HASNOT_E2E_LICENCE = 0;//     licence
var HAS_E2E_LICENCE = 1;//    licence

var ISNOT_E2E_FUNCTION = 0;//  E2E  
var IS_E2E_FUNCTION = 1;// E2E  

var ELECDIRECTION_NONE = 0;//BU     
var ELECDIRECTION_LEFT = 1;//      
var ELECDIRECTION_RIGHT = 2;//      
var ELECDIRECTION_UP = 3;//      
var ELECDIRECTION_DOWN = 4;//      

var ELECDIRECTION_IN = 1;//     
var ELECDIRECTION_OUT = 2;//     

var BU_APORT_NAME = "A";
var BU_BPORT_NAME = "B";
var BU_CPORT_NAME = "C";

var BU_TYPE_OADM = "1";
var BU_TYPE_FP = "2";

var BU_TYPE_ARR = new Object();
BU_TYPE_ARR[BU_TYPE_OADM] = "OADM BU";
BU_TYPE_ARR[BU_TYPE_FP] = "FP BU";

var PRIMARY_LINE_AB = "1";//AB       
var PRIMARY_LINE_AC = "2";//AC       
var PRIMARY_LINE_BC = "3";//BC       
var PRIMARY_LINE_NONE = "0";//BU     

var SLM_NETYPE = "61";
var PFE_NETYPE = "72";

var NSERR_MARINE_BU_EXIST = "1090615074";

var BU_MAC_MINVALUE = parseInt("0x01", 16);
var BU_MAC_MAXVALUE = parseInt("0x1f", 16);
var BU_MAC_MAXLENGTH = 2;

var PAGE_ATTR_CREATE = "0";
var PAGE_ATTR_MODIFY = "1";
var PAGE_ATTR_MODIFYLINEONLY = "2";


var BU_CONTROLEND_SRC = "0";
var BU_CONTROLEND_SNK = "1";
var BU_CONTROLEND_BOTH = "2";

/**********************
 * BU      
***********************/
var hasE2ELicence = HASNOT_E2E_LICENCE;
var isE2EFunction = ISNOT_E2E_FUNCTION;

/********************************
 * BU        =1   =2
************************************/
var BU_SWITCHMODE_INSERVICE = 1;
var BU_SWITCHMODE_OUTOFSERVICE = 2;

/**************************************
 * BU          =1    =0
***************************************/
var BU_SWITCH_CHECK = 1;
var BU_SWITCH_NOTCHECK = 0;

/**************************************
 * BU            =0    =1
***************************************/
var BU_SWITCH_VOTAGE_CHECK = 0;
var BU_SWITCH_VOTAGE_NOTCHECK = 1;

/**************************************
 *          
 *    =0   =1    =2   =3
***************************************/
var MALFUNCTYPE_NONE = 0;
var MALFUNCTYPE_SHORT = 1;
var MALFUNCTYPE_BYPASS = 2;
var MALFUNCTYPE_CARVE = 3;

/**********************
 *     
 **********************/
var refreshBindType = new Object();
refreshBindType["1"] = "bindstate";
refreshBindType["0"] = "unbindstate";

/**********************
 *      
 **********************/
var refreshbucontrolpointType = new Object();
refreshbucontrolpointType["0"] = "bcpsrc";
refreshbucontrolpointType["1"] = "bcpsnk";
refreshbucontrolpointType["2"] = "bcpsrcsnk";

var set = "UNKNOWN";
var SHORT_TAG = "-";

/**************************************************************
 *   BU
 * @param buName BU  
 * @param neid 
 *  buName neid         BU           
 *  buName      neid   BU
 *  neid         buName BU
*****************************************************************/
function queryBU(buName, neid)
{
    var xmldata = createQueryBUXML(buName, neid);
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BU + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleQueryBU, null, "inputdata=" + xmldata);//      
}

/********************
 *   BU     
********************/
function createQueryBUXML(buName, neid)
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    if(null != neid)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "neid");
        thirdlevel.setAttribute("value", neid);
        secondlevel.appendChild(thirdlevel);//        
    }
    
    if(null != buName)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "buname");
        thirdlevel.setAttribute("value", buName);
        secondlevel.appendChild(thirdlevel);//        
    }
    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/**************
 * BU  
****************/
function BUObject()
{
    this.name = "";
    this.type = "";
    this.macAddr = "";
    this.pressure = "";
    this.primaryLine = "";
    this.lastOperTime = "";
    this.bondLineList = new Array();
    this.portList = new Object();
    this.posX = -1;
    this.posY = -1;
}

BUBindLine.prototype.toString = function()
{
	var oneLineStr = "";
	oneLineStr += this.lineID + ",";
	oneLineStr += this.srcNEID + ",";    	
	oneLineStr += this.srcLmuSlotID + ",";
	oneLineStr += this.srcLmuPortID + ",";
	oneLineStr += this.srcLmiSlotID+ ",";
	oneLineStr += this.srcLmiPortID + ",";
	oneLineStr += this.snkNEID + ",";
	oneLineStr += this.snkLmuSlotID + ",";
	oneLineStr += this.snkLmuPortID + ",";
	oneLineStr += this.snkLmiSlotID + ",";
	oneLineStr += this.snkLmiPortID + ",";
	oneLineStr += this.direction + ",";
	oneLineStr += this.bucontrolpoint;
	
	return oneLineStr;
}
/**
 * BU       
 */
function BUBindLine()
{	
	this.lineID = 0;	
	this.srcNEID = 0;
	this.srcNEName = "";
	this.srcLmuSlotID = 0;
	this.srcLmuPortID = 0;
	this.srcLmiSlotID = 0;
	this.srcLmiPortID = 0;
	this.snkNEID = 0;
	this.snkNEName = "";
	this.snkLmuSlotID = 0;
	this.snkLmuPortID = 0;
	this.snkLmiSlotID = 0;
	this.snkLmiPortID = 0;
	this.direction = 0;
	this.bucontrolpoint = 0; //      ="0"   ="1"   ="2"
	
}

/**************************
 *   BU    ID   
****************************/
BUBindLine.prototype.getLineIDString = function()
{
	  var lineIDString = "";
	  
	  if(null == this.srcNEID || "undefined" == this.srcNEID)
    {
        lineIDString += UNKNOWN + SHORT_TAG;
    }
    else if(0 != this.srcNEID || (null != this.srcNEID && "undefined" != this.srcNEID && 0 != this.srcNEID))
    {
    	  lineIDString += this.srcNEName + SHORT_TAG;
    }
    
    if(null == this.snkNEID || "undefined" == this.snkNEID)
    {
        lineIDString += UNKNOWN + SHORT_TAG;
    }
    else if(0 != this.snkNEID || (null != this.snkNEID && "undefined" != this.snkNEID && 0 != this.snkNEID))
    {
        lineIDString += this.snkNEName + SHORT_TAG;
    }
    
    lineIDString += this.lineID;
    return lineIDString;
    
}


/**************
 * BU     
****************/
function BUPortObject()
{
    this.portName = "";
    this.bondSLM = "-1";
    this.bondPFE = "-1";
    this.isEarth = "0";
    this.elecDirection = "0";
    this.bondBondPFEName = "";
}

/******************
 * BU       
********************/
function BUBondLineObject()
{
    this.lineId = -1;
    this.controlPart = -1;
}

/**********************
 * BU Mac      
***********************/
function checkMacInput(obj)
{
    if(null == obj)
    {
        return;
    }
    
    obj.onkeypress = keyPressCheckMac;
    obj.onblur = onblurCheckMac;
}

/************************************
 * BU Mac        16   
************************************/
function keyPressCheckMac()
{
	  var event = EventUtil.getEvent();
	  if (event.keyCode == 37 || event.keyCode == 39 || event.keyCode == 8)
	  {
	      return true;
	  }
    var code = event.keyCode != 0 ? event.keyCode : event.charCode;
	  var ch = String.fromCharCode(code);
	  
	  var pattern = /^[a-f,A-F,0-9]$/;
	  var checker = pattern.test(ch);
	  
	  if(!checker)
	  {
	      return false;
	  }
	  
	  return true;
}

/************************************
 * BU Mac     onblur    
************************************/
function onblurCheckMac(obj)
{
	  var checkObj;
	  if(isIE)
	  {
	  	  checkObj = obj;
	  }
	  else
	  {
	      checkObj = obj.srcElement;
	      if(checkObj == null)
	      {
	          checkObj = obj;
	      }
	  }

	  if(null == checkObj)
	  {
	      checkObj = this;
	  }
	  
	  if(checkObj.value == "")
	  {
	      return;
	  }
	  
    var inputValue = checkObj.value;
    var pattern = /^[a-f,A-F,0-9]{2}$/;
    var checker = pattern.test(inputValue);
    
    if(!checker)
    {
        alert(RESOURCE["wrongmacaddr"]);
        checkObj.value = "";
        checkObj.focus();
        return false;
    }
    
    var inputNum = parseInt("0x" + inputValue, 16);
    if(inputNum > BU_MAC_MAXVALUE || inputNum < BU_MAC_MINVALUE)
    {
        alert(RESOURCE["wrongmacaddr"]);
        checkObj.value = "";
        checkObj.focus();
        return false;
    }
    
    return true;
}

/************************************
 * BU        
************************************/
function checkBuNameInput(obj)
{
	  var checkObj = obj;
	  if(null == checkObj)
	  {
	      checkObj = this;
	  }
	  
	  var pattern = /^[a-z,A-Z,0-9]{1,8}$/;
	  var checker = pattern.test(checkObj.value);
	  
	  if(!checker)
	  {
	     alert(RESOURCE["wrongbuname"]);
	     return false;
	  }
	  
	  return true;
}

/*************
 *   BU
***************/
function setBUInfo(closePgeFlg, modifyFlg, sfid)
{	
    var xmldata = createAddBuXML(modifyFlg);

    var argArr = new Array();
    argArr[0] = closePgeFlg;
    argArr[1] = modifyFlg;
    
    if(null == sfid)
    {
        sfid = TECMDCODE_CREATE_BU;
    }
    var url = "../../../../neExlorerServlet?sfid=" + sfid + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleCreateBU, argArr, "inputdata=" + xmldata);//      
}

/**************************
 *     BU xml   
****************************/
function createAddBuXML(modifyFlg)
{
	  var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buObject.name);
    secondlevel.appendChild(thirdlevel);//        
    
    if (PAGE_ATTR_MODIFYLINEONLY != pageAttribute)
    {
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "type");
	    thirdlevel.setAttribute("value", buObject.type);
	    secondlevel.appendChild(thirdlevel);//        
    	   
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "macaddr");
	    thirdlevel.setAttribute("value", "0x" + buObject.macAddr);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "pressure");
	    thirdlevel.setAttribute("value", buObject.pressure);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "aportname");
	    thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].portName);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "bportname");
	    thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].portName);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "cportname");
	    thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].portName);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "abondslm");
	    thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].bondSLM);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "bbondslm");
	    thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].bondSLM);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "cbondslm");
	    thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].bondSLM);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "abondpfe");
	    thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].bondPFE);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "abondpfename");
	    thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].bondBondPFEName);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "bbondpfe");
	    thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].bondPFE);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "bbondpfename");
	    thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].bondBondPFEName);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "cbondpfe");
	    thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].bondPFE);
	    secondlevel.appendChild(thirdlevel);//        
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "cbondpfename");
	    thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].bondBondPFEName);
	    secondlevel.appendChild(thirdlevel);//        
    }   
    if (PAGE_ATTR_MODIFYLINEONLY == pageAttribute)
    {
    	  thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "ismodifyline");
        thirdlevel.setAttribute("value", "1");
        secondlevel.appendChild(thirdlevel);//        
    }    	
    
    var bindLineList = buObject.bondLineList;        
    var lineLength = bindLineList.length;
    if (0 < lineLength)
    {
    	  var linesstr = "";//     -           ,   
        for (var index=0; index<lineLength; index++)
        {        	
        	  var bline = bindLineList[index];
        	  
        	  var oneLineStr = "";
        	  oneLineStr += bline.lineID + ",";
        	  oneLineStr += bline.srcNEID + ",";    	
        	  oneLineStr += bline.srcLmuSlotID + ",";
        	  oneLineStr += bline.srcLmuPortID + ",";
        	  oneLineStr += bline.srcLmiSlotID+ ",";
        	  oneLineStr += bline.srcLmiPortID + ",";
        	  oneLineStr += bline.snkNEID + ",";
        	  oneLineStr += bline.snkLmuSlotID + ",";
        	  oneLineStr += bline.snkLmuPortID + ",";
        	  oneLineStr += bline.snkLmiSlotID + ",";
        	  oneLineStr += bline.snkLmiPortID + ",";
        	  oneLineStr += bline.direction + ",";
        	  oneLineStr += bline.bucontrolpoint;        	
        	          	
        	  linesstr += oneLineStr;
        	  if (index != lineLength-1)
        	  {
        	  	linesstr += ";";
        	  }
        }
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "bindLines");
        thirdlevel.setAttribute("value", linesstr);
        secondlevel.appendChild(thirdlevel);//        
    }
    
    if(modifyFlg)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "modify");
        thirdlevel.setAttribute("value", 1);
        secondlevel.appendChild(thirdlevel);//        
    }
    
    if(pageAttribute == PAGE_ATTR_CREATE)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "aelecdir");
        thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].elecDirection);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "belecdir");
        thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].elecDirection);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "celecdir");
        thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].elecDirection);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "mainbridge");
        thirdlevel.setAttribute("value", buObject.primaryLine);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "aisearth");
        thirdlevel.setAttribute("value", buObject.portList[BU_APORT_NAME].isEarth);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "bisearth");
        thirdlevel.setAttribute("value", buObject.portList[BU_BPORT_NAME].isEarth);
        secondlevel.appendChild(thirdlevel);//        
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "cisearth");
        thirdlevel.setAttribute("value", buObject.portList[BU_CPORT_NAME].isEarth);
        secondlevel.appendChild(thirdlevel);//        
    }
    
    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/**************************
 *           
****************************/
function handleCreateBU(doc, argArr)
{	
	  var data = EncapsulateData(doc);//          
	  if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	  {
	  	  if(null != win.selectBUName)
	  	  {
	  	      win.selectBUName = buObject.name;
	  	  }
	  	  
	  	  win.queryBU(null, neid);
	  	  
	  	  setPageStatus();	  	  
	  }
	  
	  if(0 == data.getSErrorCode() && argArr[0])
	  {
	  	  if(!argArr[1])
	  	  {
	          sunWin.closeWin();
	      }
	      else
	      {
	          closeWin();
	      }
	      
	      setPageStatus();
	  }	  
	  if(pageAttribute != PAGE_ATTR_CREATE)
	  {
		    refreshBindLineTableStatus(data);
	  }
	  if(NSERR_MARINE_BU_EXIST == data.getSErrorCode())
	  {
	      if(confirm(RESOURCE["buisalreadyexist"]))
	      {
	          setBUInfo(argArr[0], true, TECMDCODE_CREATE_BU);
	      }
	  }
	  else
	  {
	      var errArr = [];//              
        errArr.push("buname");
        sunWin.openErrPage("../../../../page/", data.getError(), errArr);//         
    }	  
}

/*************
 *   BU  
***************/
function queryBUStatus()
{
    var xmldata = createQueryBUStatusXML();
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_BUSTATUS + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleQueryBUStatus, null, "inputdata=" + xmldata);//      
}

/********************
 *     BU  xml
**********************/
function createQueryBUStatusXML()
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "buname");
    thirdlevel.setAttribute("value", buName);
    secondlevel.appendChild(thirdlevel);//        

    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}

/*******************************************************************************
 *       
 ******************************************************************************/
function NeObj()
{
    this.neid = "-1";
    this.nename = "--";
}

/*******************************************************************************
 *           
 ******************************************************************************/
NeObj.prototype.equals = function(obj)
{
    if(!obj)
    {
        return false;
    }
    
    if(obj.neid && obj.nename && this.neid == obj.neid && this.nename == obj.nename)
    {
        return true;
    }
    
    return false;
}

/***********************************
 *               
 ***********************************/
function convertLineData(data)
{
	   var row;
     for(var i = 0, len = data.getDataRowLength(); i < len; i++)
     {
         row = data.getDataRow(i);
         row["lineIDStr"] = getShowLineIDStr(row);
         row["srcLmu"] = getShowPortInfo(row, "src", "Lmu");
         row["srcLmi"] = getShowPortInfo(row, "src", "Lmi");
         row["sinkLmu"] = getShowPortInfo(row, "sink", "Lmu");
         row["sinkLmi"] = getShowPortInfo(row, "sink", "Lmi");
     }
}

/***********************************
 *     ID
 ***********************************/
function getShowLineIDStr(row)
{
    var srcLmuneid = row["srcLmuneid"];
    var sinLmineid = row["sinkSaveSrcLmineid"];
    
    var lineIDStr = "";
    if(null == srcLmuneid || "undefined" == srcLmuneid)
    {
        lineIDStr += UNKNOWN + SHORT_TAG;
    }
    else if(0 != srcLmuneid.value || (null != sinLmineid && "undefined" != sinLmineid && 0 != sinLmineid.value))
    {
        lineIDStr += ("" == row["srcLmuNeName"].value) ? "" : row["srcLmuNeName"].value + SHORT_TAG;
    }
    
    var sinLmuneid = row["sinkLmuneid"];
    var srcLmineid = row["srcSaveSinkLmineid"];
    if(null == sinLmuneid || "undefined" == sinLmuneid)
    {
        lineIDStr += UNKNOWN + SHORT_TAG;
    }
    else if(0 != sinLmuneid.value || (null != srcLmineid && "undefined" != srcLmineid && 0 != srcLmineid.value))
    {
        lineIDStr += ("" == row["sinkLmuNeName"].value) ? "" : row["sinkLmuNeName"].value + SHORT_TAG;
    }
    
    lineIDStr += row["lineID"].value;
    
    var ptag = new ParamTag();
    ptag.value = lineIDStr;
    
    return ptag;
}

/***********************************
 *     Lmu
 ***********************************/
function getShowPortInfo(row, endStr, bdName)
{   
    var bdneid = row[endStr + bdName + "neid"];
    
    var oppBdCellName = ("src" == endStr) ? "sinkSaveSrc" : "srcSaveSink";
    oppBdCellName += "Lmi" + "neid";
    var oppBdneid = row[oppBdCellName];
    
    var srcLmu = "";
    var retStr = "";
    var ptag = new ParamTag();
    
    if(null == bdneid || "undefined" == bdneid)
    {
        retStr = SHORT_TAG;
    }
    else if(0 != bdneid.value)
    {
        retStr = row[endStr + bdName + "NeName"].value + SHORT_TAG + row[endStr + bdName + "SlotId"].value 
        + SHORT_TAG + row[endStr + bdName + "BoardName"].value + SHORT_TAG + row[endStr + bdName +  "PortName"].value;
    }
    else
    {
        retStr = (null != oppBdneid && "undefined" != oppBdneid && 0 != oppBdneid.value) ?
              RESOURCE["theThirdDevice"] : SHORT_TAG;
    }
    
    ptag.value = retStr;
    return ptag;
}

/**************************************************************
 *   PFE  
*****************************************************************/
function getBondPFEPolarity(pfeList)
{
	  if(pfeList[BU_APORT_NAME] == "--" && pfeList[BU_BPORT_NAME] == "--" && pfeList[BU_CPORT_NAME] == "--")
	  {
	      return;
	  }
    var xmldata = createQueryPFEPolarityXML(pfeList);
    var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PFE_POLARITY + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, handleQueryPFEPolarity, null, "inputdata=" + xmldata);//      
}

/****************************
 *     PFE     
*****************************/
function createQueryPFEPolarityXML(pfeList)
{
    var root = new inputxml("datainterface"); //    datainterface    
    var firstlevel = new tagElement("bussiness-params"); //                    
    var secondlevel = new tagElement("row-params"); //         
    if(null != neid)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "neid");
        thirdlevel.setAttribute("value", neid);
        secondlevel.appendChild(thirdlevel);//        
    }
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "abondpfe");
    thirdlevel.setAttribute("value", pfeList[BU_APORT_NAME]);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "bbondpfe");
    thirdlevel.setAttribute("value", pfeList[BU_BPORT_NAME]);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "cbondpfe");
    thirdlevel.setAttribute("value", pfeList[BU_CPORT_NAME]);
    secondlevel.appendChild(thirdlevel);//        

    firstlevel.appendChild(secondlevel); //                                
    root.getRoot().appendChild(firstlevel); //                             
    return root.toString(); //    
}
