/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.otdr.sor.TEOTDRBlock;
import com.huawei.nglct.otdr.sor.TEOTDRChecksumBlock;
import com.huawei.nglct.otdr.sor.TEOTDRMapBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEOTDRTraceInfo {
    private String fileName = null;
    private Map<String, TEOTDRBlock> blockMap = new HashMap<String, TEOTDRBlock>();

    TEOTDRTraceInfo() {
    }

    public TEOTDRBlock getBlock(String blockID) {
        return this.blockMap.get(blockID);
    }

    List<TEOTDRBlock> getAllExceptMapBlock() {
        ArrayList<TEOTDRBlock> blockList = new ArrayList<TEOTDRBlock>();
        Collection<TEOTDRBlock> allBlocks = this.blockMap.values();
        for (TEOTDRBlock block : allBlocks) {
            if ("Map".equals(block.getBlockID())) continue;
            blockList.add(block);
        }
        return blockList;
    }

    boolean containsBlock(String blockID) {
        return this.blockMap.containsKey(blockID);
    }

    void addBlock(TEOTDRBlock block) {
        this.blockMap.put(block.getBlockID(), block);
    }

    List<TEOTDRBlock> getBlockContainedInMap() {
        TEOTDRMapBlock mapBlock = (TEOTDRMapBlock)this.blockMap.get("Map");
        if (null == mapBlock) {
            return new ArrayList<TEOTDRBlock>();
        }
        return mapBlock.getBlocksInfo();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.blockMap == null ? 0 : ((Object)this.blockMap).hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEOTDRTraceInfo other = (TEOTDRTraceInfo)obj;
        if (this.blockMap == null ? other.blockMap != null : !((Object)this.blockMap).equals(other.blockMap)) {
            return false;
        }
        return !(this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getTraceFileCheckSum() {
        TEOTDRChecksumBlock checkSumBlock = (TEOTDRChecksumBlock)this.getBlock("Cksum");
        return checkSumBlock.getCheckSum();
    }
}

