/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.otdr.sor.TEOTDRBlock;
import com.huawei.nglct.otdr.sor.TEOTDRBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRIOUtility;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMRepeaterInfo;

public class TEOTDRSLMParametersBlockInterpreter
implements TEOTDRBlockInterpreter {
    @Override
    public TEOTDRBlock buildBlock(byte[] data, int offset) {
        TEOTDRSLMParametersBlock block = new TEOTDRSLMParametersBlock();
        String blockID = TEOTDRIOUtility.readString(data, offset);
        block.setBlockID(blockID);
        String fileType = TEOTDRIOUtility.readFixedLengthString(data, offset += blockID.getBytes().length + 1, 2);
        block.setFileType(fileType);
        String monitorMode = TEOTDRIOUtility.readFixedLengthString(data, offset += 2, 2);
        block.setMonitorType(monitorMode);
        int monitorOpticalPower = TEOTDRIOUtility.readInt(data, offset += 2);
        block.setMonitorOpticalPower(monitorOpticalPower);
        int receiveOpticalPower = TEOTDRIOUtility.readInt(data, offset += 4);
        block.setReceiveOpticalPower(receiveOpticalPower);
        int slmPulseWidth = TEOTDRIOUtility.readInt(data, offset += 4);
        block.setSlmPulseWidth(slmPulseWidth);
        long sampleRate = TEOTDRIOUtility.readUnsignedLong(data, offset += 4);
        block.setSampleRate(sampleRate);
        String codeType = TEOTDRIOUtility.readFixedLengthString(data, offset += 4, 2);
        block.setCodeType(codeType);
        short numberOfCodeBits = TEOTDRIOUtility.readShort(data, offset += 2);
        block.setNumberOfCodeBits(numberOfCodeBits);
        String filterMethod = TEOTDRIOUtility.readFixedLengthString(data, offset += 2, 2);
        block.setFilterMethod(filterMethod);
        long lengthCoefficient = TEOTDRIOUtility.readUnsignedLong(data, offset += 2);
        block.setLengthCoefficient(lengthCoefficient);
        int totalNumberOfSpan = TEOTDRIOUtility.readShort(data, offset += 4);
        block.setSpanCount((short)totalNumberOfSpan);
        offset += 2;
        TEOTDRSLMRepeaterInfo repeatorInfo = null;
        for (int i = 0; i < totalNumberOfSpan; ++i) {
            repeatorInfo = this.readRepeaterInfo(data, offset);
            offset += repeatorInfo.getSize();
            block.addRepeatorInfo(repeatorInfo);
        }
        return block;
    }

    @Override
    public byte[] reBuildBlock(TEOTDRBlock block) {
        return null;
    }

    private TEOTDRSLMRepeaterInfo readRepeaterInfo(byte[] data, int offset) {
        TEOTDRSLMRepeaterInfo repeaterInfo = new TEOTDRSLMRepeaterInfo();
        short spanID = TEOTDRIOUtility.readShort(data, offset);
        repeaterInfo.setSpanID(spanID);
        int spanLength = TEOTDRIOUtility.readInt(data, offset += 2);
        repeaterInfo.setSpanLength(spanLength);
        short norminalAttenuationCoefficient = TEOTDRIOUtility.readShort(data, offset += 4);
        repeaterInfo.setNorminalAttenuationCoefficient(norminalAttenuationCoefficient);
        int refractiveIndex = TEOTDRIOUtility.readInt(data, offset += 2);
        repeaterInfo.setRefractiveIndex(refractiveIndex);
        String fiberType = TEOTDRIOUtility.readString(data, offset += 4);
        repeaterInfo.setFiberType(fiberType);
        long repeatorPosition = TEOTDRIOUtility.readUnsignedLong(data, offset += fiberType.getBytes().length + 1);
        repeaterInfo.setRepeatorTransferTime(repeatorPosition);
        long repeatorGain = TEOTDRIOUtility.readUnsignedLong(data, offset += 4);
        repeaterInfo.setRepeatorGain(repeatorGain);
        long repeatorPeakPower = TEOTDRIOUtility.readUnsignedLong(data, offset += 4);
        repeaterInfo.setRepeatorPeakPower(repeatorPeakPower);
        short fiberLossCoefficient = TEOTDRIOUtility.readShort(data, offset += 4);
        repeaterInfo.setFiberLossCoefficient(fiberLossCoefficient);
        offset += 2;
        return repeaterInfo;
    }
}

