/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.otdr.sor.TEOTDRBlock;
import com.huawei.nglct.otdr.sor.TEOTDRBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDREvent;
import com.huawei.nglct.otdr.sor.TEOTDRIOUtility;
import com.huawei.nglct.otdr.sor.TEOTDRKeyEventsBlock;
import java.util.ArrayList;

public class TEOTDRKeyEventsBlockInterpreter
implements TEOTDRBlockInterpreter {
    @Override
    public TEOTDRBlock buildBlock(byte[] data, int offset) {
        TEOTDRKeyEventsBlock block = new TEOTDRKeyEventsBlock();
        ArrayList<TEOTDREvent> eventList = new ArrayList<TEOTDREvent>();
        String blockID = TEOTDRIOUtility.readString(data, offset);
        block.setBlockID(blockID);
        int numberOfKeyEvents = TEOTDRIOUtility.readShort(data, offset += blockID.getBytes().length + 1);
        block.setEventCount((short)numberOfKeyEvents);
        offset += 2;
        TEOTDREvent event = null;
        int i = 0;
        for (i = 0; i < numberOfKeyEvents; ++i) {
            event = this.readEvent(data, offset);
            eventList.add(event);
            offset += event.getSize();
        }
        block.setEvents(eventList);
        block.setEndtoEndLoss(TEOTDRIOUtility.readLong(data, offset));
        block.setStartEndtoEndMarkerPositions(TEOTDRIOUtility.readLong(data, offset += 4));
        block.setFinishEndtoEndMarkerPositions(TEOTDRIOUtility.readLong(data, offset += 4));
        block.setOpticalReturnLoss(TEOTDRIOUtility.readShort(data, offset += 4));
        block.setStartOpticalReturnLossMarkerPosition(TEOTDRIOUtility.readLong(data, offset += 2));
        block.setFinishOpticalReturnLossMarkerPosition(TEOTDRIOUtility.readLong(data, offset += 4));
        offset += 4;
        return block;
    }

    private TEOTDREvent readEvent(byte[] data, int pos) {
        TEOTDREvent event = new TEOTDREvent();
        event.setEventIndexID(TEOTDRIOUtility.readShort(data, pos));
        event.setPropagationTime(TEOTDRIOUtility.readLong(data, pos += 2));
        event.setAttenuationCoefficientLeadFib(TEOTDRIOUtility.readShort(data, pos += 4));
        event.setEventLoss(TEOTDRIOUtility.readShort(data, pos += 2));
        event.setEventReflectance(TEOTDRIOUtility.readLong(data, pos += 2));
        event.setEventCode(TEOTDRIOUtility.readFixedLengthString(data, pos += 4, 6));
        event.setLossMeasurementTechnique(TEOTDRIOUtility.readFixedLengthString(data, pos += 6, 2));
        pos += 2;
        long[] markLocations = new long[5];
        for (int i = 0; i < 5; ++i) {
            markLocations[i] = TEOTDRIOUtility.readLong(data, pos);
            pos += 4;
        }
        event.setMarkerLocations(markLocations);
        event.setComment(TEOTDRIOUtility.readString(data, pos));
        return event;
    }

    @Override
    public byte[] reBuildBlock(TEOTDRBlock block) {
        return null;
    }
}

