/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;

final class TEOTDRIOUtility {
    private TEOTDRIOUtility() {
    }

    static byte[] stringToByteWithEnd(String str) {
        if (null == str) {
            return null;
        }
        byte[] strBytes = str.getBytes();
        int strBytesLen = strBytes.length;
        byte[] byteArray = new byte[strBytesLen + 1];
        System.arraycopy(strBytes, 0, byteArray, 0, strBytesLen);
        byteArray[strBytesLen - 1] = 0;
        return byteArray;
    }

    static byte[] stringToByteNoEnd(String str) {
        if (null == str) {
            return null;
        }
        return str.getBytes();
    }

    static byte[] toByteArray(long l) {
        byte[] byteArray = new byte[4];
        int n = (int)l;
        byteArray[0] = (byte)n;
        byteArray[1] = (byte)(n >>> 8);
        byteArray[2] = (byte)(n >>> 16);
        byteArray[3] = (byte)(n >>> 24);
        return byteArray;
    }

    static byte[] toByteArray(int n) {
        byte[] byteArray = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        return byteArray;
    }

    static byte[] toByteArray(short n) {
        byte[] byteArray = new byte[]{(byte)n, (byte)(n >>> 8)};
        return byteArray;
    }

    static short readShort(byte[] data, int pos) {
        int b1 = TEOTDRIOUtility.readUnsignedByte(data[0 + pos]);
        int b2 = TEOTDRIOUtility.readUnsignedByte(data[1 + pos]);
        return (short)((b2 << 8) + b1);
    }

    static int readInt(byte[] data, int pos) {
        int a1 = TEOTDRIOUtility.readUnsignedByte(data[0 + pos]);
        int a2 = TEOTDRIOUtility.readUnsignedByte(data[1 + pos]);
        int a3 = TEOTDRIOUtility.readUnsignedByte(data[2 + pos]);
        int a4 = TEOTDRIOUtility.readUnsignedByte(data[3 + pos]);
        return (a4 << 24) + (a3 << 16) + (a2 << 8) + a1;
    }

    static String readString(byte[] data, int pos) {
        int length = 0;
        while (data[length + pos] != 0) {
            ++length;
        }
        byte[] buff = new byte[length];
        System.arraycopy(data, pos, buff, 0, length);
        return new String(buff);
    }

    static String readFixedLengthString(byte[] data, int pos, int length) {
        if (length > data.length - pos) {
            return null;
        }
        byte[] buff = new byte[length];
        System.arraycopy(data, pos, buff, 0, length);
        return new String(buff);
    }

    static long readLong(byte[] data, int pos) {
        return TEOTDRIOUtility.readInt(data, pos);
    }

    static int readUnsignedShort(byte[] data, int pos) {
        int ch1 = TEOTDRIOUtility.readUnsignedByte(data[0 + pos]);
        int ch2 = TEOTDRIOUtility.readUnsignedByte(data[1 + pos]);
        return (ch2 << 8) + (ch1 << 0);
    }

    static long readUnsignedLong(byte[] data, int pos) {
        byte[] b = new byte[]{data[3 + pos], data[2 + pos], data[1 + pos], data[0 + pos]};
        DataInputStream dstream = new DataInputStream(new ByteArrayInputStream(b));
        long result = -1L;
        try {
            result = dstream.readInt();
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEOTDRIOUtility.readUnsignedLong() fail!", (Throwable)e);
        }
        return result;
    }

    static final int readUnsignedByte(byte b) {
        return b >= 0 ? b : b + 256;
    }

    static String getTimeString(long time, int neid) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        cal.setTimeInMillis(time * 1000L);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        cal.set(year, month - 1, day, hour, minute, second);
        Logger log = TELogFactory.getNormalLogger();
        log.info("Marine OTDRUtility. cal: " + cal.toString());
        boolean isDST = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).changeCalendarToServerTime(cal);
        log.info("Marine OTDRUtility. cal: " + cal.toString());
        StringBuffer timeStr1 = new StringBuffer();
        int yearnew = cal.get(1);
        int monthnew = cal.get(2) + 1;
        int daynew = cal.get(5);
        int hournew = cal.get(11);
        int minutenew = cal.get(12);
        int secondnew = cal.get(13);
        timeStr1.append(yearnew).append("-");
        timeStr1.append(monthnew >= 10 ? String.valueOf(monthnew) : "0" + monthnew).append("-");
        timeStr1.append(daynew >= 10 ? String.valueOf(daynew) : "0" + daynew).append(" ");
        timeStr1.append(hournew >= 10 ? String.valueOf(hournew) : "0" + hournew).append(":");
        timeStr1.append(minutenew >= 10 ? String.valueOf(minutenew) : "0" + minutenew).append(":");
        timeStr1.append(secondnew >= 10 ? String.valueOf(secondnew) : "0" + secondnew);
        if (isDST) {
            timeStr1.append("DST");
        }
        String nmFileTime = timeStr1.toString();
        return nmFileTime;
    }
}

