/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMFileDataMgr;
import com.huawei.nglct.otdr.sor.TEOTDRBlock;
import com.huawei.nglct.otdr.sor.TEOTDRBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRChecksumBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRCustomBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRDataConvertor;
import com.huawei.nglct.otdr.sor.TEOTDRDataPointsBlock;
import com.huawei.nglct.otdr.sor.TEOTDRDataPointsBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRFixedParametersBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRGeneralParametersBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRKeyEventsBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRLinkParametersBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRMapBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRSLMExtendData;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlockInterpreterNew;
import com.huawei.nglct.otdr.sor.TEOTDRSLMRepeaterInfo;
import com.huawei.nglct.otdr.sor.TEOTDRSLMSpanExtendData;
import com.huawei.nglct.otdr.sor.TEOTDRSuppliersParametersBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRTraceInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEOTDRFileInterpreter {
    private static final double UNIT_REPEATORGAIN = 0.1;
    private static final int UNIT_REPEATERLOCATION = 1000;
    private static double LIGHT_SPEED = 2.99792458;
    private static final float SAMPLERATE_MUL = 0.1f;
    private static Map<String, TEOTDRBlockInterpreter> interpreterMap = null;
    private static Map<String, TEOTDRBlockInterpreter> interpreterMapNew = null;
    private static Logger log = TELogFactory.getNormalLogger();
    private static TEOTDRTraceInfo traceInfo = null;

    public static Object loadFileRepeatorContent(int logicNEID, String absFileName) {
        log.info("MARINE ---- BEGIN to loadFileRepeatorContent!");
        log.info("MARINE ---- fileName->" + absFileName);
        if (!TEOTDRFileInterpreter.checkFileType(absFileName)) {
            log.info("MARINE ---- check file type failed.");
            return null;
        }
        try {
            traceInfo = TEOTDRFileInterpreter.loadFileContent0(absFileName, logicNEID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRFileInterpreter.loadFileRepeatorContent() fail!", (Throwable)e);
        }
        if (null == traceInfo) {
            log.info("MARINE ---- failed to parse file. fileName->" + absFileName);
            return null;
        }
        TEOTDRSLMParametersBlock slmBlock = (TEOTDRSLMParametersBlock)traceInfo.getBlock("SpecProp");
        if (null != slmBlock) {
            List repeatorInfoList = slmBlock.getRepeatorInfoList();
            int spanCount = slmBlock.getSpanCount();
            int repeatorCount = spanCount - 1;
            TEOTDRSLMRepeaterInfo info = null;
            Object[][] dataArray = new Object[repeatorCount][];
            for (int i = 1; i < spanCount; ++i) {
                info = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(i);
                short spanID = info.getSpanID();
                long gain = info.getRepeatorGain();
                long repeaterLocation = info.getRealRptPosition();
                Object[] repeatorInfo = new Object[4];
                repeatorInfo[0] = String.valueOf(spanID - 1);
                repeatorInfo[1] = String.valueOf((double)gain * 0.1);
                int testMode = slmBlock.getMonitorType().charAt(0) == 'I' || slmBlock.getMonitorType().charAt(0) == 'i' ? 1 : 2;
                repeatorInfo[2] = String.valueOf((double)repeaterLocation / 1000.0);
                repeatorInfo[3] = String.valueOf(testMode);
                dataArray[i - 1] = repeatorInfo;
            }
            return dataArray;
        }
        return null;
    }

    public static Object loadFileContent(String absFileName, int logicNEID) {
        if (!TEOTDRFileInterpreter.checkFileType(absFileName)) {
            return null;
        }
        TEOTDRTraceInfo traceInfo = null;
        try {
            traceInfo = TEOTDRFileInterpreter.loadFileContent0(absFileName, logicNEID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
        }
        if (null == traceInfo) {
            return null;
        }
        File tmpFile = new File(absFileName);
        traceInfo.setFileName(tmpFile.getName());
        Object targetContent = null;
        try {
            targetContent = TEOTDRFileInterpreter.convertFileDataToApplicationData(traceInfo, logicNEID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("", (Throwable)e);
            targetContent = null;
        }
        return targetContent;
    }

    public static TEOTDRTraceInfo loadFileContent0(String absFileName, int logicNEID) throws Exception {
        byte[] fileContent = TEOTDRFileInterpreter.getFileBytesContent(absFileName);
        if (null == fileContent) {
            log.info("MARINE ---- failed to get file byte content.");
            return null;
        }
        return TEOTDRFileInterpreter.loadFileContent0(fileContent, logicNEID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytesContent(String absFileName) {
        log.info("MARINE ---- BEGIN to get file byte content.");
        log.info("MARINE ---- fileName->" + absFileName);
        byte[] fileContent = null;
        FileInputStream fis = null;
        BufferedInputStream bufIn = null;
        try {
            Object mutex;
            Object object = mutex = TESLMFileDataMgr.instance().acquireFileReadWriteLock(absFileName);
            synchronized (object) {
                int availableSize;
                block21: {
                    fis = new FileInputStream(absFileName);
                    bufIn = new BufferedInputStream(fis);
                    availableSize = bufIn.available();
                    if (availableSize > 0) break block21;
                    byte[] byArray = null;
                    return byArray;
                }
                fileContent = new byte[availableSize];
                if (bufIn.read(fileContent) == -1) {
                    log.info("MARINE ---- no content read.");
                }
                bufIn.close();
                mutex.notifyAll();
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != bufIn) {
                    bufIn.close();
                }
            }
            catch (IOException e) {
                log.error(e.toString());
            }
        }
        log.info("MARINE ---- END to get file byte content.");
        return fileContent;
    }

    private static TEOTDRTraceInfo loadFileContent0(byte[] fileContent, int logicNEID) {
        TEOTDRTraceInfo fileInfo = new TEOTDRTraceInfo();
        int byteIndex = 0;
        TEOTDRBlock block = null;
        String blockID = null;
        TEOTDRBlockInterpreter interpreter = null;
        int blockSize = -1;
        int blockNo = -1;
        TENE ne = TENEListMgr.getInstance().getNE(logicNEID);
        if (null == ne) {
            log.info("MARINE ---- ne not exists->" + logicNEID);
            return null;
        }
        String neVersion = ne.getHostVersion();
        String r2VersionMin = "5.61.02.01";
        blockID = "Map";
        boolean isR1Device = "5.61.02.01".compareToIgnoreCase(neVersion) > 0;
        interpreter = TEOTDRFileInterpreter.getInterActor(blockID, isR1Device);
        if (null == interpreter) {
            log.info("MARINE ---- get block interpreter. blockID->" + blockID);
            return null;
        }
        block = interpreter.buildBlock(fileContent, byteIndex);
        fileInfo.addBlock(block);
        byteIndex += block.getBlockSize();
        List<TEOTDRBlock> blockList = fileInfo.getBlockContainedInMap();
        TEOTDRBlock infoBlock2 = null;
        for (TEOTDRBlock infoBlock2 : blockList) {
            blockID = infoBlock2.getBlockID();
            blockNo = infoBlock2.getBlockNo();
            blockSize = infoBlock2.getBlockSize();
            log.info("MARINE ---- get block interpreter. blockID->" + blockID);
            interpreter = TEOTDRFileInterpreter.getInterActor(blockID, isR1Device);
            if (null == interpreter) {
                log.info("MARINE ---- can't find interpreter for block->" + blockID);
                interpreter = TEOTDRFileInterpreter.getInterActor("Custom", isR1Device);
                byte[] tmpArray = new byte[blockSize];
                System.arraycopy(fileContent, byteIndex, tmpArray, 0, tmpArray.length);
                block = interpreter.buildBlock(tmpArray, 0);
            } else {
                block = interpreter.buildBlock(fileContent, byteIndex);
            }
            byteIndex += blockSize;
            block.setBlockSize(blockSize);
            block.setBlockNo(blockNo);
            fileInfo.addBlock(block);
        }
        TEOTDRFileInterpreter.preProcessSlmBlock(fileInfo);
        return fileInfo;
    }

    private static void preProcessSlmBlock(TEOTDRTraceInfo traceInfo) {
        TEOTDRSLMParametersBlock slmBlock = (TEOTDRSLMParametersBlock)traceInfo.getBlock("SpecProp");
        TEOTDRDataPointsBlock dptsBlock = (TEOTDRDataPointsBlock)traceInfo.getBlock("DataPts");
        if (null == dptsBlock) {
            List repeatorInfoList = slmBlock.getRepeatorInfoList();
            Collections.sort(repeatorInfoList);
            TEOTDRSLMRepeaterInfo preSpanInfo = null;
            TEOTDRSLMSpanExtendData data = null;
            int sumPosition = 0;
            int size = repeatorInfoList.size();
            for (int i = 0; i < size; ++i) {
                TEOTDRSLMRepeaterInfo info = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(i);
                if (null == info) continue;
                data = new TEOTDRSLMSpanExtendData(info.getSpanID());
                if (null == preSpanInfo) {
                    data.setRealRptPosition(0);
                } else {
                    data.setRealRptPosition(sumPosition += preSpanInfo.getSpanLength());
                }
                data.setRealSpanLength(info.getSpanLength());
                info.setExtendData(data);
                preSpanInfo = info;
            }
            return;
        }
        int sampleRate = (int)((float)slmBlock.getSampleRate() * 0.1f);
        long timeBetweenTwoPoints = 5 / sampleRate * 1000;
        int dpCount = dptsBlock.getTotalPointCount();
        long totalTimeTransferLine = timeBetweenTwoPoints * (long)dpCount;
        int realLineLength = 0;
        List repeatorInfoList = slmBlock.getRepeatorInfoList();
        Collections.sort(repeatorInfoList);
        TEOTDRSLMRepeaterInfo preSpanInfo = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(0);
        TEOTDRSLMSpanExtendData data = null;
        long lastRepeaterTransferTime = 0L;
        int size = repeatorInfoList.size();
        for (int i = 1; i < size; ++i) {
            TEOTDRSLMRepeaterInfo info = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(i);
            long preRefractiveIndex = preSpanInfo.getRefractiveIndex();
            long repeatorTransferTime = info.getRepeatorTransferTime();
            long preRepeaterTransferTime = preSpanInfo.getRepeatorTransferTime();
            long realTransferTimeInPrespan = repeatorTransferTime - preRepeaterTransferTime;
            long l = lastRepeaterTransferTime = repeatorTransferTime <= 0L ? lastRepeaterTransferTime : repeatorTransferTime;
            if (repeatorTransferTime <= 0L) {
                realTransferTimeInPrespan = 0L;
            }
            int preRealSpanLength = (int)(1000.0 * LIGHT_SPEED * (double)realTransferTimeInPrespan / (double)preRefractiveIndex);
            int tmpRptPosition = realLineLength;
            if (repeatorTransferTime > 0L) {
                realLineLength += preRealSpanLength;
            }
            data = new TEOTDRSLMSpanExtendData(preSpanInfo.getSpanID());
            int pointIndex = (int)(preRepeaterTransferTime / timeBetweenTwoPoints);
            data.setPointIndex(pointIndex);
            data.setRealRptPosition(tmpRptPosition);
            int pointCount = (int)(realTransferTimeInPrespan / timeBetweenTwoPoints);
            data.setPointCount(pointCount);
            data.setRealSpanLength(preRealSpanLength);
            preSpanInfo.setExtendData(data);
            if (i == size - 1) {
                long timeInLastSpan = totalTimeTransferLine - lastRepeaterTransferTime;
                long refractiveIndexInLastSpan = info.getRefractiveIndex();
                int realSpanLenghInLastSpan = (int)(1000.0 * LIGHT_SPEED * (double)timeInLastSpan / (double)refractiveIndexInLastSpan);
                data = new TEOTDRSLMSpanExtendData(info.getSpanID());
                pointIndex = (int)(repeatorTransferTime / timeBetweenTwoPoints);
                data.setPointIndex(pointIndex);
                data.setRealRptPosition(realLineLength);
                realLineLength += realSpanLenghInLastSpan;
                pointCount = (int)(timeInLastSpan / timeBetweenTwoPoints);
                data.setPointCount(pointCount);
                data.setRealSpanLength(realSpanLenghInLastSpan);
                info.setExtendData(data);
                break;
            }
            preSpanInfo = info;
        }
        if (1 == repeatorInfoList.size()) {
            TEOTDRSLMRepeaterInfo info = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(0);
            long repeatorTransferTime = info.getRepeatorTransferTime();
            long timeInLastSpan = totalTimeTransferLine - lastRepeaterTransferTime;
            long refractiveIndexInLastSpan = info.getRefractiveIndex();
            int realSpanLenghInLastSpan = (int)(1000.0 * LIGHT_SPEED * (double)timeInLastSpan / (double)refractiveIndexInLastSpan);
            data = new TEOTDRSLMSpanExtendData(info.getSpanID());
            int pointIndex = (int)(repeatorTransferTime / timeBetweenTwoPoints);
            data.setPointIndex(pointIndex);
            data.setRealRptPosition(realLineLength);
            realLineLength += realSpanLenghInLastSpan;
            int pointCount = (int)(timeInLastSpan / timeBetweenTwoPoints);
            data.setPointCount(pointCount);
            data.setRealSpanLength(realSpanLenghInLastSpan);
            info.setExtendData(data);
        }
        TEOTDRSLMExtendData slmData = new TEOTDRSLMExtendData();
        slmData.setRealLineRange((double)realLineLength * 0.001);
        slmData.setTimeBetweenTwoPoints(timeBetweenTwoPoints);
        slmBlock.setExtendData(slmData);
    }

    private static Object convertFileDataToApplicationData(Object fileContent, int neid) throws Exception {
        return TEOTDRDataConvertor.convertFileDataToApplicationData(fileContent, neid);
    }

    private static synchronized void initInterpreterMap() {
        if (null != interpreterMap) {
            return;
        }
        interpreterMap = new HashMap<String, TEOTDRBlockInterpreter>();
        interpreterMap.put("Map", new TEOTDRMapBlockInterpreter());
        interpreterMap.put("GenParams", new TEOTDRGeneralParametersBlockInterpreter());
        interpreterMap.put("SupParams", new TEOTDRSuppliersParametersBlockInterpreter());
        interpreterMap.put("FxdParams", new TEOTDRFixedParametersBlockInterpreter());
        interpreterMap.put("KeyEvents", new TEOTDRKeyEventsBlockInterpreter());
        interpreterMap.put("LnkParams", new TEOTDRLinkParametersBlockInterpreter());
        interpreterMap.put("DataPts", new TEOTDRDataPointsBlockInterpreter());
        interpreterMap.put("Cksum", new TEOTDRChecksumBlockInterpreter());
        interpreterMap.put("SpecProp", new TEOTDRSLMParametersBlockInterpreter());
        interpreterMap.put("Custom", new TEOTDRCustomBlockInterpreter());
        interpreterMapNew = new HashMap<String, TEOTDRBlockInterpreter>();
        interpreterMapNew.putAll(interpreterMap);
        interpreterMapNew.put("SpecProp", new TEOTDRSLMParametersBlockInterpreterNew());
    }

    private static TEOTDRBlockInterpreter getInterActor(String blockID, boolean isR1Device) {
        TEOTDRBlockInterpreter interpreter = null;
        interpreter = !isR1Device ? interpreterMapNew.get(blockID) : interpreterMap.get(blockID);
        return interpreter;
    }

    private static boolean checkFileType(String absFileName) {
        boolean isValidFile;
        File file = new File(absFileName);
        if (!file.exists() || !file.isFile()) {
            log.info("MARINE ---- file does not exist!");
            log.info("MARINE ---- fileName->" + absFileName);
            return false;
        }
        int dotIndex = absFileName.lastIndexOf(".");
        String fileSuffix = absFileName.substring(dotIndex + 1);
        boolean bl = isValidFile = "sor".equalsIgnoreCase(fileSuffix) || "g".equalsIgnoreCase(fileSuffix);
        if (!isValidFile) {
            log.info("MARINE ---- file type is invalid. only .g or .sor will be valid.");
        }
        return isValidFile;
    }

    public static void main(String[] args) {
    }

    public static TEOTDRTraceInfo getTraceInfo() {
        return traceInfo;
    }

    static {
        log.info("MARINE ---- BEGIN to init interpreter!");
        TEOTDRFileInterpreter.initInterpreterMap();
        log.info("MARINE ---- END to init interpreter!");
    }
}

