/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.otdr.sor.TEOTDRBlock;
import com.huawei.nglct.otdr.sor.TEOTDRBlockInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRDataPointsBlock;
import com.huawei.nglct.otdr.sor.TEOTDRIOUtility;

public class TEOTDRDataPointsBlockInterpreter
implements TEOTDRBlockInterpreter {
    @Override
    public TEOTDRBlock buildBlock(byte[] data, int offset) {
        TEOTDRDataPointsBlock block = new TEOTDRDataPointsBlock();
        String id = TEOTDRIOUtility.readString(data, offset);
        block.setBlockID(id);
        int numberOfDataPoints = (int)TEOTDRIOUtility.readLong(data, offset += id.getBytes().length + 1);
        block.setTotalPointCount(numberOfDataPoints);
        int totalNumberScaleFactorsUsed = TEOTDRIOUtility.readShort(data, offset += 4);
        offset += 2;
        block.setScaleFactorCount((short)totalNumberScaleFactorsUsed);
        int[] dptsArray = new int[numberOfDataPoints];
        int arrayIndex = 0;
        for (int i = 0; i < totalNumberScaleFactorsUsed; ++i) {
            int totalDataPointsUsingScaleFactor = (int)TEOTDRIOUtility.readLong(data, offset);
            short scaleFactor = TEOTDRIOUtility.readShort(data, offset += 4);
            offset += 2;
            for (int j = 0; j < totalDataPointsUsingScaleFactor; ++j) {
                int dNumber = TEOTDRIOUtility.readUnsignedShort(data, offset);
                offset += 2;
                dptsArray[arrayIndex++] = dNumber *= scaleFactor * -1;
            }
        }
        block.setDptsArray(dptsArray);
        return block;
    }

    @Override
    public byte[] reBuildBlock(TEOTDRBlock block) {
        return null;
    }
}

