/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.sor;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineCableLineRptUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.sor.TEOTDRDataPointsBlock;
import com.huawei.nglct.otdr.sor.TEOTDREvent;
import com.huawei.nglct.otdr.sor.TEOTDRFixedParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRGeneralParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRIOUtility;
import com.huawei.nglct.otdr.sor.TEOTDRKeyEventsBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMLineDeviceInfo;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRSLMRepeaterInfo;
import com.huawei.nglct.otdr.sor.TEOTDRSuppliersParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRTraceInfo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class TEOTDRDataConvertor {
    private static final double LIGHT_SPEED = 2.99792458;
    private static final String LEFTENDXMLTAG = "</";
    private static final String RIGHTBRACKET = ">";
    private static final String XMLENDTAG = "/>";
    private static final String QUOTATIONMARK = "\"";
    private static final String EQUALMARK = "=";
    private static final String LEFTBRACKET = "<";
    private static final String BLANK_SPACE = " ";
    private static final String POINT = ".";
    private static final String PARAM_VALUE = "value";
    private static final String CURVINFO = "curvinfo";
    private static final String PARAM_NAME = "name";
    private static final String EVENT_LOCATION_IN_LINE = "eventLocationInLine";
    private static final String EVENT_LOCATION_IN_SPAN = "eventLocationInSpan";
    private static final String LOSS_MEASUREMENT_TECHNIQUE = "lossMeasurementTechnique";
    private static final String EVENT_CODE = "eventCode";
    private static final String EVENT_REFLECTANCE = "eventReflectance";
    private static final String EVENT_LOSS = "eventLoss";
    private static final String TOTAL_POINT_COUNT_STR = "totalPointCount";
    private static final String REPEATORTRANSFERTIME = "repeatortransfertime";
    private static final String ATTENUATION_COEFFICIENT_LEAD_FIB = "attenuationCoefficientLeadFib";
    private static final String PROPAGATION_TIME = "propagationTime";
    private static final String EVENT_INDEX_ID = "eventIndexID";
    private static final String FIBER_LOSS_COEFFICIENT = "fiberLossCoefficient";
    private static final String REPEATOR_PEAK_POWER = "repeatorPeakPower";
    private static final String REPEATOR_GAIN = "repeatorGain";
    private static final String REPEATER_LOCATION = "repeaterLocation";
    private static final String FIBER_TYPE = "fiberType";
    private static final String REFRACTIVE_INDEX = "refractiveIndex";
    private static final String LOSS_COEFFICIENT = "lossCoefficient";
    private static final String SPAN_LENGTH = "spanLength";
    private static final String SPANID = "spanid";
    private static final String DEVICEID = "deviceID";
    private static final String SPANIDOFDEVICE = "spanIDOfDevice";
    private static final String DEVICETYPE = "deviceType";
    private static final String DEVICEOFFSETFROMSPANSTARTPOINT = "deviceOffsetFromSpanStartPoint";
    private static final String DEVICENAME = "deviceName";
    private static final short DEVICETYPE_OEQ = 3;
    private static final String DEVICETYPE_OEQ_NAME = "OEQ";
    private static final String ERROR_SUCCESS_MSG = "<error-message errorcode=\"0\" errorinfo=\"\u00b2\u00d9\u00d7\u00f7\u00b3\u00c9\u00b9\u00a6\"/>";
    private static final String LENGTH_COEFFICIENT = "lengthCoefficient";
    private static final String FILTER_METHOD = "filterMethod";
    private static final String NUMBER_OF_CODE_BITS = "numberOfCodeBits";
    private static final String CODE_TYPE = "codeType";
    private static final String SAMPLE_RATE = "sampleRate";
    private static final String RECEIVE_OPTICAL_POWER = "receiveOpticalPower";
    private static final String MONITOR_OPTICAL_POWER = "monitorOpticalPower";
    private static final String MONITOR_TYPE = "monitorType";
    private static final String FILE_TYPE = "fileType";
    private static final String END_OF_FIBER_THRESHOLD = "endOfFiberThreshold";
    private static final String REFLECTANCE_THRESHOLD = "reflectanceThreshold";
    private static final String LOSS_THRESHOLD = "lossThreshold";
    private static final String MEASURE_RANGE_DISTANCE = "measureRangeDistance";
    private static final String PULSE_WIDTHS_USED = "pulseWidthsUsed";
    private static final String WAVELENGH = "waveLength";
    private static final String SAMPLE_TIMES = "sampleTimes";
    private static final String TESTDATE = "dateTimeStamp";
    private static final String SUPPLIER_NAME = "supplierName";
    private static final String COMMENT = "comment";
    private static final String REPEATERROWS = "repeaterrows";
    private static final String DEVICEROWS = "devicerows";
    private static final String REPEATERNAMES = "repeaternames";
    private static final String EVENTROWS = "eventrows";
    private static final String DATA_PTS_ROW_COUNT = "curveaxis";
    private static final String TEST_PARAM_ROW_COUNT = "curveparam";
    private static final String FILENAME = "filename";
    private static final String PARAM = "param";
    private static final String ROW_PARAMS = "row-params";
    private static final String BUSSINESS_PARAMS = "bussiness-params";
    private static final String DATAINTERFACE = "datainterface";
    private static final String XMLHEAD = "<?xml version='1.0' encoding='UTF-8'?>";
    private static final String WAVE_LENGTH_STR = "WaveLength";
    private static final float WAVELENGTH_MUL = 0.01f;
    private static final float OPTICALPOWER_MUL = 0.1f;
    private static final float SAMPLERATE_MUL = 0.1f;
    private static final float LENGTHCOEFFICIENT_MUL = 0.001f;
    private static final float SPANLENGTH_MUL = 0.001f;
    private static final float LOSSCOEFFICIENT_MUL = 0.001f;
    private static final float REFRACTIVEINDEX_MUL = 1.0E-5f;
    private static final float REPEATORPOSITION_MUL = 0.001f;
    private static final float REPEATORGAIN_MUL = 0.1f;
    private static final float FIBERLOSSCOEFFICIENT_MUL = 0.001f;
    private static final float LOSSTHRESHOLD_MUL = 0.001f;
    private static final float REFLECTANCETHRESHOLD_MUL = 0.001f;
    private static final float ENDOFFIBERTHRESHOLD_MUL = 0.001f;

    private TEOTDRDataConvertor() {
    }

    static Object convertFileDataToApplicationData(Object fileData, int neid) throws Exception {
        TEOTDRTraceInfo traceInfo = (TEOTDRTraceInfo)fileData;
        TEOTDRGeneralParametersBlock genBlock = (TEOTDRGeneralParametersBlock)traceInfo.getBlock("GenParams");
        TEOTDRSuppliersParametersBlock supBlock = (TEOTDRSuppliersParametersBlock)traceInfo.getBlock("SupParams");
        TEOTDRFixedParametersBlock fxdBlock = (TEOTDRFixedParametersBlock)traceInfo.getBlock("FxdParams");
        TEOTDRSLMParametersBlock slmBlock = (TEOTDRSLMParametersBlock)traceInfo.getBlock("SpecProp");
        TEOTDRDataPointsBlock dptsBlock = (TEOTDRDataPointsBlock)traceInfo.getBlock("DataPts");
        TEOTDRKeyEventsBlock eventBlock = (TEOTDRKeyEventsBlock)traceInfo.getBlock("KeyEvents");
        short eventCount = 0;
        if (null != eventBlock) {
            eventCount = eventBlock.getEventCount();
        }
        short repeatorCount = 0;
        if (null != slmBlock) {
            repeatorCount = slmBlock.getSpanCount();
        }
        short deviceCount = 0;
        if (null != slmBlock) {
            deviceCount = slmBlock.getLineDeviceCount();
        }
        StringBuffer buf = new StringBuffer();
        buf.append(XMLHEAD);
        buf.append(TEOTDRDataConvertor.createStartTag(DATAINTERFACE));
        buf.append(TEOTDRDataConvertor.createStartTag(BUSSINESS_PARAMS));
        buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
        String fileName = traceInfo.getFileName();
        if (-1 == fileName.indexOf("mid")) {
            Logger log = TELogFactory.getNormalLogger();
            log.info("MARINE DataConvertor Convert FileName. fileName->" + fileName);
            fileName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(fileName, neid);
            log.info("MARINE DataConvertor Convert FileName. fileName->" + fileName);
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, FILENAME, fileName));
        buf.append(TEOTDRDataConvertor.createElement(PARAM, TEST_PARAM_ROW_COUNT, "1"));
        int dptsRowCount = 0;
        if (null != dptsBlock && dptsBlock.getTotalPointCount() != 0) {
            dptsRowCount = 1;
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, DATA_PTS_ROW_COUNT, String.valueOf(dptsRowCount)));
        short eventRowCount = 0;
        if (null != eventBlock && 0 < eventCount) {
            eventRowCount = eventCount;
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENTROWS, String.valueOf(eventRowCount)));
        short deviceRowCount = 0;
        if (null != slmBlock && 0 < deviceCount) {
            deviceRowCount = deviceCount;
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, DEVICEROWS, String.valueOf(deviceRowCount)));
        short repeatorRowCount = 0;
        if (null != slmBlock && 0 < repeatorCount) {
            repeatorRowCount = repeatorCount;
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATERROWS, String.valueOf(repeatorRowCount)));
        String[] fileParams = traceInfo.getFileName().split("_");
        int lineID = Integer.valueOf(fileParams[0]);
        String rptNameStr = TEMarineCableLineRptUtil.getRepeaterName(lineID, neid);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATERNAMES, rptNameStr));
        buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
        buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
        String comment = genBlock.getComment();
        buf.append(TEOTDRDataConvertor.createElement(PARAM, COMMENT, comment));
        String supName = supBlock.getSupplierName();
        buf.append(TEOTDRDataConvertor.createElement(PARAM, SUPPLIER_NAME, supName));
        String dateTimeStamp = TEOTDRIOUtility.getTimeString(fxdBlock.getDateTimeStamp(), neid);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, TESTDATE, dateTimeStamp));
        String waveLengthStr = supBlock.getOpticalModuleID();
        String waveLength = "";
        int dotIndex = waveLengthStr.indexOf(58);
        int leftIndex = waveLengthStr.indexOf(40);
        if (0 <= waveLengthStr.indexOf(WAVE_LENGTH_STR) && 0 <= dotIndex && 0 <= leftIndex) {
            waveLength = waveLengthStr.substring(dotIndex + 1, leftIndex);
        }
        waveLength = String.valueOf((float)Integer.parseInt(waveLength.trim()) * 0.01f);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, WAVELENGH, waveLength));
        String sampleTimes = String.valueOf(fxdBlock.getNumberOfAverages());
        buf.append(TEOTDRDataConvertor.createElement(PARAM, SAMPLE_TIMES, sampleTimes));
        String pulseWidthsUsed = String.valueOf(fxdBlock.getPulseWidthsUsed().get(0));
        if (null != slmBlock) {
            pulseWidthsUsed = String.valueOf(slmBlock.getSlmPulseWidth());
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, PULSE_WIDTHS_USED, pulseWidthsUsed));
        long cableLength = fxdBlock.getAcquisitionRangeDistance();
        double measureRangeDistance = cableLength;
        if (null != slmBlock && -1.0 != slmBlock.getRealLineRange()) {
            measureRangeDistance = slmBlock.getRealLineRange();
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, MEASURE_RANGE_DISTANCE, String.valueOf(measureRangeDistance)));
        String lossThreshold = String.valueOf((float)fxdBlock.getLossThreshold() * 0.001f);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, LOSS_THRESHOLD, lossThreshold));
        String reflectanceThreshold = String.valueOf((float)fxdBlock.getReflectanceThreshold() * 0.001f);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, REFLECTANCE_THRESHOLD, reflectanceThreshold));
        String endOfFiberThreshold = String.valueOf((float)fxdBlock.getEndOfFiberThreshold() * 0.001f);
        buf.append(TEOTDRDataConvertor.createElement(PARAM, END_OF_FIBER_THRESHOLD, endOfFiberThreshold));
        if (null != slmBlock) {
            buf.append(TEOTDRDataConvertor.createElement(PARAM, FILE_TYPE, slmBlock.getFileType()));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, MONITOR_TYPE, slmBlock.getMonitorType()));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, MONITOR_OPTICAL_POWER, String.valueOf((float)slmBlock.getMonitorOpticalPower() * 0.1f)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, RECEIVE_OPTICAL_POWER, String.valueOf((float)slmBlock.getReceiveOpticalPower() * 0.1f)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, SAMPLE_RATE, String.valueOf((float)slmBlock.getSampleRate() * 0.1f)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, CODE_TYPE, slmBlock.getCodeType()));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, NUMBER_OF_CODE_BITS, String.valueOf(slmBlock.getNumberOfCodeBits())));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, FILTER_METHOD, slmBlock.getFilterMethod()));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, LENGTH_COEFFICIENT, String.valueOf((float)slmBlock.getLengthCoefficient() * 0.001f)));
        }
        buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
        if (null != dptsBlock && dptsRowCount != 0) {
            TEOTDRDataConvertor.processDptsData(buf, dptsBlock);
        }
        if (null != eventBlock) {
            TEOTDRDataConvertor.processKeyEventData(buf, eventBlock, slmBlock);
        }
        if (null != slmBlock) {
            TEOTDRDataConvertor.processSlmBlockData(buf, slmBlock);
        }
        buf.append(TEOTDRDataConvertor.createEndTag(BUSSINESS_PARAMS));
        buf.append(ERROR_SUCCESS_MSG);
        buf.append(TEOTDRDataConvertor.createEndTag(DATAINTERFACE));
        return buf.toString();
    }

    private static void processSlmBlockData(StringBuffer buf, TEOTDRSLMParametersBlock slmBlock) {
        if (null != slmBlock) {
            TEOTDRSLMRepeaterInfo info = null;
            List repeatorInfoList = slmBlock.getRepeatorInfoList();
            Collections.sort(repeatorInfoList);
            int spanCount = slmBlock.getSpanCount();
            for (int i = 0; i < spanCount; ++i) {
                info = (TEOTDRSLMRepeaterInfo)repeatorInfoList.get(i);
                short spanID = info.getSpanID();
                int spanLength = info.getSpanLength();
                short lossCoefficient = info.getNorminalAttenuationCoefficient();
                long refractiveIndex = info.getRefractiveIndex();
                String fiberType = info.getFiberType();
                long repeatorPosition = info.getRealRptPosition();
                long repeatorTransferTime = info.getRepeatorTransferTime();
                long repeatorGain = info.getRepeatorGain();
                long repeatorPeakPower = info.getRepeatorPeakPower();
                short fiberLossCoefficient = info.getFiberLossCoefficient();
                float location = (float)repeatorPosition * 0.001f;
                float gain = repeatorGain;
                float power = (float)repeatorPeakPower / 10.0f;
                buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, SPANID, String.valueOf(spanID - 1)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, SPAN_LENGTH, String.valueOf((float)spanLength * 0.001f)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, LOSS_COEFFICIENT, String.valueOf((float)lossCoefficient * 0.001f)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, REFRACTIVE_INDEX, String.valueOf((float)refractiveIndex * 1.0E-5f)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, FIBER_TYPE, fiberType));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATER_LOCATION, String.valueOf(location)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATORTRANSFERTIME, String.valueOf(repeatorTransferTime)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATOR_GAIN, String.valueOf(gain * 0.1f)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, REPEATOR_PEAK_POWER, String.valueOf(power * 0.1f)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, FIBER_LOSS_COEFFICIENT, String.valueOf((float)fiberLossCoefficient * 0.001f)));
                buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
            }
            TEOTDRSLMLineDeviceInfo deviceInfo = null;
            List<TEOTDRSLMLineDeviceInfo> lineDeviceInfoList = slmBlock.getLineDeviceInfoList();
            Collections.sort(lineDeviceInfoList);
            int deviceCount = slmBlock.getLineDeviceCount();
            int oeq_index = 1;
            for (int i = 0; i < deviceCount; ++i) {
                deviceInfo = lineDeviceInfoList.get(i);
                short deviceID = deviceInfo.getDeviceID();
                short spanIDOfDevice = deviceInfo.getSpanIDOfDevice();
                short deviceType = deviceInfo.getDeviceType();
                int deviceOffsetFromSpanStartPoint = deviceInfo.getDeviceOffsetFromSpanStartPoint();
                String deviceName = deviceInfo.getDeviceName();
                if (3 == deviceType) {
                    deviceName = DEVICETYPE_OEQ_NAME + oeq_index;
                    ++oeq_index;
                }
                buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, DEVICEID, String.valueOf(deviceID)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, SPANIDOFDEVICE, String.valueOf(spanIDOfDevice)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, DEVICETYPE, String.valueOf(deviceType)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, DEVICEOFFSETFROMSPANSTARTPOINT, String.valueOf(deviceOffsetFromSpanStartPoint)));
                buf.append(TEOTDRDataConvertor.createElement(PARAM, DEVICENAME, deviceName.trim()));
                buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
            }
        }
    }

    private static void processKeyEventData(StringBuffer buf, TEOTDRKeyEventsBlock eventBlock, TEOTDRSLMParametersBlock slmBlock) {
        double c = 2.99792458;
        List eventList = eventBlock.getEvents();
        if (eventList.isEmpty()) {
            return;
        }
        List spanList = slmBlock.getRepeatorInfoList();
        int spanCount = slmBlock.getSpanCount();
        long[] propagationTimeArray = new long[spanCount];
        int[] spanLengthArray = new int[spanCount];
        long[] refractiveIndexArray = new long[spanCount];
        for (int i = 0; i < spanCount; ++i) {
            TEOTDRSLMRepeaterInfo info = (TEOTDRSLMRepeaterInfo)spanList.get(i);
            if (null == info) continue;
            propagationTimeArray[i] = info.getRepeatorTransferTime();
            refractiveIndexArray[i] = info.getRefractiveIndex();
            spanLengthArray[i] = info.getRealSpanLength();
        }
        Collections.sort(eventList);
        TEOTDREvent event2 = null;
        for (TEOTDREvent event2 : eventList) {
            double eventLocationInSpan;
            int i;
            short eventIndexID = event2.getEventIndexID();
            long propagationTime = event2.getPropagationTime();
            short attenuationCoefficientLeadFib = event2.getAttenuationCoefficientLeadFib();
            short eventLoss = event2.getEventLoss();
            long eventReflectance = event2.getEventReflectance();
            String eventCode = event2.getEventCode();
            String lossMeasurementTechnique = event2.getLossMeasurementTechnique();
            String comment = event2.getComment();
            for (i = 0; i < spanCount && propagationTimeArray[i] < propagationTime; ++i) {
            }
            if (i >= spanCount) {
                i = spanCount - 1;
            }
            int index = i == 0 ? 0 : i - 1;
            long spanPropagationTime = propagationTime - TEOTDRDataConvertor.getPropagationTime(propagationTimeArray, index);
            double eventLocationInLine = eventLocationInSpan = c * (double)spanPropagationTime / (double)refractiveIndexArray[index];
            for (int j = 0; j < index; ++j) {
                eventLocationInLine += (double)spanLengthArray[j] / 1000.0;
            }
            buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_INDEX_ID, String.valueOf(eventIndexID)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, PROPAGATION_TIME, String.valueOf(propagationTime)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, ATTENUATION_COEFFICIENT_LEAD_FIB, String.valueOf(attenuationCoefficientLeadFib)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_LOSS, String.valueOf(eventLoss)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_REFLECTANCE, String.valueOf(eventReflectance)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_CODE, eventCode));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, LOSS_MEASUREMENT_TECHNIQUE, lossMeasurementTechnique));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, COMMENT, comment));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_LOCATION_IN_SPAN, String.valueOf(eventLocationInSpan)));
            buf.append(TEOTDRDataConvertor.createElement(PARAM, EVENT_LOCATION_IN_LINE, String.valueOf(eventLocationInLine)));
            buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
        }
    }

    private static long getPropagationTime(long[] propagationTimeArray, int index) {
        int i;
        if (0L != propagationTimeArray[index] || 0 == index) {
            return propagationTimeArray[index];
        }
        int len = propagationTimeArray.length;
        for (i = 1; i < len && 0L != propagationTimeArray[i]; ++i) {
        }
        return propagationTimeArray[i - 1];
    }

    private static void processDptsData(StringBuffer buf, TEOTDRDataPointsBlock dptsBlock) {
        buf.append(TEOTDRDataConvertor.createStartTag(ROW_PARAMS));
        buf.append(TEOTDRDataConvertor.createElement(PARAM, TOTAL_POINT_COUNT_STR, String.valueOf(dptsBlock.getTotalPointCount())));
        StringBuilder tmpBuf = new StringBuilder();
        int[] dptsArray = dptsBlock.getDptsArray();
        int standard = -1;
        int lastNum = -1;
        for (int i = 0; i < dptsArray.length; ++i) {
            int point = dptsArray[i];
            point /= 1000;
            if (0 == i) {
                standard = point;
                lastNum = point;
                tmpBuf.append(Integer.toString(point, 36));
            } else {
                int minus = point - standard;
                if (minus == lastNum) {
                    tmpBuf.append(POINT);
                } else {
                    lastNum = minus;
                    tmpBuf.append(Integer.toString(minus, 36));
                }
            }
            if (i == dptsArray.length - 1) continue;
            tmpBuf.append(BLANK_SPACE);
        }
        buf.append(TEOTDRDataConvertor.createElement(PARAM, CURVINFO, tmpBuf.toString()));
        buf.append(TEOTDRDataConvertor.createEndTag(ROW_PARAMS));
    }

    private static String createStartTag(String tagName) {
        StringBuffer buf = new StringBuffer();
        buf.append(LEFTBRACKET).append(tagName).append(RIGHTBRACKET);
        return buf.toString();
    }

    private static String createEndTag(String tagName) {
        StringBuffer buf = new StringBuffer();
        buf.append(LEFTENDXMLTAG).append(tagName).append(RIGHTBRACKET);
        return buf.toString();
    }

    private static String createElement(String tagName, String name, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append(LEFTBRACKET);
        buf.append(tagName).append(BLANK_SPACE);
        buf.append(PARAM_NAME).append(EQUALMARK);
        buf.append(QUOTATIONMARK).append(name).append(QUOTATIONMARK).append(BLANK_SPACE);
        buf.append(PARAM_VALUE).append(EQUALMARK);
        buf.append(QUOTATIONMARK).append(TEOTDRDataConvertor.convertSpecialValue(value)).append(QUOTATIONMARK);
        buf.append(XMLENDTAG);
        return buf.toString();
    }

    private static String convertSpecialValue(String speValue) {
        String tValue = speValue;
        tValue = tValue.replaceAll("&", "&amp;");
        tValue = tValue.replaceAll(RIGHTBRACKET, "&gt;");
        tValue = tValue.replaceAll(LEFTBRACKET, "&lt;");
        tValue = tValue.replaceAll(QUOTATIONMARK, "&quot;");
        tValue = tValue.replaceAll("'", "&apos;");
        return tValue;
    }
}

