/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.servlet;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEOTDRSaveTestRecordServlet
extends HttpServlet {
    private static final String NE_ID_STR = "neID";
    private static final String ERRORMESSAGE_STR = "errormessage";
    private static final String ERRORCODE_STR = "errorcode";
    private static final String FILENAME_STR = "fileName";
    private static final String TESTMODE_STR = "testMode";
    private static final String INDEXID_STR = "indexID";
    private static final String FILE_NOT_EXIST_STR = "1090781211";
    private static final int FILE_NOT_EXIST_INT = 1090781211;
    private static final String OPERATION_SUCCEED_CODE_STR = "0";

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.doPost(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter print = response.getWriter();
        Datainterface outputData = new Datainterface();
        BussinessParams bus = new BussinessParams();
        outputData.setBussinessParams(bus);
        Datainterface inputData = null;
        try {
            ServletInputStream in = request.getInputStream();
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            int c = -1;
            while ((c = in.read()) != -1) {
                ba.write(c);
            }
            String str = new String(ba.toByteArray(), "UTF-8");
            if (TESysManagerBean.getInstance().isIntegratedStatus()) {
                str = str.replaceAll("%20", "\\+");
                str = URLDecoder.decode(str, "UTF-8");
            }
            String[] strArr = str.split("&");
            str = strArr[strArr.length - 1];
            StringReader sr = new StringReader(str);
            inputData = Datainterface.unmarshal((Reader)sr);
            sr.close();
            ba.close();
        }
        catch (Exception e1) {
            StringWriter out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal((Writer)out);
                print.println(out.toString());
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("MARSHAL Fail", (Throwable)ex);
                return;
            }
        }
        int neid = -1;
        RowParams oRow = null;
        Param oParam = null;
        RowParams row = null;
        int indexID = -1;
        int testMode = -1;
        String fileName = null;
        Param param = null;
        ArrayList rowList = inputData.getBussinessParams().getRowParamList();
        row = (RowParams)rowList.get(0);
        param = row.getParam(NE_ID_STR);
        neid = Integer.parseInt(param.getValue());
        param = row.getParam(INDEXID_STR);
        indexID = Integer.parseInt(param.getValue());
        int rowLen = rowList.size();
        for (int i = 1; i < rowLen; ++i) {
            row = (RowParams)rowList.get(i);
            oRow = new RowParams();
            bus.addRowParams(oRow);
            param = row.getParam(TESTMODE_STR);
            testMode = Integer.parseInt(param.getValue());
            param = row.getParam(FILENAME_STR);
            oRow.addParam(param);
            fileName = param.getValue();
            TELogFactory.getNormalLogger().info("MARINE ---- fileName->" + fileName);
            fileName = TESLMOTDRDataMgr.convertAppletFileNameToNMUTCFileName(fileName, neid);
            TELogFactory.getNormalLogger().info("MARINE ---- fileName->" + fileName);
            oParam = new Param(ERRORCODE_STR, OPERATION_SUCCEED_CODE_STR);
            oRow.addParam(oParam);
            if (!TESLMOTDRDataMgr.fileExists(neid, indexID, fileName)) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
                oParam.setValue(FILE_NOT_EXIST_STR);
                oParam = new Param(ERRORMESSAGE_STR, TEErrorResourceUtil.getErrorMessage((int)1090781211).getErrorinfo());
                continue;
            }
            TESLMOTDRDataMgr.makeTestRecordSaved(neid, indexID, testMode, fileName);
        }
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        StringWriter out = new StringWriter();
        try {
            outputData.marshal((Writer)out);
            print.println(out.toString());
            out.close();
            print.flush();
        }
        catch (Exception e) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal((Writer)out);
                print.println(out.toString());
                print.flush();
            }
            catch (Exception ex) {
                return;
            }
            TELogFactory.getNormalLogger().error("TEOTDRSaveTestRecordServlet.doPost() fail!", (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }
}

