/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.servlet;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TEOTDRLoadFileContentServlet
extends HttpServlet {
    private static final int FILE_NOT_EXIST = 1090781211;
    private static final int FAILED_TO_PARSE_FILE = 1090781212;
    private Logger log = TELogFactory.getNormalLogger();

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException {
        this.doPost(req, rsp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException {
        Object obj;
        rsp.setContentType("text/xml;charset=UTF-8");
        rsp.setHeader("Cache-Control", "no-cache");
        rsp.setHeader("Pragma", "no-cache");
        String filename = req.getParameter("fileName");
        this.log.info("MARINE Load File Content. fileName->" + filename);
        String neIDStr = req.getParameter("neID");
        int neID = Integer.parseInt(neIDStr);
        if (-1 == filename.indexOf("mid")) {
            filename = TESLMOTDRDataMgr.convertAppletFileNameToNMUTCFileName(filename, neID);
        }
        this.log.info("MARINE ---- RECIEVE load file content request!");
        this.log.info("MARINE Load File Content.  fileName->" + filename);
        this.log.info("MARINE ---- neID->" + neIDStr);
        if (null == neIDStr || null == filename) {
            this.log.info("MARINE ---- wrong parameters.");
            this.log.info("MARINE ---- fileName-> NULL");
            this.log.info("MARINE ---- neID-> NULL");
            Datainterface outputData = new Datainterface();
            StringWriter out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal((Writer)out);
                rsp.getWriter().print(((Object)out).toString());
            }
            catch (MarshalException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() MarshalException!", (Throwable)e);
            }
            catch (ValidationException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() ValidationException!", (Throwable)e);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() IOException!", (Throwable)e);
            }
        }
        String value = "";
        boolean exist = true;
        int realNEID = TESLMOTDRDataMgr.getRealNEID(neID);
        String absFilePath = TESLMOTDRDataMgr.getAbstractPath(realNEID) + filename;
        File file = new File(absFilePath);
        if (!file.exists() || !file.isFile()) {
            exist = false;
        }
        if (exist) {
            obj = TESLMOTDRDataMgr.loadFileContent(neID, filename);
            if (null == obj) {
                this.log.info("MARINE ---- FAILED to load file content");
                Datainterface outputData = new Datainterface();
                StringWriter out = new StringWriter();
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090781212));
                try {
                    outputData.marshal((Writer)out);
                    rsp.getWriter().print(((Object)out).toString());
                    rsp.getWriter().flush();
                    rsp.getWriter().close();
                }
                catch (MarshalException e) {
                    TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() MarshalException!", (Throwable)e);
                }
                catch (ValidationException e) {
                    TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() ValidationException!", (Throwable)e);
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() IOException!", (Throwable)e);
                }
                return;
            }
        } else {
            this.log.info("MARINE ---- file not exist");
            Datainterface outputData = new Datainterface();
            StringWriter out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090781211));
            try {
                outputData.marshal((Writer)out);
                rsp.getWriter().print(((Object)out).toString());
                rsp.getWriter().flush();
                rsp.getWriter().close();
            }
            catch (MarshalException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() MarshalException!", (Throwable)e);
            }
            catch (ValidationException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() ValidationException!", (Throwable)e);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() IOException!", (Throwable)e);
            }
            return;
        }
        this.log.info("MARINE ---- SUCCEEDED to load file content.");
        value = obj.toString();
        try {
            rsp.getWriter().print(value);
            rsp.getWriter().flush();
            rsp.getWriter().close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRLoadFileContentServlet.doPost() fail!", (Throwable)e);
        }
    }
}

