/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.servlet;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.sor.TEOTDRFileInterpreter;
import com.huawei.nglct.otdr.sor.TEOTDRSLMParametersBlock;
import com.huawei.nglct.otdr.sor.TEOTDRTraceInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TEOTDRImportBaseLineServlet
extends HttpServlet {
    private static final String OUT_OF_SRV_FILESUFFIX = ".sor";
    private static final String FILE_NAME = "fileName";
    private static final int DEFAULT_TIME_OUT = 20;
    private static final String NSCMD_SLM_GET_SPANNUMBER = "NSCMD_SLM_GET_SPANNUMBER";
    private static final String TEST_MODE = "testMode";
    private static final String INDEX_ID = "indexID";
    private static final String NE_ID = "neID";
    private static final String UPLOAD_PATH = "upload";
    private static final int MODE_ERR = 42791;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int MAXPOSTSIZE = 0x6400000;
    private static final int FILE_UPLOAD_FAILED = 1091092491;
    private static final int FAILED_TO_PARSE_FILE = 1090781212;
    private static final int RPT_COUNT_NOT_EQUAL = 1090593356;
    private static final int TESTMODE_IN_SRV = 1;
    private static final int TESTMODE_OUT_OF_SRV = 2;
    private int neID = -1;
    private int indexID = -1;
    private int testMode = -1;
    private int lmiNEID = -1;
    private int lmiSlotID = -1;
    private int lmiPortID = -1;

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.doPost(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("MARINE ---- RECEIVE import baseline request");
        response.setContentType("text/xml;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        this.neID = Integer.parseInt(request.getParameter(NE_ID));
        this.indexID = Integer.parseInt(request.getParameter(INDEX_ID));
        this.testMode = Integer.parseInt(request.getParameter(TEST_MODE));
        this.lmiNEID = Integer.parseInt(request.getParameter("lmiNEID"));
        this.lmiSlotID = Integer.parseInt(request.getParameter("lmiSlotID"));
        this.lmiPortID = Integer.parseInt(request.getParameter("lmiPortID"));
        String fileName = request.getParameter(FILE_NAME);
        this.log.info("MARINE ---- get data from request. neID->" + this.neID + ",indexID->" + this.indexID + ",testMode->" + this.testMode + "lmiNEID->" + this.lmiNEID + ",lmiSlotID->" + this.lmiSlotID + ",lmiPortID->" + this.lmiPortID + ",fileName->" + fileName);
        String path = TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(this.neID)) + UPLOAD_PATH;
        this.log.info("MARINE ---- upload file. storage path->" + path);
        File directory = new File(path);
        if (directory.exists() && !directory.isDirectory()) {
            try {
                directory.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() fail!", (Throwable)e);
            }
        }
        if (!directory.exists()) {
            try {
                if (!directory.mkdirs()) {
                    TELogFactory.getNormalLogger().info("MARINE ---- failed to create directory. path->" + path);
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() fail!", (Throwable)e);
            }
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(0x6400000L);
        try {
            List fileItems = upload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) continue;
                String name = item.getName();
                item.write(new File(path + File.separator + name));
            }
        }
        catch (Exception e) {
            this.log.info("MARINE ---- failed to write file. fileName->" + fileName);
            ArrayList<Integer> errList = new ArrayList<Integer>();
            errList.add(1091092491);
            this.recordUploadResult(errList);
            this.log.info("", (Throwable)e);
            return;
        }
        int result = this.processUploadFile(path, fileName, this.neID);
        Datainterface output = new Datainterface();
        BussinessParams bus = new BussinessParams();
        output.setBussinessParams(bus);
        RowParams row = null;
        Param param = null;
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        if (0 == result) {
            String blFileName = TESLMOTDRDataMgr.getBaseLineFileName(this.neID, this.indexID, this.testMode);
            this.log.info("Marine Import BaseLine. blFileName: " + blFileName);
            String clietBLFileName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(blFileName, this.neID);
            row = new RowParams();
            bus.addRowParams(row);
            param = new Param(FILE_NAME, clietBLFileName);
            row.addParam(param);
        }
        PrintWriter pw = response.getWriter();
        StringWriter out = new StringWriter();
        try {
            output.marshal((Writer)out);
            pw.println(out.toString());
            pw.flush();
        }
        catch (Exception e) {
            output = new Datainterface();
            out = new StringWriter();
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                output.marshal((Writer)out);
                pw.println(out.toString());
            }
            catch (Exception ex) {
                return;
            }
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() fail!", (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != pw) {
                pw.close();
            }
        }
    }

    private int processUploadFile(String path, String fileName, int logicNEID) {
        ArrayList<Object> errList = new ArrayList<Object>();
        File file = new File(path + File.separator + fileName);
        TEOTDRTraceInfo traceInfo = null;
        try {
            traceInfo = TEOTDRFileInterpreter.loadFileContent0(path + File.separator + fileName, logicNEID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() fail!", (Throwable)e);
        }
        if (null == traceInfo) {
            try {
                file.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() fail!", (Throwable)e);
            }
            errList.add(1090781212);
            this.recordUploadResult(errList);
            return 1090781212;
        }
        int repeaterCountInFile = -1;
        TEOTDRSLMParametersBlock slmBlock = (TEOTDRSLMParametersBlock)traceInfo.getBlock("SpecProp");
        if (null != slmBlock) {
            int tmpMode = -1;
            String monitorType = slmBlock.getMonitorType();
            if ((monitorType = monitorType.toLowerCase()).startsWith("i")) {
                tmpMode = 1;
            } else if (monitorType.startsWith("o")) {
                tmpMode = 2;
            }
            if (this.testMode != tmpMode) {
                this.log.info("MARINE ---- test mode not equal");
                try {
                    file.delete();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() Exception!", (Throwable)e);
                }
                return 42791;
            }
            repeaterCountInFile = slmBlock.getSpanCount() - 1;
        }
        this.log.info("MARINE ---- repeater num in file is ->" + repeaterCountInFile);
        int lineRptCount = this.sendCmdToGetRptCount();
        this.log.info("MARINE ---- repeater num from ne is ->" + lineRptCount);
        if (lineRptCount != repeaterCountInFile) {
            this.log.info("MARINE ---- repeater num not equal");
            try {
                file.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() Exception!", (Throwable)e);
            }
            errList.add(1090593356);
            this.recordUploadResult(errList);
            return 1090593356;
        }
        int result = this.setBaseLine(path, fileName);
        if (0 != result) {
            try {
                file.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() Exception!", (Throwable)e);
            }
            errList.add(result);
            this.recordUploadResult(errList);
            return result;
        }
        try {
            file.delete();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.processUploadFile() Exception!", (Throwable)e);
        }
        errList.add(0);
        String blName = TESLMOTDRDataMgr.getBaseLineFileName(this.neID, this.indexID, this.testMode);
        errList.add(blName);
        this.recordUploadResult(errList);
        return 0;
    }

    private int setBaseLine(String path, String fileName) {
        try {
            String testRecordSuffix = this.getTestRecordSuffix(this.testMode);
            StringBuffer timeStr = this.getCurrentDateStr();
            String nmFileTime = timeStr.toString();
            String neFileTime = TESLMOTDRDataMgr.convertNMFileTimeToNEFileTime(nmFileTime, this.neID);
            String neFileName = neFileTime + testRecordSuffix;
            File file = TESLMOTDRDataMgr.copyFile(path, fileName, path, neFileName);
            if (null == file) {
                return 1091092491;
            }
            int result = TESLMOTDRDataMgr.sendFileToNE(this.neID, path, neFileName);
            if (0 != result) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() Exception!", (Throwable)e);
                }
                return 1091092491;
            }
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neID);
            Operation operation = definitions.getOperation("NSCMD_SLM_SET_BASELINE");
            Input input = operation.getInput();
            input.setPartValue(INDEX_ID, String.valueOf(this.indexID));
            input.setPartValue(TEST_MODE, String.valueOf(this.testMode));
            input.setPartValue(FILE_NAME, neFileName);
            ArrayList<Operation> operList = new ArrayList<Operation>();
            operList.add(operation);
            OperationResult operResult = TENECommMgr.getInstance().sendCommand(this.neID, operList, this.getTimeOut());
            if (null != operResult) {
                result = operResult.retCode;
            }
            if (result == 0) {
                Output output = operation.getOutput(0);
                boolean isSuc = true;
                int faultlen = output.getFaultCount();
                for (int i = 0; i < faultlen; ++i) {
                    int faultCode = Integer.parseInt(output.getFault(i).getCode());
                    if (0 == faultCode) continue;
                    result = faultCode;
                    isSuc = false;
                    break;
                }
                if (isSuc) {
                    TESLMOTDRDataMgr.deleteBaseLine(this.neID, this.indexID, this.testMode);
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.indexID).append('_');
                    buf.append(this.testMode).append('_');
                    buf.append(TESLMOTDRDataMgr.getRealNEID(this.lmiNEID)).append('_');
                    buf.append(this.lmiSlotID).append('_');
                    buf.append(this.lmiPortID).append('_');
                    buf.append(nmFileTime);
                    buf.append("_baseline");
                    buf.append(testRecordSuffix);
                    TESLMOTDRDataMgr.copyFile(path, file.getName(), TESLMOTDRDataMgr.getAbstractPath(TESLMOTDRDataMgr.getRealNEID(this.neID)), buf.toString());
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() Exception!", (Throwable)e);
                    }
                    TESLMOTDRDataMgr.updateBaseLine(this.neID, this.indexID, this.testMode, buf.toString());
                    return result;
                }
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() Exception!", (Throwable)e);
            }
            ArrayList<Integer> errList = new ArrayList<Integer>();
            errList.add(result);
            this.recordUploadResult(errList);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() MarshalException!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() FileNotFoundException!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.setBaseLine() ValidationException!", (Throwable)e);
        }
        return 1091092491;
    }

    private String getTestRecordSuffix(int testMode) {
        return OUT_OF_SRV_FILESUFFIX;
    }

    private StringBuffer getCurrentDateStr() {
        Calendar cal = Calendar.getInstance();
        StringBuffer timeStr = new StringBuffer();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        timeStr.append(year);
        timeStr.append(month >= 10 ? String.valueOf(month) : "0" + month);
        timeStr.append(day >= 10 ? String.valueOf(day) : "0" + day);
        timeStr.append(hour >= 10 ? String.valueOf(hour) : "0" + hour);
        timeStr.append(minute >= 10 ? String.valueOf(minute) : "0" + minute);
        timeStr.append(second >= 10 ? String.valueOf(second) : "0" + second);
        return timeStr;
    }

    private int getTimeOut() {
        return 20;
    }

    private int sendCmdToGetRptCount() {
        int result = 0;
        try {
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)this.neID);
            Operation operation = definitions.getOperation(NSCMD_SLM_GET_SPANNUMBER);
            Input input = operation.getInput();
            input.setPartValue("lineID", String.valueOf(this.indexID));
            ArrayList<Operation> operList = new ArrayList<Operation>();
            operList.add(operation);
            OperationResult operResult = TENECommMgr.getInstance().sendCommand(this.neID, operList, this.getTimeOut());
            if (null != operResult) {
                result = operResult.retCode;
            }
            if (result == 0) {
                Output output = operation.getOutput(0);
                boolean isSuc = true;
                int faultlen = output.getFaultCount();
                for (int i = 0; i < faultlen; ++i) {
                    int faultCode = Integer.parseInt(output.getFault(i).getCode());
                    if (0 == faultCode) continue;
                    result = faultCode;
                    isSuc = false;
                    break;
                }
                if (isSuc) {
                    Part part = output.getPart("segmentNum");
                    if (null == part) {
                        part = output.getPart("spanNum");
                    }
                    return Integer.parseInt(part.getValue()) - 1;
                }
            }
            ArrayList<Integer> errList = new ArrayList<Integer>();
            errList.add(result);
            this.recordUploadResult(errList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRImportBaseLineServlet.sendCmdToGetRptCount() fail!", (Throwable)e);
        }
        return -2;
    }

    private void recordUploadResult(List errList) {
        TESLMOTDRDataMgr.recordUploadResult(this.neID, this.indexID, this.testMode, errList);
    }
}

