/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.servlet;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.linemonitor.TELineRefreshInfo;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMRefreshTypeMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TEOTDRGetRefreshTypeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String NE_NOT_EXIST = "68560014";
    private static final int ERROR_CODE_LINE_NOT_EXSIT = 42781;
    private Logger log = TELogFactory.getNormalLogger();

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.doPost(req, rsp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        rsp.setContentType("text/xml;charset=UTF-8");
        rsp.setHeader("Cache-Control", "no-cache");
        rsp.setHeader("Pragma", "no-cache");
        int neID = -1;
        int indexID = -1;
        neID = Integer.parseInt(req.getParameter("neID"));
        indexID = Integer.parseInt(req.getParameter("indexID"));
        Datainterface outputData = null;
        PrintWriter print = rsp.getWriter();
        try {
            outputData = this.getRefreshData(neID, indexID);
            if (null == outputData) {
                throw new Exception("The Output Data is null !!!");
            }
            StringWriter out = new StringWriter();
            outputData.marshal((Writer)out);
            print.print(((Object)out).toString());
            ((Writer)out).close();
            print.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRGetRefreshTypeServlet.doPost() fail!", (Throwable)e);
        }
    }

    public Datainterface getRefreshData(int neID, int indexID) {
        this.log.info("MARINE ---- Get refresh type data.");
        this.log.info("MARINE ---- neID->" + neID);
        this.log.info("MARINE ---- indexID->" + indexID);
        Datainterface outputData = new Datainterface();
        if (-1 == neID || -1 == indexID) {
            this.log.info("MARINE  ---- neID or indexID is invalid.");
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return outputData;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_EXIST)));
            return outputData;
        }
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        Param param = null;
        TELineRefreshInfo refreshInfo = TESLMRefreshTypeMgr.getInstance().getRefreshInfo(neID, indexID);
        if (null == refreshInfo) {
            this.log.info("MARINE  ---- line is not exist,refreshInfo is NULL!");
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)42781));
            return outputData;
        }
        byte refreshType = refreshInfo.getRefreshType();
        int refreshTime = refreshInfo.getRefreshTime();
        int refreshStatus = refreshInfo.getRefreshStatus();
        this.log.info("MARINE  ---- get refreshType data is ->" + refreshType);
        this.log.info("MARINE  ---- get refreshTime data is ->" + refreshTime);
        this.log.info("MARINE  ---- get refreshStatus data is ->" + refreshStatus);
        String data = null;
        if (-1 == refreshType || -1 == refreshTime || -1 == refreshStatus) {
            this.log.info("MARINE  ---- line is not exist, line id is ->" + indexID);
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)42781));
            return outputData;
        }
        data = String.valueOf(refreshType);
        row = new RowParams();
        param = new Param();
        param.setName("refreshType");
        param.setValue(data);
        row.addParam(param);
        param = new Param();
        param.setName("refreshTime");
        param.setValue(String.valueOf(refreshTime));
        row.addParam(param);
        param = new Param();
        param.setName("refreshStatus");
        param.setValue(String.valueOf(refreshStatus));
        row.addParam(param);
        bus.addRowParams(row);
        outputData.setBussinessParams(bus);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return outputData;
    }
}

