/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.servlet;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TEOTDRGenerateInSvrChartServlet
extends HttpServlet {
    private static final long serialVersionUID = -7095757628883918647L;

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException {
        this.doPost(req, rsp);
    }

    private static CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)series1), (Comparable)((Object)category1));
        dataset.addValue(4.0, (Comparable)((Object)series1), (Comparable)((Object)category2));
        dataset.addValue(3.0, (Comparable)((Object)series1), (Comparable)((Object)category3));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)category4));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)category5));
        dataset.addValue(5.0, (Comparable)((Object)series2), (Comparable)((Object)category1));
        dataset.addValue(7.0, (Comparable)((Object)series2), (Comparable)((Object)category2));
        dataset.addValue(6.0, (Comparable)((Object)series2), (Comparable)((Object)category3));
        dataset.addValue(8.0, (Comparable)((Object)series2), (Comparable)((Object)category4));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)category5));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)category1));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category2));
        dataset.addValue(2.0, (Comparable)((Object)series3), (Comparable)((Object)category3));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)category4));
        dataset.addValue(6.0, (Comparable)((Object)series3), (Comparable)((Object)category5));
        return dataset;
    }

    private static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart((String)"Bar Chart Demo 1", (String)"Category", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, new Color(64, 0, 0));
        renderer.setSeriesPaint(0, (Paint)gp0);
        renderer.setSeriesPaint(1, (Paint)gp1);
        renderer.setSeriesPaint(2, (Paint)gp2);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
        return chart;
    }

    public static Datainterface getDatabyFileName(String fileName) {
        Datainterface di = new Datainterface();
        String file = "d:/repeatChartInfo.xml";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            di = Datainterface.unmarshal((Reader)reader);
            di.getBussinessParams().getRowParams(0).getParam(0).setValue(fileName);
            StringWriter out = new StringWriter();
            di.marshal((Writer)out);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRGenerateInSvrChartServlet.getDatabyFileName() fail!", (Throwable)e);
        }
        return di;
    }

    public ArrayList ConvertDatainterfaceToArrayList(Datainterface data) {
        ArrayList<String> array = new ArrayList<String>();
        int len = data.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            Param param = data.getBussinessParams().getRowParams(i).getParam("repeaterPlus");
            if (param == null) continue;
            array.add(param.getValue());
        }
        return array;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException {
        String isDebug = req.getParameter("isDebug");
        boolean debug = isDebug != null;
        String filename = req.getParameter("filename");
        String[] files = filename.split(",");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Datainterface data = new Datainterface();
        int len = files.length;
        for (int i = 0; i < len; ++i) {
            if (debug) {
                data = TEOTDRGenerateInSvrChartServlet.getDatabyFileName(files[i]);
            } else {
                String oneFile = files[i];
                Object[][] repeatorArray = (Object[][])TESLMOTDRDataMgr.loadFileRepeatorContent(-1, oneFile);
                if (null == repeatorArray) {
                    return;
                }
                BussinessParams bus = new BussinessParams();
                RowParams row = null;
                Param param = null;
                String repeatorIDStr = null;
                String repeatorGain = null;
                for (int j = 0; j < repeatorArray.length; ++j) {
                    Object[] repeatorInfo = repeatorArray[j];
                    repeatorIDStr = repeatorInfo[0].toString();
                    repeatorGain = repeatorInfo[1].toString();
                    row = new RowParams();
                    param = new Param();
                    param.setName("repeatorID");
                    param.setValue(repeatorIDStr);
                    row.addParam(param);
                    param = new Param();
                    param.setName("repeatorGain");
                    param.setValue(repeatorGain);
                    row.addParam(param);
                    bus.addRowParams(row);
                }
                data.setBussinessParams(bus);
            }
            for (int j = 0; j < data.getBussinessParams().getRowParamsCount(); ++j) {
                Param repeaterLocation = data.getBussinessParams().getRowParams(j).getParam("repeatorID");
                Param repeaterPlus = data.getBussinessParams().getRowParams(j).getParam("repeatorGain");
                if (repeaterLocation == null) continue;
                double value = Double.parseDouble(repeaterPlus.getValue());
                dataset.addValue(value, (Comparable)((Object)files[i]), (Comparable)((Object)repeaterLocation.getValue()));
            }
        }
        JFreeChart chart = TEOTDRGenerateInSvrChartServlet.createChart((CategoryDataset)dataset);
        Font font = new Font(" \u00ba\u00da\u00cc\u00e5", 1, 20);
        TextTitle title = new TextTitle("OTDR Curve");
        title.setFont(font);
        chart.setTitle(title);
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)rsp.getOutputStream(), (JFreeChart)chart, (int)800, (int)570);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEOTDRGenerateInSvrChartServlet.doPost() fail!", (Throwable)e);
        }
    }

    public static void main(String[] args) {
    }
}

