/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.FileLocator;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class TESLMReportUtil {
    public static final String FILE_SPLIT_STR = "_";
    public static final int FILENAME_DATE_INDEX = 5;
    public static final String DATE_STR = "-";
    public static final String TIEM_STR = ":";

    public static String converNEFileNameToTestTime(String fileName, int neID) {
        Logger log = TELogFactory.getNormalLogger();
        log.info("Convert Time. neID: " + neID);
        int logicNEID = TENECommMgr.getInstance().getLogicNEID(neID);
        log.info("Convert Time. logicNEID: " + logicNEID);
        log.info("Convert Time. fileName: " + fileName);
        fileName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(fileName, logicNEID);
        log.info("Convert Time. fileName: " + fileName);
        String fileNameArray = fileName.substring(0, fileName.lastIndexOf("."));
        String testTime = fileNameArray.split(FILE_SPLIT_STR)[5];
        StringBuffer timeStr = new StringBuffer();
        int year = Integer.parseInt(testTime.substring(0, 4));
        int month = Integer.parseInt(testTime.substring(4, 6));
        int day = Integer.parseInt(testTime.substring(6, 8));
        int hour = Integer.parseInt(testTime.substring(8, 10));
        int minute = Integer.parseInt(testTime.substring(10, 12));
        int second = Integer.parseInt(testTime.substring(12, 14));
        timeStr.append(year);
        timeStr.append(DATE_STR);
        timeStr.append(month >= 10 ? String.valueOf(month) : "0" + month);
        timeStr.append(DATE_STR);
        timeStr.append(day >= 10 ? String.valueOf(day) : "0" + day);
        timeStr.append(" ");
        timeStr.append(hour >= 10 ? String.valueOf(hour) : "0" + hour);
        timeStr.append(TIEM_STR);
        timeStr.append(minute >= 10 ? String.valueOf(minute) : "0" + minute);
        timeStr.append(TIEM_STR);
        timeStr.append(second >= 10 ? String.valueOf(second) : "0" + second);
        return timeStr.toString();
    }

    public static Document parseFile(String filepath) {
        try {
            File fileObj = new File(filepath);
            URL url = fileObj.toURL();
            InputStream in = url.openStream();
            return TESLMReportUtil.parseFile(in);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMReportUtil.parseFile() fail!", (Throwable)e);
            return null;
        }
    }

    public static Document parseFile(InputStream in) {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builderFactory = DocumentBuilderFactory.newInstance();
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(in);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMReportUtil.parseFile() fail!", (Throwable)e);
            return null;
        }
        return doc;
    }

    public static boolean writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File fileObj = new File(filename);
            URL url = fileObj.toURL();
            String realPath = FileLocator.toFileURL((URL)url).getPath();
            File file = new File(realPath);
            StreamResult result = new StreamResult(file);
            if (!file.canWrite()) {
                file.delete();
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return true;
        }
        catch (TransformerConfigurationException e) {
            return false;
        }
        catch (TransformerException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getFormatResult(double result) {
        double tmpResult = (double)((long)(result * 1000.0)) / 1000.0;
        return String.valueOf(tmpResult);
    }

    public static int getPhyNEID(int logicNEID) {
        return TEConfigurationDataMgr.getInstance().getNEID(logicNEID);
    }
}

