/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterface;
import com.huawei.nglct.otdr.report.reportmgr.TESLMReportDataMgr;
import com.huawei.nglct.otdr.report.reportmodule.TESLMRepeaterReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportIndexData;
import com.huawei.nglct.otdr.report.util.TESLMReportUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TESLMRepeaterReportUtil {
    private static final String TEST_MODE = "testMode";
    private static final String LINE_ID = "lineID";
    private static final String TEST_TIME = "testTime";
    private static final String REPEATER_ID = "repeaterID";
    private static final String REPEATER_LOCATION = "repeaterLocation";
    private static final String DB_VALUE = "dbValue";
    private static final String NEID_ATTR = "neid";
    private static final String paramName = "param";

    public static void addReportData(String filePath, List reportDataList) {
        Document doc = TESLMReportUtil.parseFile(filePath);
        if (null == doc) {
            return;
        }
        int len = reportDataList.size();
        for (int i = 0; i < len; ++i) {
            TESLMRepeaterReport reportData = (TESLMRepeaterReport)reportDataList.get(i);
            Element file = TESLMRepeaterReportUtil.findParamNode(doc, reportData.getReportIndex());
            if (null == file) {
                file = doc.createElement(paramName);
                TESLMRepeaterReportUtil.addReportDataNode(filePath, doc, file, reportData);
                continue;
            }
            TESLMRepeaterReportUtil.refreshReportDataParam(filePath, doc, file, reportData);
        }
        doc.normalize();
        TESLMReportUtil.writeXmlFile(doc, filePath);
    }

    private static void addReportDataNode(String filePath, Document doc, Element fileEle, TESLMReportInterface reportData) {
        TESLMRepeaterReport eventReport = (TESLMRepeaterReport)reportData;
        TESLMReportIndexData index = eventReport.getReportIndex();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(NEID_ATTR, String.valueOf(index.getNeid()));
        attrMap.put(TEST_MODE, String.valueOf(index.getTestMode()));
        attrMap.put(LINE_ID, String.valueOf(index.getLineID()));
        attrMap.put(TEST_TIME, index.getTestTime());
        attrMap.put(REPEATER_ID, String.valueOf(index.getObjID()));
        attrMap.put(REPEATER_LOCATION, String.valueOf(eventReport.getRepeaterLocation()));
        attrMap.put(DB_VALUE, String.valueOf(eventReport.getDbValue()));
        DocumentFragment docfrag = doc.createDocumentFragment();
        Set entrySet = attrMap.entrySet();
        Map.Entry entry2 = null;
        String nodeName = null;
        String attrValue = null;
        for (Map.Entry entry2 : entrySet) {
            nodeName = String.valueOf(entry2.getKey());
            attrValue = String.valueOf(entry2.getValue());
            fileEle.setAttribute(nodeName, attrValue);
        }
        fileEle.appendChild(docfrag);
        doc.getDocumentElement().appendChild(fileEle);
    }

    private static void refreshReportDataParam(String filePath, Document doc, Element fileEle, TESLMReportInterface reportData) {
        TESLMRepeaterReport eventReport = (TESLMRepeaterReport)reportData;
        TESLMReportIndexData index = eventReport.getReportIndex();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(NEID_ATTR, String.valueOf(index.getNeid()));
        attrMap.put(TEST_MODE, String.valueOf(index.getTestMode()));
        attrMap.put(LINE_ID, String.valueOf(index.getLineID()));
        attrMap.put(TEST_TIME, index.getTestTime());
        attrMap.put(REPEATER_ID, String.valueOf(index.getObjID()));
        attrMap.put(REPEATER_LOCATION, String.valueOf(eventReport.getRepeaterLocation()));
        attrMap.put(DB_VALUE, String.valueOf(eventReport.getDbValue()));
        NodeList childNodeList = fileEle.getChildNodes();
        Node childNode = null;
        int ksize = childNodeList.getLength();
        for (int k = 0; k < ksize; ++k) {
            childNode = childNodeList.item(k);
            if (1 != childNode.getNodeType()) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getNodeName();
            childElement.setAttribute(nodeName, String.valueOf(attrMap.get(nodeName)));
        }
    }

    private static Element findParamNode(Document doc, TESLMReportIndexData index) {
        Node fileChildNode = null;
        Element fileChildElement = null;
        NodeList fileNodeList = doc.getElementsByTagName(paramName);
        int isize = fileNodeList.getLength();
        for (int i = 0; i < isize; ++i) {
            fileChildNode = fileNodeList.item(i);
            if (1 != fileChildNode.getNodeType()) continue;
            fileChildElement = (Element)fileChildNode;
            int testModeElement = Integer.parseInt(fileChildElement.getAttribute(TEST_MODE));
            int lineIDElement = Integer.parseInt(fileChildElement.getAttribute(LINE_ID));
            String testTimeElement = fileChildElement.getAttribute(TEST_TIME);
            int repeaterIDElement = Integer.parseInt(fileChildElement.getAttribute(REPEATER_ID));
            if (testModeElement != index.getTestMode() || lineIDElement != index.getLineID() || !testTimeElement.equals(index.getTestTime()) || repeaterIDElement != index.getObjID()) continue;
            return fileChildElement;
        }
        return null;
    }

    public static void deleteReportData(String filePath, List reportDataList) {
        try {
            Document doc = TESLMReportUtil.parseFile(filePath);
            if (null == doc) {
                return;
            }
            int len = reportDataList.size();
            for (int i = 0; i < len; ++i) {
                TESLMReportInterface data = (TESLMReportInterface)reportDataList.get(i);
                TESLMReportIndexData index = data.getReportIndex();
                Element file = TESLMRepeaterReportUtil.findParamNode(doc, index);
                if (null == file) continue;
                doc.getDocumentElement().removeChild(file);
            }
            doc.normalize();
            TESLMReportUtil.writeXmlFile(doc, filePath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMRepeaterReportUtil.deleteReportData() fail!", (Throwable)e);
        }
    }

    public static Datainterface getReportData(Datainterface inputData) {
        List reportInfoList = TESLMReportDataMgr.getInstance().getReportData(TESLMRepeaterReportUtil.parseInputData(inputData), 1);
        return TESLMRepeaterReportUtil.convertOutputData(reportInfoList);
    }

    private static Map parseInputData(Datainterface inputData) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        BussinessParams bussParams = inputData.getBussinessParams();
        for (int i = 0; i < bussParams.getRowParamsCount(); ++i) {
            RowParams rowParam = bussParams.getRowParams(i);
            paramMap.put("startTime", rowParam.getParam("startTime").getValue());
            paramMap.put("endTime", rowParam.getParam("endTime").getValue());
            paramMap.put(NEID_ATTR, rowParam.getParam(NEID_ATTR).getValue());
            paramMap.put(TEST_MODE, rowParam.getParam(TEST_MODE).getValue());
            paramMap.put(LINE_ID, rowParam.getParam(LINE_ID).getValue());
            paramMap.put(REPEATER_ID, rowParam.getParam("objID").getValue());
        }
        return paramMap;
    }

    private static Datainterface convertOutputData(List reportInfoList) {
        Datainterface outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        for (int i = 0; i < reportInfoList.size(); ++i) {
            TESLMRepeaterReport reportData = (TESLMRepeaterReport)reportInfoList.get(i);
            TESLMReportIndexData indexData = reportData.getReportIndex();
            RowParams row = new RowParams();
            Param neidParam = new Param();
            neidParam.setName(NEID_ATTR);
            neidParam.setValue(String.valueOf(indexData.getNeid()));
            row.addParam(neidParam);
            Param lineIDParam = new Param();
            lineIDParam.setName(LINE_ID);
            lineIDParam.setValue(String.valueOf(indexData.getLineID()));
            row.addParam(lineIDParam);
            Param testTimeParam = new Param();
            testTimeParam.setName(TEST_TIME);
            testTimeParam.setValue(String.valueOf(indexData.getTestTime()));
            row.addParam(testTimeParam);
            Param repeaterIDParam = new Param();
            repeaterIDParam.setName(REPEATER_ID);
            repeaterIDParam.setValue(String.valueOf(indexData.getObjID()));
            row.addParam(repeaterIDParam);
            Param locationParam = new Param();
            locationParam.setName(REPEATER_LOCATION);
            locationParam.setValue(TESLMReportUtil.getFormatResult(reportData.getRepeaterLocation()));
            row.addParam(locationParam);
            Param dbValueParam = new Param();
            dbValueParam.setName(DB_VALUE);
            dbValueParam.setValue(String.valueOf(reportData.getDbValue()));
            row.addParam(dbValueParam);
            bussiness.addRowParams(row);
        }
        outputData.setBussinessParams(bussiness);
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage((int)0);
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }

    public static Datainterface getRepeaterIDListData(int neid, int testMode) {
        Integer lineID;
        Map repeaterReportMap = TESLMReportDataMgr.getInstance().getRepeaterReportMap();
        HashMap<Integer, String> repeaterMap = new HashMap<Integer, String>();
        Set entrySet = repeaterReportMap.entrySet();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : entrySet) {
            TESLMReportIndexData index = (TESLMReportIndexData)entry2.getKey();
            lineID = new Integer(index.getLineID());
            int repeaterID = index.getObjID();
            int reportNEID = index.getNeid();
            int testModeValue = index.getTestMode();
            if (reportNEID != neid || testModeValue != testMode) continue;
            if (!repeaterMap.containsKey(lineID)) {
                repeaterMap.put(lineID, String.valueOf(repeaterID));
                continue;
            }
            String repeaterStr = (String)repeaterMap.get(lineID);
            repeaterStr = repeaterStr + "-" + repeaterID;
            repeaterMap.put(lineID, repeaterStr);
        }
        Datainterface outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        entrySet = repeaterMap.entrySet();
        for (Map.Entry entry2 : entrySet) {
            RowParams row = new RowParams();
            Param lineIDParam = new Param();
            lineIDParam.setName(LINE_ID);
            lineID = (Integer)entry2.getKey();
            lineIDParam.setValue(lineID.toString());
            row.addParam(lineIDParam);
            Param repeaterListParam = new Param();
            repeaterListParam.setName("repeaterList");
            repeaterListParam.setValue((String)entry2.getValue());
            row.addParam(repeaterListParam);
            bussiness.addRowParams(row);
        }
        outputData.setBussinessParams(bussiness);
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage((int)0);
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }
}

