/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.util;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterface;
import com.huawei.nglct.otdr.report.reportmgr.TESLMReportDataMgr;
import com.huawei.nglct.otdr.report.reportmodule.TESLMEventReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportIndexData;
import com.huawei.nglct.otdr.report.util.TESLMReportUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TESLMEventReportUtil {
    private static final String TEST_MODE = "testMode";
    private static final String LINE_ID = "lineID";
    private static final String TEST_TIME = "testTime";
    private static final String EVENT_ID = "eventID";
    private static final String EVENT_LOCATION = "eventLocation";
    private static final String EVENT_TYPE = "eventType";
    private static final String NEID_ATTR = "neid";
    private static final String paramName = "param";

    public static void addReportData(String filePath, List eventDataList) {
        Document doc = TESLMReportUtil.parseFile(filePath);
        if (null == doc) {
            return;
        }
        int len = eventDataList.size();
        for (int i = 0; i < len; ++i) {
            TESLMEventReport reportData = (TESLMEventReport)eventDataList.get(i);
            Element file = TESLMEventReportUtil.findParamNode(doc, reportData.getReportIndex());
            if (null == file) {
                file = doc.createElement(paramName);
                TESLMEventReportUtil.addReportDataNode(filePath, doc, file, reportData);
                continue;
            }
            TESLMEventReportUtil.refreshReportDataParam(filePath, doc, file, reportData);
        }
        doc.normalize();
        TESLMReportUtil.writeXmlFile(doc, filePath);
    }

    private static void addReportDataNode(String filePath, Document doc, Element fileEle, TESLMReportInterface reportData) {
        TESLMEventReport eventReport = (TESLMEventReport)reportData;
        TESLMReportIndexData index = eventReport.getReportIndex();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(NEID_ATTR, String.valueOf(index.getNeid()));
        attrMap.put(TEST_MODE, String.valueOf(index.getTestMode()));
        attrMap.put(LINE_ID, String.valueOf(index.getLineID()));
        attrMap.put(TEST_TIME, index.getTestTime());
        attrMap.put(EVENT_ID, String.valueOf(index.getObjID()));
        attrMap.put(EVENT_LOCATION, String.valueOf(eventReport.getEventLocation()));
        attrMap.put(EVENT_TYPE, String.valueOf(eventReport.getEventType()));
        DocumentFragment docfrag = doc.createDocumentFragment();
        Set entrySet = attrMap.entrySet();
        Map.Entry entry2 = null;
        String nodeName = null;
        String attrValue = null;
        for (Map.Entry entry2 : entrySet) {
            nodeName = String.valueOf(entry2.getKey());
            attrValue = String.valueOf(entry2.getValue());
            fileEle.setAttribute(nodeName, attrValue);
        }
        fileEle.appendChild(docfrag);
        doc.getDocumentElement().appendChild(fileEle);
    }

    private static void refreshReportDataParam(String filePath, Document doc, Element fileEle, TESLMReportInterface reportData) {
        TESLMEventReport eventReport = (TESLMEventReport)reportData;
        TESLMReportIndexData index = eventReport.getReportIndex();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(TEST_MODE, String.valueOf(index.getTestMode()));
        attrMap.put(LINE_ID, String.valueOf(index.getLineID()));
        attrMap.put(TEST_TIME, index.getTestTime());
        attrMap.put(EVENT_ID, String.valueOf(index.getObjID()));
        attrMap.put(EVENT_LOCATION, String.valueOf(eventReport.getEventLocation()));
        attrMap.put(EVENT_TYPE, String.valueOf(eventReport.getEventType()));
        NodeList childNodeList = fileEle.getChildNodes();
        Node childNode = null;
        int ksize = childNodeList.getLength();
        for (int k = 0; k < ksize; ++k) {
            childNode = childNodeList.item(k);
            if (1 != childNode.getNodeType()) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getNodeName();
            childElement.setAttribute(nodeName, String.valueOf(attrMap.get(nodeName)));
        }
    }

    private static Element findParamNode(Document doc, TESLMReportIndexData index) {
        Node fileChildNode = null;
        Element fileChildElement = null;
        NodeList fileNodeList = doc.getElementsByTagName(paramName);
        int isize = fileNodeList.getLength();
        for (int i = 0; i < isize; ++i) {
            fileChildNode = fileNodeList.item(i);
            if (1 != fileChildNode.getNodeType()) continue;
            fileChildElement = (Element)fileChildNode;
            int testModeElement = Integer.parseInt(fileChildElement.getAttribute(TEST_MODE));
            int lineIDElement = Integer.parseInt(fileChildElement.getAttribute(LINE_ID));
            String testTimeElement = fileChildElement.getAttribute(TEST_TIME);
            int eventIDElement = Integer.parseInt(fileChildElement.getAttribute(EVENT_ID));
            if (testModeElement != index.getTestMode() || lineIDElement != index.getLineID() || !testTimeElement.equals(index.getTestTime()) || eventIDElement != index.getObjID()) continue;
            return fileChildElement;
        }
        return null;
    }

    public static void deleteReportData(String filePath, List dataList) {
        try {
            Document doc = TESLMReportUtil.parseFile(filePath);
            if (null == doc) {
                return;
            }
            int len = dataList.size();
            for (int i = 0; i < len; ++i) {
                TESLMReportInterface data = (TESLMReportInterface)dataList.get(i);
                TESLMReportIndexData index = data.getReportIndex();
                Element file = TESLMEventReportUtil.findParamNode(doc, index);
                if (null == file) continue;
                doc.getDocumentElement().removeChild(file);
            }
            doc.normalize();
            TESLMReportUtil.writeXmlFile(doc, filePath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMEventReportUtil.deleteReportData() fail!", (Throwable)e);
        }
    }

    public static Datainterface getReportData(Datainterface inputData) {
        List reportInfoList = TESLMReportDataMgr.getInstance().getReportData(TESLMEventReportUtil.parseEventInputData(inputData), 2);
        return TESLMEventReportUtil.convertEventOutputData(reportInfoList);
    }

    private static Map parseEventInputData(Datainterface inputData) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        BussinessParams bussParams = inputData.getBussinessParams();
        for (int i = 0; i < bussParams.getRowParamsCount(); ++i) {
            RowParams rowParam = bussParams.getRowParams(i);
            paramMap.put("startTime", rowParam.getParam("startTime").getValue());
            paramMap.put("endTime", rowParam.getParam("endTime").getValue());
            paramMap.put(NEID_ATTR, rowParam.getParam(NEID_ATTR).getValue());
            paramMap.put(TEST_MODE, rowParam.getParam(TEST_MODE).getValue());
            paramMap.put(LINE_ID, rowParam.getParam(LINE_ID).getValue());
            paramMap.put(EVENT_TYPE, rowParam.getParam("objID").getValue());
        }
        return paramMap;
    }

    private static Datainterface convertEventOutputData(List reportInfoList) {
        Datainterface outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        for (int i = 0; i < reportInfoList.size(); ++i) {
            TESLMEventReport reportData = (TESLMEventReport)reportInfoList.get(i);
            TESLMReportIndexData indexData = reportData.getReportIndex();
            RowParams row = new RowParams();
            Param neidParam = new Param();
            neidParam.setName(NEID_ATTR);
            neidParam.setValue(String.valueOf(indexData.getNeid()));
            row.addParam(neidParam);
            Param lineIDParam = new Param();
            lineIDParam.setName(LINE_ID);
            lineIDParam.setValue(String.valueOf(indexData.getLineID()));
            row.addParam(lineIDParam);
            Param testTimeParam = new Param();
            testTimeParam.setName(TEST_TIME);
            testTimeParam.setValue(String.valueOf(indexData.getTestTime()));
            row.addParam(testTimeParam);
            Param repeaterIDParam = new Param();
            repeaterIDParam.setName(EVENT_ID);
            repeaterIDParam.setValue(String.valueOf(indexData.getObjID()));
            row.addParam(repeaterIDParam);
            Param locationParam = new Param();
            locationParam.setName(EVENT_LOCATION);
            locationParam.setValue(TESLMReportUtil.getFormatResult(reportData.getEventLocation()));
            row.addParam(locationParam);
            Param dbValueParam = new Param();
            dbValueParam.setName(EVENT_TYPE);
            dbValueParam.setValue(String.valueOf(reportData.getEventType()));
            row.addParam(dbValueParam);
            bussiness.addRowParams(row);
        }
        outputData.setBussinessParams(bussiness);
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage((int)0);
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }

    public static Datainterface getLineIDList(int neid, int testMode) {
        Map eventReportMap = TESLMReportDataMgr.getInstance().getEventReportMap();
        Set entrySet = eventReportMap.entrySet();
        Map.Entry entry = null;
        Iterator iter = entrySet.iterator();
        String repeaterStr = "";
        Datainterface outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        while (iter.hasNext()) {
            entry = iter.next();
            TESLMReportIndexData index = (TESLMReportIndexData)entry.getKey();
            Integer lineID = new Integer(index.getLineID());
            int reportNEID = index.getNeid();
            int testModeValue = index.getTestMode();
            if (reportNEID != neid || testModeValue != testMode) continue;
            RowParams row = new RowParams();
            Param lineIDParam = new Param();
            lineIDParam.setName(LINE_ID);
            lineIDParam.setValue(lineID.toString());
            row.addParam(lineIDParam);
            Param repeaterListParam = new Param();
            repeaterListParam.setName("repeaterList");
            repeaterListParam.setValue(repeaterStr);
            row.addParam(repeaterListParam);
            bussiness.addRowParams(row);
        }
        outputData.setBussinessParams(bussiness);
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage((int)0);
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }
}

