/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.reportmodule;

import com.huawei.nglct.otdr.report.TESLMReportConstance;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportFactoryInterface;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterpreterInterface;
import com.huawei.nglct.util.xml.TERWCfgFile;
import java.io.File;
import java.util.List;
import java.util.Map;

public class TESLMReportHandlerData {
    private int reportType;
    private String xmlFileName = "";
    private TESLMReportFactoryInterface reportFactory;
    private TESLMReportInterpreterInterface reportInterpreter;

    public TESLMReportHandlerData(int reportType, String xmlFileName, TESLMReportFactoryInterface reportFactory, TESLMReportInterpreterInterface reportInterpreter) {
        this.reportType = reportType;
        this.xmlFileName = xmlFileName;
        this.reportFactory = reportFactory;
        this.reportInterpreter = reportInterpreter;
    }

    public void addReportData(List reportDataList) {
        this.reportFactory.addReportData(reportDataList, this.getXMLFilePath(this.xmlFileName));
    }

    public void delRepotData(List removeDataList) {
        this.reportFactory.delReportData(removeDataList, this.getXMLFilePath(this.xmlFileName));
    }

    public List getReportData(Map inputMap) {
        return this.reportFactory.getReportData(inputMap);
    }

    private String getXMLFilePath(String fileName) {
        StringBuffer str = new StringBuffer();
        String relativePath = TESLMReportConstance.OTDR_ROOT_PATH + File.separator + fileName;
        str.append(TERWCfgFile.getBundleRWCfgFilePath(this.getClass(), (String)relativePath));
        return str.toString();
    }

    public TESLMReportFactoryInterface getReportFactory() {
        return this.reportFactory;
    }

    public void setReportFactory(TESLMReportFactoryInterface reportFactory) {
        this.reportFactory = reportFactory;
    }

    public TESLMReportInterpreterInterface getReportInterpreter() {
        return this.reportInterpreter;
    }

    public void setReportInterpreter(TESLMReportInterpreterInterface reportInterpreter) {
        this.reportInterpreter = reportInterpreter;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.reportType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMReportHandlerData other = (TESLMReportHandlerData)obj;
        return this.reportType == other.reportType;
    }
}

