/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.reportmodule;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterpreterInterface;
import com.huawei.nglct.otdr.report.reportmodule.TESLMRepeaterReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportIndexData;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TESLMRepeaterReportInterpreter
implements TESLMReportInterpreterInterface {
    @Override
    public void buildReportData(String filePath, Map desMap) {
        try {
            File file = new File(filePath);
            URL url = file.toURI().toURL();
            Document doc = TEParseXMLFile.parseFile((InputStream)url.openStream());
            NodeList children = doc.getElementsByTagName("param");
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)children.item(i);
                int neid = Integer.parseInt(element.getAttribute("neid"));
                int testMode = Integer.parseInt(element.getAttribute("testMode"));
                int lineID = Integer.parseInt(element.getAttribute("lineID"));
                String testTime = element.getAttribute("testTime");
                int repeaterID = Integer.parseInt(element.getAttribute("repeaterID"));
                double repeaterLocation = Double.parseDouble(element.getAttribute("repeaterLocation"));
                float dbValue = Float.parseFloat(element.getAttribute("dbValue"));
                TESLMReportIndexData index = new TESLMReportIndexData(neid, lineID, testTime, repeaterID, testMode);
                TESLMRepeaterReport reportData = new TESLMRepeaterReport(index, repeaterLocation, dbValue);
                desMap.put(index, reportData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMRepeaterReportInterpreter.buildReportData() Exception!", (Throwable)e);
        }
    }
}

