/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.reportmodule;

import com.huawei.nglct.otdr.report.reportinterface.TESLMReportFactoryInterface;
import com.huawei.nglct.otdr.report.reportmgr.TESLMReportDataMgr;
import com.huawei.nglct.otdr.report.reportmodule.TESLMEventReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportIndexData;
import com.huawei.nglct.otdr.report.util.TESLMEventReportUtil;
import com.huawei.nglct.otdr.report.util.TESLMReportUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TESLMEventReportFactory
implements TESLMReportFactoryInterface {
    @Override
    public void addReportData(List dataList, String filePath) {
        TESLMEventReportUtil.addReportData(filePath, dataList);
    }

    @Override
    public void cleanRePortData(Object obj, String filePath) {
    }

    @Override
    public void delReportData(List dataList, String filePath) {
        TESLMEventReportUtil.deleteReportData(filePath, dataList);
    }

    @Override
    public List getReportData(Map inputMap) {
        int logicNEID = Integer.parseInt((String)inputMap.get("neid"));
        int neid = TESLMReportUtil.getPhyNEID(logicNEID);
        int testMode = Integer.parseInt(String.valueOf(inputMap.get("testMode")));
        int lineID = Integer.parseInt((String)inputMap.get("lineID"));
        int eventType = Integer.parseInt((String)inputMap.get("eventType"));
        String startTime = (String)inputMap.get("startTime");
        String endTime = (String)inputMap.get("endTime");
        if (0 == lineID && 0 == eventType) {
            return this.getReportData(neid, testMode, startTime, endTime);
        }
        if (0 != lineID && 0 == eventType) {
            return this.getReportData(neid, testMode, startTime, endTime, lineID);
        }
        if (0 == lineID && 0 != eventType) {
            return this.getEventTypeReportData(neid, testMode, startTime, endTime, eventType);
        }
        if (0 != lineID && 0 != eventType) {
            return this.getReportData(neid, testMode, startTime, endTime, lineID, eventType);
        }
        return null;
    }

    private List getReportData(int neid, int testMode, String startTime, String endTime) {
        ArrayList<TESLMEventReport> objList = new ArrayList<TESLMEventReport>();
        Set entrySet = TESLMReportDataMgr.getInstance().getEventReportMap().entrySet();
        for (Map.Entry entry : entrySet) {
            TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
            TESLMEventReport reportData = (TESLMEventReport)entry.getValue();
            String testTime = indexData.getTestTime();
            int localTestMode = indexData.getTestMode();
            if (startTime.compareTo(testTime) > 0 || endTime.compareTo(testTime) < 0 || neid != indexData.getNeid() || testMode != localTestMode) continue;
            objList.add(reportData);
        }
        return objList;
    }

    private List getReportData(int neid, int testMode, String startTime, String endTime, int lineID) {
        ArrayList<TESLMEventReport> objList = new ArrayList<TESLMEventReport>();
        Set entrySet = TESLMReportDataMgr.getInstance().getEventReportMap().entrySet();
        for (Map.Entry entry : entrySet) {
            TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
            TESLMEventReport reportData = (TESLMEventReport)entry.getValue();
            String testTime = indexData.getTestTime();
            int localTestMode = indexData.getTestMode();
            if (startTime.compareTo(testTime) > 0 || endTime.compareTo(testTime) < 0 || neid != indexData.getNeid() || lineID != indexData.getLineID() || testMode != localTestMode) continue;
            objList.add(reportData);
        }
        return objList;
    }

    private List getReportData(int neid, int testMode, String startTime, String endTime, int lineID, int eventType) {
        ArrayList<TESLMEventReport> objList = new ArrayList<TESLMEventReport>();
        Set entrySet = TESLMReportDataMgr.getInstance().getEventReportMap().entrySet();
        for (Map.Entry entry : entrySet) {
            TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
            TESLMEventReport reportData = (TESLMEventReport)entry.getValue();
            String testTime = indexData.getTestTime();
            int localTestMode = indexData.getTestMode();
            if (startTime.compareTo(testTime) > 0 || endTime.compareTo(testTime) < 0 || neid != indexData.getNeid() || lineID != indexData.getLineID() || eventType != reportData.getEventType() || testMode != localTestMode) continue;
            objList.add(reportData);
        }
        return objList;
    }

    private List getEventTypeReportData(int neid, int testMode, String startTime, String endTime, int eventType) {
        ArrayList<TESLMEventReport> objList = new ArrayList<TESLMEventReport>();
        Set entrySet = TESLMReportDataMgr.getInstance().getEventReportMap().entrySet();
        for (Map.Entry entry : entrySet) {
            TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
            TESLMEventReport reportData = (TESLMEventReport)entry.getValue();
            String testTime = indexData.getTestTime();
            int localTestMode = indexData.getTestMode();
            if (startTime.compareTo(testTime) > 0 || endTime.compareTo(testTime) < 0 || neid != indexData.getNeid() || eventType != reportData.getEventType() || testMode != localTestMode) continue;
            objList.add(reportData);
        }
        return objList;
    }
}

