/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.reportmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.otdr.report.TESLMReportConstance;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportFactoryInterface;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterpreterInterface;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportHandlerData;
import com.huawei.nglct.util.xml.TERWCfgFile;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TESLMReportHandlerMgr {
    private HashMap handlerMap = new HashMap();
    private HashMap reportClassMap = new HashMap();
    private static final String REPORT_PROPERTY_XML_PATH = TERWCfgFile.getBundleRWCfgFilePath(TESLMReportHandlerMgr.class, (String)TESLMReportConstance.REPORT_PROPERTY_FILE_PATH);
    private static TESLMReportHandlerMgr instance = new TESLMReportHandlerMgr();

    public static TESLMReportHandlerMgr getInstance() {
        return instance;
    }

    private TESLMReportHandlerMgr() {
        this.initHandlerData();
    }

    private void initHandlerData() {
        try {
            File file = new File(REPORT_PROPERTY_XML_PATH);
            URL url = file.toURI().toURL();
            Document doc = TEParseXMLFile.parseFile((InputStream)url.openStream());
            NodeList children = doc.getElementsByTagName("property");
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)children.item(i);
                int reportType = Integer.parseInt(element.getAttribute("reportType"));
                String xmlFileName = element.getAttribute("xmlFileName");
                String factoryClassMapping = element.getAttribute("factoryObj");
                String interpreterClassMapping = element.getAttribute("interpreterObj");
                String reportClassMapping = element.getAttribute("reportObj");
                TESLMReportFactoryInterface reportFactory = (TESLMReportFactoryInterface)Class.forName(factoryClassMapping).newInstance();
                TESLMReportInterpreterInterface reportInterpreter = (TESLMReportInterpreterInterface)Class.forName(interpreterClassMapping).newInstance();
                TESLMReportHandlerData reportHandlerData = new TESLMReportHandlerData(reportType, xmlFileName, reportFactory, reportInterpreter);
                this.handlerMap.put(new Integer(reportType), reportHandlerData);
                this.reportClassMap.put(new Integer(reportType), reportClassMapping);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("msg", (Throwable)e);
        }
    }

    public TESLMReportHandlerData getReportHandler(Integer reportType) {
        if (null != this.handlerMap && !this.handlerMap.isEmpty()) {
            return (TESLMReportHandlerData)this.handlerMap.get(reportType);
        }
        return null;
    }

    public TESLMReportFactoryInterface getReportFactory(Integer reportType) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        if (null != handler) {
            return handler.getReportFactory();
        }
        return null;
    }

    public TESLMReportInterpreterInterface getInterpreter(Integer reportType) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        if (null != handler) {
            return handler.getReportInterpreter();
        }
        return null;
    }

    public String getReportClassMapping(Integer reportType) {
        if (null != this.reportClassMap && !this.reportClassMap.isEmpty()) {
            return (String)this.reportClassMap.get(reportType);
        }
        return null;
    }

    public String getXMLFileName(Integer reportType) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        if (null != handler) {
            return handler.getXmlFileName();
        }
        return null;
    }

    public void addReportData(Integer reportType, List reportDataList) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        handler.addReportData(reportDataList);
    }

    public void delReportData(Integer reportType, List removeDataList) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        handler.delRepotData(removeDataList);
    }

    public List getReportData(Integer reportType, Map inputMap) {
        TESLMReportHandlerData handler = this.getReportHandler(reportType);
        return handler.getReportData(inputMap);
    }

    public HashMap getHandlerMap() {
        return this.handlerMap;
    }

    public void setHandlerMap(HashMap handlerMap) {
        this.handlerMap = handlerMap;
    }

    public HashMap getReportClassMap() {
        return this.reportClassMap;
    }

    public void setReportClassMap(HashMap reportClassMap) {
        this.reportClassMap = reportClassMap;
    }
}

