/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report.reportmgr;

import com.huawei.nglct.otdr.report.TESLMReportConstance;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterface;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterpreterInterface;
import com.huawei.nglct.otdr.report.reportmgr.TESLMReportHandlerMgr;
import com.huawei.nglct.otdr.report.reportmodule.TESLMEventReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMRepeaterReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMReportIndexData;
import com.huawei.nglct.util.xml.TERWCfgFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TESLMReportDataMgr {
    private Map repeaterReportMap = new HashMap();
    private Map eventReportMap = new HashMap();
    private TESLMReportHandlerMgr reportHandlerMgr = TESLMReportHandlerMgr.getInstance();
    private static TESLMReportDataMgr instance = new TESLMReportDataMgr();

    private TESLMReportDataMgr() {
        this.initReportData();
    }

    public static TESLMReportDataMgr getInstance() {
        return instance;
    }

    private void initReportData() {
        for (Integer reportType : this.reportHandlerMgr.getHandlerMap().keySet()) {
            String filePath;
            TESLMReportInterpreterInterface interpreter = this.reportHandlerMgr.getInterpreter(reportType);
            if (1 == reportType) {
                filePath = this.getXMLFilePath(new Integer(1));
                if (null == filePath) continue;
                interpreter.buildReportData(filePath, this.repeaterReportMap);
                continue;
            }
            if (2 != reportType || null == (filePath = this.getXMLFilePath(new Integer(2)))) continue;
            interpreter.buildReportData(filePath, this.eventReportMap);
        }
    }

    public void addReportData(int reportType, List reportDataList) {
        int len = reportDataList.size();
        for (int i = 0; i < len; ++i) {
            TESLMReportInterface data;
            if (1 == reportType) {
                data = (TESLMRepeaterReport)reportDataList.get(i);
                this.repeaterReportMap.put(data.getReportIndex(), data);
                continue;
            }
            if (2 != reportType) continue;
            data = (TESLMEventReport)reportDataList.get(i);
            this.eventReportMap.put(data.getReportIndex(), data);
        }
        this.reportHandlerMgr.addReportData(new Integer(reportType), reportDataList);
    }

    public void delReportData(int neid, int lineID, int reportType, String testTime, int testMode) {
        ArrayList removeDataList = new ArrayList();
        if (1 == reportType) {
            Set entrySet = this.repeaterReportMap.entrySet();
            Map.Entry entry = null;
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
                if (neid != indexData.getNeid() || lineID != indexData.getLineID() || !testTime.equalsIgnoreCase(indexData.getTestTime()) || testMode != indexData.getTestMode()) continue;
                removeDataList.add(entry.getValue());
                iter.remove();
            }
        } else if (2 == reportType) {
            Set entrySet = this.eventReportMap.entrySet();
            Map.Entry entry = null;
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                TESLMReportIndexData indexData = (TESLMReportIndexData)entry.getKey();
                if (neid != indexData.getNeid() || lineID != indexData.getLineID() || !testTime.equalsIgnoreCase(indexData.getTestTime()) || testMode != indexData.getTestMode()) continue;
                removeDataList.add(entry.getValue());
                iter.remove();
            }
        }
        if (removeDataList.size() > 0) {
            this.reportHandlerMgr.delReportData(new Integer(reportType), removeDataList);
        }
    }

    public void delReportData(int neid, int lineID) {
        TESLMReportIndexData indexData;
        ArrayList removeRptDataList = new ArrayList();
        ArrayList removeEventDataList = new ArrayList();
        Set entrySet = this.repeaterReportMap.entrySet();
        Map.Entry entry = null;
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            indexData = (TESLMReportIndexData)entry.getKey();
            if (neid != indexData.getNeid() || lineID != indexData.getLineID()) continue;
            removeRptDataList.add(entry.getValue());
            iter.remove();
        }
        entrySet = this.eventReportMap.entrySet();
        entry = null;
        iter = entrySet.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            indexData = (TESLMReportIndexData)entry.getKey();
            if (neid != indexData.getNeid() || lineID != indexData.getLineID()) continue;
            removeEventDataList.add(entry.getValue());
            iter.remove();
        }
        if (removeRptDataList.size() > 0) {
            this.reportHandlerMgr.delReportData(new Integer(1), removeRptDataList);
        }
        if (removeEventDataList.size() > 0) {
            this.reportHandlerMgr.delReportData(new Integer(2), removeEventDataList);
        }
    }

    public void delReportData(int neid) {
        TESLMReportIndexData indexData;
        ArrayList removeRptDataList = new ArrayList();
        ArrayList removeEventDataList = new ArrayList();
        Set entrySet = this.repeaterReportMap.entrySet();
        Map.Entry entry = null;
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            indexData = (TESLMReportIndexData)entry.getKey();
            if (neid != indexData.getNeid()) continue;
            removeRptDataList.add(entry.getValue());
            iter.remove();
        }
        entrySet = this.eventReportMap.entrySet();
        entry = null;
        iter = entrySet.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            indexData = (TESLMReportIndexData)entry.getKey();
            if (neid != indexData.getNeid()) continue;
            removeEventDataList.add(entry.getValue());
            iter.remove();
        }
        if (removeRptDataList.size() > 0) {
            this.reportHandlerMgr.delReportData(new Integer(1), removeRptDataList);
        }
        if (removeEventDataList.size() > 0) {
            this.reportHandlerMgr.delReportData(new Integer(2), removeEventDataList);
        }
    }

    public List getReportData(Map inputMap, int reportType) {
        return this.reportHandlerMgr.getReportData(new Integer(reportType), inputMap);
    }

    private String getXMLFilePath(Integer reportType) {
        String fileName = this.reportHandlerMgr.getXMLFileName(reportType);
        String relativePath = TESLMReportConstance.OTDR_ROOT_PATH + File.separator + fileName;
        String filePath = TERWCfgFile.getBundleRWCfgFilePath(this.getClass(), (String)relativePath);
        return filePath;
    }

    public Map getEventReportMap() {
        return this.eventReportMap;
    }

    public void setEventReportMap(HashMap eventReportMap) {
        this.eventReportMap = eventReportMap;
    }

    public Map getRepeaterReportMap() {
        return this.repeaterReportMap;
    }

    public void setRepeaterReportMap(HashMap repeaterReportMap) {
        this.repeaterReportMap = repeaterReportMap;
    }
}

