/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.report;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.otdr.report.reportinterface.TESLMReportInterface;
import com.huawei.nglct.otdr.report.reportmgr.TESLMReportDataMgr;
import com.huawei.nglct.otdr.report.reportmodule.TESLMEventReport;
import com.huawei.nglct.otdr.report.reportmodule.TESLMRepeaterReport;
import com.huawei.nglct.otdr.report.util.TESLMEventReportUtil;
import com.huawei.nglct.otdr.report.util.TESLMRepeaterReportUtil;
import com.huawei.nglct.otdr.report.util.TESLMReportUtil;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESLMReportInf {
    private static final String SORT_BY_ASC = "asc";
    private static final String LINE_ID_PARAM = "lineID";
    private static final String TESTING_TIME_PARAM = "testTime";
    private static final String REPEATER_ID_PARAM = "repeaterID";
    private static final String EVENT_ID_PARAM = "eventID";

    public static Datainterface getAllReportData(Datainterface inputData) {
        Datainterface outputData = null;
        RowParams rowParam = inputData.getBussinessParams().getRowParams(0);
        int reportType = Integer.parseInt(rowParam.getParam("reportType").getValue());
        if (1 == reportType) {
            outputData = TESLMRepeaterReportUtil.getReportData(inputData);
        } else if (2 == reportType) {
            outputData = TESLMEventReportUtil.getReportData(inputData);
        }
        if (null != outputData && 0 != outputData.getBussinessParams().getRowParamsCount()) {
            TESLMReportInf.sortData(outputData, inputData.getPageParams());
        }
        return outputData;
    }

    public static Datainterface getRepeaterList(int neid, int testMode) {
        return TESLMRepeaterReportUtil.getRepeaterIDListData(neid, testMode);
    }

    public static Datainterface getEventLineIDList(int neid, int testMode) {
        return TESLMEventReportUtil.getLineIDList(neid, testMode);
    }

    public static void addReportData(int neid, int lineID, String fileName, int reportType, Object reportData) {
        TESLMReportInterface data;
        int testMode;
        Object[] info;
        int i;
        ArrayList<TESLMRepeaterReport> reportDataList = new ArrayList<TESLMRepeaterReport>();
        if (null == reportData) {
            return;
        }
        Object[][] infoArray = (Object[][])reportData;
        Logger log = TELogFactory.getNormalLogger();
        log.info("Add Report convert time. fileName: " + fileName);
        String testTime = TESLMReportUtil.converNEFileNameToTestTime(fileName, neid);
        log.info("Add Report convert time. testTime: " + testTime);
        if (1 == reportType) {
            for (i = 0; i < infoArray.length; ++i) {
                info = infoArray[i];
                int repeaterID = Integer.parseInt((String)info[0]);
                float dbValue = Float.parseFloat((String)info[1]);
                double repeaterLocation = Double.parseDouble((String)info[2]);
                testMode = Integer.parseInt((String)info[3]);
                data = new TESLMRepeaterReport(neid, lineID, testTime, repeaterID, repeaterLocation, dbValue, testMode);
                reportDataList.add((TESLMRepeaterReport)data);
            }
        }
        if (2 == reportType) {
            for (i = 0; i < infoArray.length; ++i) {
                info = infoArray[i];
                int eventID = Integer.parseInt((String)info[0]);
                double eventLocation = Double.parseDouble((String)info[1]);
                int eventType = Integer.parseInt((String)info[2]);
                testMode = Integer.parseInt((String)info[3]);
                data = new TESLMEventReport(neid, lineID, testTime, eventID, eventLocation, eventType, testMode);
                reportDataList.add((TESLMRepeaterReport)data);
            }
        }
        TESLMReportDataMgr.getInstance().addReportData(reportType, reportDataList);
    }

    public static void delReportData(int neid, int lineID) {
        TESLMReportDataMgr.getInstance().delReportData(neid, lineID);
    }

    public static void delReportData(int neid) {
        TESLMReportDataMgr.getInstance().delReportData(neid);
    }

    public static void delReportData(int neid, int lineID, int reportType, String fileName, int testMode) {
        Logger log = TELogFactory.getNormalLogger();
        log.info("Del Report convert time. fileName: " + fileName);
        String testTime = TESLMReportUtil.converNEFileNameToTestTime(fileName, neid);
        log.info("Del Report convert time. testTime: " + testTime);
        TESLMReportDataMgr.getInstance().delReportData(neid, lineID, reportType, testTime, testMode);
    }

    private static void sortData(Datainterface allData, PageParams pageparams) {
        String sortby = SORT_BY_ASC;
        TESLMReportInf.sortDatainterface(allData, sortby);
    }

    private static void sortDatainterface(Datainterface allData, String sortby) {
        try {
            allData.getBussinessParams().addRowParams(0, new RowParams());
            RowParams[] rowparams = allData.getBussinessParams().getRowParams();
            TESLMReportInf.quickSort(rowparams, sortby, 1, rowparams.length - 1);
            allData.getBussinessParams().setRowParams(rowparams);
            allData.getBussinessParams().removeRowParams(0);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESLMHFCPFileUtil.sortDatainterface() fail!", (Throwable)e);
            return;
        }
    }

    private static void quickSort(RowParams[] rowparams, String sortby, int low, int high) {
        if (low < high) {
            int pivotloc = TESLMReportInf.partition(rowparams, sortby, low, high);
            TESLMReportInf.quickSort(rowparams, sortby, low, pivotloc - 1);
            TESLMReportInf.quickSort(rowparams, sortby, pivotloc + 1, high);
        }
    }

    private static int partition(RowParams[] rowparams, String sortby, int low, int high) {
        return TESLMReportInf.partitionByOneSortParam(rowparams, sortby, low, high);
    }

    private static int partitionByOneSortParam(RowParams[] rowparams, String sortby, int low, int high) {
        rowparams[0] = rowparams[low];
        while (low < high) {
            while (low < high) {
                if (sortby.equals(SORT_BY_ASC)) {
                    if (!TESLMReportInf.getHighCompareValue(rowparams, high)) break;
                    --high;
                    continue;
                }
                if (TESLMReportInf.getHighCompareValue(rowparams, high)) break;
                --high;
            }
            rowparams[low] = rowparams[high];
            while (low < high) {
                if (sortby.equals(SORT_BY_ASC)) {
                    if (!TESLMReportInf.getLowCompareValue(rowparams, low)) break;
                    ++low;
                    continue;
                }
                if (TESLMReportInf.getLowCompareValue(rowparams, low)) break;
                ++low;
            }
            rowparams[high] = rowparams[low];
        }
        rowparams[low] = rowparams[0];
        return low;
    }

    private static boolean getLowCompareValue(RowParams[] rowparams, int low) {
        int lowObjID = -1;
        int comObjID = -1;
        int lowLineID = Integer.parseInt(rowparams[low].getParam(LINE_ID_PARAM).getValue());
        int comLineID = Integer.parseInt(rowparams[0].getParam(LINE_ID_PARAM).getValue());
        if (null != rowparams[low].getParam(REPEATER_ID_PARAM)) {
            lowObjID = Integer.parseInt(rowparams[low].getParam(REPEATER_ID_PARAM).getValue());
        } else if (null != rowparams[low].getParam(EVENT_ID_PARAM)) {
            lowObjID = Integer.parseInt(rowparams[low].getParam(EVENT_ID_PARAM).getValue());
        }
        if (null != rowparams[0].getParam(REPEATER_ID_PARAM)) {
            comObjID = Integer.parseInt(rowparams[0].getParam(REPEATER_ID_PARAM).getValue());
        } else if (null != rowparams[0].getParam(EVENT_ID_PARAM)) {
            comObjID = Integer.parseInt(rowparams[0].getParam(EVENT_ID_PARAM).getValue());
        }
        String lowTestingTime = rowparams[low].getParam(TESTING_TIME_PARAM).getValue();
        String comTestingTime = rowparams[0].getParam(TESTING_TIME_PARAM).getValue();
        if (lowLineID < comLineID) {
            return true;
        }
        if (lowLineID > comLineID) {
            return false;
        }
        if (lowLineID == comLineID && lowTestingTime.compareTo(comTestingTime) < 0) {
            return true;
        }
        if (lowLineID == comLineID && lowTestingTime.compareTo(comTestingTime) > 0) {
            return false;
        }
        if (lowLineID == comLineID && lowTestingTime.compareTo(comTestingTime) == 0 && lowObjID < comObjID) {
            return true;
        }
        return lowLineID != comLineID || lowTestingTime.compareTo(comTestingTime) != 0 || lowObjID <= comObjID;
    }

    private static boolean getHighCompareValue(RowParams[] rowparams, int high) {
        int highObjID = -1;
        int comObjID = -1;
        int highLineID = Integer.parseInt(rowparams[high].getParam(LINE_ID_PARAM).getValue());
        int comLineID = Integer.parseInt(rowparams[0].getParam(LINE_ID_PARAM).getValue());
        if (null != rowparams[high].getParam(REPEATER_ID_PARAM)) {
            highObjID = Integer.parseInt(rowparams[high].getParam(REPEATER_ID_PARAM).getValue());
        } else if (null != rowparams[high].getParam(EVENT_ID_PARAM)) {
            highObjID = Integer.parseInt(rowparams[high].getParam(EVENT_ID_PARAM).getValue());
        }
        if (null != rowparams[0].getParam(REPEATER_ID_PARAM)) {
            comObjID = Integer.parseInt(rowparams[0].getParam(REPEATER_ID_PARAM).getValue());
        } else if (null != rowparams[0].getParam(EVENT_ID_PARAM)) {
            comObjID = Integer.parseInt(rowparams[0].getParam(EVENT_ID_PARAM).getValue());
        }
        String highTestingTime = rowparams[high].getParam(TESTING_TIME_PARAM).getValue();
        String comTestingTime = rowparams[0].getParam(TESTING_TIME_PARAM).getValue();
        if (highLineID > comLineID) {
            return true;
        }
        if (highLineID < comLineID) {
            return false;
        }
        if (highLineID == comLineID && highTestingTime.compareTo(comTestingTime) > 0) {
            return true;
        }
        if (highLineID == comLineID && highTestingTime.compareTo(comTestingTime) < 0) {
            return false;
        }
        if (highLineID == comLineID && highTestingTime.compareTo(comTestingTime) == 0 && highObjID > comObjID) {
            return true;
        }
        return highLineID != comLineID || highTestingTime.compareTo(comTestingTime) != 0 || highObjID >= comObjID;
    }
}

