/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.linedata;

import com.huawei.nglct.otdr.linedata.TESLMLineState;
import com.huawei.nglct.otdr.linedata.TESLMLineStruct;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;

public class TESLMLineNEData {
    private TIntObjectHashMap<TESLMLineStruct> lineDataMap = new TIntObjectHashMap();

    public void refreshLineState(int indexID, TESLMLineState state) {
        TESLMLineStruct line = this.getLineStruct(indexID);
        if (null != line) {
            line.refreshState(state);
        }
    }

    public void refreshLineData(TIntArrayList lineList) {
        int[] keys;
        if (null == lineList) {
            return;
        }
        boolean isLineListEmpty = lineList.isEmpty();
        if (isLineListEmpty) {
            this.lineDataMap.clear();
            return;
        }
        TIntObjectHashMap newLineDataMap = new TIntObjectHashMap();
        for (int indexID : keys = lineList.toNativeArray()) {
            TESLMLineStruct line = (TESLMLineStruct)this.lineDataMap.get(indexID);
            if (null == line) {
                line = new TESLMLineStruct();
            }
            newLineDataMap.put(indexID, (Object)line);
        }
        this.lineDataMap.clear();
        this.lineDataMap.putAll(newLineDataMap);
    }

    public TESLMLineState getLineState(int indexID) {
        TESLMLineStruct line = this.getLineStruct(indexID);
        return line.getState();
    }

    public void deleteLine(int indexID) {
        this.lineDataMap.remove(indexID);
    }

    public void addLineData(TIntArrayList lineList) {
        int[] keys;
        if (null == lineList || lineList.isEmpty()) {
            return;
        }
        for (int indexID : keys = lineList.toNativeArray()) {
            TESLMLineStruct line = (TESLMLineStruct)this.lineDataMap.get(indexID);
            if (null == line) {
                line = new TESLMLineStruct();
            }
            this.lineDataMap.put(indexID, (Object)line);
        }
    }

    private TESLMLineStruct getLineStruct(int indexID) {
        TESLMLineStruct line = (TESLMLineStruct)this.lineDataMap.get(indexID);
        if (null == line) {
            line = new TESLMLineStruct();
            this.lineDataMap.put(indexID, (Object)line);
        }
        return line;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.lineDataMap == null ? 0 : this.lineDataMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMLineNEData other = (TESLMLineNEData)obj;
        return !(this.lineDataMap == null ? other.lineDataMap != null : !this.lineDataMap.equals(other.lineDataMap));
    }

    public int getNewLineIndexID() {
        int minLineIndexID = 1;
        int maxLineIndexID = 65535;
        int newIndexID = 0;
        for (int i = minLineIndexID; i < maxLineIndexID; ++i) {
            if (this.lineDataMap.containsKey(i)) continue;
            newIndexID = i;
            break;
        }
        if (0 == newIndexID) {
            newIndexID = 1;
        }
        return newIndexID;
    }
}

