/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.nemgr.marine.linemonitor.TESLMSetHFCPStatusBean;
import com.huawei.nglct.otdr.hfcpfiledata.TESLMHFCPFile;
import com.huawei.nglct.otdr.hfcpfiledata.TESLMHFCPFileCopyHandler;
import com.huawei.nglct.otdr.hfcpfiledata.TESLMHFCPFileMgr;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileAdapter;
import org.slf4j.Logger;

public class TESLMHFCPFileUtil {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_UPLOAD_TYPE = 1;
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static final int HFCP_STATUS_STOP = 0;

    public static int sendFileToNE(String ipAddress, int neid, String neFilePath, String localFilePath, String fileName) {
        log.info("<HFCP> Send File ---- IP address is : " + ipAddress + "File name is : " + fileName + "NE File Path is : " + neFilePath + "Local File Path is : " + localFilePath);
        int isSuccess = 0;
        if (null != TESLMHFCPFileMgr.instance().findFile(neid)) {
            log.info("<HFCP> Send File ---- The file " + fileName + " is being translated!");
            return 1090613365;
        }
        isSuccess = TESLMHFCPFileMgr.instance().registerFile(neid, neFilePath, localFilePath, fileName, 2);
        if (0 != isSuccess) {
            log.info("<HFCP> Send File ---- The registration  of the file : " + fileName + " failed!result is : " + isSuccess);
            TESLMHFCPFileMgr.instance().delFile(neid);
            return isSuccess;
        }
        TESLMHFCPFile hfcpFile = TESLMHFCPFileMgr.instance().getFile(neid);
        isSuccess = TEHFCPFileAdapter.sendFile((byte[])hfcpFile.getFileData(), (String)neFilePath, (String)localFilePath, (String)fileName, (int)neid);
        log.info("<HFCP> Send File ---- Send file result is " + isSuccess);
        TESLMHFCPFileMgr.instance().delFile(neid);
        log.info("<HFCP> Send File ---- End!");
        return isSuccess;
    }

    public static int getFileFromNE(String ipAddress, int neid, String neFilePath, String localFilePath, String fileName) {
        log.info("<HFCP> Get File ---- IP address is : " + ipAddress + "File name is : " + fileName + "NE File Path is : " + neFilePath + "Local File Path is : " + localFilePath);
        int isSuccess = 0;
        if (null != TESLMHFCPFileMgr.instance().findFile(neid)) {
            log.info("<HFCP> Get File ---- The file " + fileName + " is being translated!");
            return 1090613365;
        }
        isSuccess = TESLMHFCPFileMgr.instance().registerFile(neid, neFilePath, localFilePath, fileName, 1);
        if (0 != isSuccess) {
            log.info("<HFCP> Get File ---- The registration  of the file : " + fileName + " failed! result is : " + isSuccess);
            TESLMHFCPFileMgr.instance().delFile(neid);
            return isSuccess;
        }
        byte[] fileData = TEHFCPFileAdapter.getFile((String)neFilePath, (String)localFilePath, (String)fileName, (int)neid);
        isSuccess = TEHFCPHandler.instance().getRet();
        if ((null == fileData || fileData.length == 0) && isSuccess != 0) {
            log.info("<HFCP> Get File ---- The file length is 0 or file is null!");
            TESLMHFCPFileMgr.instance().delFile(neid);
            return isSuccess;
        }
        String filePathName = localFilePath + fileName;
        TESLMHFCPFileCopyHandler.writeFile(filePathName, fileData);
        TESLMHFCPFileMgr.instance().delFile(neid);
        return isSuccess;
    }

    public static int getFileTransferProgress(int neid) {
        TESLMHFCPFile hfcpFile = TESLMHFCPFileMgr.instance().getFile(neid);
        if (null == hfcpFile) {
            return -1;
        }
        return TEHFCPFileAdapter.getTransferProgress((int)neid);
    }

    public static void hfcpStatusSender(int neID) {
        try {
            TESLMSetHFCPStatusBean neExplorerBean = new TESLMSetHFCPStatusBean();
            int sfId = 2556126;
            SubFunc subfunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfId);
            Datainterface inputData = new Datainterface();
            inputData.setBussinessParams(new BussinessParams());
            RowParams rowParams = new RowParams();
            rowParams.addParam("hfcpStatus", String.valueOf(0));
            inputData.getBussinessParams().addRowParams(rowParams);
            neExplorerBean.performBussinessProcess(neID, subfunc, inputData, null, null, null);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TESLMHFCPFileUtil.hfcpStatusSender() fail!", (Throwable)ex);
        }
    }
}

