/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.otdr.hfcpfiledata.TESLMHFCPFile;
import com.huawei.nglct.otdr.hfcpfiledata.TESLMHFCPFileCopyHandler;
import gnu.trove.TIntObjectHashMap;
import org.slf4j.Logger;

public class TESLMHFCPFileMgr {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static TESLMHFCPFileMgr hfcpFileMgr = new TESLMHFCPFileMgr();
    private TIntObjectHashMap<TESLMHFCPFile> fileMap = new TIntObjectHashMap();

    private TESLMHFCPFileMgr() {
    }

    public static TESLMHFCPFileMgr instance() {
        return hfcpFileMgr;
    }

    public TESLMHFCPFile getFile(int neid) {
        return this.findFile(neid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMHFCPFile addFile(int neid) {
        TIntObjectHashMap<TESLMHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            TESLMHFCPFile hfcpFile = this.findFile(neid);
            if (null == hfcpFile) {
                hfcpFile = new TESLMHFCPFile(neid);
                log.info("<HFCP> File Management ---- Create file object of the NE : " + neid);
                this.fileMap.put(neid, (Object)hfcpFile);
            }
            return hfcpFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMHFCPFile delFile(int neid) {
        TIntObjectHashMap<TESLMHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            return (TESLMHFCPFile)this.fileMap.remove(neid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TESLMHFCPFile findFile(int neid) {
        TIntObjectHashMap<TESLMHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            TESLMHFCPFile hfcpFile = (TESLMHFCPFile)this.fileMap.get(neid);
            if (null != hfcpFile) {
                log.info("<HFCP> File Management ---- Find file " + hfcpFile.getFileName());
            } else {
                log.info("<HFCP> File Management ---- No file of the NE is found, neID->: " + neid);
            }
            return hfcpFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllFile() {
        TIntObjectHashMap<TESLMHFCPFile> tIntObjectHashMap = this.fileMap;
        synchronized (tIntObjectHashMap) {
            this.fileMap.clear();
        }
    }

    public int registerFile(int neid, String neFilePath, String localFilePath, String fileName, int sendType) {
        int registeFlag = 0;
        TESLMHFCPFile hfcpFile = this.addFile(neid);
        hfcpFile.setNeFilePath(neFilePath);
        hfcpFile.setLocalFilePath(localFilePath);
        hfcpFile.setFileName(fileName);
        log.info("<HFCP> File Management ---- The registered file name is : " + fileName);
        log.info("<HFCP> File Management ---- The registered local file path is : " + localFilePath);
        log.info("<HFCP> File Management ---- The registered ne file path is : " + neFilePath);
        registeFlag = hfcpFile.checkFileNameVaild();
        if (0 != registeFlag) {
            log.info("<HFCP> File Management ---- Register FAILED. Result is  : " + registeFlag);
            return registeFlag;
        }
        String strPath = localFilePath + fileName;
        if (2 == sendType) {
            registeFlag = TESLMHFCPFileCopyHandler.checkFileValid(strPath);
            if (0 != registeFlag) {
                return registeFlag;
            }
            byte[] fileData = TESLMHFCPFileCopyHandler.getFileBytes(strPath);
            if (null == fileData) {
                fileData = new byte[]{};
            }
            hfcpFile.setFileData(fileData);
        } else {
            hfcpFile.setFileData(null);
        }
        return registeFlag;
    }

    public static TESLMHFCPFileMgr getHfcpFileMgr() {
        return hfcpFileMgr;
    }
}

