/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.otdr.TESLMFileDataMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;

public class TESLMHFCPFileCopyHandler {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileBytes(String fileName) {
        log.info("<HFCP> File Copy Handler ---- Get file bytes begin!");
        byte[] fileContent = null;
        BufferedInputStream bufIn = null;
        try {
            log.info("<HFCP> File Copy Handler ---- The file name is : " + fileName);
            bufIn = new BufferedInputStream(new FileInputStream(fileName));
            Object object = TESLMFileDataMgr.instance().acquireFileReadWriteLock(fileName);
            synchronized (object) {
                ByteArrayOutputStream baout = new ByteArrayOutputStream();
                int code = bufIn.read();
                while (code != -1) {
                    baout.write(code);
                    code = bufIn.read();
                }
                fileContent = baout.toByteArray();
                baout.close();
                int availableSize = fileContent.length;
                log.info("<HFCP> File Copy Handler ---- The file size is : " + availableSize);
                if (availableSize <= 0) {
                    log.info("<HFCP> File Copy Handler ---- Get file bytes result is null! ");
                    byte[] byArray = null;
                    return byArray;
                }
            }
            bufIn.close();
        }
        catch (FileNotFoundException e) {
            log.error("<HFCP> File Copy Handler ---- Get file exception!");
            log.error("TESLMHFCPFileCopyHandler.getFileBytes() fail!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("<HFCP> File Copy Handler ---- Get file exception!");
            log.error("TESLMHFCPFileCopyHandler.getFileBytes() fail!", (Throwable)e);
        }
        catch (Exception e) {
            log.error("<HFCP> File Copy Handler ---- Get file exception!");
            log.error("TESLMHFCPFileCopyHandler.getFileBytes() fail!", (Throwable)e);
        }
        finally {
            if (null != bufIn) {
                try {
                    bufIn.close();
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
        }
        log.info("<HFCP> File Copy Handler ---- Get file bytes success!");
        return fileContent;
    }

    public static int checkFileValid(String fileName) {
        try {
            log.info("<HFCP> File Copy Handler ---- The checked file name is : " + fileName);
            File file = new File(fileName);
            if (!file.exists()) {
                log.info("<HFCP> File Copy Handler ---- The checked file is not exist!");
                return -1;
            }
        }
        catch (Exception e) {
            log.error("<HFCP> File Copy Handler ---- The checked file exception!");
            log.error("TESLMHFCPFileCopyHandler.checkFileValid() fail!", (Throwable)e);
        }
        log.info("<HFCP> File Copy Handler ---- Check file result is success : 0");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(String fileName, byte[] fileData) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                log.info("<HFCP> File Copy Handler ---- The written file already exists!");
                return 1090613368;
            }
            Object object = TESLMFileDataMgr.instance().acquireFileReadWriteLock(fileName);
            synchronized (object) {
                BufferedOutputStream bufOut = new BufferedOutputStream(new FileOutputStream(fileName));
                if (null == fileData) {
                    fileData = new byte[]{};
                }
                bufOut.write(fileData, 0, fileData.length);
                bufOut.flush();
                bufOut.close();
            }
        }
        catch (Exception e) {
            log.error("<HFCP> File Copy Handler ---- Write file exception!");
            log.error("TESLMHFCPFileCopyHandler.writeFile() fail!", (Throwable)e);
        }
        log.info("<HFCP> File Copy Handler ---- Write file result is : 0");
        return 0;
    }
}

