/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.hfcpfiledata;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.util.Arrays;
import org.slf4j.Logger;

public class TESLMHFCPFile {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private int neid = -1;
    private String fileName = "";
    private String localFilePath = "";
    private String neFilePath = "";
    private byte[] fileData;

    public TESLMHFCPFile(int neid) {
        this.neid = neid;
    }

    public int checkFileNameVaild() {
        log.info("<HFCP> HFCP File ---- Check file name : " + this.getFileName() + " begin!");
        int isValid = 0;
        if (0 == this.getLocalFilePath().length() || 0 == this.getFileName().length()) {
            log.info("<HFCP> HFCP File ---- The local file path length is : 0");
            log.info("<HFCP> HFCP File ---- The file name length is : 0");
            log.info("<HFCP> HFCP File ---- Check file result is TE_ERR_SLM_PATHFILE_ZERO: 1090613372");
            return 1090613372;
        }
        int maxLen = 10000;
        String strPath = this.getLocalFilePath() + this.getFileName();
        log.info("<HFCP> HFCP File ---- The checked file path is : " + strPath);
        if (maxLen < strPath.length()) {
            log.info("<HFCP> HFCP File ---- The length of the file path is too long!");
            isValid = 1090613371;
        }
        log.info("<HFCP> HFCP File ---- Check file result is : " + isValid);
        return isValid;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public void setLocalFilePath(String localFilePath) {
        this.localFilePath = localFilePath;
    }

    public String getNeFilePath() {
        return this.neFilePath;
    }

    public void setNeFilePath(String neFilePath) {
        this.neFilePath = neFilePath;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + TESLMHFCPFile.hashCode(this.fileData);
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.localFilePath == null ? 0 : this.localFilePath.hashCode());
        result = 31 * result + (this.neFilePath == null ? 0 : this.neFilePath.hashCode());
        result = 31 * result + this.neid;
        return result;
    }

    private static int hashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMHFCPFile other = (TESLMHFCPFile)obj;
        if (!Arrays.equals(this.fileData, other.fileData)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.localFilePath == null ? other.localFilePath != null : !this.localFilePath.equals(other.localFilePath)) {
            return false;
        }
        if (this.neFilePath == null ? other.neFilePath != null : !this.neFilePath.equals(other.neFilePath)) {
            return false;
        }
        return this.neid == other.neid;
    }

    public String toString() {
        return this.getFileName();
    }
}

