/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.filedata;

import com.huawei.nglct.otdr.TESLMFileDataMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.otdr.filedata.TESLMTestFileProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TESLMTestLineFileData {
    private int neID = -1;
    private int indexID = -1;
    private List<TESLMTestFile> fileList = null;
    private TESLMTestFile inBaseLineFile = null;
    private TESLMTestFile outBaseLineFile = null;

    public TESLMTestLineFileData(int neID, int indexID) {
        this.neID = neID;
        this.indexID = indexID;
        this.fileList = new ArrayList<TESLMTestFile>();
    }

    public boolean deleteTestRecord(String fileName) {
        if (null == fileName || fileName.equals("")) {
            return false;
        }
        Iterator<TESLMTestFile> iter = this.fileList.iterator();
        while (iter.hasNext()) {
            TESLMTestFile file = iter.next();
            if (!fileName.equals(file.getFileName())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        TESLMTestFile file = null;
        String fileName = null;
        Iterator<TESLMTestFile> iter = this.fileList.iterator();
        ArrayList<String> deletingFileList = new ArrayList<String>();
        while (iter.hasNext()) {
            file = iter.next();
            fileName = file.getFileName();
            deletingFileList.add(fileName);
            TESLMFileDataMgr.instance().deleteFile(this.neID, fileName);
        }
        if (null != this.inBaseLineFile) {
            fileName = this.inBaseLineFile.getFileName();
            deletingFileList.add(fileName);
            TESLMFileDataMgr.instance().deleteFile(this.neID, fileName);
        }
        if (null != this.outBaseLineFile) {
            fileName = this.outBaseLineFile.getFileName();
            deletingFileList.add(fileName);
            TESLMFileDataMgr.instance().deleteFile(this.neID, fileName);
        }
        TESLMOTDRDataMgr.deleteRecordFromFile(this.neID, deletingFileList);
        this.fileList.clear();
    }

    public void deleteLineSelf() {
        TESLMTestFile file2 = null;
        for (TESLMTestFile file2 : this.fileList) {
            this.makeFileTmp(file2);
        }
        if (null != this.inBaseLineFile) {
            this.makeFileTmp(this.inBaseLineFile);
        }
        if (null != this.outBaseLineFile) {
            this.makeFileTmp(this.outBaseLineFile);
        }
        this.fileList.clear();
    }

    private void makeFileTmp(TESLMTestFile file) {
        if (null == file) {
            return;
        }
        file.setTmp(true);
        TESLMTestFileProperty state = file.getState();
        int testType = file.getTestType();
        String fileName = file.getFileName();
        boolean isBaseLine = state.isBaseLIne();
        boolean isSaved = state.isSaved();
        boolean isTmp = state.isTmp();
        boolean isComplete = state.isComplete();
        TESLMOTDRDataMgr.makeTmpFile(this.neID, this.indexID, testType, fileName, isBaseLine, isSaved, isTmp, isComplete);
    }

    public void deleteBaseLine(int testMode) {
        String fileName = null;
        TESLMTestFile file = this.getBaseLineFile0(testMode);
        if (null != file) {
            fileName = file.getFileName();
            TESLMFileDataMgr.instance().deleteFile(this.neID, fileName);
            TESLMOTDRDataMgr.deleteRecordFromFile(this.neID, fileName);
        }
        if (2 == testMode) {
            this.outBaseLineFile = null;
        } else if (1 == testMode) {
            this.inBaseLineFile = null;
        }
    }

    public void updateBaseLine(int testMode, String fileName) {
        String blFileName;
        boolean isInSvr = false;
        if (2 == testMode) {
            isInSvr = false;
        } else if (1 == testMode) {
            isInSvr = true;
        } else {
            return;
        }
        TESLMTestFile fileTmp = this.getBaseLineFile0(testMode);
        if (null != fileTmp && !fileName.equals(blFileName = fileTmp.getFileName())) {
            this.deleteBaseLine(testMode);
        }
        TESLMTestFile file = null;
        if (isInSvr) {
            if (null == this.inBaseLineFile) {
                this.inBaseLineFile = new TESLMTestFile(true);
            }
            file = this.inBaseLineFile;
        } else {
            if (null == this.outBaseLineFile) {
                this.outBaseLineFile = new TESLMTestFile(true);
            }
            file = this.outBaseLineFile;
        }
        file.setFileName(fileName);
    }

    public String getBaseLineFileName(int testMode) {
        TESLMTestFile file = this.getBaseLineFile0(testMode);
        return null != file ? file.getFileName() : null;
    }

    public void makeTestRecordSaved(int testMode, String fileName) {
        Iterator<TESLMTestFile> iter = this.fileList.iterator();
        TESLMTestFileProperty state = null;
        while (iter.hasNext()) {
            TESLMTestFile file = iter.next();
            if (file.getTestMode() != testMode || !fileName.equals(file.getFileName())) continue;
            file.setSaved(true);
            state = file.getState();
            int testType = file.getTestType();
            boolean isBaseLine = state.isBaseLIne();
            boolean isSaved = state.isSaved();
            boolean isTmp = state.isTmp();
            boolean isComplete = state.isComplete();
            TESLMOTDRDataMgr.refreshFileProperty(this.neID, this.indexID, testType, file.getFileName(), isBaseLine, isSaved, isTmp, isComplete);
        }
    }

    public boolean addTestRecord(TESLMTestFile recFile) {
        if (null == recFile) {
            return false;
        }
        String fName = recFile.getFileName();
        if (recFile.isBaseLIne()) {
            int fileTestMode = recFile.getTestMode();
            if (1 == fileTestMode) {
                this.inBaseLineFile = recFile;
                return true;
            }
            if (2 == fileTestMode) {
                this.outBaseLineFile = recFile;
                return true;
            }
            return false;
        }
        if (!this.fileExists(fName)) {
            this.fileList.add(recFile);
            return true;
        }
        return false;
    }

    public List<String> getHistoryTestRecord(int testMode) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (TESLMTestFile file : this.fileList) {
            if (file.getTestMode() != testMode || !file.isSaved()) continue;
            fileNameList.add(file.getFileName());
        }
        Collections.sort(fileNameList);
        return fileNameList;
    }

    public List<String> getUnsavedTestRecord() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (TESLMTestFile file : this.fileList) {
            if (file.isSaved()) continue;
            fileNameList.add(file.getFileName());
        }
        Collections.sort(fileNameList);
        return fileNameList;
    }

    public boolean fileExists(String fileName) {
        if (null == fileName) {
            return false;
        }
        for (TESLMTestFile file : this.fileList) {
            if (!fileName.equals(file.getFileName())) continue;
            return true;
        }
        if (null != this.inBaseLineFile && fileName.equals(this.inBaseLineFile.getFileName())) {
            return true;
        }
        return null != this.outBaseLineFile && fileName.equals(this.outBaseLineFile.getFileName());
    }

    private TESLMTestFile getBaseLineFile0(int testMode) {
        TESLMTestFile file = null;
        if (2 == testMode) {
            file = this.outBaseLineFile;
        } else if (1 == testMode) {
            file = this.inBaseLineFile;
        }
        return file;
    }

    public TESLMTestFile getInBaseLineFile() {
        return this.inBaseLineFile;
    }

    public void setInBaseLineFile(TESLMTestFile inBaseLineFile) {
        this.inBaseLineFile = inBaseLineFile;
    }

    public TESLMTestFile getOutBaseLineFile() {
        return this.outBaseLineFile;
    }

    public void setOutBaseLineFile(TESLMTestFile outBaseLineFile) {
        this.outBaseLineFile = outBaseLineFile;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fileList == null ? 0 : ((Object)this.fileList).hashCode());
        result = 31 * result + (this.inBaseLineFile == null ? 0 : this.inBaseLineFile.hashCode());
        result = 31 * result + this.indexID;
        result = 31 * result + this.neID;
        result = 31 * result + (this.outBaseLineFile == null ? 0 : this.outBaseLineFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMTestLineFileData other = (TESLMTestLineFileData)obj;
        if (this.fileList == null ? other.fileList != null : !((Object)this.fileList).equals(other.fileList)) {
            return false;
        }
        if (this.inBaseLineFile == null ? other.inBaseLineFile != null : !this.inBaseLineFile.equals(other.inBaseLineFile)) {
            return false;
        }
        if (this.indexID != other.indexID) {
            return false;
        }
        if (this.neID != other.neID) {
            return false;
        }
        return !(this.outBaseLineFile == null ? other.outBaseLineFile != null : !this.outBaseLineFile.equals(other.outBaseLineFile));
    }

    public int getIndexID() {
        return this.indexID;
    }

    public void setIndexID(int indexID) {
        this.indexID = indexID;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }
}

