/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.filedata;

import com.huawei.nglct.otdr.filedata.TESLMRepeatorGainInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TESLMRepeatorInfo {
    private int repeatorID = -1;
    private Map<String, TESLMRepeatorGainInfo> gainMap = null;

    public TESLMRepeatorInfo(int repeatorID) {
        this.repeatorID = repeatorID;
        this.gainMap = new HashMap<String, TESLMRepeatorGainInfo>();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.gainMap == null ? 0 : ((Object)this.gainMap).hashCode());
        result = 31 * result + this.repeatorID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMRepeatorInfo other = (TESLMRepeatorInfo)obj;
        if (this.gainMap == null ? other.gainMap != null : !((Object)this.gainMap).equals(other.gainMap)) {
            return false;
        }
        return this.repeatorID == other.repeatorID;
    }

    public int getRepeatorID() {
        return this.repeatorID;
    }

    public void addRepeatorGainInfo(String date, String gain) {
        if (!this.gainMap.containsKey(date)) {
            TESLMRepeatorGainInfo gainInfo = new TESLMRepeatorGainInfo(this.repeatorID);
            gainInfo.setDate(date);
            gainInfo.setRepeatorGain(gain);
            this.gainMap.put(date, gainInfo);
        }
    }

    public String loadRepeatorGainInfo(int testMode) {
        if (this.gainMap.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Set<Map.Entry<String, TESLMRepeatorGainInfo>> entrySet = this.gainMap.entrySet();
        for (Map.Entry<String, TESLMRepeatorGainInfo> entry : entrySet) {
            buf.append(entry.getKey()).append(",");
            buf.append(entry.getValue()).append(" ");
        }
        return buf.toString().trim();
    }

    public void delGainInfoByDate(String date) {
        this.gainMap.remove(date);
    }

    public boolean hasGainInfo() {
        return !this.gainMap.isEmpty();
    }
}

