/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.filedata;

import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.otdr.filedata.TESLMTestLineFileData;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class TESLMNEFileData {
    private int neID = -1;
    private TIntObjectHashMap<TESLMTestLineFileData> fileDataMap = null;

    public TESLMNEFileData(int mNEID) {
        this.neID = mNEID;
        this.fileDataMap = new TIntObjectHashMap();
    }

    public boolean deleteTestRecord(int indexID, String fileName) {
        TESLMTestLineFileData lineFileData = this.getLineFileData(indexID);
        if (null == lineFileData) {
            return false;
        }
        return lineFileData.deleteTestRecord(fileName);
    }

    public void deleteTestRecord(int indexID) {
        TESLMTestLineFileData lineFileData = this.getLineFileData(indexID);
        if (null != lineFileData) {
            lineFileData.deleteLineSelf();
            this.removeLineFileData(indexID);
        }
    }

    public boolean addTestRecord(int indexID, TESLMTestFile file) {
        TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(indexID);
        if (null == lineFileData) {
            lineFileData = new TESLMTestLineFileData(this.neID, indexID);
            this.fileDataMap.put(indexID, (Object)lineFileData);
        }
        return lineFileData.addTestRecord(file);
    }

    public List<String> getHistoryTestRecord(int indexID, int testMode) {
        TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(indexID);
        if (null == lineFileData) {
            return new ArrayList<String>();
        }
        return lineFileData.getHistoryTestRecord(testMode);
    }

    public List<String> getUnsavedTestRecord(int indexID) {
        Integer indexIDInteger = indexID;
        TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(indexIDInteger.intValue());
        if (null == lineFileData) {
            return new ArrayList<String>();
        }
        return lineFileData.getUnsavedTestRecord();
    }

    public void deleteBaseLine(int indexID, int testMode) {
        TESLMTestLineFileData lineFileData = this.getLineFileData(indexID);
        if (null == lineFileData) {
            return;
        }
        lineFileData.deleteBaseLine(testMode);
    }

    public void clear() {
        int[] keys;
        for (int key : keys = this.fileDataMap.keys()) {
            TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(key);
            lineFileData.clear();
        }
        this.fileDataMap.clear();
    }

    public void updateBaseLine(int indexID, int testMode, String fileName) {
        TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(indexID);
        if (null == lineFileData) {
            lineFileData = new TESLMTestLineFileData(this.neID, indexID);
            this.fileDataMap.put(indexID, (Object)lineFileData);
        }
        lineFileData.updateBaseLine(testMode, fileName);
    }

    public String getBaseLineName(int indexID, int testMode) {
        TESLMTestLineFileData lineFileData = this.getLineFileData(indexID);
        if (null == lineFileData) {
            return null;
        }
        return lineFileData.getBaseLineFileName(testMode);
    }

    public void makeTestRecordSaved(int indexID, int testMode, String fileName) {
        TESLMTestLineFileData lineFileData = this.getLineFileData(indexID);
        if (null != lineFileData) {
            lineFileData.makeTestRecordSaved(testMode, fileName);
        }
    }

    private void removeLineFileData(int indexID) {
        this.fileDataMap.remove(indexID);
    }

    private TESLMTestLineFileData getLineFileData(int indexID) {
        return (TESLMTestLineFileData)this.fileDataMap.get(indexID);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fileDataMap == null ? 0 : this.fileDataMap.hashCode());
        result = 31 * result + this.neID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMNEFileData other = (TESLMNEFileData)obj;
        if (this.fileDataMap == null ? other.fileDataMap != null : !this.fileDataMap.equals(other.fileDataMap)) {
            return false;
        }
        return this.neID == other.neID;
    }

    public boolean fileExists(int indexID, String fileName) {
        TESLMTestLineFileData lineFileData = (TESLMTestLineFileData)this.fileDataMap.get(indexID);
        if (null != lineFileData) {
            return lineFileData.fileExists(fileName);
        }
        return false;
    }

    public int[] getLineIDData() {
        return this.fileDataMap.keys();
    }
}

