/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.filedata;

import com.huawei.nglct.otdr.filedata.TESLMRepeatorInfo;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;

public class TESLMLineRepeatorInfo {
    private int neID = -1;
    private final int testMode;
    private int indexID = -1;
    private TIntObjectHashMap<TESLMRepeatorInfo> repeatorInfoMap = null;

    public TESLMLineRepeatorInfo(int neID, int indexID) {
        this.neID = neID;
        this.indexID = indexID;
        this.testMode = 1;
        this.repeatorInfoMap = new TIntObjectHashMap();
    }

    public int getIndexID() {
        return this.indexID;
    }

    public void setIndexID(int indexID) {
        this.indexID = indexID;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public int getTestMode() {
        return this.testMode;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.indexID;
        result = 31 * result + this.neID;
        result = 31 * result + (this.repeatorInfoMap == null ? 0 : this.repeatorInfoMap.hashCode());
        result = 31 * result + this.testMode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESLMLineRepeatorInfo other = (TESLMLineRepeatorInfo)obj;
        if (this.indexID != other.indexID) {
            return false;
        }
        if (this.neID != other.neID) {
            return false;
        }
        if (this.repeatorInfoMap == null ? other.repeatorInfoMap != null : !this.repeatorInfoMap.equals(other.repeatorInfoMap)) {
            return false;
        }
        return this.testMode == other.testMode;
    }

    public void addRepeatorGainInfo(int repeatorID, String date, String gain) {
        Integer repeatorInteger = repeatorID;
        TESLMRepeatorInfo repeatorInfo = (TESLMRepeatorInfo)this.repeatorInfoMap.get(repeatorInteger.intValue());
        if (null == repeatorInfo) {
            repeatorInfo = new TESLMRepeatorInfo(repeatorID);
            this.repeatorInfoMap.put(repeatorInteger.intValue(), (Object)repeatorInfo);
        }
        repeatorInfo.addRepeatorGainInfo(date, gain);
    }

    public String loadRepeatorGainInfo(int testMode, int repeatorID) {
        Integer repeatorInteger = repeatorID;
        TESLMRepeatorInfo repeatorInfo = (TESLMRepeatorInfo)this.repeatorInfoMap.get(repeatorInteger.intValue());
        if (null == repeatorInfo) {
            return null;
        }
        return repeatorInfo.loadRepeatorGainInfo(testMode);
    }

    public String getRepeaterIDInfo() {
        int[] keys;
        if (this.repeatorInfoMap.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int key : keys = this.repeatorInfoMap.keys()) {
            buf.append(key).append(" ");
        }
        return buf.toString().trim();
    }

    public void delRepeatorGainInfo(String date) {
        TIntObjectIterator iter = this.repeatorInfoMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            TESLMRepeatorInfo repeaterInfo = (TESLMRepeatorInfo)iter.value();
            repeaterInfo.delGainInfoByDate(date);
            if (repeaterInfo.hasGainInfo()) continue;
            iter.remove();
        }
    }
}

