/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.beans;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.StringWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;

public class TEOTDRShowBaseLineBean {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String NE_NOT_EXIST = "68560014";
    private static final int BASELINE_NOT_EXIST = 42793;
    private static final int FILE_NOT_EXIST = 1090781211;
    private static final int FAILED_TO_PARSE_FILE = 1090781212;

    public String getBaseLineData(int neID, int indexID, int testMode) throws MarshalException, ValidationException {
        Datainterface outputData = new Datainterface();
        BussinessParams bus = new BussinessParams();
        outputData.setBussinessParams(bus);
        StringWriter out = new StringWriter();
        if (-1 == neID || -1 == indexID || -1 == testMode) {
            log.info("MARINE ---- indexID is invalid.");
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            outputData.marshal((Writer)out);
            return ((Object)out).toString();
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_EXIST)));
            outputData.marshal((Writer)out);
            return ((Object)out).toString();
        }
        String blName = TESLMOTDRDataMgr.getBaseLineFileName(neID, indexID, testMode);
        if (null == blName) {
            log.info("MARINE ----  line doesn't have a baseline...neID->" + neID + "    indexID->" + indexID);
            RowErrors rowErr = new RowErrors();
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setErrorcode("42793");
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)42793));
            rowErr.setErrorMessage(errorMessage);
            Param errParam = new Param();
            errParam.setName("neid");
            errParam.setValue("" + neID);
            rowErr.addParam(errParam);
            errParam = new Param();
            errParam.setName("indexID");
            errParam.setValue("" + indexID);
            rowErr.addParam(errParam);
            TENE neObj = TENEListMgr.getInstance().getNE(neID);
            errParam = new Param("nename", neObj.getNEName());
            rowErr.addParam(errParam);
            RowParams errRow = new RowParams();
            errRow.addRowErrors(rowErr);
            outputData.getBussinessParams().clearRowParams();
            outputData.getBussinessParams().addRowParams(errRow);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)2));
            outputData.marshal((Writer)out);
            return ((Object)out).toString();
        }
        if (!TESLMOTDRDataMgr.fileExists(neID, indexID, blName)) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090781211));
            outputData.marshal((Writer)out);
            return ((Object)out).toString();
        }
        Object fileContent = TESLMOTDRDataMgr.loadFileContent(neID, blName);
        if (null == fileContent) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090781212));
            outputData.marshal((Writer)out);
            return ((Object)out).toString();
        }
        return fileContent.toString();
    }
}

