/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.beans;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.filedata.TESLMTestFileName;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class TEOTDRGetTestFileNameListBean {
    private static final String FILE_NAME = "fileName";
    public static final int GET_UNSAVED = 0;
    public static final int GET_HISTORY = 1;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String NE_NOT_EXIST = "68560014";

    public Datainterface getFileData(int neID, int indexID, int testMode, int fileType) {
        log.info("MARINE ---- receive get file name request");
        log.info("MARINE ---- neID->" + neID);
        log.info("MARINE ---- indexID->" + indexID);
        log.info("MARINE ---- testMode->" + testMode);
        log.info("MARINE ---- fileType->" + fileType + "    0: UNSAVED  1:HISTORY");
        Datainterface outputData = new Datainterface();
        if (-1 == neID || -1 == indexID) {
            log.info("MARINE ---- neID or indexID is invalid.");
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return outputData;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_EXIST)));
            return outputData;
        }
        List<String> fileNameList = null;
        if (1 == fileType) {
            String baseLineName;
            fileNameList = TESLMOTDRDataMgr.getHistoryTestRecord(neID, indexID, testMode);
            if (null == fileNameList) {
                fileNameList = new ArrayList<String>();
            }
            if (null != (baseLineName = TESLMOTDRDataMgr.getBaseLineFileName(neID, indexID, testMode))) {
                fileNameList.add(baseLineName);
            }
        } else {
            fileNameList = TESLMOTDRDataMgr.getUnsavedTestRecord(neID, indexID);
        }
        if (null == fileNameList) {
            fileNameList = new ArrayList<String>();
        }
        log.info("MARINE ---- fileNameList->" + fileNameList);
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        Param param = null;
        Collections.sort(fileNameList);
        ArrayList<String> fileNameListSort = this.fileNameSort(fileNameList);
        for (String fileName : fileNameListSort) {
            log.info("MARINE ---- fileName->" + fileName);
            row = new RowParams();
            fileName = TESLMOTDRDataMgr.convertNMUTCFileNameToAppletFileName(fileName, neID);
            log.info("MARINE ---- fileName->" + fileName);
            param = new Param();
            param.setName(FILE_NAME);
            param.setValue(fileName);
            row.addParam(param);
            bus.addRowParams(row);
        }
        outputData.setBussinessParams(bus);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return outputData;
    }

    public ArrayList<String> fileNameSort(List<String> fileNameList) {
        ArrayList<String> fileNameListTmp = new ArrayList<String>();
        ArrayList<TESLMTestFileName> fileNameListTmp1 = new ArrayList<TESLMTestFileName>();
        TESLMTestFileName fileName = null;
        for (String name : fileNameList) {
            fileName = new TESLMTestFileName(name);
            fileNameListTmp1.add(fileName);
        }
        Collections.sort(fileNameListTmp1);
        for (TESLMTestFileName fileNameTmp : fileNameListTmp1) {
            fileNameListTmp.add(fileNameTmp.toString());
        }
        return fileNameListTmp;
    }
}

