/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.beans;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import org.slf4j.Logger;

public class TEOTDRGetLineRepeaterIDListBean {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String NE_NOT_EXIST = "68560014";

    public Datainterface getLineRepeaterIDData(int neID, int indexID) {
        log.info("MARINE ---- receive get line repeater id data request.");
        log.info("MARINE ---- neID->" + neID);
        log.info("MARINE ---- indexID->" + indexID);
        Datainterface outputData = new Datainterface();
        if (-1 == neID || -1 == indexID) {
            log.info("MARINE  ---- neID or indexID is invalid.");
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return outputData;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_EXIST)));
            return outputData;
        }
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        Param param = null;
        String data = TESLMOTDRDataMgr.getRepeaterIDInfo(neID, indexID);
        log.info("MARINE  ---- get repeater id info. data->" + data);
        if (null == data) {
            data = "";
        }
        row = new RowParams();
        param = new Param();
        param.setName("rptID");
        param.setValue(data);
        row.addParam(param);
        bus.addRowParams(row);
        outputData.setBussinessParams(bus);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return outputData;
    }
}

