/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.beans;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import org.slf4j.Logger;

public class TEOTDRGenerateRepeaterInfoChartBean {
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String NE_NOT_EXIST = "68560014";

    public Datainterface getRepeaterChartInfo(int neID, int indexID, int testMode, int rptID) {
        Datainterface outputData = new Datainterface();
        if (-1 == neID || -1 == indexID) {
            log.info("MARINE ---- neID or indexID is invalid.");
            log.info("MARINE ---- neID->" + neID);
            log.info("MARINE ---- indexID->" + indexID);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return outputData;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_EXIST)));
            return outputData;
        }
        String datas = null;
        datas = TESLMOTDRDataMgr.loadRepeatorGainInfo(neID, indexID, testMode, rptID);
        datas = this.changeUTCTimeToAppletTime(neID, datas);
        log.info("MARINE ---- repeater gain info");
        log.info("MARINE ---- DATA->" + datas);
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        Param param = null;
        row = new RowParams();
        param = new Param();
        param.setName("rptGainInfo");
        if (null == datas) {
            datas = "";
        }
        param.setValue(datas);
        row.addParam(param);
        bus.addRowParams(row);
        outputData.setBussinessParams(bus);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return outputData;
    }

    private String changeUTCTimeToAppletTime(int neID, String repeaterGainStr) {
        if (null == repeaterGainStr) {
            return null;
        }
        StringBuffer appletTimeBuffer = new StringBuffer();
        String[] whiteSpaceSplitArr = repeaterGainStr.split(" ");
        String aAppletTimeStr = null;
        int len = whiteSpaceSplitArr.length;
        for (int i = 0; i < len; ++i) {
            String[] commaSplitArr = whiteSpaceSplitArr[i].split(",");
            aAppletTimeStr = TESLMOTDRDataMgr.convertNMUTCFileTimeToAppletFileTime(commaSplitArr[0], neID);
            appletTimeBuffer.append(aAppletTimeStr).append(",");
            appletTimeBuffer.append(commaSplitArr[1]).append(" ");
        }
        return appletTimeBuffer.toString().trim();
    }
}

