/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.param;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphViewTestRecordView;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceParamsInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedListener;
import com.huawei.nglct.otdr.appletgraph.legend.TEOTDRLegendPanel;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphLegendInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class TEOTDRParamPanel
extends JPanel
implements TEOTDRGraphLegendInterface,
TEOTDRGraphModule {
    private static final long serialVersionUID = 1L;
    protected static final int FILE_NAME_ROW = 0;
    protected static final int SUPPLIER_NAME_ROW = 1;
    protected static final int COMMENT_ROW = 2;
    protected static final int DATE_TIMESTAMP_ROW = 3;
    protected static final int END_OF_FIBER_THRESHOLD_ROW = 4;
    protected static final int MONITOR_TYPE_ROW = 5;
    protected static final int FILTER_METHOD_ROW = 6;
    protected static final int LOSS_THRESHOLD_ROW = 7;
    protected static final int MEASURE_RANGE_DISTANCE_ROW = 8;
    protected static final int TEST_OPTICAL_POWER_ROW = 9;
    protected static final int CODE_TYPE_ROW = 10;
    protected static final int PULSE_WIDTHS_USED_ROW = 11;
    protected static final int REFLECTANCE_THRESHOLD_ROW = 12;
    protected static final int SAMPLE_RATE_ROW = 13;
    protected static final int WAVE_LENGTH_ROW = 14;
    protected static final int SAMPLE_TIMES_ROW = 15;
    protected static final String NUMBER_OF_CODE_BITS_CONVERT = "NUMBER_OF_CODE_BITS_CONVERT_";
    protected static final String NUMBER_OF_CODE_BITS_SINGLE = "1";
    protected static final String CODE_TYPE_SINGLE = "CODE_TYPE_SINGLE";
    protected static final String CODE_TYPE_GRAY = "CODE_TYPE_GRAY";
    private static TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    private transient TEOTDRGraphFileTreeFileOpenedListener fileOpenListener = null;
    private transient TEOTDRGraphLegendMakeFileSelectedListener fileSelectedListener = null;
    private transient TEOTDRGraphFileTreeFileClosedListener fileClosedListener = null;
    private transient TEOTDRGraphFileTreeFileDeletedListener fileDeletedListener = null;
    private String selectedFileName = null;
    private InmTable paramTable = null;
    private DefaultTableModel paramTableModel = null;
    DecimalFormat doubleFormatter = new DecimalFormat("0.000");
    private Object[] paramTableHandName = new Object[]{resUtil.getString("TEST_PARAM_NAME"), resUtil.getString("TEST_PARAM_VALUE")};
    private Object[][] paramTableRowName = new Object[][]{{resUtil.getString("fileName"), ""}, {resUtil.getString("supplierName"), ""}, {resUtil.getString("comment"), ""}, {resUtil.getString("dateTimeStamp"), ""}, {resUtil.getString("endOfFiberThreshold"), ""}, {resUtil.getString("monitorType"), ""}, {resUtil.getString("filterMethod"), ""}, {resUtil.getString("lossThreshold"), ""}, {resUtil.getString("measureRangeDistance"), ""}, {resUtil.getString("testOpticalPower"), ""}, {resUtil.getString("codeType"), ""}, {resUtil.getString("pulseWidthsUsed"), ""}, {resUtil.getString("reflectanceThreshold"), ""}, {resUtil.getString("sampleRate"), ""}, {resUtil.getString("waveLength"), ""}, {resUtil.getString("sampleTimes"), ""}};
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRParamPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.initModel();
        this.initTable();
        this.jbInit();
        this.initListener();
        this.registerModule();
    }

    private void initModel() {
        this.paramTableModel = new DefaultTableModel(this.paramTableRowName, this.paramTableHandName){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    private void initTable() {
        this.paramTable = new InmTable(this.paramTableModel);
        this.paramTable.setBackground(Color.WHITE);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder upBorder = new TitledBorder(border, resUtil.getString("LEGEND_TABLE_NAME"));
        TEOTDRLegendPanel legendpanel = new TEOTDRLegendPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
        JScrollPane upPanel = new JScrollPane();
        upPanel.getViewport().add(legendpanel);
        upPanel.setBorder(upBorder);
        this.add((Component)upPanel, "North");
        border = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder downBorder = new TitledBorder(border, resUtil.getString("TEST_PARAM_TABLE_NAME"));
        JScrollPane bottomPane = new JScrollPane();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setPreferredSize(new Dimension(170, 100));
        bottomPanel.setMinimumSize(new Dimension(170, 100));
        bottomPanel.setMaximumSize(new Dimension(170, 100));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.paramTable);
        bottomPanel.add((Component)scrollPane, "Center");
        bottomPane.getViewport().add(bottomPanel);
        bottomPane.setBorder(downBorder);
        this.add((Component)bottomPane, "Center");
    }

    private void initListener() {
        this.fileOpenListener = new TEOTDRGraphFileTreeFileOpenedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRParamPanel.this.handleFileTreeFileOpenedEvent(event);
            }
        };
        this.fileSelectedListener = new TEOTDRGraphLegendMakeFileSelectedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRParamPanel.this.handleLegendMakeFileSelectedEvent(event);
            }
        };
        this.fileClosedListener = new TEOTDRGraphFileTreeFileClosedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRParamPanel.this.handleFileTreeFileClosedEvent(event);
            }
        };
        this.fileDeletedListener = new TEOTDRGraphFileTreeFileDeletedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRParamPanel.this.handleFileTreeFileDeletedEvent(event);
            }
        };
        this.teOTDRGraphEventManager.addListener(this.fileOpenListener);
        this.teOTDRGraphEventManager.addListener(this.fileSelectedListener);
        this.teOTDRGraphEventManager.addListener(this.fileClosedListener);
        this.teOTDRGraphEventManager.addListener(this.fileDeletedListener);
    }

    private void handleFileTreeFileOpenedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileOpenedEvent theEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TEOTDRParamPanel.handleFileTreeFileOpenedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00ce\u00c4\u00bc\u00fe\u00bf\u00aa\u00b9\u00d8\u00b1\u00d5\u00ca\u00c2\u00bc\u00fe fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.selectedFileName = fileName;
            this.refreshTable();
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRParamPanel.handleFileTreeFileOpenedEvent() fail!", e);
        }
    }

    private void handleLegendMakeFileSelectedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphLegendMakeFileSelectedEvent theEvent = (TEOTDRGraphLegendMakeFileSelectedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TEOTDRParamPanel.handleLegendMakeFileSelectedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00cd\u00bc\u00c0\u00fd\u00c9\u00cf\u00ce\u00c4\u00bc\u00fe\u00d1\u00a1\u00d4\u00f1\u00ca\u00c2\u00bc\u00fe fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.selectedFileName = fileName;
            this.refreshTable();
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRParamPanel.handleLegendMakeFileSelectedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileClosedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileClosedEvent theEvent = (TEOTDRGraphFileTreeFileClosedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TEOTDRParamPanel.handleFileTreeFileClosedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            if (null != this.selectedFileName && this.selectedFileName.equals(fileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRParamPanel.handleFileTreeFileClosedEvent() fail!", e);
        }
    }

    private void handleFileTreeFileDeletedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileDeletedEvent theEvent = (TEOTDRGraphFileTreeFileDeletedEvent)event;
        try {
            List<String> fileNameList = theEvent.getFileNameList();
            String classMethodName = "TEOTDRParamPanel.handleFileTreeFileDeletedEvent()";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00c9\u00be\u00b3\u00fd\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe fileNameList: " + fileNameList;
            TECommonUtil.log(classMethodName, logInfo);
            if (fileNameList.contains(this.selectedFileName)) {
                this.selectedFileName = null;
                this.clearTable();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRParamPanel.handleFileTreeFileDeletedEvent() fail!", e);
        }
    }

    private void refreshTable() {
        String classMethodName = "TEOTDRParamPanel.refreshTable()";
        String logInfo = "\u00cb\u00a2\u00d0\u00c2\u00b2\u00ce\u00ca\u00fd\u00b1\u00ed\u00b8\u00f1 ";
        TECommonUtil.log(classMethodName, logInfo);
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(this.selectedFileName);
        TEOTDRGraphTraceParamsInfo traceParamsInfo = traceInfo.getTraceParamsInfo();
        String showName = "";
        if (0 > this.selectedFileName.indexOf("mid")) {
            HashMap<String, String> fileNameParamMap = null;
            fileNameParamMap = TECommonUtil.getParamMapFromFileName(this.selectedFileName, false);
            boolean isBaseline = NUMBER_OF_CODE_BITS_SINGLE.equals(fileNameParamMap.get("baseline"));
            showName = this.teCommonUtil.getParamFromFileName(this.selectedFileName, "showName", this.isViewTestRecordView());
            showName = isBaseline ? resUtil.getString("BASELINE_NAME") : showName;
        } else {
            showName = this.selectedFileName;
        }
        String supplierName = traceParamsInfo.getSupplierName();
        String comment = traceParamsInfo.getComment();
        String dateTimeStamp = traceParamsInfo.getDateTimeStamp();
        String endOfFiberThreshold = String.valueOf(traceParamsInfo.getEndOfFiberThreshold());
        String monitorType = traceParamsInfo.getMonitorType();
        String filterMethod = traceParamsInfo.getFilterMethod();
        String lossThreshold = String.valueOf(traceParamsInfo.getLossThreshold());
        String measureRangeDistance = String.valueOf(traceParamsInfo.getMeasureRangeDistance());
        String monitorOpticalPower = String.valueOf(traceParamsInfo.getMonitorOpticalPower());
        String numberOfCodeBits = String.valueOf(traceParamsInfo.getNumberOfCodeBits());
        numberOfCodeBits = this.convertNumberOfCodeBits(numberOfCodeBits);
        String pulseWidthsUsed = String.valueOf(traceParamsInfo.getPulseWidthsUsed());
        double pulseWidth = Double.parseDouble(pulseWidthsUsed);
        pulseWidthsUsed = String.valueOf((int)(pulseWidth / 1000.0));
        String reflectanceThreshold = String.valueOf(this.doubleFormatter.format(traceParamsInfo.getReflectanceThreshold()));
        String sampleRate = String.valueOf(traceParamsInfo.getSampleRate());
        String waveLength = String.valueOf(this.doubleFormatter.format(traceParamsInfo.getWaveLength()));
        String sampleTimes = String.valueOf(traceParamsInfo.getNumberOfAverages());
        this.paramTableModel.setValueAt(showName, 0, 1);
        this.paramTableModel.setValueAt(supplierName, 1, 1);
        this.paramTableModel.setValueAt(comment, 2, 1);
        this.paramTableModel.setValueAt(dateTimeStamp, 3, 1);
        this.paramTableModel.setValueAt(endOfFiberThreshold, 4, 1);
        this.paramTableModel.setValueAt(monitorType, 5, 1);
        this.paramTableModel.setValueAt(filterMethod, 6, 1);
        this.paramTableModel.setValueAt(lossThreshold, 7, 1);
        this.paramTableModel.setValueAt(measureRangeDistance, 8, 1);
        if (monitorOpticalPower.equalsIgnoreCase("2.14748368E8")) {
            monitorOpticalPower = "/";
        }
        this.paramTableModel.setValueAt(monitorOpticalPower, 9, 1);
        this.paramTableModel.setValueAt(numberOfCodeBits, 10, 1);
        this.paramTableModel.setValueAt(pulseWidthsUsed, 11, 1);
        this.paramTableModel.setValueAt("-" + reflectanceThreshold, 12, 1);
        this.paramTableModel.setValueAt(sampleRate, 13, 1);
        this.paramTableModel.setValueAt(waveLength, 14, 1);
        this.paramTableModel.setValueAt(sampleTimes, 15, 1);
        this.paramTableModel.fireTableDataChanged();
    }

    private String convertNumberOfCodeBits(String numberOfCodeBits) {
        if (null == numberOfCodeBits || "".equals(numberOfCodeBits)) {
            return "";
        }
        return resUtil.getString(NUMBER_OF_CODE_BITS_CONVERT + numberOfCodeBits);
    }

    private String convertCodeType(String numberOfCodeBits) {
        if (null == numberOfCodeBits || "".equals(numberOfCodeBits)) {
            return "";
        }
        if (NUMBER_OF_CODE_BITS_SINGLE.equals(numberOfCodeBits)) {
            return resUtil.getString(CODE_TYPE_SINGLE);
        }
        return resUtil.getString(CODE_TYPE_GRAY);
    }

    private void clearTable() {
        String classMethodName = "TEOTDRParamPanel.clearTable()";
        String logInfo = "\u00c7\u00e5\u00bf\u00d5\u00b1\u00ed\u00b8\u00f1 ";
        TECommonUtil.log(classMethodName, logInfo);
        int len = this.paramTableModel.getRowCount();
        for (int i = 0; i < len; ++i) {
            this.paramTableModel.setValueAt(null, i, 1);
        }
        this.paramTableModel.fireTableDataChanged();
    }

    @Override
    public TEOTDRGraphInteractor getInteractor() {
        return this;
    }

    public void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("legendmodule", this);
    }

    @Override
    public Component getParamTable() {
        return this.paramTable;
    }

    @Override
    public void destroy() {
    }

    private boolean isViewTestRecordView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphViewTestRecordView;
    }
}

