/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.lookandfeel;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.lookandfeel.HuaweiTheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UIStyleTool {
    private static final String METAL_CLASS_NAME = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static boolean isWindows = true;
    private static final int DEFAULT_FONT_SIZE_WIN = 12;
    private static int winFontSize = 12;
    private static final int DEFAULT_FONT_SIZE_UNIX = 12;
    private static int unixFontSize = 12;
    private static final String DEFAULT_FONT = "Dialog";
    private static String fontName = "Dialog";
    private static final int DEFAULT_ICON_WIDTH = 16;
    private static final int DEFAULT_ICON_HEIGHT = 14;
    private static final Color MAIN_BACKGROUD_COLOR = new Color(239, 239, 239);
    public static final Color HYPERLINK_COLOR = new Color(0, 102, 153);
    private static final Color SELECTED_BACKGROUND = new Color(0, 102, 153);
    private static final Color EDIT_BACKGROUND;
    public static final Color BORDER_COLOR;
    private static final Color TABLE_Header_BACKGROUND;
    private static final Color DISABLED_BACKGROUND;
    private static final Color DISABLED_FOREGROUND;
    private static final int MIN_UNIX_FONTSIZE = 11;
    private static final int MAX_UNIX_FONTSIZE = 20;
    private static final int MIN_WINDOWS_FONTSIZE = 10;
    private static final int MAX_WINDOWS_FONTSIZE = 20;

    public static void setFontName(String s) {
        if (null != s && !s.equals(fontName)) {
            fontName = s;
        }
    }

    public static void setUnixFontSize(int i) {
        if (i >= 11 && i <= 20) {
            unixFontSize = i;
        }
    }

    public static void setWinFontSize(int i) {
        if (i >= 10 && i <= 20) {
            winFontSize = i;
        }
    }

    public static void setHuaweiStyle() {
        try {
            MetalLookAndFeel.setCurrentTheme(new HuaweiTheme());
            UIManager.setLookAndFeel(METAL_CLASS_NAME);
        }
        catch (Exception e) {
            TEAppletLogMgr.error("UIStyleTool.setHuaweiStyle() fail!", e);
        }
        UIStyleTool.installHuaweiStyle();
    }

    private static void installHuaweiStyle() {
        UIStyleTool.installCommonStyle();
        Color color = new Color(224, 224, 224);
        UIManager.put("desktop", color);
        Color color1 = EDIT_BACKGROUND;
        UIManager.put("window", color1);
        UIManager.put("text", color1);
        UIManager.put("hyperlinktext", HYPERLINK_COLOR);
        Color color2 = SELECTED_BACKGROUND;
        UIManager.put("textHighlight", color2);
        Color color3 = new Color(255, 255, 255);
        UIManager.put("textHighlightText", color3);
        Color color4 = MAIN_BACKGROUD_COLOR;
        UIManager.put("control", color4);
        Color color5 = new Color(255, 255, 255);
        UIManager.put("controlLtHighlight", color5);
        Color color6 = new Color(128, 128, 128);
        UIManager.put("controlShadow", color6);
        Color color7 = new Color(64, 64, 64);
        UIManager.put("controlDkShadow", color7);
        UIManager.put("scrollbar.thumb", color4);
        UIManager.put("tableGrid", BORDER_COLOR);
        Color color8 = new Color(169, 166, 169);
        UIManager.put("treeline", color8);
        UIManager.put("Button.background", MAIN_BACKGROUD_COLOR);
        UIManager.put("Button.disabledText", DISABLED_FOREGROUND);
        UIManager.put("Button.select", MAIN_BACKGROUD_COLOR);
        UIManager.put("ToolbarButton.background", color4);
        UIManager.put("ToolbarButton.borderColor", new Color(130, 133, 171));
        UIManager.put("ToolbarButton.reoverBackground", new Color(211, 212, 223));
        UIManager.put("ToolbarButton.pressedBackground", new Color(188, 190, 212));
        UIManager.put("ToggleButton.background", color4);
        UIManager.put("ToggleButton.background", color4);
        UIManager.put("RadioButton.background", color4);
        UIManager.put("CheckBox.background", color4);
        UIManager.put("CheckBox.disabledText", DISABLED_FOREGROUND);
        UIManager.put("ComboBox.background", color1);
        UIManager.put("ComboBox.listBackground", color1);
        UIManager.put("ComboBox.selectionForeground", color3);
        UIManager.put("ComboBox.selectionBackground", color2);
        UIManager.put("ComboBox.disabledForeground", DISABLED_FOREGROUND);
        UIManager.put("Label.foreground", Color.black);
        UIManager.put("Label.background", color4);
        UIManager.put("Label.disabledForeground", DISABLED_FOREGROUND);
        UIManager.put("List.background", color1);
        UIManager.put("List.selectionBackground", color2);
        UIManager.put("List.selectionForeground", color3);
        UIManager.put("MenuBar.background", color4);
        UIManager.put("RadioButtonMenuItem.background", color4);
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", Color.black);
        UIManager.put("RadioButtonMenuItem.acceleratorSelectionForeground", color3);
        UIManager.put("RadioButtonMenuItem.selectionBackground", color2);
        UIManager.put("RadioButtonMenuItem.selectionForeground", color3);
        UIManager.put("CheckBoxMenuItem.background", color4);
        UIManager.put("CheckBoxMenuItem.acceleratorForeground", Color.black);
        UIManager.put("CheckBoxMenuItem.acceleratorSelectionForeground", color3);
        UIManager.put("CheckBoxMenuItem.selectionBackground", color2);
        UIManager.put("CheckBoxMenuItem.selectionForeground", color3);
        UIManager.put("Menu.background", color4);
        UIManager.put("Menu.selectionBackground", color2);
        UIManager.put("Menu.selectionForeground", color3);
        UIManager.put("Menu.acceleratorForeground", Color.black);
        UIManager.put("Menu.acceleratorSelectionForeground", color3);
        UIDefaults.ProxyLazyValue proxylazyvalue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicIconFactory", "getMenuItemCheckIcon");
        UIManager.put("Menu.checkIcon", proxylazyvalue);
        UIManager.put("MenuItem.background", color4);
        UIManager.put("MenuItem.acceleratorForeground", Color.black);
        UIManager.put("MenuItem.acceleratorSelectionForeground", color3);
        UIManager.put("MenuItem.selectionBackground", color2);
        UIManager.put("MenuItem.selectionForeground", color3);
        UIManager.put("MenuItem.checkIcon", proxylazyvalue);
        UIManager.put("PopupMenu.background", color4);
        UIManager.put("PopupMenu.selectionBackground", color2);
        UIManager.put("PopupMenu.selectionForeground", color3);
        UIManager.put("OptionPane.background", color4);
        UIManager.put("Panel.background", color4);
        UIManager.put("ProgressBar.foreground", color2);
        UIManager.put("ProgressBar.background", Color.white);
        UIManager.put("ProgressBar.backgroundHighlight", color2);
        UIManager.put("ProgressBar.selectionBackground", color2);
        UIManager.put("ProgressBar.selectionForeground", color3);
        UIManager.put("ScrollPane.background", color4);
        UIManager.put("ScrollBar.thumb", color4);
        UIManager.put("ScrollBar.thumbHighlight", new Color(157, 160, 176));
        UIManager.put("ScrollBar.thumbDarkShadow", new Color(64, 64, 64));
        UIManager.put("ScrollBar.thumbLightShadow", new Color(128, 128, 128));
        UIManager.put("ScrollBar.width", 15);
        UIManager.put("ScrollBar.minimumThumbSize", new Dimension(12, 12));
        UIManager.put("ScrollBar.thumbNormalHighlight", new Color(121, 124, 162));
        UIManager.put("ScrollBar.thumbNormalDark", new Color(231, 231, 249));
        UIManager.put("ScrollBar.thumbDisableHighlight", new Color(126, 126, 126));
        UIManager.put("ScrollBar.thumbDisableDark", new Color(232, 232, 232));
        UIManager.put("ScrollBar.thumbActiveHighlight", new Color(64, 67, 98));
        UIManager.put("ScrollBar.thumbActiveDark", new Color(255, 255, 255));
        UIManager.put("ScrollBar.arrowEnableColor", new Color(92, 95, 130));
        UIManager.put("Slider.background", color4);
        UIManager.put("SplitPane.background", color4);
        UIManager.put("SplitPane.highlight", MAIN_BACKGROUD_COLOR);
        UIManager.put("Viewport.background", color4);
        UIManager.put("TabbedPane.background", color4);
        UIManager.put("TabbedPane.selected", color4);
        UIManager.put("TabbedPane.highlight", color4);
        UIManager.put("TabbedPaneUI", "com.huawei.nglct.otdr.appletgraph.lookandfeel.HuaWeiMetalTabbedPaneUI");
        UIManager.put("ScrollBarUI", "com.huawei.nglct.otdr.appletgraph.lookandfeel.HuaweiScrollBarUI");
        UIManager.put("Table.background", color1);
        UIManager.put("Table.gridColor", BORDER_COLOR);
        UIManager.put("Table.selectionBackground", color2);
        UIManager.put("Table.selectionForeground", color3);
        UIManager.put("TableHeader.background", TABLE_Header_BACKGROUND);
        UIManager.put("PasswordField.background", color1);
        UIManager.put("PasswordField.selectionBackground", color2);
        UIManager.put("PasswordField.selectionForeground", color3);
        UIManager.put("PasswordField.inactiveForeground", DISABLED_FOREGROUND);
        UIManager.put("PasswordField.inactiveBackground", DISABLED_BACKGROUND);
        UIManager.put("TextArea.background", color1);
        UIManager.put("TextArea.selectionBackground", color2);
        UIManager.put("TextArea.selectionForeground", color3);
        UIManager.put("TextArea.inactiveForeground", DISABLED_FOREGROUND);
        UIManager.put("TextArea.inactiveBackground", DISABLED_BACKGROUND);
        UIManager.put("TextPane.background", color1);
        UIManager.put("TextPane.selectionBackground", color2);
        UIManager.put("TextPane.selectionForeground", color3);
        UIManager.put("TextPane.inactiveForeground", DISABLED_FOREGROUND);
        UIManager.put("TextPane.inactiveBackground", DISABLED_BACKGROUND);
        UIManager.put("EditorPane.background", color1);
        UIManager.put("EditorPane.selectionBackground", color2);
        UIManager.put("EditorPane.selectionForeground", color3);
        UIManager.put("EditorPane.inactiveForeground", DISABLED_FOREGROUND);
        UIManager.put("EditorPane.inactiveBackground", DISABLED_BACKGROUND);
        UIManager.put("TitledBorder.titleColor", Color.black);
        UIManager.put("ToolBar.background", MAIN_BACKGROUD_COLOR);
        UIManager.put("ToolTip.background", color1);
        UIManager.put("ToolTip.acceleratorForeground", Color.black);
        UIManager.put("Separator.foreground", BORDER_COLOR);
        if (isWindows) {
            UIManager.put("InternalFrame.background", color);
            UIManager.put("InternalFrame.activeTitleBackground", new Color(52, 97, 139));
            UIManager.put("InternalFrame.activeTitleForeground", Color.black);
            UIManager.put("InternalFrame.inactiveTitleForeground", new Color(92, 92, 92));
            UIManager.put("InternalFrame.maximizeIcon", new HuaweiInternalFrameMaximizeIcon());
            UIManager.put("InternalFrame.iconifyIcon", new HuaweiInternalFrameMinimizeIcon());
            UIManager.put("InternalFrame.minimizeIcon", new HuaweiInternalFrameAltMaximizeIcon());
            UIManager.put("InternalFrame.closeIcon", new HuaweiInternalFrameCloseIcon());
        } else {
            UIManager.put("activeCaptionBorder", new Color(178, 77, 122));
            UIManager.put("InternalFrame.activeTitleForeground", Color.black);
            UIManager.put("InternalFrame.inactiveTitleForeground", new Color(92, 92, 92));
            UIManager.put("InternalFrame.maximizeIcon", new MotifMaximizeIcon());
            UIManager.put("InternalFrame.iconifyIcon", new MotifIconifyIcon());
            UIManager.put("InternalFrame.minimizeIcon", new MotifMinimizeIcon());
            UIManager.put("InternalFrame.closeIcon", new MotifCloseIcon());
        }
        UIManager.put("Tree.backgrou nd", color1);
        UIManager.put("Tree.textBackground", color1);
        UIManager.put("Tree.selectionBackground", color2);
        UIManager.put("Tree.selectionForeground", color3);
        UIManager.put("Tree.line", new Color(169, 166, 169));
        UIManager.put("Tree.hash", new Color(169, 166, 169));
        UIManager.put("Desktop.background", color);
        UIManager.put("DesktopIcon.background", color4);
        UIManager.put("MenuItem.acceleratorDelimiter", "+");
    }

    private static void installCommonStyle() {
        Font font = null;
        Font font2 = null;
        String s = "Monospaced";
        String s1 = System.getProperty("os.name");
        if (0 <= s1.indexOf("SunOS") || 0 <= s1.indexOf("HP-UX") || 0 <= s1.indexOf("Solaris") || 0 <= s1.indexOf("AIX")) {
            font = new Font(fontName, 0, unixFontSize);
            font2 = new Font(s, 0, unixFontSize);
        } else if (s1.indexOf("Windows") >= 0) {
            font = new Font(fontName, 0, winFontSize);
            font2 = new Font(s, 0, winFontSize);
        } else {
            font = new Font(fontName, 0, unixFontSize);
            font2 = new Font(s, 0, unixFontSize);
        }
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", font);
        UIManager.put("Menu.font", font);
        UIManager.put("Menu.acceleratorFont", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("MenuItem.acceleratorFont", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("OptionPane.buttonFont", font);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font2);
        UIManager.put("EditorPane.font", font2);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("InternalFrame.font", font);
        UIManager.put("InternalFrame.titleFont", font);
        UIManager.put("Tree.font", font);
        UIManager.put("DesktopIcon.font", font);
        UIManager.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
        UIManager.put("ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
        BasicBorders.SplitPaneBorder splitpaneborder = new BasicBorders.SplitPaneBorder(UIManager.getColor("SplitPane.highlight"), UIManager.getColor("SplitPane.darkShadow")){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 0, 0);
            }
        };
        UIManager.put("SplitPane.border", splitpaneborder);
        CheckBoxMenuItemIcon checkboxmenuitemicon = new CheckBoxMenuItemIcon();
        UIManager.put("CheckBoxMenuItem.checkIcon", checkboxmenuitemicon);
        UIStyleTool.installKeyMap();
    }

    private static void installKeyMap() {
        UIManager.put("SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "ctrl shift TAB", "focusOutBackward"}));
        UIManager.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
        UIManager.put("Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}));
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        UIStyleTool.installHuaweiStyle();
        JFrame jframe = new JFrame("go");
        jframe.setSize(500, 400);
        JTree jtree = new JTree();
        JScrollPane jscrollpane = new JScrollPane(jtree);
        jframe.getContentPane().setLayout(new BorderLayout());
        jframe.getContentPane().add((Component)jscrollpane, "Center");
        jframe.setDefaultCloseOperation(3);
        JButton jbutton = new JButton("Select");
        jbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                JFileChooser jfilechooser = new JFileChooser("gg");
                jfilechooser.showOpenDialog(null);
            }
        });
        jframe.getContentPane().add((Component)jbutton, "South");
        jframe.show();
    }

    static {
        BORDER_COLOR = new Color(119, 119, 119);
        TABLE_Header_BACKGROUND = new Color(239, 239, 239);
        DISABLED_BACKGROUND = new Color(252, 251, 253);
        DISABLED_FOREGROUND = new Color(92, 92, 92);
        EDIT_BACKGROUND = Color.white;
        String s = System.getProperty("os.name");
        if (s != null && (s.indexOf("Solaris") != -1 || s.indexOf("SunOS") != -1 || s.indexOf("Linux") != -1 || s.indexOf("HP-UX") != -1)) {
            isWindows = false;
        }
    }

    public static class LightBevelBorder
    extends BevelBorder {
        @Override
        protected void paintRaisedBevel(Component component, Graphics g, int i, int j, int k, int l) {
            Color color = g.getColor();
            int i1 = l;
            int j1 = k;
            g.translate(i, j);
            g.setColor(this.getHighlightOuterColor(component));
            g.drawLine(0, 0, 0, i1 - 1);
            g.drawLine(1, 0, j1 - 1, 0);
            g.setColor(this.getShadowOuterColor(component));
            g.drawLine(1, i1 - 1, j1 - 1, i1 - 1);
            g.drawLine(j1 - 1, 1, j1 - 1, i1 - 2);
            g.setColor(this.getShadowInnerColor(component));
            g.drawLine(2, i1 - 2, j1 - 2, i1 - 2);
            g.drawLine(j1 - 2, 2, j1 - 2, i1 - 3);
            g.translate(-i, -j);
            g.setColor(color);
        }

        @Override
        protected void paintLoweredBevel(Component component, Graphics g, int i, int j, int k, int l) {
            Color color = g.getColor();
            int i1 = l;
            int j1 = k;
            g.translate(i, j);
            g.setColor(this.getShadowInnerColor(component));
            g.drawLine(0, 0, 0, i1 - 1);
            g.drawLine(1, 0, j1 - 1, 0);
            g.setColor(this.getShadowOuterColor(component));
            g.drawLine(1, 1, 1, i1 - 2);
            g.drawLine(2, 1, j1 - 2, 1);
            g.setColor(this.getHighlightOuterColor(component));
            g.drawLine(1, i1 - 1, j1 - 1, i1 - 1);
            g.drawLine(j1 - 1, 1, j1 - 1, i1 - 2);
            g.translate(-i, -j);
            g.setColor(color);
        }

        LightBevelBorder(int i) {
            super(i);
        }
    }

    private static class HuaweiInternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = (Color)UIManager.get("control");
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width, this.height);
            if (buttonmodel.isPressed() && buttonmodel.isArmed() && buttonmodel.isEnabled()) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.white);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.black);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            if (!buttonmodel.isEnabled()) {
                g.setColor(UIManager.getColor("controlShadow"));
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(4, 3, this.width - 6, this.height - 5);
            g.drawLine(5, 3, this.width - 5, this.height - 5);
            g.drawLine(4, this.height - 5, this.width - 6, 3);
            g.drawLine(5, this.height - 5, this.width - 5, 3);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class HuaweiInternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = (Color)UIManager.get("control");
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width, this.height);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.white);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.black);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            g.setColor(Color.black);
            g.drawRect(3, 3, this.width - 8, this.height - 7);
            g.drawLine(3, 4, this.width - 5, 4);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class HuaweiInternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = (Color)UIManager.get("control");
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width, this.height);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.white);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.black);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            g.setColor(Color.black);
            g.drawLine(4, this.height - 4, 9, this.height - 4);
            g.drawLine(4, this.height - 5, 9, this.height - 5);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class HuaweiInternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = (Color)UIManager.get("control");
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width, this.height);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.white);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(Color.white);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(Color.black);
                g.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            g.setColor(Color.black);
            g.drawRect(6, this.height - 11, 5, 5);
            g.drawLine(6, this.height - 10, 11, this.height - 10);
            g.setColor(color);
            g.fillRect(4, this.height - 8, 5, 5);
            g.setColor(Color.black);
            g.drawRect(4, this.height - 8, 5, 5);
            g.drawLine(4, this.height - 7, 9, this.height - 7);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MotifIconifyIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = jbutton.getBackground();
            Color color1 = Color.white;
            Color color2 = Color.black;
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(color2);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(color1);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color2);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            g.setColor(color1);
            g.drawLine(this.width / 2 - 1, this.height / 2 - 1, this.width / 2 + 2, this.height / 2 - 1);
            g.drawLine(this.width / 2 - 1, this.height / 2 - 1, this.width / 2 - 1, this.height / 2 + 1);
            g.setColor(color2);
            g.drawLine(this.width / 2 - 1, this.height / 2 + 1, this.width / 2 + 2, this.height / 2 + 1);
            g.drawLine(this.width / 2 + 2, this.height / 2 - 1, this.width / 2 + 2, this.height / 2 + 1);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private MotifIconifyIcon() {
        }
    }

    private static class MotifMaximizeIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = jbutton.getBackground();
            Color color1 = Color.white;
            Color color2 = Color.black;
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(color2);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(color1);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color2);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            g.setColor(color1);
            g.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 - 4);
            g.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 - 4, this.height / 2 + 4);
            g.setColor(color2);
            g.drawLine(this.width / 2 - 4, this.height / 2 + 4, this.width / 2 + 4, this.height / 2 + 4);
            g.drawLine(this.width / 2 + 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 + 4);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private MotifMaximizeIcon() {
        }
    }

    private static class MotifMinimizeIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = jbutton.getBackground();
            Color color1 = Color.white;
            Color color2 = Color.black;
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonmodel.isPressed() && buttonmodel.isArmed()) {
                g.setColor(color2);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(color1);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color2);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            g.setColor(color2);
            g.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 - 4);
            g.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 - 4, this.height / 2 + 4);
            g.setColor(color1);
            g.drawLine(this.width / 2 - 4, this.height / 2 + 4, this.width / 2 + 4, this.height / 2 + 4);
            g.drawLine(this.width / 2 + 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 + 4);
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private MotifMinimizeIcon() {
        }
    }

    private static class MotifCloseIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            JButton jbutton = (JButton)component;
            ButtonModel buttonmodel = jbutton.getModel();
            Color color = (Color)UIManager.get("control");
            Color color1 = Color.white;
            Color color2 = Color.black;
            g.translate(i, j);
            g.setColor(color);
            g.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonmodel.isPressed() && buttonmodel.isArmed() && buttonmodel.isEnabled()) {
                g.setColor(color2);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color1);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                g.setColor(color1);
                g.drawLine(0, 0, this.width - 1, 0);
                g.drawLine(0, 1, 0, this.height - 1);
                g.setColor(color2);
                g.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                g.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            if (!buttonmodel.isEnabled()) {
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(4, 3, this.width - 6, this.height - 5);
                g.drawLine(4, this.height - 5, this.width - 6, 3);
                g.drawLine(4, 3, this.width - 6, this.height - 5);
                g.drawLine(4, this.height - 5, this.width - 6, 3);
            } else {
                g.setColor(color1);
                g.drawLine(4, 3, this.width - 6, this.height - 5);
                g.drawLine(4, this.height - 5, this.width - 6, 3);
                g.setColor(color2);
                g.drawLine(4, 3, this.width - 6, this.height - 5);
                g.drawLine(4, this.height - 5, this.width - 6, 3);
            }
            g.translate(-i, -j);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private MotifCloseIcon() {
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int ICON_WIDTH = 9;
        private static final int ICON_HEIGHT = 9;

        @Override
        public void paintIcon(Component component, Graphics g, int i, int j) {
            AbstractButton abstractbutton = (AbstractButton)component;
            ButtonModel buttonmodel = abstractbutton.getModel();
            boolean flag = buttonmodel.isSelected();
            boolean flag1 = buttonmodel.isEnabled();
            if (flag) {
                if (!flag1) {
                    g.setColor(MetalLookAndFeel.getControlDisabled());
                }
                g.drawLine(i + 7, j + 1, i + 7, j + 3);
                g.drawLine(i + 6, j + 2, i + 6, j + 4);
                g.drawLine(i + 5, j + 3, i + 5, j + 5);
                g.drawLine(i + 4, j + 4, i + 4, j + 6);
                g.drawLine(i + 3, j + 5, i + 3, j + 7);
                g.drawLine(i + 2, j + 4, i + 2, j + 6);
                g.drawLine(i + 1, j + 3, i + 1, j + 5);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }

        private CheckBoxMenuItemIcon() {
        }
    }
}

